/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.apisupport.layers.LayerDataNode;
import org.openide.TopManager;
import org.openide.execution.NbfsURLConnection;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.io.NbObjectInputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WritableXMLFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Attr,
AbstractFileSystem.Change,
AbstractFileSystem.Info,
AbstractFileSystem.List,
AbstractFileSystem.Transfer,
FileSystem.Status,
FileChangeListener {
    private Document doc;
    private Date time;
    private URL base;
    private FileObject xmlfile;
    private String suffix;
    private FileChangeListener fileChangeListener;
    private static final Set warnedAboutDupeKids = new HashSet(1);
    private final Set orderAbsorbers = new HashSet();
    private static final int INDENT_STEP = 4;

    public WritableXMLFileSystem(URL uRL, Document document) throws PropertyVetoException {
        this.attr = this;
        this.change = this;
        this.info = this;
        this.list = this;
        this.transfer = this;
        this.doc = document;
        FileSystemCapability.Bean bean = new FileSystemCapability.Bean();
        bean.setCompile(true);
        bean.setDebug(true);
        bean.setExecute(true);
        bean.setDoc(false);
        this.setCapability((FileSystemCapability)bean);
        this.time = new Date();
        this.setBase(uRL);
        this.fileChangeListener = WeakListener.fileChange((FileChangeListener)this, null);
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("WritableXMLFileSystem is not persistent");
    }

    public void setDocument(Document document) {
        this.doc = document;
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        while (enumeration.hasMoreElements()) {
            ((FileObject)enumeration.nextElement()).refresh(true);
        }
        this.time = new Date();
    }

    public void setBase(URL uRL) throws PropertyVetoException {
        String string;
        int n;
        this.base = uRL;
        this.setSystemName(uRL.toString());
        this.xmlfile = NbfsURLConnection.decodeURL((URL)uRL);
        this.suffix = this.xmlfile != null ? ((n = (string = this.xmlfile.getName()).indexOf(95)) != -1 ? string.substring(n) : "") : "";
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getDisplayName() {
        return "XML layer: " + this.getSystemName();
    }

    public boolean isReadOnly() {
        return false;
    }

    private Element findElement(String string) {
        return this.findElementIn(this.doc.getDocumentElement(), string);
    }

    private Element findElementIn(Element element, String string) {
        String string2;
        String string3;
        if (element == null) {
            return null;
        }
        if (string.equals("")) {
            return element;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Element element3;
            if (nodeList.item(n2).getNodeType() == 1 && ((element3 = (Element)nodeList.item(n2)).getNodeName().equals("file") || element3.getNodeName().equals("folder")) && element3.getAttribute("name").equals(string3)) {
                element2 = element3;
                break;
            }
            ++n2;
        }
        return this.findElementIn(element2, string2);
    }

    public boolean folder(String string) {
        Element element = this.findElement(string);
        if (element == null) {
            return false;
        }
        boolean bl = element.getNodeName().equals("folder");
        return bl;
    }

    public String[] children(String string) {
        Element element = this.findElement(string);
        if (element == null) {
            return new String[0];
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            Element element2;
            Node node = nodeList.item(n2);
            if (node != null && node.getNodeType() == 1 && ((element2 = (Element)node).getNodeName().equals("file") || element2.getNodeName().equals("folder"))) {
                String string2 = element2.getAttribute("name");
                if (hashSet.add(string2)) {
                    arrayList.add(string2);
                } else if (warnedAboutDupeKids.add(this.xmlfile + ":" + string + "/" + string2)) {
                    if (string.equals("")) {
                        LayerDataNode.getErr().println("WARNING: in " + this.xmlfile + " the root folder contains the child " + string2 + " more than once.");
                    } else {
                        LayerDataNode.getErr().println("WARNING: in " + this.xmlfile + " the folder " + string + " contains the child " + string2 + " more than once.");
                    }
                    LayerDataNode.getErr().println("The Open APIs Support module will not work properly with such a layer.");
                    LayerDataNode.getErr().println("Please edit the XML text and merge together all children of a <folder> with the same name.");
                }
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private byte[] getContentsOf(String string) throws FileNotFoundException {
        Element element = this.findElement(string);
        if (element == null) {
            throw new FileNotFoundException(string);
        }
        String string2 = element.getAttribute("url");
        if (string2.length() > 0) {
            try {
                URL uRL = WritableXMLFileSystem.currentify(new URL(this.base, string2), this.suffix);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                InputStream inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[uRLConnection.getContentLength()];
                if (inputStream.read(byArray) != byArray.length) {
                    throw new IOException("wrong content length");
                }
                FileObject fileObject = NbfsURLConnection.decodeURL((URL)uRL);
                if (fileObject != null) {
                    fileObject.removeFileChangeListener(this.fileChangeListener);
                    fileObject.addFileChangeListener(this.fileChangeListener);
                }
                return byArray;
            }
            catch (IOException iOException) {
                throw new FileNotFoundException(iOException.getMessage());
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 4) {
                stringBuffer.append(nodeList.item(n).getNodeValue());
            } else if (nodeList.item(n).getNodeType() == 3) {
                stringBuffer.append(nodeList.item(n).getNodeValue().trim());
            }
            ++n;
        }
        try {
            return stringBuffer.toString().getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FileNotFoundException(unsupportedEncodingException.getMessage());
        }
    }

    private static URL currentify(URL uRL, String string) {
        try {
            if (uRL.getProtocol().equals("nbres")) {
                FileObject fileObject;
                String string2 = uRL.getFile();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                if ((fileObject = FileSystemCapability.EXECUTE.findResource(string2)) != null) {
                    return fileObject.getURL();
                }
            } else if (uRL.getProtocol().equals("nbresloc")) {
                String string3;
                String string4;
                String string5;
                String string6;
                int n;
                String string7 = uRL.getFile();
                if (string7.startsWith("/")) {
                    string7 = string7.substring(1);
                }
                if ((n = string7.lastIndexOf(47)) == -1) {
                    string6 = "";
                    string5 = string7;
                } else {
                    string6 = string7.substring(0, n + 1);
                    string5 = string7.substring(n + 1);
                }
                n = string5.lastIndexOf(46);
                if (n == -1) {
                    string4 = string5;
                    string3 = "";
                } else {
                    string4 = string5.substring(0, n);
                    string3 = string5.substring(n);
                }
                ArrayList<String> arrayList = new ArrayList<String>(WritableXMLFileSystem.computeSubVariants(string));
                arrayList.add(string);
                Collections.reverse(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string8 = (String)iterator.next();
                    String string9 = string6 + string4 + string8 + string3;
                    FileObject fileObject = FileSystemCapability.EXECUTE.findResource(string9);
                    if (fileObject == null) continue;
                    return fileObject.getURL();
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            LayerDataNode.err.notify(16, (Throwable)fileStateInvalidException);
        }
        return uRL;
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        return new ByteArrayInputStream(this.getContentsOf(string));
    }

    public OutputStream outputStream(final String string) throws IOException {
        final Element element = this.findElement(string);
        if (element == null) {
            throw new FileNotFoundException(string);
        }
        String string2 = element.getAttribute("url");
        if (this.xmlfile != null && !string2.equals("") && string2.indexOf(58) == -1 && string2.indexOf("../") == -1) {
            String string3 = this.xmlfile.getParent().toString() + "/" + string2;
            FileObject fileObject = this.xmlfile.getFileSystem().findResource(string3);
            if (fileObject == null) {
                throw new FileNotFoundException(string3);
            }
            final FileLock fileLock = fileObject.lock();
            return new FilterOutputStream(fileObject.getOutputStream(fileLock)){

                public void close() throws IOException {
                    super.close();
                    fileLock.releaseLock();
                }
            };
        }
        return new ByteArrayOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                super.close();
                byte[] byArray = this.toByteArray();
                char[] cArray = new char[byArray.length];
                boolean bl = false;
                int n = 0;
                while (n < byArray.length) {
                    char c = (char)byArray[n];
                    if ((c < ' ' || c > '~') && c != '\n' && c != '\t' && c != '\r') {
                        bl = true;
                        break;
                    }
                    cArray[n] = c;
                    ++n;
                }
                NodeList nodeList = element.getChildNodes();
                ArrayList<Node> arrayList = new ArrayList<Node>(1);
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    if (nodeList.item(n2).getNodeType() == 4) {
                        arrayList.add(nodeList.item(n2));
                    } else if (nodeList.item(n2).getNodeType() == 3 && nodeList.item(n2).getNodeValue().trim().length() > 0) {
                        element.removeChild(nodeList.item(n2));
                    }
                    ++n2;
                }
                if (!bl) {
                    CDATASection cDATASection = WritableXMLFileSystem.this.doc.createCDATASection(new String(cArray));
                    element.removeAttribute("url");
                    Iterator iterator = arrayList.iterator();
                    if (iterator.hasNext()) {
                        element.replaceChild(cDATASection, (CDATASection)iterator.next());
                        while (iterator.hasNext()) {
                            element.removeChild((CDATASection)iterator.next());
                        }
                    } else {
                        WritableXMLFileSystem.appendWithIndent(element, cDATASection);
                    }
                } else {
                    Object object;
                    if (WritableXMLFileSystem.this.xmlfile == null) {
                        throw new IOException("cannot write binary data to the void");
                    }
                    String string4 = element.getAttribute("name");
                    int n3 = string4.lastIndexOf(46);
                    String string2 = n3 == -1 ? "data" : string4.substring(n3 + 1);
                    String string3 = WritableXMLFileSystem.this.xmlfile.getName() + "-" + Integer.toHexString(string.hashCode());
                    FileObject fileObject = WritableXMLFileSystem.this.xmlfile.getParent().getFileObject(string3, string2);
                    if (fileObject == null) {
                        fileObject = WritableXMLFileSystem.this.xmlfile.getParent().createData(string3, string2);
                    }
                    FileLock fileLock = fileObject.lock();
                    try {
                        object = fileObject.getOutputStream(fileLock);
                        try {
                            ((OutputStream)object).write(byArray);
                            Object var16_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var16_19 = null;
                            ((OutputStream)object).close();
                            throw throwable;
                        }
                        ((OutputStream)object).close();
                        Object var18_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        fileLock.releaseLock();
                        throw throwable;
                    }
                    fileLock.releaseLock();
                    element.setAttribute("url", string3 + "." + string2);
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        element.removeChild((CDATASection)object.next());
                    }
                }
            }
        };
    }

    private void createFileOrFolder(String string, boolean bl) throws IOException {
        String string2;
        String string3;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        Element element = this.findElement(string3);
        if (element == null) {
            throw new FileNotFoundException(string3);
        }
        Element element2 = this.doc.createElement(bl ? "folder" : "file");
        element2.setAttribute("name", string2);
        WritableXMLFileSystem.appendWithIndent(element, element2);
    }

    public void createFolder(String string) throws IOException {
        this.createFileOrFolder(string, true);
    }

    public void createData(String string) throws IOException {
        this.createFileOrFolder(string, false);
    }

    public void delete(String string) throws IOException {
        Element element = this.findElement(string);
        if (element == null) {
            throw new FileNotFoundException(string);
        }
        Node node = element.getParentNode();
        if (node == null) {
            throw new IOException();
        }
        node.removeChild(element);
    }

    public void rename(String string, String string2) throws IOException {
        Element element = this.findElement(string);
        if (element == null) {
            throw new FileNotFoundException(string);
        }
        int n = string2.lastIndexOf(47);
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        element.setAttribute("name", string2);
    }

    public boolean copy(String string, AbstractFileSystem.Transfer transfer, String string2) throws IOException {
        String string3;
        String string4;
        if (!(transfer instanceof WritableXMLFileSystem)) {
            return false;
        }
        WritableXMLFileSystem writableXMLFileSystem = (WritableXMLFileSystem)transfer;
        Element element = this.findElement(string);
        if (element == null) {
            throw new FileNotFoundException(string);
        }
        Element element2 = writableXMLFileSystem == this ? (Element)element.cloneNode(true) : (Element)writableXMLFileSystem.doc.importNode(element, true);
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            string4 = "";
            string3 = string2;
        } else {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        }
        Element element3 = writableXMLFileSystem.findElement(string4);
        if (element3 == null) {
            throw new FileNotFoundException(string4);
        }
        element2.setAttribute("name", string3);
        Element element4 = writableXMLFileSystem.findElement(string2);
        if (element4 != null) {
            element3.replaceChild(element2, element4);
        } else {
            WritableXMLFileSystem.appendWithIndent(element3, element2);
        }
        return true;
    }

    public boolean move(String string, AbstractFileSystem.Transfer transfer, String string2) throws IOException {
        String string3;
        String string4;
        if (!(transfer instanceof WritableXMLFileSystem)) {
            return false;
        }
        WritableXMLFileSystem writableXMLFileSystem = (WritableXMLFileSystem)transfer;
        Element element = this.findElement(string);
        if (element == null) {
            throw new FileNotFoundException(string);
        }
        Element element2 = writableXMLFileSystem == this ? element : (Element)writableXMLFileSystem.doc.importNode(element, true);
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            string4 = "";
            string3 = string2;
        } else {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        }
        Element element3 = writableXMLFileSystem.findElement(string4);
        if (element3 == null) {
            throw new FileNotFoundException(string4);
        }
        element2.setAttribute("name", string3);
        Element element4 = writableXMLFileSystem.findElement(string2);
        if (element != element2) {
            element.getParentNode().removeChild(element);
        }
        if (element4 != null) {
            element3.replaceChild(element2, element4);
        } else {
            WritableXMLFileSystem.appendWithIndent(element3, element2);
        }
        return true;
    }

    public Enumeration attributes(String string) {
        Element element = this.findElement(string);
        if (element == null) {
            return EmptyEnumeration.EMPTY;
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            if (nodeList.item(n).getNodeType() == 1 && (element2 = (Element)nodeList.item(n)).getNodeName().equals("attr")) {
                arrayList.add(element2.getAttribute("name"));
            }
            ++n;
        }
        return Collections.enumeration(arrayList);
    }

    public Object readAttribute(String string, String string2) {
        Element element = this.findElement(string);
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            if (nodeList.item(n).getNodeType() == 1 && (element2 = (Element)nodeList.item(n)).getNodeName().equals("attr") && element2.getAttribute("name").equals(string2)) {
                try {
                    Attr attr = element2.getAttributeNode("bytevalue");
                    if (attr != null) {
                        return new Byte(attr.getValue());
                    }
                    attr = element2.getAttributeNode("shortvalue");
                    if (attr != null) {
                        return new Short(attr.getValue());
                    }
                    attr = element2.getAttributeNode("intvalue");
                    if (attr != null) {
                        return new Integer(attr.getValue());
                    }
                    attr = element2.getAttributeNode("longvalue");
                    if (attr != null) {
                        return new Long(attr.getValue());
                    }
                    attr = element2.getAttributeNode("floatvalue");
                    if (attr != null) {
                        return new Float(attr.getValue());
                    }
                    attr = element2.getAttributeNode("doublevalue");
                    if (attr != null) {
                        return new Double(attr.getValue());
                    }
                    attr = element2.getAttributeNode("boolvalue");
                    if (attr != null) {
                        return new Boolean(attr.getValue());
                    }
                    attr = element2.getAttributeNode("charvalue");
                    if (attr != null) {
                        return new Character(attr.getValue().charAt(0));
                    }
                    attr = element2.getAttributeNode("stringvalue");
                    if (attr != null) {
                        String string3 = attr.getValue();
                        StringBuffer stringBuffer = new StringBuffer(string3.length());
                        int n2 = 0;
                        while (n2 < string3.length()) {
                            char c = string3.charAt(n2);
                            if (n2 + 5 < string3.length() && c == '\\' && string3.charAt(n2 + 1) == 'u' && Character.isDigit(string3.charAt(n2 + 2))) {
                                String string4 = string3.substring(n2 + 2, n2 + 6);
                                stringBuffer.append((char)Integer.parseInt(string4, 16));
                                n2 += 5;
                            } else {
                                stringBuffer.append(c);
                            }
                            ++n2;
                        }
                        return stringBuffer.toString();
                    }
                    attr = element2.getAttributeNode("methodvalue");
                    if (attr != null) {
                        String string5 = attr.getValue();
                        Object[] objectArray = new Object[]{this.findResource(string), string2};
                        int n3 = string5.lastIndexOf(46);
                        if (n3 != -1) {
                            String string6 = string5.substring(n3 + 1);
                            String string7 = string5.substring(0, n3);
                            Class<?> clazz = Class.forName(string7, true, TopManager.getDefault().currentClassLoader());
                            Object[][] objectArrayArray = new Object[][]{null, null, null};
                            Method[] methodArray = new Method[]{null, null, null};
                            Class<?> clazz2 = null;
                            Class<?> clazz3 = null;
                            if (objectArray != null) {
                                if (objectArray.length > 0) {
                                    clazz2 = objectArray[0].getClass();
                                }
                                if (objectArray.length > 1) {
                                    clazz3 = objectArray[1].getClass();
                                }
                            }
                            Method[] methodArray2 = clazz.getDeclaredMethods();
                            int n4 = 0;
                            while (n4 < methodArray2.length) {
                                if (methodArray2[n4].getName().equals(string6)) {
                                    Class<?>[] classArray = methodArray2[n4].getParameterTypes();
                                    if (objectArray == null || objectArray.length == 0 || classArray.length == 0) {
                                        if (classArray.length == 0 && methodArray[0] == null && objectArrayArray[0] == null) {
                                            methodArray[classArray.length] = methodArray2[n4];
                                            objectArrayArray[classArray.length] = new Object[0];
                                        }
                                    } else if (classArray.length == 2 && objectArray.length >= 2 && methodArray[2] == null && objectArrayArray[2] == null) {
                                        Class<?> clazz4 = classArray[0];
                                        if (classArray[0].isAssignableFrom(clazz2) && classArray[1].isAssignableFrom(clazz3)) {
                                            methodArray[classArray.length] = methodArray2[n4];
                                            objectArrayArray[classArray.length] = new Object[]{objectArray[0], objectArray[1]};
                                            break;
                                        }
                                        if (classArray[0].isAssignableFrom(clazz3) && classArray[1].isAssignableFrom(clazz2)) {
                                            methodArray[classArray.length] = methodArray2[n4];
                                            objectArrayArray[classArray.length] = new Object[]{objectArray[1], objectArray[0]};
                                            break;
                                        }
                                    } else if (classArray.length == 1 && objectArray.length >= 1 && methodArray[1] == null && objectArrayArray[1] == null) {
                                        if (classArray[0].isAssignableFrom(clazz2)) {
                                            methodArray[classArray.length] = methodArray2[n4];
                                            objectArrayArray[classArray.length] = new Object[]{objectArray[0]};
                                        } else if (classArray[0].isAssignableFrom(clazz3)) {
                                            methodArray[classArray.length] = methodArray2[n4];
                                            objectArrayArray[classArray.length] = new Object[]{objectArray[1]};
                                        }
                                    }
                                }
                                ++n4;
                            }
                            int n5 = methodArray.length - 1;
                            while (n5 >= 0) {
                                if (methodArray[n5] != null && objectArrayArray[n5] != null) {
                                    methodArray[n5].setAccessible(true);
                                    return methodArray[n5].invoke(null, objectArrayArray[n5]);
                                }
                                --n5;
                            }
                        }
                        throw new InstantiationException(string5);
                    }
                    attr = element2.getAttributeNode("serialvalue");
                    if (attr != null) {
                        String string8 = attr.getValue();
                        if (string8.length() == 0) {
                            return null;
                        }
                        byte[] byArray = new byte[string8.length() / 2];
                        int n6 = 0;
                        int n7 = 0;
                        while (n7 < string8.length()) {
                            int n8 = Integer.parseInt(string8.substring(n7, n7 + 2), 16);
                            if (n8 > 127) {
                                n8 -= 256;
                            }
                            byArray[n6++] = (byte)n8;
                            n7 += 2;
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n6);
                        NbObjectInputStream nbObjectInputStream = new NbObjectInputStream((InputStream)byteArrayInputStream);
                        return nbObjectInputStream.readObject();
                    }
                    attr = element2.getAttributeNode("urlvalue");
                    if (attr != null) {
                        return new URL(attr.getValue());
                    }
                    attr = element2.getAttributeNode("newvalue");
                    if (attr != null) {
                        return Class.forName(attr.getValue(), true, TopManager.getDefault().currentClassLoader()).newInstance();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace((PrintWriter)LayerDataNode.getErr());
                    LayerDataNode.err.notify(1, (Throwable)exception);
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public void writeAttribute(String string, String string2, Object object) throws IOException {
        Object object2;
        Object object3;
        boolean bl;
        Node node;
        Object object4;
        if (object == null && this.orderAbsorbers.contains(object4 = string + "/" + string2)) {
            this.orderAbsorbers.remove(object4);
            return;
        }
        if (string2.equals("OpenIDE-Folder-Order") && object instanceof String) {
            object4 = new StringTokenizer((String)object, "/");
            if (((StringTokenizer)object4).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object4).nextToken();
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object4).nextToken();
                    this.writeAttribute(string, string3 + "/" + string4, Boolean.TRUE);
                    this.orderAbsorbers.add(string + "/" + string3 + "/" + string4);
                    string3 = string4;
                }
            }
            return;
        }
        object4 = this.findElement(string);
        if (object4 == null) {
            throw new FileNotFoundException(string);
        }
        Node node2 = null;
        NodeList nodeList = object4.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1 && (node = (Element)nodeList.item(n)).getNodeName().equals("attr") && node.getAttribute("name").equals(string2)) {
                node2 = node;
                break;
            }
            ++n;
        }
        if (object == null) {
            if (node2 != null) {
                object4.removeChild(node2);
            }
            if ((node = this.findSerialComment((Element)object4, string2)) != null) {
                object4.removeChild(node);
            }
            return;
        }
        if (node2 == null) {
            node2 = this.doc.createElement("attr");
            node2.setAttribute("name", string2);
            bl = true;
        } else {
            object3 = node2.getChildNodes();
            int n2 = 0;
            while (n2 < object3.getLength()) {
                object2 = object3.item(n2);
                if (object2.getNodeType() == 2 && !object2.getNodeName().equals("name")) {
                    node2.removeChild((Node)object2);
                }
                ++n2;
            }
            bl = false;
        }
        object3 = null;
        if (object instanceof Byte) {
            node2.setAttribute("bytevalue", object.toString());
        } else if (object instanceof Short) {
            node2.setAttribute("shortvalue", object.toString());
        } else if (object instanceof Integer) {
            node2.setAttribute("intvalue", object.toString());
        } else if (object instanceof Long) {
            node2.setAttribute("longvalue", object.toString());
        } else if (object instanceof Float) {
            node2.setAttribute("floatvalue", object.toString());
        } else if (object instanceof Double) {
            node2.setAttribute("doublevalue", object.toString());
        } else if (object instanceof Character) {
            node2.setAttribute("charvalue", object.toString());
        } else if (object instanceof Boolean) {
            node2.setAttribute("boolvalue", object.toString());
        } else if (object instanceof String) {
            String string5 = (String)object;
            object2 = new StringBuffer(6 * string5.length());
            char[] cArray = new char[]{'&', '<', '>', '\"', '\''};
            int n3 = 0;
            while (n3 < string5.length()) {
                boolean bl2 = false;
                int n4 = 0;
                while (n4 < cArray.length) {
                    if (string5.charAt(n3) == cArray[n4]) {
                        ((StringBuffer)object2).append(WritableXMLFileSystem.encodeChar(string5.charAt(n3)));
                        bl2 = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl2 && Character.isISOControl(string5.charAt(n3))) {
                    ((StringBuffer)object2).append(WritableXMLFileSystem.encodeChar(string5.charAt(n3)));
                } else if (!bl2) {
                    ((StringBuffer)object2).append(string5.charAt(n3));
                }
                ++n3;
            }
            node2.setAttribute("stringvalue", ((StringBuffer)object2).toString());
        } else if (object instanceof URL) {
            node2.setAttribute("urlvalue", object.toString());
        } else {
            Object object5;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object2 = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object2).writeObject(object);
            ((ObjectOutputStream)object2).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Class<?> clazz = object.getClass();
            boolean bl3 = false;
            try {
                object5 = clazz.newInstance();
                byteArrayOutputStream = new ByteArrayOutputStream();
                object2 = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object2).writeObject(object5);
                ((ObjectOutputStream)object2).close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                bl3 = Utilities.compareObjects((Object)byArray, (Object)byArray2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl3) {
                node2.setAttribute("newvalue", clazz.getName());
            } else {
                object5 = new StringBuffer(byArray.length * 2);
                int n5 = 0;
                while (n5 < byArray.length) {
                    if (byArray[n5] < 16 && byArray[n5] >= 0) {
                        ((StringBuffer)object5).append("0");
                    }
                    ((StringBuffer)object5).append(Integer.toHexString(byArray[n5] < 0 ? byArray[n5] + 256 : byArray[n5]));
                    ++n5;
                }
                node2.setAttribute("serialvalue", ((StringBuffer)object5).toString());
                String string6 = clazz.isArray() ? Arrays.asList((Object[])object).toString() : object.toString();
                object3 = " (" + string2 + "=" + string6 + ") ";
            }
        }
        if (bl) {
            WritableXMLFileSystem.appendWithIndent((Element)object4, node2);
        }
        Comment comment = this.findSerialComment((Element)object4, string2);
        if (object3 != null) {
            if (comment != null) {
                comment.setData((String)object3);
            } else {
                WritableXMLFileSystem.appendWithIndent((Element)object4, this.doc.createComment((String)object3));
            }
        } else if (comment != null) {
            object4.removeChild(comment);
        }
        if (string2.startsWith("SystemFileSystem")) {
            this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, this.findResource(string), true, true));
        }
    }

    private Comment findSerialComment(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            String string2;
            if (nodeList.item(n).getNodeType() == 8 && (string2 = nodeList.item(n).getNodeValue()).startsWith(" (" + string + "=") && string2.endsWith(") ")) {
                return (Comment)nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    private static String encodeChar(char c) {
        String string = Integer.toString(c, 16);
        return "\\u" + "0000".substring(0, "0000".length() - string.length()).concat(string);
    }

    public void renameAttributes(String string, String string2) {
    }

    public void deleteAttributes(String string) {
    }

    public boolean readOnly(String string) {
        return false;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        try {
            return this.getContentsOf(string).length;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0L;
        }
    }

    public void markUnimportant(String string) {
        Element element = this.findElement(string);
        if (element == null) {
            return;
        }
        String string2 = " This file is not important. ";
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 8 && nodeList.item(n).getNodeValue().equals(string2)) {
                return;
            }
            ++n;
        }
        WritableXMLFileSystem.appendWithIndent(element, this.doc.createComment(string2));
    }

    public Date lastModified(String string) {
        String string2;
        Element element = this.findElement(string);
        if (element != null && (string2 = element.getAttribute("url")).length() > 0) {
            try {
                FileObject fileObject = NbfsURLConnection.decodeURL((URL)WritableXMLFileSystem.currentify(new URL(this.base, string2), this.suffix));
                if (fileObject != null) {
                    fileObject.removeFileChangeListener(this.fileChangeListener);
                    fileObject.addFileChangeListener(this.fileChangeListener);
                    Date date = fileObject.lastModified();
                    return date;
                }
            }
            catch (MalformedURLException malformedURLException) {
                LayerDataNode.err.notify(1, (Throwable)malformedURLException);
            }
        }
        return this.time;
    }

    public void lock(String string) throws IOException {
    }

    public void unlock(String string) {
    }

    public String annotateName(String string, Set set) {
        return WritableXMLFileSystem.annotateNameGeneral(string, set, "<root folder>", this.suffix, this.fileChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String annotateNameGeneral(String string, Set set, String string2, String string3, FileChangeListener fileChangeListener) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            String string4 = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
            if (string4 == null) continue;
            try {
                Object var16_15;
                InputStream inputStream;
                block8: {
                    String string5;
                    URL uRL = WritableXMLFileSystem.currentify(new URL("nbresloc:/" + string4.replace('.', '/') + ".properties"), string3);
                    inputStream = uRL.openStream();
                    try {
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        String string6 = fileObject.getPackageNameExt('/', '.');
                        String string7 = properties.getProperty(string6);
                        FileObject fileObject2 = NbfsURLConnection.decodeURL((URL)uRL);
                        if (fileObject2 != null) {
                            fileObject2.removeFileChangeListener(fileChangeListener);
                            fileObject2.addFileChangeListener(fileChangeListener);
                            fileObject2.getParent().removeFileChangeListener(fileChangeListener);
                            fileObject2.getParent().addFileChangeListener(fileChangeListener);
                        }
                        if (string7 == null) break block8;
                        string5 = string7;
                        var16_15 = null;
                    }
                    catch (Throwable throwable) {
                        var16_15 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    return string5;
                }
                var16_15 = null;
                inputStream.close();
                {
                }
            }
            catch (IOException iOException) {
                LayerDataNode.err.notify(1, (Throwable)iOException);
                return string + " <no such bundle: " + string4 + ">";
            }
        }
        if (set.size() == 1 && ((FileObject)set.iterator().next()).isRoot()) {
            return string2;
        }
        return string;
    }

    public Image annotateIcon(Image image, int n, Set set) {
        return WritableXMLFileSystem.annotateIconGeneral(image, n, set, this.suffix, this.fileChangeListener);
    }

    static Image annotateIconGeneral(Image image, int n, Set set, String string, FileChangeListener fileChangeListener) {
        String string2;
        if (n == 1) {
            string2 = "SystemFileSystem.icon";
        } else if (n == 2) {
            string2 = "SystemFileSystem.icon32";
        } else {
            return image;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            Object object = fileObject.getAttribute(string2);
            if (object instanceof Image) {
                return (Image)object;
            }
            if (object == null) continue;
            try {
                URL uRL = WritableXMLFileSystem.currentify((URL)object, string);
                FileObject fileObject2 = NbfsURLConnection.decodeURL((URL)uRL);
                if (fileObject2 != null) {
                    fileObject2.removeFileChangeListener(fileChangeListener);
                    fileObject2.addFileChangeListener(fileChangeListener);
                }
                return Toolkit.getDefaultToolkit().getImage(uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace((PrintWriter)LayerDataNode.getErr());
                LayerDataNode.err.notify(1, (Throwable)exception);
            }
        }
        return image;
    }

    private static void appendWithIndent(Element element, Node node) throws DOMException {
        Node node2 = element;
        int n = -1;
        while (!(node2 instanceof Document)) {
            node2 = node2.getParentNode();
            ++n;
        }
        String string = element.hasChildNodes() ? WritableXMLFileSystem.spaces(4) : "\n" + WritableXMLFileSystem.spaces((n + 1) * 4);
        element.appendChild(((Document)node2).createTextNode(string));
        element.appendChild(node);
        element.appendChild(((Document)node2).createTextNode("\n" + WritableXMLFileSystem.spaces(n * 4)));
    }

    private static String spaces(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 32;
            ++n2;
        }
        return new String(cArray);
    }

    static List computeSubVariants(String string) {
        int n = string.indexOf(95);
        if (n == -1) {
            return Collections.EMPTY_LIST;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        List list = WritableXMLFileSystem.computeSubVariants(string2, string3);
        return list.subList(0, list.size() - 1);
    }

    private static List computeSubVariants(String string, String string2) {
        int n = string2.indexOf(95, 1);
        if (n == -1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            linkedList.add(string + string2);
            return linkedList;
        }
        String string3 = string2.substring(n);
        List list = WritableXMLFileSystem.computeSubVariants(string, string3);
        List list2 = WritableXMLFileSystem.computeSubVariants(string + string2.substring(0, n), string3);
        LinkedList linkedList = new LinkedList(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.someFileChange(fileEvent);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.someFileChange(fileEvent);
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.someFileChange((FileEvent)fileRenameEvent);
    }

    public void fileChanged(FileEvent fileEvent) {
        this.someFileChange(fileEvent);
    }

    private void someFileChange(FileEvent fileEvent) {
        final boolean bl = fileEvent.isExpected();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                WritableXMLFileSystem.super.refreshResource("", bl);
                WritableXMLFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)WritableXMLFileSystem.this, true, true));
            }
        });
    }
}

