/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;

public final class HostConfig
implements LifecycleListener {
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private int debug = 0;
    private Host host = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    private File appBase() {
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        return file;
    }

    private void deployApps() {
        File appBase;
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.deploying"));
        }
        if (!(appBase = this.appBase()).exists() || !appBase.isDirectory()) {
            return;
        }
        String[] files = appBase.list();
        int i = 0;
        while (i < files.length) {
            if (!files[i].equalsIgnoreCase("META-INF") && !files[i].equalsIgnoreCase("WEB-INF")) {
                URL url;
                File dir = new File(appBase, files[i]);
                if (dir.isDirectory()) {
                    File webInf = new File(dir, "/WEB-INF");
                    if (webInf.exists() && webInf.isDirectory() && webInf.canRead()) {
                        String contextPath = "/" + files[i];
                        if (files[i].equals("ROOT")) {
                            contextPath = "";
                        }
                        if (this.host.findChild(contextPath) == null) {
                            if (this.debug >= 1) {
                                this.log(sm.getString("hostConfig.deployDir", files[i]));
                            }
                            try {
                                url = new URL("file", null, dir.getCanonicalPath());
                                ((Deployer)((Object)this.host)).install(contextPath, url);
                            }
                            catch (Throwable t) {
                                this.log(sm.getString("hostConfig.deployDir.error", files[i]), t);
                            }
                        }
                    }
                } else if (files[i].toLowerCase().endsWith(".war")) {
                    String contextPath = "/" + files[i];
                    int period = contextPath.lastIndexOf(".");
                    if (period >= 0) {
                        contextPath = contextPath.substring(0, period);
                    }
                    if (contextPath.equals("/ROOT")) {
                        contextPath = "";
                    }
                    if (this.host.findChild(contextPath) == null) {
                        if (this.debug >= 1) {
                            this.log(sm.getString("hostConfig.deployJar", files[i]));
                        }
                        try {
                            url = new URL("file", null, dir.getCanonicalPath());
                            url = new URL("jar:" + url.toString() + "!/");
                            ((Deployer)((Object)this.host)).install(contextPath, url);
                        }
                        catch (Throwable t) {
                            this.log(sm.getString("hostConfig.deployJar.error", files[i]), t);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int hostDebug;
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost && (hostDebug = ((StandardHost)this.host).getDebug()) > this.debug) {
                this.debug = hostDebug;
            }
        }
        catch (ClassCastException e) {
            this.log(sm.getString("hostConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "]: " + message);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "] " + message, throwable);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
            System.out.println(String.valueOf(String.valueOf(throwable)));
            throwable.printStackTrace(System.out);
        }
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    private void start() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.start"));
        }
        this.deployApps();
    }

    private void stop() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.stop"));
        }
        this.undeployApps();
    }

    private void undeployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.undeploying"));
        }
        String[] contextPaths = ((Deployer)((Object)this.host)).findDeployedApps();
        int i = 0;
        while (i < contextPaths.length) {
            if (this.debug >= 1) {
                this.log(sm.getString("hostConfig.undeploy", contextPaths[i]));
            }
            try {
                ((Deployer)((Object)this.host)).remove(contextPaths[i]);
            }
            catch (Throwable t) {
                this.log(sm.getString("hostConfig.undeploy.error", contextPaths[i]), t);
            }
            ++i;
        }
    }
}

