/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.cmdline.CmdlineDiffProvider;
import org.openide.util.Utilities;

public class Patch
extends Reader {
    private static final int CONTEXT_DIFF = 0;
    private static final int NORMAL_DIFF = 1;
    private Difference[] diffs;
    private PushbackReader source;
    private int currDiff = 0;
    private int line = 1;
    private String newLine = null;
    private StringBuffer buff = new StringBuffer();
    private static final String CONTEXT_MARK1B = "*** ";
    private static final String CONTEXT_MARK1E = " ****";
    private static final String CONTEXT_MARK2B = "--- ";
    private static final String CONTEXT_MARK2E = " ----";
    private static final String CONTEXT_MARK_DELIMETER = ",";
    private static final String DIFFERENCE_DELIMETER = "***************";
    private static final String LINE_PREP = "  ";
    private static final String LINE_PREP_ADD = "+ ";
    private static final String LINE_PREP_REMOVE = "- ";
    private static final String LINE_PREP_CHANGE = "! ";

    private Patch(Difference[] differenceArray, Reader reader) {
        this.diffs = differenceArray;
        this.source = new PushbackReader(new BufferedReader(reader), 1);
    }

    public static Reader apply(Difference[] differenceArray, Reader reader) {
        return new Patch(differenceArray, reader);
    }

    public static FileDifferences[] parse(Reader reader) throws IOException {
        ArrayList<FileDifferences> arrayList = new ArrayList<FileDifferences>();
        SinglePatchReader singlePatchReader = new SinglePatchReader(reader);
        int[] nArray = new int[1];
        String[] stringArray = new String[1];
        while (singlePatchReader.hasNextPatch(nArray, stringArray)) {
            Difference[] differenceArray = null;
            switch (nArray[0]) {
                case 0: {
                    differenceArray = Patch.parseContextDiff(singlePatchReader);
                    break;
                }
                case 1: {
                    differenceArray = Patch.parseNormalDiff(singlePatchReader);
                }
            }
            if (differenceArray == null) continue;
            arrayList.add(new FileDifferences(stringArray[0].intern(), differenceArray));
        }
        return arrayList.toArray(new FileDifferences[arrayList.size()]);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.buff.length() < n2) {
            this.doRetrieve(n2 - this.buff.length());
        }
        if ((n3 = Math.min(this.buff.length(), n2)) == 0) {
            return -1;
        }
        String string = this.buff.substring(0, n3);
        char[] cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n, n3);
        this.buff.delete(0, n3);
        return n3;
    }

    public void close() throws IOException {
        this.source.close();
    }

    private void doRetrieve(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            CharSequence charSequence;
            if (this.currDiff < this.diffs.length && (1 == this.diffs[this.currDiff].getType() && this.line == this.diffs[this.currDiff].getFirstStart() + 1 || 1 != this.diffs[this.currDiff].getType() && this.line == this.diffs[this.currDiff].getFirstStart())) {
                if (this.compareText(this.source, this.diffs[this.currDiff].getFirstText())) {
                    charSequence = Patch.convertNewLines(this.diffs[this.currDiff].getSecondText(), this.newLine);
                    this.buff.append((String)charSequence);
                    ++this.currDiff;
                } else {
                    throw new IOException("Patch not applicable.");
                }
            }
            charSequence = null;
            if (this.newLine == null) {
                charSequence = new StringBuffer();
            }
            String string = Patch.readLine(this.source, charSequence);
            if (charSequence != null) {
                this.newLine = charSequence.toString();
            }
            if (string == null) break;
            this.buff.append(string);
            this.buff.append(this.newLine);
            ++this.line;
        }
    }

    private static String readLine(PushbackReader pushbackReader, StringBuffer stringBuffer) throws IOException {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = pushbackReader.read();
        if (n == -1) {
            return null;
        }
        char c = (char)n;
        while (c != '\n' && c != '\r') {
            stringBuffer2.append(c);
            n = pushbackReader.read();
            if (n == -1) break;
            c = (char)n;
        }
        if (stringBuffer != null) {
            stringBuffer.append(c);
        }
        if (c == '\r') {
            try {
                n = pushbackReader.read();
                if (n != -1) {
                    c = (char)n;
                    if (c != '\n') {
                        pushbackReader.unread(c);
                    } else if (stringBuffer != null) {
                        stringBuffer.append(c);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringBuffer2.toString();
    }

    private static String convertNewLines(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\n') {
                stringBuffer.append(string2);
            } else if (c == '\r') {
                if (n + 1 < string.length() && string.charAt(n + 1) == '\n') {
                    ++n;
                    stringBuffer.append(string2);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean compareText(PushbackReader pushbackReader, String string) throws IOException {
        int n;
        if (string == null || string.length() == 0) {
            return true;
        }
        string = this.adjustTextNL(string);
        char[] cArray = new char[string.length()];
        int n2 = 0;
        String string2 = "";
        do {
            if ((n = pushbackReader.read(cArray, 0, cArray.length - n2)) > 0) {
                n2 += n;
                string2 = string2 + new String(cArray, 0, n);
            }
            if (string2.endsWith("\r")) {
                try {
                    char c = (char)pushbackReader.read();
                    if (c != '\n') {
                        pushbackReader.unread(c);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            string2 = this.adjustTextNL(string2);
            n2 = string2.length();
        } while (n > 0 && n2 < cArray.length);
        string2.getChars(0, string2.length(), cArray, 0);
        this.line += Patch.numChars('\n', cArray);
        return string2.equals(string);
    }

    private String adjustTextNL(String string) {
        string = Utilities.replaceString((String)string, (String)"\r\n", (String)"\n");
        string = Utilities.replaceString((String)string, (String)"\n\r", (String)"\n");
        string = Utilities.replaceString((String)string, (String)"\r", (String)"\n");
        return string;
    }

    private static int numChars(char c, char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private static Difference[] parseContextDiff(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList arrayList = new ArrayList();
        while (true) {
            String string;
            if ((string = bufferedReader.readLine()) != null && !DIFFERENCE_DELIMETER.equals(string)) {
                continue;
            }
            int[] nArray = new int[2];
            string = bufferedReader.readLine();
            if (string != null && string.startsWith(CONTEXT_MARK1B)) {
                try {
                    Patch.readNums(string, CONTEXT_MARK1B.length(), nArray);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(numberFormatException.getLocalizedMessage());
                }
                ArrayList arrayList2 = new ArrayList();
                string = Patch.fillChanges(nArray, bufferedReader, CONTEXT_MARK2B, arrayList2);
                int[] nArray2 = new int[2];
                if (string != null && string.startsWith(CONTEXT_MARK2B)) {
                    try {
                        Patch.readNums(string, CONTEXT_MARK2B.length(), nArray2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException(numberFormatException.getLocalizedMessage());
                    }
                    ArrayList arrayList3 = new ArrayList();
                    string = Patch.fillChanges(nArray2, bufferedReader, DIFFERENCE_DELIMETER, arrayList3);
                    Patch.mergeChanges(nArray, nArray2, arrayList2, arrayList3, arrayList);
                }
            }
            if (string == null) break;
        }
        return arrayList.toArray(new Difference[arrayList.size()]);
    }

    private static void readNums(String string, int n, int[] nArray) throws NumberFormatException {
        int n2 = string.indexOf(CONTEXT_MARK_DELIMETER, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing comma.");
        }
        nArray[0] = Integer.parseInt(string.substring(n, n2).trim());
        n = n2 + 1;
        n2 = string.indexOf(32, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing final space.");
        }
        nArray[1] = Integer.parseInt(string.substring(n, n2).trim());
    }

    private static String fillChanges(int[] nArray, BufferedReader bufferedReader, String string, List list) throws IOException {
        String string2 = bufferedReader.readLine();
        int n = nArray[0];
        while (n <= nArray[1]) {
            StringBuffer stringBuffer;
            int[] nArray2;
            if (string2 == null || string2.startsWith(string)) break;
            if (string2.startsWith(LINE_PREP_ADD)) {
                nArray2 = new int[3];
                nArray2[0] = n;
                nArray2[2] = 1;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(LINE_PREP_ADD.length()));
                stringBuffer.append('\n');
                while ((string2 = bufferedReader.readLine()).startsWith(LINE_PREP_ADD)) {
                    stringBuffer.append(string2.substring(LINE_PREP_ADD.length()));
                    stringBuffer.append('\n');
                    ++n;
                }
                nArray2[1] = n;
                list.add(nArray2);
                list.add(stringBuffer.toString());
            } else if (string2.startsWith(LINE_PREP_REMOVE)) {
                nArray2 = new int[3];
                nArray2[0] = n;
                nArray2[2] = 0;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(LINE_PREP_REMOVE.length()));
                stringBuffer.append('\n');
                while ((string2 = bufferedReader.readLine()).startsWith(LINE_PREP_REMOVE)) {
                    stringBuffer.append(string2.substring(LINE_PREP_REMOVE.length()));
                    stringBuffer.append('\n');
                    ++n;
                }
                nArray2[1] = n;
                list.add(nArray2);
                list.add(stringBuffer.toString());
            } else if (string2.startsWith(LINE_PREP_CHANGE)) {
                nArray2 = new int[3];
                nArray2[0] = n;
                nArray2[2] = 2;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(LINE_PREP_CHANGE.length()));
                stringBuffer.append('\n');
                while ((string2 = bufferedReader.readLine()).startsWith(LINE_PREP_CHANGE)) {
                    stringBuffer.append(string2.substring(LINE_PREP_CHANGE.length()));
                    stringBuffer.append('\n');
                    ++n;
                }
                nArray2[1] = n;
                list.add(nArray2);
                list.add(stringBuffer.toString());
            } else {
                string2 = bufferedReader.readLine();
            }
            ++n;
        }
        return string2;
    }

    private static void mergeChanges(int[] nArray, int[] nArray2, List list, List list2, List list3) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n || n3 < n2) {
            int[] nArray3;
            boolean bl = true;
            while (bl && n4 < n) {
                nArray3 = (int[])list.get(n4);
                boolean bl2 = bl = nArray3[2] == 1 || nArray3[2] == 0;
                if (!bl) continue;
                list3.add(new Difference(nArray3[2], nArray3[0], nArray3[1], nArray2[0] + nArray3[0] - nArray[0], nArray2[0] + nArray3[1] - nArray[0], (String)list.get(n4 + 1), ""));
                n4 += 2;
            }
            bl = true;
            while (bl && n3 < n2) {
                nArray3 = (int[])list2.get(n3);
                boolean bl3 = bl = nArray3[2] == 1 || nArray3[2] == 0;
                if (!bl) continue;
                list3.add(new Difference(nArray3[2], nArray[0] + nArray3[0] - nArray2[0], nArray[0] + nArray3[1] - nArray2[0], nArray3[0], nArray3[1], "", (String)list2.get(n3 + 1)));
                n3 += 2;
            }
            if (n4 >= n || n3 >= n2) continue;
            nArray3 = (int[])list.get(n4);
            int[] nArray4 = (int[])list2.get(n3);
            list3.add(new Difference(nArray3[2], nArray3[0], nArray3[1], nArray4[0], nArray4[1], (String)list.get(n4 + 1), (String)list2.get(n3 + 1)));
            n4 += 2;
            n3 += 2;
        }
    }

    private static Difference[] parseNormalDiff(Reader reader) throws IOException {
        String string;
        RE rE;
        try {
            rE = new RE("(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)");
        }
        catch (RESyntaxException rESyntaxException) {
            rE = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList arrayList = new ArrayList();
        while ((string = bufferedReader.readLine()) != null) {
            CmdlineDiffProvider.outputLine(string, rE, arrayList, stringBuffer, stringBuffer2);
        }
        CmdlineDiffProvider.setTextOnLastDifference(arrayList, stringBuffer, stringBuffer2);
        return arrayList.toArray(new Difference[arrayList.size()]);
    }

    public static class FileDifferences {
        private String fileName;
        private Difference[] diffs;

        public FileDifferences(String string, Difference[] differenceArray) {
            this.fileName = string;
            this.diffs = differenceArray;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final Difference[] getDifferences() {
            return this.diffs;
        }
    }

    private static class SinglePatchReader
    extends Reader {
        private static final int BUFF_SIZE = 512;
        private PushbackReader in;
        private char[] buffer = new char[512];
        private int buffLength = 0;
        private int buffPos = 0;
        private boolean isAtEndOfPatch = false;
        private static final String FILE_INDEX = "Index: ";

        public SinglePatchReader(Reader reader) {
            this.in = new PushbackReader(reader, 512);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n2 > 0) {
                int n4;
                if (n2 < this.buffLength) {
                    n4 = n2;
                    n2 = 0;
                } else if (this.buffLength > 0) {
                    n4 = this.buffLength;
                    n2 -= this.buffLength;
                } else if (this.isAtEndOfPatch) {
                    n2 = 0;
                    n4 = -1;
                } else {
                    this.buffLength = this.readTillEndOfPatch(this.buffer);
                    this.buffPos = 0;
                    if (this.buffLength <= 0) {
                        n4 = -1;
                    } else {
                        n4 = Math.min(n2, this.buffLength);
                        n2 -= n4;
                    }
                }
                if (n4 > 0) {
                    System.arraycopy(this.buffer, this.buffPos, cArray, n, n4);
                    n += n4;
                    this.buffLength -= n4;
                    this.buffPos += n4;
                    n3 += n4;
                    continue;
                }
                n2 = 0;
            }
            if (n3 == 0) {
                n3 = -1;
            }
            return n3;
        }

        private int readTillEndOfPatch(char[] cArray) throws IOException {
            int n = this.in.read(cArray);
            String string = new String(cArray);
            int n2 = 0;
            if (string.startsWith(FILE_INDEX) || (n2 = string.indexOf("\nIndex: ")) >= 0) {
                this.isAtEndOfPatch = true;
            } else {
                n2 = string.lastIndexOf(10);
                if (n2 >= 0) {
                    ++n2;
                }
            }
            if (n2 >= 0 && n2 < n) {
                this.in.unread(cArray, n2, n - n2);
                n = n2;
            }
            if (n2 == 0) {
                n = -1;
            }
            return n;
        }

        public void close() throws IOException {
        }

        /*
         * Unable to fully structure code
         */
        private boolean hasNextPatch(int[] var1_1, String[] var2_2) throws IOException {
            this.isAtEndOfPatch = false;
            var3_3 = this.in;
            var4_4 = new char["***************".length()];
            try {
                var6_5 = new RE("(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)");
            }
            catch (RESyntaxException var7_6) {
                var6_5 = null;
            }
            while ((var5_8 = var3_3.read(var4_4)) > 0) {
                block16: {
                    block17: {
                        block18: {
                            var7_7 = new String(var4_4, 0, var5_8);
                            var9_10 = var7_7.indexOf(10);
                            var10_11 = var7_7.indexOf(13);
                            var8_9 = var9_10 < 0 ? var10_11 : var9_10;
                            if (var8_9 >= 0) {
                                var7_7 = var9_10 > 0 && var9_10 == var10_11 + 1 ? var7_7.substring(0, var8_9 - 1) : var7_7.substring(0, var8_9);
                                if (var8_9 + 1 < var5_8) {
                                    var3_3.unread(var4_4, var8_9 + 1, var5_8 - (var8_9 + 1));
                                    var5_8 = var8_9 + 1;
                                }
                            }
                            if (var7_7.equals("***************")) {
                                var1_1[0] = 0;
                                var3_3.unread(var4_4, 0, var5_8);
                                return true;
                            }
                            if (var7_7.startsWith("Index: ")) {
                                var11_12 = new StringBuffer(var7_7.substring("Index: ".length()));
                                if (var8_9 < 0) {
                                    while ((var13_17 = (int)(var12_15 = var3_3.read())) != 10 && var12_15 != -1) {
                                        var11_12.append((char)var13_17);
                                    }
                                }
                                var2_2[0] = var11_12.toString();
                                continue;
                            }
                            if (!var7_7.startsWith("*** ")) break block16;
                            var11_13 = new StringBuffer(var7_7.substring("*** ".length()));
                            var12_16 = var11_13.toString();
                            var13_17 = var12_16.indexOf(9);
                            if (var13_17 > 0) {
                                var11_13 = var11_13.delete(var13_17, var11_13.length());
                            }
                            if (var8_9 >= 0) break block17;
                            var14_18 = 0;
                            var15_19 = '\u0000';
                            if (var13_17 >= 0) break block18;
                            if (true) ** GOTO lbl46
                            do {
                                var11_13.append(var15_19);
lbl46:
                                // 2 sources

                                var14_18 = var3_3.read();
                                v0 = (char)var14_18;
                                var15_19 = v0;
                            } while (v0 != '\n' && var15_19 != '\r' && var15_19 != '\t' && var14_18 != -1);
                        }
                        if (var15_19 != '\n' && var15_19 != '\r' && var14_18 != -1) {
                            do {
                                var14_18 = var3_3.read();
                                v1 = (char)var14_18;
                                var15_19 = v1;
                            } while (v1 != '\n' && var15_19 != '\r' && var14_18 != -1);
                        }
                        if (var15_19 == '\r' && (var14_18 = var3_3.read()) != -1 && (var15_19 = (char)((char)var14_18)) != '\n') {
                            var3_3.unread(var15_19);
                        }
                    }
                    var2_2[0] = var11_13.toString();
                    continue;
                }
                if (var6_5 != null && var6_5.match(var7_7)) {
                    var1_1[0] = 1;
                    var3_3.unread(var4_4, 0, var5_8);
                    return true;
                }
                if (var8_9 >= 0) continue;
                do {
                    var11_14 = var3_3.read();
                    v2 = (char)var11_14;
                    var12_15 = v2;
                } while (v2 != '\n' && var12_15 != 13 && var11_14 != -1);
                if (var12_15 != 13 || (var11_14 = var3_3.read()) == -1 || (var12_15 = (int)((char)var11_14)) == 10) continue;
                var3_3.unread(var12_15);
            }
            return false;
        }
    }
}

