/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.modules.diff.builtin.visualizer.LinesComponent;
import org.openide.TopManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class DiffPanel
extends JPanel {
    private static final double VERTICAL_SCROLL_NUM_LINES = 4.0;
    private static final double HORIZONTAL_SCROLL_NUM_LINES = 4.0;
    private int totalHeight = 0;
    private int additionalHeight = 0;
    private int totalLines = 0;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private LinesComponent linesComp1;
    private LinesComponent linesComp2;
    private ArrayList closeListeners = new ArrayList();
    private boolean diffSetSuccess = true;
    static final long serialVersionUID = 3683458237532937983L;
    private static final String PLAIN_TEXT_MIME = "text/plain";
    private Hashtable kitActions;
    private PropertyChangeListener copyL;
    private PropertyChangeListener copyP;
    private JViewport jViewport1;
    private JViewport jViewport2;
    private JButton nextButton;
    private JLabel fileLabel2;
    private JLabel fileLabel1;
    private JPanel filePanel2;
    private JPanel filePanel1;
    private JEditorPane jEditorPane2;
    private JEditorPane jEditorPane1;
    private JScrollPane jScrollPane2;
    private JPanel editorPanel;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JButton prevButton;
    private JPanel commandPanel;
    static /* synthetic */ Class class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;

    public DiffPanel() {
        this.initComponents();
        this.prevButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/prev.gif")));
        this.nextButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/next.gif")));
        this.prevButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"DiffComponent.prevButton.mnemonic").charAt(0));
        this.nextButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"DiffComponent.nextButton.mnemonic").charAt(0));
        this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"DiffComponent.title"));
        this.initActions();
        this.jSplitPane1.setResizeWeight(0.5);
        this.putClientProperty("PersistenceType", "Never");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_DiffPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_DiffPanelA11yDesc"));
        this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane1A11yName"));
        this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane1A11yDescr"));
        this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane2A11yName"));
        this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane2A11yDescr"));
    }

    private void initComponents() {
        this.commandPanel = new JPanel();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.editorPanel = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.filePanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.fileLabel1 = new JLabel();
        this.filePanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane2 = new JEditorPane();
        this.fileLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.commandPanel.setLayout(new GridBagLayout());
        this.prevButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel)).getString("DiffComponent.prevButton.toolTipText"));
        this.prevButton.setPreferredSize(new Dimension(24, 24));
        this.prevButton.setMaximumSize(new Dimension(24, 24));
        this.prevButton.setMargin(new Insets(1, 1, 0, 1));
        this.prevButton.setMinimumSize(new Dimension(24, 24));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.commandPanel.add((Component)this.prevButton, gridBagConstraints);
        this.nextButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel)).getString("DiffComponent.nextButton.toolTipText"));
        this.nextButton.setPreferredSize(new Dimension(24, 24));
        this.nextButton.setMaximumSize(new Dimension(24, 24));
        this.nextButton.setMargin(new Insets(1, 1, 0, 1));
        this.nextButton.setMinimumSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.commandPanel.add((Component)this.nextButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.commandPanel, gridBagConstraints);
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.setPreferredSize(new Dimension(700, 600));
        this.jSplitPane1.setDividerSize(4);
        this.filePanel1.setLayout(new GridBagLayout());
        this.jEditorPane1.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                DiffPanel.this.jEditorPane1CaretUpdate(caretEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.fileLabel1.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel1.add((Component)this.fileLabel1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.filePanel1);
        this.filePanel2.setLayout(new GridBagLayout());
        this.jEditorPane2.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                DiffPanel.this.jEditorPane2CaretUpdate(caretEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.jEditorPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.fileLabel2.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel2.add((Component)this.fileLabel2, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.filePanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editorPanel.add((Component)this.jSplitPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.editorPanel, gridBagConstraints);
    }

    private void jEditorPane1CaretUpdate(CaretEvent caretEvent) {
    }

    private void jEditorPane2CaretUpdate(CaretEvent caretEvent) {
    }

    public void setCurrentLine(int n, int n2) {
        if (n > 0) {
            this.showLine(n, n2);
        }
    }

    public void addPrevLineButtonListener(ActionListener actionListener) {
        this.prevButton.addActionListener(actionListener);
    }

    public void addNextLineButtonListener(ActionListener actionListener) {
        this.nextButton.addActionListener(actionListener);
    }

    private void jScrollBar1AdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.exitForm(null);
    }

    private void exitForm(WindowEvent windowEvent) {
    }

    private void initActions() {
        this.jEditorPane1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DiffPanel.this.editorActivated(DiffPanel.this.jEditorPane1);
            }

            public void focusLost(FocusEvent focusEvent) {
                DiffPanel.this.editorDeactivated(DiffPanel.this.jEditorPane1);
            }
        });
        this.jEditorPane2.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DiffPanel.this.editorActivated(DiffPanel.this.jEditorPane2);
            }

            public void focusLost(FocusEvent focusEvent) {
                DiffPanel.this.editorDeactivated(DiffPanel.this.jEditorPane2);
            }
        });
    }

    private Action getAction(String string, JEditorPane jEditorPane) {
        Hashtable<Object, Action> hashtable;
        if (this.kitActions == null) {
            this.kitActions = new Hashtable();
        }
        if ((hashtable = (Hashtable<Object, Action>)this.kitActions.get(jEditorPane)) == null) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit == null) {
                return null;
            }
            Action[] actionArray = editorKit.getActions();
            hashtable = new Hashtable<Object, Action>(actionArray.length);
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                hashtable.put(actionArray[n2].getValue("Name"), actionArray[n2]);
                ++n2;
            }
            this.kitActions.put(jEditorPane, hashtable);
        }
        return (Action)hashtable.get(string);
    }

    private void editorActivated(final JEditorPane jEditorPane) {
        final Action action = this.getAction("copy-to-clipboard", jEditorPane);
        if (action != null) {
            final CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DiffPanel.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction));
            final ActionPerformer actionPerformer = new ActionPerformer(){

                public void performAction(SystemAction systemAction) {
                    action.actionPerformed(new ActionEvent(jEditorPane, 0, ""));
                }
            };
            callbackSystemAction.setActionPerformer((ActionPerformer)(action.isEnabled() ? actionPerformer : null));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                            callbackSystemAction.setActionPerformer(actionPerformer);
                        } else if (callbackSystemAction.getActionPerformer() == actionPerformer) {
                            callbackSystemAction.setActionPerformer(null);
                        }
                    }
                }
            };
            action.addPropertyChangeListener(propertyChangeListener);
            if (jEditorPane.equals(this.jEditorPane1)) {
                this.copyL = propertyChangeListener;
            } else {
                this.copyP = propertyChangeListener;
            }
        }
    }

    private void editorDeactivated(JEditorPane jEditorPane) {
        Action action = this.getAction("copy-to-clipboard", jEditorPane);
        PropertyChangeListener propertyChangeListener = jEditorPane.equals(this.jEditorPane1) ? this.copyL : this.copyP;
        if (action != null) {
            action.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void addWindowListener(WindowListener windowListener) {
        Container container = this.getTopLevelAncestor();
        if (container instanceof Window) {
            ((Window)container).addWindowListener(windowListener);
        }
    }

    public void open() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffPanel.this.jSplitPane1.setDividerLocation(0.5);
                DiffPanel.this.openPostProcess();
            }
        });
    }

    protected void openPostProcess() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffPanel.this.initGlobalSizes();
                DiffPanel.this.addChangeListeners();
            }
        });
    }

    private void initGlobalSizes() {
        int n;
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane2.getDocument();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
        int n3 = Math.max(n2, n = NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getEndPosition().getOffset()));
        if (n3 < 1) {
            n3 = 1;
        }
        this.totalLines = n3;
        int n4 = this.jEditorPane2.getSize().height;
        int n5 = this.jEditorPane1.getSize().height;
        if (n4 > n5) {
            n5 = n4;
        }
        this.totalHeight = n5;
    }

    private void showLine(int n, int n2) {
        this.linesComp1.setActiveLine(n);
        this.linesComp2.setActiveLine(n);
        this.linesComp2.repaint();
        this.linesComp1.repaint();
        int n3 = 5;
        if (n <= 5) {
            n3 = n / 2;
        }
        int n4 = this.jViewport1.getExtentSize().height;
        this.initGlobalSizes();
        Point point = this.jViewport1.getViewPosition();
        Point point2 = this.jViewport2.getViewPosition();
        int n5 = this.totalHeight * (n - n3 - 1) / (this.totalLines + 1);
        int n6 = this.jViewport1.getViewRect().y;
        if (n5 < point.y || n5 + (n2 + n3) * this.totalHeight / this.totalLines > point.y + n4) {
            point.y = n5;
            point2.y = n5;
            this.setViewPosition(point, point2);
        }
        int n7 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getDocument()), (int)n);
        int n8 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getDocument()), (int)n);
        this.jEditorPane1.setCaretPosition(n7);
        this.jEditorPane2.setCaretPosition(n8);
    }

    private void setViewPosition(Point point, Point point2) {
        this.jViewport1.setViewPosition(point);
        this.jViewport1.repaint(this.jViewport1.getViewRect());
        this.jViewport2.setViewPosition(point2);
        this.jViewport2.repaint(this.jViewport2.getViewRect());
    }

    private void joinScrollBars() {
        final JScrollBar jScrollBar = this.jScrollPane1.getHorizontalScrollBar();
        final JScrollBar jScrollBar2 = this.jScrollPane1.getVerticalScrollBar();
        final JScrollBar jScrollBar3 = this.jScrollPane2.getHorizontalScrollBar();
        final JScrollBar jScrollBar4 = this.jScrollPane2.getVerticalScrollBar();
        jScrollBar2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar2.getValue();
                int n2 = jScrollBar4.getValue();
                if (n2 != n) {
                    jScrollBar4.setValue(n);
                }
            }
        });
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        jScrollBar4.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar4.getValue();
                int n2 = jScrollBar2.getValue();
                if (n2 != n) {
                    jScrollBar2.setValue(n);
                }
            }
        });
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar.getValue();
                if (n == DiffPanel.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar3.getModel().getExtent();
                if (n2 == n4) {
                    DiffPanel.this.horizontalScroll2ChangedValue = 0;
                } else {
                    DiffPanel.this.horizontalScroll2ChangedValue = n * (n3 - n5) / (n2 - n4);
                }
                DiffPanel.this.horizontalScroll1ChangedValue = -1;
                jScrollBar3.setValue(DiffPanel.this.horizontalScroll2ChangedValue);
            }
        });
        jScrollBar3.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar3.getValue();
                if (n == DiffPanel.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar3.getModel().getExtent();
                if (n3 == n5) {
                    DiffPanel.this.horizontalScroll1ChangedValue = 0;
                } else {
                    DiffPanel.this.horizontalScroll1ChangedValue = n * (n2 - n4) / (n3 - n5);
                }
                DiffPanel.this.horizontalScroll2ChangedValue = -1;
                jScrollBar.setValue(DiffPanel.this.horizontalScroll1ChangedValue);
            }
        });
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private String strCharacters(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void customizeEditor(JEditorPane jEditorPane) {
        StyledDocument styledDocument;
        EditorKit editorKit = jEditorPane.getEditorKit();
        Document document = jEditorPane.getDocument();
        try {
            styledDocument = (StyledDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            styledDocument = new DefaultStyledDocument();
            try {
                styledDocument.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            jEditorPane.setDocument(styledDocument);
        }
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = Integer.toString(n2).length();
        int n4 = 0;
        while (n4 <= n2) {
            int n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n4);
            String string = Integer.toString(n4 + 1);
            if (string.length() < n3) {
                string = this.strCharacters(' ', n3 - string.length()) + string;
            }
            ++n4;
        }
    }

    private void setScrollBarsIncrements() {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        int n = this.jEditorPane1.getSize().height / NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement((int)(4.0 * (double)n));
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement((int)(4.0 * (double)n));
        this.jScrollPane1.getHorizontalScrollBar().setUnitIncrement((int)(4.0 * (double)n));
        this.jScrollPane2.getHorizontalScrollBar().setUnitIncrement((int)(4.0 * (double)n));
    }

    private void addChangeListeners() {
        this.jEditorPane1.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DiffPanel.access$700(13.access$1100(this.this$1));
                        DiffPanel.access$1200(13.access$1100(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffPanel access$1100(13 var0) {
                return var0.DiffPanel.this;
            }
        });
        this.jEditorPane2.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DiffPanel.access$700(15.access$1300(this.this$1));
                        DiffPanel.access$1400(15.access$1300(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffPanel access$1300(15 var0) {
                return var0.DiffPanel.this;
            }
        });
    }

    public void setSource1(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane1.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane1.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        editorKit.install(this.jEditorPane1);
        this.jEditorPane1.setDocument(document);
        this.jEditorPane1.setEditable(false);
        this.customizeEditor(this.jEditorPane1);
        this.linesComp1 = new LinesComponent(this.jEditorPane1);
        this.jScrollPane1.setRowHeaderView(this.linesComp1);
        this.jViewport1 = this.jScrollPane1.getViewport();
    }

    public void setSource2(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane2.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane2.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        editorKit.install(this.jEditorPane2);
        this.jEditorPane2.setDocument(document);
        this.jEditorPane2.setEditable(false);
        this.customizeEditor(this.jEditorPane2);
        this.linesComp2 = new LinesComponent(this.jEditorPane2);
        this.jScrollPane2.setRowHeaderView(this.linesComp2);
        this.jViewport2 = this.jScrollPane2.getViewport();
        this.joinScrollBars();
    }

    public void setSource1Title(String string) {
        this.fileLabel1.setText(string);
    }

    public void setSource2Title(String string) {
        this.fileLabel2.setText(string);
    }

    public void setMimeType1(String string) {
        this.jEditorPane1.setContentType(string);
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane1.setEditorKit(editorKit);
    }

    public void setMimeType2(String string) {
        this.jEditorPane2.setContentType(string);
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane2.setEditorKit(editorKit);
    }

    public void setDocument1(Document document) {
        if (document != null) {
            this.jEditorPane1.setDocument(document);
        }
    }

    public void setDocument2(Document document) {
        if (document != null) {
            this.jEditorPane2.setDocument(document);
        }
    }

    private void setHighlight(StyledDocument styledDocument, int n, int n2, Color color) {
        int n3 = n - 1;
        while (n3 < n2) {
            int n4;
            if (n3 >= 0 && (n4 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n3)) >= 0) {
                Style style = styledDocument.getLogicalStyle(n4);
                if (style == null) {
                    style = styledDocument.addStyle("diff-style(" + color + "):1500", null);
                }
                style.addAttribute(StyleConstants.ColorConstants.Background, color);
                styledDocument.setLogicalStyle(n4, style);
            }
            ++n3;
        }
    }

    private void unhighlight(StyledDocument styledDocument) {
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        Style style = styledDocument.addStyle("diff-style(white):1500", null);
        style.addAttribute(StyleConstants.ColorConstants.Background, Color.white);
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n3);
            styledDocument.setLogicalStyle(n4, style);
            ++n3;
        }
    }

    public void unhighlightAll() {
        this.unhighlight((StyledDocument)this.jEditorPane1.getDocument());
        this.unhighlight((StyledDocument)this.jEditorPane2.getDocument());
    }

    public void highlightRegion1(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    public void highlightRegion2(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    private void addEmptyLines(StyledDocument styledDocument, int n, int n2) {
        int n3 = styledDocument.getEndPosition().getOffset();
        int n4 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n3);
        int n5 = n3;
        if (n <= n4) {
            n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        }
        String string = this.strCharacters('\n', n2);
        try {
            styledDocument.insertString(n5, string, null);
        }
        catch (BadLocationException badLocationException) {
            TopManager.getDefault().notifyException((Throwable)badLocationException);
        }
    }

    public void addEmptyLines1(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp1.addEmptyLines(n, n2);
    }

    public void addEmptyLines2(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp2.addEmptyLines(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ LinesComponent access$1200(DiffPanel diffPanel) {
        return diffPanel.linesComp1;
    }

    static /* synthetic */ LinesComponent access$1400(DiffPanel diffPanel) {
        return diffPanel.linesComp2;
    }
}

