/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.netbeans.modules.settings.Env;
import org.netbeans.modules.settings.ScheduledRequest;
import org.netbeans.modules.settings.convertors.ModuleInfoManager;
import org.netbeans.modules.settings.convertors.SerialDataNode;
import org.netbeans.modules.settings.convertors.XMLSettingsSupport;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceDataObject;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

public final class SerialDataConvertor
extends FileChangeAdapter
implements PropertyChangeListener,
FileSystem.AtomicAction {
    static final String EA_NAME = "name";
    final Object READWRITE_LOCK = new Object();
    private final InstanceContent lkpContent;
    private final Lookup lookup;
    private final DataObject dobj;
    private final FileObject provider;
    private final NodeConvertor node;
    private SettingsInstance instance;
    private SaveSupport saver;
    private ErrorManager err;
    private PropertyChangeListener moduleInfoListener;
    private ModuleInfo mi;
    private boolean miUnInitialized = true;
    private static final ErrorManager _err = ErrorManager.getDefault();
    private ScheduledRequest request;

    public SerialDataConvertor(DataObject dataObject, FileObject fileObject) {
        this.err = ErrorManager.getDefault().getInstance(this.getClass().getName());
        this.dobj = dataObject;
        this.provider = fileObject;
        this.lkpContent = new InstanceContent();
        FileObject fileObject2 = dataObject.getPrimaryFile();
        fileObject2.addFileChangeListener(WeakListener.fileChange((FileChangeListener)this, (Object)fileObject2));
        if (this.isModuleEnabled()) {
            this.instance = this.createInstance(null);
            this.lkpContent.add((Object)this.instance);
        }
        this.lkpContent.add((Object)this);
        this.node = new NodeConvertor();
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.lkpContent);
    }

    private SerialDataConvertor() {
        this.lkpContent = null;
        this.lookup = null;
        this.dobj = null;
        this.provider = null;
        this.node = null;
    }

    public static Object createWriter() {
        return new SerialDataConvertor();
    }

    public void write(Writer writer, Object object) throws IOException {
        XMLSettingsSupport.storeToXML10(object, writer, ModuleInfoManager.getDefault().getModuleInfo(object.getClass()));
    }

    void handleUnfiredChange() {
        this.saver.propertyChange(null);
    }

    DataObject getDataObject() {
        return this.dobj;
    }

    FileObject getProvider() {
        return this.provider;
    }

    public final Lookup getLookup() {
        return this.lookup;
    }

    private SettingsInstance createInstance(Object object) {
        return new SettingsInstance(object);
    }

    private SaveSupport createSaveSupport(Object object) {
        return new SaveSupport(object);
    }

    private synchronized void attachToInstance(Object object) {
        if (this.saver != null) {
            this.saver.removePropertyChangeListener(this);
            this.saver.flush();
        }
        this.saver = this.createSaveSupport(object);
        this.saver.addPropertyChangeListener(this);
    }

    private void provideSaveCookie() {
        if (this.saver.isChanged()) {
            this.lkpContent.add((Object)this.saver);
        } else {
            this.lkpContent.remove((Object)this.saver);
        }
    }

    private void instanceCookieChanged(Object object) {
        SaveSupport saveSupport = this.saver;
        if (saveSupport != null) {
            saveSupport.removePropertyChangeListener(this);
            this.lkpContent.remove((Object)saveSupport);
            this.getScheduledRequest().cancel();
            this.saver = null;
        }
        this.lkpContent.remove((Object)this, (InstanceContent.Convertor)this.node);
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        if (this.instance != null) {
            this.lkpContent.remove((Object)this.instance);
            this.instance = null;
        }
        if (this.isModuleEnabled()) {
            this.instance = this.createInstance(object);
            this.lkpContent.add((Object)this.instance);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string == "savecookie") {
            this.provideSaveCookie();
        } else if (string == "fileChanged") {
            this.miUnInitialized = true;
            if (this.mi != null) {
                ModuleInfoManager.getDefault().unregisterPropertyChangeListener(this.moduleInfoListener, this.mi);
            }
            this.instanceCookieChanged(null);
        } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            this.instanceCookieChanged(null);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        if (this.saver != null && fileEvent.firedFrom((FileSystem.AtomicAction)this.saver)) {
            return;
        }
        this.propertyChange(new PropertyChangeEvent(this, "fileChanged", null, null));
    }

    private boolean isModuleEnabled() {
        if (this.miUnInitialized) {
            this.mi = this.getModuleInfo();
            this.miUnInitialized = false;
            if (this.mi != null) {
                this.moduleInfoListener = WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.mi);
                ModuleInfoManager.getDefault().registerPropertyChangeListener(this.moduleInfoListener, this.mi);
            }
        }
        return this.mi == null || this.mi.isEnabled();
    }

    private ModuleInfo getModuleInfo() {
        try {
            String string = new SettingsInstance(null).getSettings(true).getCodeNameBase();
            return string == null ? null : ModuleInfoManager.getDefault().getModule(string);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    static void inform(Throwable throwable) {
        _err.notify(1, throwable);
    }

    public void run() throws IOException {
        this.saver.writeDown();
    }

    private synchronized ScheduledRequest getScheduledRequest() {
        if (this.request == null) {
            this.request = new ScheduledRequest(this.getDataObject().getPrimaryFile(), this);
        }
        return this.request;
    }

    private static final class NodeConvertor
    implements InstanceContent.Convertor {
        static /* synthetic */ Class class$org$openide$nodes$Node;

        private NodeConvertor() {
        }

        public Object convert(Object object) {
            SerialDataConvertor serialDataConvertor = (SerialDataConvertor)object;
            return new SerialDataNode(serialDataConvertor);
        }

        public Class type(Object object) {
            return class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = NodeConvertor.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node;
        }

        public String id(Object object) {
            return object.toString();
        }

        public String displayName(Object object) {
            return object.toString();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static final class Provider
    implements Environment.Provider {
        private final FileObject providerFO;

        public static Environment.Provider create(FileObject fileObject) {
            return new Provider(fileObject);
        }

        private Provider(FileObject fileObject) {
            this.providerFO = fileObject;
        }

        public Lookup getEnvironment(DataObject dataObject) {
            if (!(dataObject instanceof InstanceDataObject)) {
                return Lookup.EMPTY;
            }
            return new SerialDataConvertor(dataObject, this.providerFO).getLookup();
        }
    }

    private final class SaveSupport
    implements FileSystem.AtomicAction,
    SaveCookie,
    PropertyChangeListener,
    Saver {
        public static final String PROP_SAVE = "savecookie";
        public static final String PROP_FILE_CHANGED = "fileChanged";
        private ArrayList propertyChangeListenerList;
        private boolean isChanged = false;
        private final FileObject file;
        private final WeakReference instance;
        private Boolean knownToBeTemplate = null;
        private boolean isWriting = false;
        private Convertor convertor;
        private ByteArrayOutputStream buf;
        static /* synthetic */ Class class$java$beans$PropertyChangeListener;

        public SaveSupport(Object object) {
            this.instance = new WeakReference<Object>(object);
            this.file = SerialDataConvertor.this.getDataObject().getPrimaryFile();
        }

        public final boolean isChanged() {
            return this.isChanged;
        }

        private boolean acceptSave() {
            Object t = this.instance.get();
            return t != null && t instanceof Serializable && !(t instanceof TopComponent);
        }

        private boolean ignoreChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.isChanged || this.isWriting || !SerialDataConvertor.this.getDataObject().isValid()) {
                return true;
            }
            if (propertyChangeEvent != null && Boolean.FALSE.equals(propertyChangeEvent.getPropagationId())) {
                return true;
            }
            if (this.knownToBeTemplate == null) {
                this.knownToBeTemplate = SerialDataConvertor.this.getDataObject().isTemplate() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.knownToBeTemplate;
        }

        private Convertor getConvertor() {
            return this.convertor;
        }

        private Convertor initConvertor() {
            Object t = this.instance.get();
            if (t == null) {
                throw new IllegalStateException("setting object cannot be null: " + SerialDataConvertor.this.getDataObject());
            }
            try {
                FileObject fileObject = Env.findProvider(t.getClass());
                if (fileObject != null) {
                    Object object;
                    FileObject fileObject2 = Env.findEntityRegistration(fileObject);
                    if (fileObject2 == null) {
                        fileObject2 = fileObject;
                    }
                    if ((object = fileObject2.getAttribute("hint.originalPublicID")) == null || !(object instanceof String)) {
                        throw new IOException("missing or invalid attribute: hint.originalPublicID, provider: " + fileObject2);
                    }
                    if ("-//NetBeans//DTD Session settings 1.0//EN".equals(object)) {
                        this.convertor = null;
                        return this.convertor;
                    }
                    object = fileObject.getAttribute("settings.convertor");
                    if (object == null || !(object instanceof Convertor)) {
                        throw new IOException("cannot create convertor: " + object + ", provider: " + fileObject);
                    }
                    this.convertor = (Convertor)object;
                    return this.convertor;
                }
            }
            catch (IOException iOException) {
                SerialDataConvertor.inform(iOException);
            }
            return this.convertor;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerList == null) {
                this.propertyChangeListenerList = new ArrayList();
                Object t = this.instance.get();
                if (t == null) {
                    return;
                }
                Convertor convertor = this.initConvertor();
                if (convertor != null) {
                    convertor.registerSaver(t, this);
                } else {
                    this.registerPropertyChangeListener(t);
                }
            }
            this.propertyChangeListenerList.add(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerList != null && !this.propertyChangeListenerList.isEmpty()) {
                ((AbstractCollection)this.propertyChangeListenerList).remove(propertyChangeListener);
                Object t = this.instance.get();
                if (t == null) {
                    return;
                }
                Convertor convertor = this.getConvertor();
                if (convertor != null) {
                    convertor.unregisterSaver(t, this);
                } else {
                    this.unregisterPropertyChangeListener(t);
                }
            }
        }

        private void registerPropertyChangeListener(Object object) {
            try {
                Method method = object.getClass().getMethod("addPropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = SaveSupport.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                method.invoke(object, this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                if (errorManager.isLoggable(1)) {
                    errorManager.log(1, "NoSuchMethodException: " + object.getClass().getName() + ".addPropertyChangeListener");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)illegalAccessException, "Instance: " + object);
                errorManager.notify((Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
            }
        }

        private void unregisterPropertyChangeListener(Object object) {
            try {
                Method method = object.getClass().getMethod("removePropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = SaveSupport.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                method.invoke(object, this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                if (errorManager.isLoggable(1)) {
                    errorManager.log(1, "NoSuchMethodException: " + object.getClass().getName() + ".removePropertyChangeListener");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)illegalAccessException, "Instance: " + object);
                errorManager.notify((Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
            }
        }

        private void firePropertyChange(String string) {
            ArrayList arrayList;
            SaveSupport saveSupport = this;
            synchronized (saveSupport) {
                if (this.propertyChangeListenerList == null) {
                    return;
                }
                arrayList = (ArrayList)this.propertyChangeListenerList.clone();
            }
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, null, null);
            int n = 0;
            while (n < arrayList.size()) {
                ((PropertyChangeListener)arrayList.get(n)).propertyChange(propertyChangeEvent);
                ++n;
            }
        }

        public void flush() {
            SerialDataConvertor.this.getScheduledRequest().forceToFinish();
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.ignoreChange(propertyChangeEvent)) {
                return;
            }
            this.isChanged = true;
            this.firePropertyChange(PROP_SAVE);
            if (this.acceptSave()) {
                SerialDataConvertor.this.getScheduledRequest().schedule(this.instance.get());
            }
        }

        public void markDirty() {
            if (this.ignoreChange(null)) {
                return;
            }
            this.isChanged = true;
            this.firePropertyChange(PROP_SAVE);
        }

        public void requestSave() throws IOException {
            if (this.ignoreChange(null)) {
                return;
            }
            this.isChanged = true;
            this.firePropertyChange(PROP_SAVE);
            SerialDataConvertor.this.getScheduledRequest().schedule(this.instance.get());
        }

        public void run() throws IOException {
            if (!SerialDataConvertor.this.getDataObject().isValid()) {
                if (SerialDataConvertor.this.err.isLoggable(1)) {
                    SerialDataConvertor.this.err.log("invalid data object cannot be used for storing " + SerialDataConvertor.this.getDataObject());
                }
                return;
            }
            try {
                this.try2run();
            }
            catch (IOException iOException) {
                if (SerialDataConvertor.this.getDataObject().isValid()) {
                    throw iOException;
                }
                return;
            }
        }

        private void try2run() throws IOException {
            Object object = SerialDataConvertor.this.READWRITE_LOCK;
            synchronized (object) {
                FileLock fileLock;
                if (SerialDataConvertor.this.err.isLoggable(1)) {
                    SerialDataConvertor.this.err.log("saving " + SerialDataConvertor.this.getDataObject());
                }
                if ((fileLock = SerialDataConvertor.this.getScheduledRequest().getFileLock()) == null) {
                    return;
                }
                OutputStream outputStream = this.file.getOutputStream(fileLock);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
                try {
                    this.buf.writeTo(bufferedOutputStream);
                    if (SerialDataConvertor.this.err.isLoggable(1)) {
                        SerialDataConvertor.this.err.log("saved " + SerialDataConvertor.this.dobj);
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    ((OutputStream)bufferedOutputStream).close();
                    throw throwable;
                }
                ((OutputStream)bufferedOutputStream).close();
            }
        }

        public void save() throws IOException {
            if (!this.isChanged) {
                return;
            }
            SerialDataConvertor.this.getScheduledRequest().runAndWait();
        }

        private void writeDown() throws IOException {
            Object t = this.instance.get();
            if (t == null) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            try {
                this.isWriting = true;
                Convertor convertor = this.getConvertor();
                if (convertor != null) {
                    convertor.write(outputStreamWriter, t);
                } else {
                    SerialDataConvertor.this.write(outputStreamWriter, t);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ((Writer)outputStreamWriter).close();
                this.isWriting = false;
                throw throwable;
            }
            ((Writer)outputStreamWriter).close();
            this.isWriting = false;
            this.isChanged = false;
            this.buf = byteArrayOutputStream;
            this.file.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            this.buf = null;
            this.synchronizeName(t);
            if (!this.isChanged) {
                this.firePropertyChange(PROP_SAVE);
            }
        }

        private void synchronizeName(Object object) {
            Method method;
            try {
                try {
                    method = object.getClass().getMethod("getDisplayName", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = object.getClass().getMethod("getName", null);
                }
            }
            catch (Exception exception) {
                return;
            }
            try {
                String string = (String)method.invoke(object, null);
                String string2 = (String)SerialDataConvertor.this.dobj.getPrimaryFile().getAttribute(SerialDataConvertor.EA_NAME);
                if (string != null && !string.equals(string2)) {
                    SerialDataConvertor.this.dobj.rename(string);
                }
            }
            catch (Exception exception) {
                SerialDataConvertor.this.err.annotate((Throwable)exception, SerialDataConvertor.this.dobj.getPrimaryFile().toString());
                SerialDataConvertor.inform(exception);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class SettingsInstance
    implements InstanceCookie.Of,
    InstanceCookie.Origin {
        private SoftReference inst;
        private XMLSettingsSupport.SettingsRecognizer settings = null;
        private boolean doNotCheckContent = false;

        public SettingsInstance(Object object) {
            this.setCachedInstance(object);
        }

        private XMLSettingsSupport.SettingsRecognizer getSettings(boolean bl) throws IOException {
            SettingsInstance settingsInstance = this;
            synchronized (settingsInstance) {
                if (this.settings == null) {
                    Object object = SerialDataConvertor.this.READWRITE_LOCK;
                    synchronized (object) {
                        this.settings = new XMLSettingsSupport.SettingsRecognizer(bl, SerialDataConvertor.this.getDataObject().getPrimaryFile());
                        this.settings.parse();
                    }
                    XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.settings;
                    return settingsRecognizer;
                }
                if (!bl && !this.settings.isAllRead()) {
                    this.settings.setAllRead(false);
                    this.settings.parse();
                }
                XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.settings;
                return settingsRecognizer;
            }
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            Object object;
            SettingsInstance settingsInstance = this;
            synchronized (settingsInstance) {
                object = this.getCachedInstance();
                if (object != null) {
                    Object object2 = object;
                    return object2;
                }
            }
            XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.getSettings(false);
            object = settingsRecognizer.instanceCreate();
            SettingsInstance settingsInstance2 = this;
            synchronized (settingsInstance2) {
                Object object3 = this.getCachedInstance();
                if (object3 != null) {
                    Object object4 = object3;
                    return object4;
                }
                this.setCachedInstance(object);
            }
            SerialDataConvertor.this.attachToInstance(object);
            return object;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            Object object = this.getCachedInstance();
            if (object != null) {
                return object.getClass();
            }
            XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.getSettings(false);
            return settingsRecognizer.instanceClass();
        }

        public boolean instanceOf(Class clazz) {
            try {
                if (SerialDataConvertor.this.mi != null && ModuleInfoManager.getDefault().isReloaded(SerialDataConvertor.this.mi) && clazz.getClassLoader() != ClassLoader.getSystemClassLoader()) {
                    Class clazz2 = this.instanceClass();
                    return clazz.isAssignableFrom(clazz2);
                }
                return this.getSettings(true).getInstanceOf().contains(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                SerialDataConvertor.this.err.annotate((Throwable)classNotFoundException, SerialDataConvertor.this.getDataObject().getPrimaryFile().toString());
                SerialDataConvertor.inform(classNotFoundException);
            }
            catch (IOException iOException) {
                SerialDataConvertor.this.err.annotate((Throwable)iOException, SerialDataConvertor.this.getDataObject().getPrimaryFile().toString());
                SerialDataConvertor.inform(iOException);
            }
            return false;
        }

        public String instanceName() {
            Object object = this.getCachedInstance();
            if (object != null) {
                return object.getClass().getName();
            }
            try {
                return this.getSettings(true).instanceName();
            }
            catch (IOException iOException) {
                SerialDataConvertor.this.err.annotate((Throwable)iOException, SerialDataConvertor.this.getDataObject().getPrimaryFile().toString());
                SerialDataConvertor.inform(iOException);
                return "";
            }
        }

        public FileObject instanceOrigin() {
            return SerialDataConvertor.this.getDataObject().getPrimaryFile();
        }

        private Object getCachedInstance() {
            return this.inst.get();
        }

        private void setCachedInstance(Object object) {
            this.inst = new SoftReference<Object>(object);
        }

        public void setInstance(Object object) throws IOException {
            SerialDataConvertor.this.instanceCookieChanged(object);
            if (object != null) {
                SerialDataConvertor.this.attachToInstance(object);
                SerialDataConvertor.this.getScheduledRequest().runAndWait();
            }
        }
    }
}

