/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.Format;
import java.util.AbstractSequentialList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.corba.IDLDataObject;
import org.netbeans.modules.corba.settings.CORBASupportSettings;
import org.netbeans.modules.corba.settings.ORBSettings;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;

public class IDLDataLoader
extends MultiFileLoader
implements FileChangeListener {
    static final long serialVersionUID = -1462379765695052830L;
    private static final boolean DEBUG = false;
    private transient CORBASupportSettings _M_css;
    public static final String IDL_EXTENSION = "idl";
    private static final String JAVA_EXTENSION = "java";
    private static final String CLASS_EXTENSION = "class";
    public static final String PROP_EXTENSIONS = "extensions";
    protected transient int fi_counter = 0;
    protected transient HashMap _M_folders = new HashMap();
    public boolean _M_hide_generated_files = true;
    static /* synthetic */ Class class$org$netbeans$modules$corba$IDLDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$corba$IDLDataLoader;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$netbeans$modules$corba$ParseAction;
    static /* synthetic */ Class class$org$netbeans$modules$corba$GenerateImplAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$corba$settings$CORBASupportSettings;

    public IDLDataLoader() {
        super(class$org$netbeans$modules$corba$IDLDataObject == null ? (class$org$netbeans$modules$corba$IDLDataObject = IDLDataLoader.class$("org.netbeans.modules.corba.IDLDataObject")) : class$org$netbeans$modules$corba$IDLDataObject);
    }

    protected void initialize() {
        this.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$corba$IDLDataLoader == null ? (class$org$netbeans$modules$corba$IDLDataLoader = IDLDataLoader.class$("org.netbeans.modules.corba.IDLDataLoader")) : class$org$netbeans$modules$corba$IDLDataLoader)).getString("PROP_IDLLoader_Name"));
        this.setActions(new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = IDLDataLoader.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = IDLDataLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = IDLDataLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$corba$ParseAction == null ? (class$org$netbeans$modules$corba$ParseAction = IDLDataLoader.class$("org.netbeans.modules.corba.ParseAction")) : class$org$netbeans$modules$corba$ParseAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$corba$GenerateImplAction == null ? (class$org$netbeans$modules$corba$GenerateImplAction = IDLDataLoader.class$("org.netbeans.modules.corba.GenerateImplAction")) : class$org$netbeans$modules$corba$GenerateImplAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = IDLDataLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = IDLDataLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = IDLDataLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = IDLDataLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = IDLDataLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = IDLDataLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = IDLDataLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = IDLDataLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))});
    }

    public ExtensionList getExtensions() {
        ExtensionList extensionList = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (extensionList == null) {
            extensionList = new ExtensionList();
            extensionList.addExtension(IDL_EXTENSION);
            this.putProperty(PROP_EXTENSIONS, extensionList, false);
        }
        return extensionList;
    }

    public void setExtensions(ExtensionList extensionList) {
        this.putProperty(PROP_EXTENSIONS, extensionList, true);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.getProperty(PROP_EXTENSIONS));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.available() > 0) {
            objectInput.readInt();
            this.putProperty(PROP_EXTENSIONS, objectInput.readObject(), false);
        }
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws IOException {
        return new IDLDataObject(fileObject, this);
    }

    public boolean getHide() {
        return this._M_hide_generated_files;
    }

    public void setHide(boolean bl) {
        boolean bl2 = this._M_hide_generated_files;
        this._M_hide_generated_files = bl;
        this.firePropertyChange("_M_hide_generated_files", new Object(), new Object());
    }

    public boolean folderIsInCache(FileObject fileObject) {
        return this._M_folders.containsKey(fileObject);
    }

    public String getAbsolutePath(FileObject fileObject) {
        return fileObject.getPackageName('/') + fileObject.getName();
    }

    public void addFolderToCache(FileObject fileObject) {
        WeakSet weakSet = new WeakSet();
        fileObject.addFileChangeListener((FileChangeListener)this);
        this._M_folders.put(fileObject, weakSet);
    }

    public void removeFolderFromCache(FileObject fileObject) {
        fileObject.removeFileChangeListener((FileChangeListener)this);
        this._M_folders.remove(fileObject);
    }

    public void addFosToCache(FileObject fileObject, WeakSet weakSet) {
        fileObject.addFileChangeListener((FileChangeListener)this);
        this._M_folders.put(fileObject, weakSet);
    }

    public boolean isFileObjectInWeakSet(WeakSet weakSet, FileObject fileObject) {
        Iterator iterator = weakSet.iterator();
        while (iterator.hasNext()) {
            if (!fileObject.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void addFileObjectToCache(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        WeakSet weakSet = (WeakSet)this._M_folders.get(fileObject2);
        if (weakSet != null) {
            if (!this.isFileObjectInWeakSet(weakSet, fileObject)) {
                String string = fileObject.getName() + "." + fileObject.getExt();
                weakSet.add((Object)fileObject);
            }
        } else {
            WeakSet weakSet2 = new WeakSet();
            weakSet2.add((Object)fileObject);
            this.addFosToCache(fileObject2, weakSet2);
        }
    }

    public void removeFileObjectFromCache(FileObject fileObject) {
        WeakSet weakSet;
        if (this.folderIsInCache(fileObject.getParent()) && this.isFileObjectInWeakSet(weakSet = (WeakSet)this._M_folders.get(fileObject.getParent()), fileObject)) {
            weakSet.remove((Object)fileObject);
        }
    }

    public WeakSet getFileObjectsForFileObject(FileObject fileObject) {
        return (WeakSet)this._M_folders.get(fileObject.getParent());
    }

    public LinkedList getDataObjectsFromFileObjects(WeakSet weakSet) {
        LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
        if (weakSet == null) {
            return linkedList;
        }
        DataObject dataObject = null;
        FileObject fileObject = null;
        Iterator iterator = weakSet.iterator();
        while (iterator.hasNext()) {
            block4: {
                fileObject = (FileObject)iterator.next();
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObject = null;
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block4;
                    dataObjectNotFoundException.printStackTrace();
                }
            }
            if (dataObject == null) continue;
            linkedList.add(dataObject);
        }
        return linkedList;
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2;
        Object object;
        if (fileObject.isFolder()) {
            return null;
        }
        if (fileObject.getParent() == null) {
            return null;
        }
        String string = fileObject.getExt();
        if (this.getExtensions().isRegistered(fileObject)) {
            this.addFileObjectToCache(fileObject);
            return fileObject;
        }
        if (!string.equals(JAVA_EXTENSION) && !string.equals(CLASS_EXTENSION)) {
            return null;
        }
        if (this._M_css == null) {
            this._M_css = (CORBASupportSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$corba$settings$CORBASupportSettings == null ? (class$org$netbeans$modules$corba$settings$CORBASupportSettings = IDLDataLoader.class$("org.netbeans.modules.corba.settings.CORBASupportSettings")) : class$org$netbeans$modules$corba$settings$CORBASupportSettings), (boolean)true);
        }
        if (!this.folderIsInCache(fileObject.getParent())) {
            object = this.findIdls(fileObject);
            fileObject2 = fileObject.getParent();
            this.addFosToCache(fileObject2, (WeakSet)object);
        }
        if ((object = this.getDataObjectsFromFileObjects(this.getFileObjectsForFileObject(fileObject))) == null) {
            return null;
        }
        fileObject2 = null;
        IDLDataObject iDLDataObject = null;
        try {
            Iterator iterator = ((AbstractSequentialList)object).iterator();
            while (iterator.hasNext()) {
                ORBSettings oRBSettings;
                iDLDataObject = (IDLDataObject)iterator.next();
                if (!iDLDataObject.canGenerate(fileObject)) continue;
                String string2 = iDLDataObject.getOrbForCompilation();
                ORBSettings oRBSettings2 = oRBSettings = string2 != null ? this._M_css.getSettingByName(string2) : this._M_css.getActiveSetting();
                if (oRBSettings != null && oRBSettings.hideGeneratedFiles()) {
                    fileObject2 = iDLDataObject.getPrimaryFile();
                    return fileObject2;
                }
                return null;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new IDLFileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry.Numb(multiDataObject, fileObject);
    }

    protected WeakSet findIdls(FileObject fileObject) {
        ++this.fi_counter;
        FileObject fileObject2 = fileObject.getParent();
        FileObject[] fileObjectArray = fileObject2.getChildren();
        WeakSet weakSet = new WeakSet();
        int n = 0;
        while (n < fileObjectArray.length) {
            if (fileObjectArray[n].isData() && fileObjectArray[n].getExt().equals(IDL_EXTENSION)) {
                weakSet.add((Object)fileObjectArray[n]);
            }
            ++n;
        }
        return weakSet;
    }

    protected Map createStringsMap() {
        if (this._M_css == null) {
            this._M_css = (CORBASupportSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$corba$settings$CORBASupportSettings == null ? (class$org$netbeans$modules$corba$settings$CORBASupportSettings = IDLDataLoader.class$("org.netbeans.modules.corba.settings.CORBASupportSettings")) : class$org$netbeans$modules$corba$settings$CORBASupportSettings), (boolean)true);
        }
        return this._M_css.getActiveSetting().getReplaceableStringsProps();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        FileObject fileObject2 = fileObject.getParent();
        if (this.folderIsInCache(fileObject2) && fileObject.getExt().equals(IDL_EXTENSION)) {
            this.addFileObjectToCache(fileObject);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (fileObject.isFolder()) {
            this.removeFolderFromCache(fileObject);
        }
        if (fileObject.isData()) {
            this.removeFileObjectFromCache(fileObject);
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class IDLFileEntry
    extends FileEntry.Format {
        static final long serialVersionUID = -3139969782935474471L;

        IDLFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            Map map = IDLDataLoader.this.createStringsMap();
            map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            map.put("NAME", string);
            MapFormat mapFormat = new MapFormat(map);
            mapFormat.setLeftBrace("__");
            mapFormat.setRightBrace("__");
            mapFormat.setExactMatch(false);
            return mapFormat;
        }
    }
}

