/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.browser.ir.util;

public final class StringConvert {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexChar(char c) {
        int n = c % 16;
        int n2 = c / 16;
        return "\\x" + table[n2] + table[n];
    }

    private static String convertChar(char c) {
        switch (c) {
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\u000b': {
                return "\\v";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\u0007': {
                return "\\a";
            }
        }
        return StringConvert.toHexChar(c);
    }

    public static String convert(char c) {
        if (c < ' ') {
            return StringConvert.convertChar(c);
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '?') {
            return "\\?";
        }
        return new Character(c).toString();
    }

    public static String convert(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < ' ') {
                String string2 = StringConvert.convertChar(c);
                stringBuffer.append(string2);
            } else if (c == '\\') {
                stringBuffer.append("\\\\");
            } else if (c == '\'') {
                stringBuffer.append("\\'");
            } else if (c == '\"') {
                stringBuffer.append("\\\"");
            } else if (c == '?') {
                stringBuffer.append("\\?");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

