/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.idl.cpp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.modules.corba.utils.FileUtils;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class Preprocessor {
    static final int START = 0;
    static final int NORMAL = 1;
    static final int BLOCK_COMMENT = 2;
    static final int MASK_SKIP = 1;
    static final int MASK_ELSE = 2;
    static final int MASK_AVAIL = 4;
    static final int CMD_NONE = 0;
    static final int CMD_UNKNOWN = 1;
    static final int CMD_SKIP = 2;
    static final String LBL_DEFINE = "define";
    static final int CMD_DEFINE = 3;
    static final String LBL_UNDEF = "undef";
    static final int CMD_UNDEF = 4;
    static final String LBL_INCLUDE = "include";
    static final int CMD_INCLUDE = 5;
    static final String LBL_LINE = "line";
    static final int CMD_LINE = 6;
    static final String LBL_IFDEF = "ifdef";
    static final int CMD_IFDEF = 7;
    static final String LBL_IFNDEF = "ifndef";
    static final int CMD_IFNDEF = 8;
    static final String LBL_ELSE = "else";
    static final int CMD_ELSE = 9;
    static final String LBL_ENDIF = "endif";
    static final int CMD_ENDIF = 10;
    static final String LBL_IF = "if";
    static final int CMD_IF = 11;
    static final String LBL_ELIF = "elif";
    static final int CMD_ELIF = 12;
    boolean included;
    boolean systemFile;
    String[] sysDirs;
    File file;
    FileObject fobj;
    String pwd;
    String filename;
    BufferedReader input;
    PrintStream output;
    Hashtable defines;
    int[] ifDepth;
    int state;
    String str;
    int line;
    int pos;
    int lineHeight;
    static final int TOKEN_UNKNOWN = -1;
    static final int TOKEN_ERROR = 0;
    static final int TOKEN_NONE = 1;
    static final int TOKEN_VALUE = 2;
    static final int TOKEN_OR = 3;
    static final int TOKEN_AND = 4;
    static final int TOKEN_NOT = 5;
    static final int TOKEN_LBRACKET = 6;
    static final int TOKEN_RBRACKET = 7;
    static final int TOKEN_EQUAL = 8;
    static final int TOKEN_NOT_EQUAL = 9;
    static final int TOKEN_GREATER = 10;
    static final int TOKEN_GREATER_EQUAL = 11;
    static final int TOKEN_LESS = 12;
    static final int TOKEN_LESS_EQUAL = 13;
    static final int TOKEN_PLUS = 14;
    static final int TOKEN_MINUS = 15;
    static final int TOKEN_MULTIPLE = 16;
    static final int TOKEN_DIVIDE = 17;
    static final int TOKEN_REMAINDER = 18;
    static final int TOKEN_LSHIFT = 19;
    static final int TOKEN_RSHIFT = 20;
    static final int TOKEN_BOR = 21;
    static final int TOKEN_BAND = 22;
    static final int TOKEN_BXOR = 23;
    int token;
    long tokenValue;
    int tokenStart;

    public Preprocessor(String string, String string2, Hashtable hashtable, String[] stringArray, PrintStream printStream, boolean bl) {
        this(string, string2, hashtable, stringArray, printStream);
        this.included = true;
        this.systemFile = bl;
    }

    public Preprocessor(String string, String string2, Hashtable hashtable, String[] stringArray, PrintStream printStream) {
        this.pwd = string;
        this.file = null;
        this.filename = string2;
        this.input = null;
        this.output = printStream;
        this.defines = hashtable != null ? hashtable : new Hashtable();
        this.sysDirs = stringArray != null ? stringArray : new String[]{};
        this.ifDepth = new int[0];
        this.line = 0;
        this.included = false;
        this.systemFile = false;
    }

    void error(String string) throws PreprocessorException {
        throw new PreprocessorException(this.line - this.lineHeight, "Error on line " + (this.line - this.lineHeight) + ": " + string);
    }

    static void staticError(String string) throws PreprocessorException {
        throw new PreprocessorException(0, "Error: " + string);
    }

    void addDepth() {
        int[] nArray = this.ifDepth;
        this.ifDepth = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this.ifDepth, 1, nArray.length);
    }

    void removeDepth() {
        int[] nArray = this.ifDepth;
        this.ifDepth = new int[nArray.length - 1];
        System.arraycopy(nArray, 1, this.ifDepth, 0, this.ifDepth.length);
    }

    boolean readLine() throws IOException {
        this.str = this.input.readLine();
        this.lineHeight = 0;
        if (this.str == null) {
            return false;
        }
        ++this.line;
        ++this.lineHeight;
        while (this.str.endsWith("\\")) {
            this.str = this.str.substring(0, this.str.length() - 1);
            String string = this.input.readLine();
            if (string == null) {
                return true;
            }
            this.str = this.str + string;
            ++this.line;
            ++this.lineHeight;
        }
        return true;
    }

    boolean readLineNext() throws IOException {
        this.str = this.str.substring(0, this.str.length() - 1) + "/*";
        String string = this.input.readLine();
        if (string == null) {
            return false;
        }
        this.str = this.str + string;
        ++this.line;
        ++this.lineHeight;
        while (this.str.endsWith("\\")) {
            this.str = this.str.substring(0, this.str.length() - 1);
            string = this.input.readLine();
            if (string == null) {
                return true;
            }
            this.str = this.str + string;
            ++this.line;
            ++this.lineHeight;
        }
        return true;
    }

    void writeOutput(String string) {
        if (string != null) {
            this.output.println(string);
        } else {
            this.output.println();
        }
        while (this.lineHeight > 1) {
            --this.lineHeight;
            this.output.println();
        }
    }

    int getPosChar() {
        return this.pos < this.str.length() ? (int)this.str.charAt(this.pos) : -1;
    }

    int getPosChar(int n) {
        return (n += this.pos) < this.str.length() ? (int)this.str.charAt(n) : -1;
    }

    boolean isDigit(int n) {
        return n >= 0 && Character.isDigit((char)n);
    }

    int getHexNumber(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        return -1;
    }

    int getOctalNumber(int n) {
        if (n >= 48 && n <= 55) {
            return n - 48;
        }
        return -1;
    }

    boolean isJavaIdentifierStart(int n) {
        return n >= 0 && Character.isJavaIdentifierStart((char)n);
    }

    int eatWhiteSpaces() {
        int n = this.pos;
        while (this.pos < this.str.length() && Character.isWhitespace(this.str.charAt(this.pos))) {
            ++this.pos;
        }
        return this.pos - n;
    }

    String eatCharacter() throws PreprocessorException {
        if (this.getPosChar() != 39) {
            return null;
        }
        ++this.pos;
        int n = this.pos;
        while (this.pos < this.str.length() && this.str.charAt(this.pos) != '\'') {
            if (this.getPosChar() == 92) {
                switch (this.getPosChar(1)) {
                    case 34: 
                    case 39: 
                    case 92: {
                        ++this.pos;
                    }
                }
            }
            ++this.pos;
        }
        if (this.pos >= this.str.length()) {
            this.error("Unterminated character: " + this.str);
        }
        String string = this.str.substring(n, this.pos);
        ++this.pos;
        return string;
    }

    String eatString() throws PreprocessorException {
        if (this.getPosChar() != 34) {
            return null;
        }
        ++this.pos;
        int n = this.pos;
        while (this.pos < this.str.length() && this.str.charAt(this.pos) != '\"') {
            if (this.getPosChar() == 92) {
                switch (this.getPosChar(1)) {
                    case 34: 
                    case 39: 
                    case 92: {
                        ++this.pos;
                    }
                }
            }
            ++this.pos;
        }
        if (this.pos >= this.str.length()) {
            this.error("Unterminated string: " + this.str);
        }
        String string = this.str.substring(n, this.pos);
        ++this.pos;
        return string;
    }

    String eatIncludeString() {
        if (this.getPosChar() != 60) {
            return null;
        }
        ++this.pos;
        int n = this.pos;
        while (this.pos < this.str.length() && this.str.charAt(this.pos) != '>') {
            ++this.pos;
        }
        if (this.pos >= this.str.length()) {
            return null;
        }
        String string = this.str.substring(n, this.pos);
        ++this.pos;
        return string;
    }

    String eatIncludeString2() {
        if (this.getPosChar() != 34) {
            return null;
        }
        ++this.pos;
        int n = this.pos;
        while (this.pos < this.str.length() && this.str.charAt(this.pos) != '\"') {
            ++this.pos;
        }
        if (this.pos >= this.str.length()) {
            return null;
        }
        String string = this.str.substring(n, this.pos);
        ++this.pos;
        return string;
    }

    String eatIdentifier() {
        int n = this.pos;
        if (this.pos >= this.str.length() || !Character.isJavaIdentifierStart(this.str.charAt(this.pos))) {
            return null;
        }
        ++this.pos;
        while (this.pos < this.str.length() && Character.isJavaIdentifierPart(this.str.charAt(this.pos))) {
            ++this.pos;
        }
        return this.str.substring(n, this.pos);
    }

    String eatInteger() {
        int n = this.pos;
        while (this.pos < this.str.length() && Character.isDigit(this.str.charAt(this.pos))) {
            ++this.pos;
        }
        if (n >= this.pos) {
            return null;
        }
        return this.str.substring(n, this.pos);
    }

    int findCommand() throws IOException {
        this.pos = 0;
        this.eatWhiteSpaces();
        if (this.getPosChar() != 35) {
            return 0;
        }
        ++this.pos;
        this.eatWhiteSpaces();
        if (this.str.startsWith(LBL_DEFINE, this.pos)) {
            this.pos += LBL_DEFINE.length();
            if (this.eatWhiteSpaces() > 0) {
                return this.ifDepth.length <= 0 || (this.ifDepth[0] & 1) == 0 ? 3 : 2;
            }
        } else if (this.str.startsWith(LBL_UNDEF, this.pos)) {
            this.pos += LBL_UNDEF.length();
            if (this.eatWhiteSpaces() > 0) {
                return this.ifDepth.length <= 0 || (this.ifDepth[0] & 1) == 0 ? 4 : 2;
            }
        } else if (this.str.startsWith(LBL_INCLUDE, this.pos)) {
            this.pos += LBL_INCLUDE.length();
            if (this.eatWhiteSpaces() > 0) {
                return this.ifDepth.length <= 0 || (this.ifDepth[0] & 1) == 0 ? 5 : 2;
            }
        } else if (this.str.startsWith(LBL_LINE, this.pos)) {
            this.pos += LBL_LINE.length();
            if (this.eatWhiteSpaces() > 0) {
                return this.ifDepth.length <= 0 || (this.ifDepth[0] & 1) == 0 ? 6 : 2;
            }
        } else if (this.str.startsWith(LBL_IFDEF, this.pos)) {
            this.pos += LBL_IFDEF.length();
            if (this.eatWhiteSpaces() > 0) {
                return 7;
            }
        } else if (this.str.startsWith(LBL_IFNDEF, this.pos)) {
            this.pos += LBL_IFNDEF.length();
            if (this.eatWhiteSpaces() > 0) {
                return 8;
            }
        } else if (this.str.startsWith(LBL_ELSE, this.pos)) {
            this.pos += LBL_ELSE.length();
            if (this.pos >= this.str.length() || Character.isWhitespace(this.str.charAt(this.pos))) {
                return 9;
            }
        } else if (this.str.startsWith(LBL_ENDIF, this.pos)) {
            this.pos += LBL_ENDIF.length();
            if (this.pos >= this.str.length() || Character.isWhitespace(this.str.charAt(this.pos))) {
                return 10;
            }
        } else if (this.str.startsWith(LBL_IF, this.pos)) {
            this.pos += LBL_IF.length();
            if (this.eatWhiteSpaces() > 0) {
                return 11;
            }
        } else if (this.str.startsWith(LBL_ELIF, this.pos)) {
            this.pos += LBL_ELIF.length();
            if (this.eatWhiteSpaces() > 0) {
                return 12;
            }
        }
        return 1;
    }

    void performInclude() throws PreprocessorException {
        boolean bl;
        String string;
        switch (this.getPosChar()) {
            case 60: {
                string = this.eatIncludeString();
                bl = true;
                break;
            }
            case 34: {
                string = this.eatIncludeString2();
                bl = false;
                break;
            }
            default: {
                this.error("Invalid include argument: " + this.str);
                return;
            }
        }
        this.eatWhiteSpaces();
        if (this.pos < this.str.length()) {
            this.error("Include command expects one argument only: " + this.str);
        } else {
            if (this.file != null) {
                new Preprocessor(this.file.getParent(), string, this.defines, this.sysDirs, this.output, bl).perform();
            } else if (this.fobj != null) {
                new Preprocessor(FileUtils.getRealFileName(this.fobj.getParent()), string, this.defines, this.sysDirs, this.output, bl).perform();
            }
            this.output.println("# " + this.line + " \"" + this.filename + "\" 2");
            this.lineHeight = 1;
        }
        this.writeOutput(null);
    }

    void performDefine() throws PreprocessorException {
        String string = this.eatIdentifier();
        if (string == null || string.length() < 1) {
            this.error("Bad define name: " + this.str);
        } else {
            if (this.getPosChar() == 40) {
                this.error("Defines with arguments are not supported" + this.str);
            }
            if (this.defines.get(string) != null) {
                this.error("Redefining of define: " + string + ": " + this.str);
            }
            this.eatWhiteSpaces();
            String string2 = this.str.substring(this.pos) + " ";
            this.defines.put(string, string2);
        }
        this.writeOutput(null);
    }

    void performUndef() throws PreprocessorException {
        String string = this.eatIdentifier();
        this.eatWhiteSpaces();
        if (this.pos < this.str.length()) {
            this.error("Undef command expects one argument only: " + this.str);
        }
        if (this.defines.remove(string) == null) {
            this.error("Define does not exists: " + string + ": " + this.str);
        }
        this.writeOutput(null);
    }

    void performLineDef() throws PreprocessorException {
        String string = this.eatInteger();
        if (string == null) {
            this.error("Expected line number: " + this.str);
        } else {
            try {
                this.eatWhiteSpaces();
                if (this.pos < this.str.length()) {
                    this.error("Line command expects one argument only: " + this.str);
                } else {
                    this.line = Integer.parseInt(string) - 1;
                    this.output.println("# " + this.line + " \"" + this.filename + "\"");
                    this.lineHeight = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.error("Invalid line number format: " + this.str);
            }
        }
        this.writeOutput(null);
    }

    void performIfDef() throws PreprocessorException {
        String string = this.eatIdentifier();
        if (string == null || string.length() < 1) {
            this.error("Bad define name: " + this.str);
        } else {
            this.eatWhiteSpaces();
            if (this.pos < this.str.length()) {
                this.error("Ifdef command expects one argument only: " + this.str);
            }
            if (this.defines.get(string) != null && (this.ifDepth.length <= 0 || (this.ifDepth[0] & 1) == 0)) {
                this.addDepth();
                this.ifDepth[0] = 0;
            } else {
                this.addDepth();
                this.ifDepth[0] = 5;
            }
        }
        this.writeOutput(null);
    }

    void performIfNDef() throws PreprocessorException {
        String string = this.eatIdentifier();
        if (string == null || string.length() < 1) {
            this.error("Bad define name: " + this.str);
        } else {
            this.eatWhiteSpaces();
            if (this.pos < this.str.length()) {
                this.error("Ifndef command expects one argument only: " + this.str);
            }
            if (this.defines.get(string) == null && (this.ifDepth.length <= 0 || (this.ifDepth[0] & 1) == 0)) {
                this.addDepth();
                this.ifDepth[0] = 0;
            } else {
                this.addDepth();
                this.ifDepth[0] = 5;
            }
        }
        this.writeOutput(null);
    }

    void performElse() throws PreprocessorException {
        this.eatWhiteSpaces();
        if (this.pos < this.str.length()) {
            this.error("Else command expects no arguments: " + this.str);
        }
        if (this.ifDepth.length <= 0) {
            this.error("Unexpected else command: " + this.str);
        } else if ((this.ifDepth[0] & 2) != 0) {
            this.error("Unexpected else command: " + this.str);
            this.ifDepth[0] = 3;
        } else {
            this.ifDepth[0] = (this.ifDepth[0] & 4) != 0 && (this.ifDepth.length <= 1 || (this.ifDepth[1] & 1) == 0) ? 2 : 3;
        }
        this.writeOutput(null);
    }

    void performEndIf() throws PreprocessorException {
        this.eatWhiteSpaces();
        if (this.pos < this.str.length()) {
            this.error("Endif command expects no arguments: " + this.str);
        }
        if (this.ifDepth.length <= 0) {
            this.error("Unexpected endif command: " + this.str);
        } else {
            this.removeDepth();
        }
        this.writeOutput(null);
    }

    void performIf() throws PreprocessorException {
        String string = this.str.substring(this.pos);
        if (string == null || string.length() < 1) {
            this.error("If command expects agument: " + this.str);
        } else {
            this.str = string;
            if (this.calcExpression() && (this.ifDepth.length <= 0 || (this.ifDepth[0] & 1) == 0)) {
                this.addDepth();
                this.ifDepth[0] = 0;
            } else {
                this.addDepth();
                this.ifDepth[0] = 5;
            }
        }
        this.writeOutput(null);
    }

    void performElif() throws PreprocessorException {
        String string = this.str.substring(this.pos);
        if (string == null || string.length() < 1) {
            this.error("Elif command expects agument: " + this.str);
        } else if (this.ifDepth.length <= 0) {
            this.error("Unexpected elif command: " + this.str);
        } else if ((this.ifDepth[0] & 2) != 0) {
            this.error("Unexpected elif command: " + this.str);
            this.ifDepth[0] = 3;
        } else {
            this.str = string;
            this.ifDepth[0] = this.calcExpression() && (this.ifDepth[0] & 4) != 0 && (this.ifDepth.length <= 1 || (this.ifDepth[1] & 1) == 0) ? 0 : ((this.ifDepth[0] & 4) != 0 ? 5 : 1);
        }
        this.writeOutput(null);
    }

    void performUnknown() {
        this.pos = 0;
        this.eatWhiteSpaces();
        if (this.getPosChar() != 35) {
            this.writeOutput(null);
            return;
        }
        ++this.pos;
        int n = this.pos;
        this.eatWhiteSpaces();
        this.str = this.str.substring(0, n) + this.str.substring(this.pos);
        this.writeOutput(this.str);
    }

    boolean replaceDefines() throws PreprocessorException {
        boolean bl = false;
        String string = "";
        this.pos = 0;
        while (this.pos < this.str.length()) {
            if (this.getPosChar() == 34) {
                int n = this.pos;
                this.eatString();
                string = string + this.str.substring(n, this.pos);
                continue;
            }
            if (this.getPosChar() == 39) {
                int n = this.pos;
                this.eatCharacter();
                string = string + this.str.substring(n, this.pos);
                continue;
            }
            String string2 = this.eatIdentifier();
            if (string2 != null && string2.length() >= 1) {
                String string3 = (String)this.defines.get(string2);
                if (string3 != null) {
                    string = string + string3;
                    bl = true;
                    continue;
                }
                if (string2.startsWith("__") && string2.endsWith("__")) {
                    if ("__FILE__".equals(string2)) {
                        string = string + "\"";
                        int n = 0;
                        while (n < this.filename.length()) {
                            string = this.filename.charAt(n) == '\\' ? string + "\\\\" : string + this.filename.charAt(n);
                            ++n;
                        }
                        string = string + "\"";
                        bl = true;
                        continue;
                    }
                    if ("__LINE__".equals(string2)) {
                        string = string + this.line;
                        bl = true;
                        continue;
                    }
                    string = string + string2;
                    continue;
                }
                string = string + string2;
                continue;
            }
            string = string + (char)this.getPosChar();
            ++this.pos;
        }
        this.str = string;
        return bl;
    }

    void performComment() throws PreprocessorException {
        String string = "";
        this.pos = 0;
        if (this.state != 2) {
            this.state = 1;
        }
        while (this.pos < this.str.length()) {
            switch (this.state) {
                case 0: 
                case 1: {
                    int n;
                    if (this.getPosChar() == 47) {
                        if (this.getPosChar(1) == 47) {
                            this.pos = this.str.length();
                            string = string + ' ';
                            break;
                        }
                        if (this.getPosChar(1) == 42) {
                            this.pos += 2;
                            this.state = 2;
                            string = string + ' ';
                            break;
                        }
                    }
                    if (this.getPosChar() == 34) {
                        n = this.pos;
                        this.eatString();
                        string = string + this.str.substring(n, this.pos);
                        break;
                    }
                    if (this.getPosChar() == 39) {
                        n = this.pos;
                        this.eatCharacter();
                        string = string + this.str.substring(n, this.pos);
                        break;
                    }
                    string = string + (char)this.getPosChar();
                    ++this.pos;
                    break;
                }
                case 2: {
                    if (this.getPosChar() == 42 && this.getPosChar(1) == 47) {
                        this.pos += 2;
                        this.state = 1;
                        break;
                    }
                    ++this.pos;
                    break;
                }
                default: {
                    this.error("Internal error: bad state: " + this.str);
                }
            }
        }
        this.str = string;
    }

    void performLine() throws PreprocessorException {
        if (this.ifDepth.length > 0 && (this.ifDepth[0] & 1) != 0) {
            this.writeOutput(null);
            return;
        }
        while (this.replaceDefines()) {
        }
        this.writeOutput(this.str);
    }

    /*
     * Unable to fully structure code
     */
    int getToken() {
        if (this.str == null) {
            return 0;
        }
        if (this.token >= 0) {
            return this.token;
        }
        this.eatWhiteSpaces();
        this.tokenStart = this.pos++;
        switch (this.getPosChar()) {
            case 40: {
                this.token = 6;
                return 6;
            }
            case 41: {
                ++this.pos;
                this.token = 7;
                return 7;
            }
            case 61: {
                if (this.getPosChar(1) != 61) break;
                this.pos += 2;
                this.token = 8;
                return 8;
            }
            case 62: {
                ++this.pos;
                if (this.getPosChar() == 61) {
                    ++this.pos;
                    this.token = 11;
                    return 11;
                }
                if (this.getPosChar() == 62) {
                    ++this.pos;
                    this.token = 20;
                    return 20;
                }
                this.token = 10;
                return 10;
            }
            case 60: {
                ++this.pos;
                if (this.getPosChar() == 61) {
                    ++this.pos;
                    this.token = 13;
                    return 13;
                }
                if (this.getPosChar() == 60) {
                    ++this.pos;
                    this.token = 19;
                    return 19;
                }
                this.token = 12;
                return 12;
            }
            case 43: {
                ++this.pos;
                this.token = 14;
                return 14;
            }
            case 45: {
                ++this.pos;
                this.token = 15;
                return 15;
            }
            case 42: {
                ++this.pos;
                this.token = 16;
                return 16;
            }
            case 47: {
                ++this.pos;
                this.token = 17;
                return 17;
            }
            case 37: {
                ++this.pos;
                this.token = 18;
                return 18;
            }
            case 33: {
                ++this.pos;
                if (this.getPosChar() == 61) {
                    ++this.pos;
                    this.token = 9;
                    return 9;
                }
                this.token = 5;
                return 5;
            }
            case 124: {
                ++this.pos;
                if (this.getPosChar() == 124) {
                    ++this.pos;
                    this.token = 3;
                    return 3;
                }
                this.token = 21;
                return 21;
            }
            case 38: {
                ++this.pos;
                if (this.getPosChar() == 38) {
                    ++this.pos;
                    this.token = 4;
                    return 4;
                }
                this.token = 22;
                return 22;
            }
            case 94: {
                ++this.pos;
                this.token = 23;
                return 23;
            }
            case 39: {
                ++this.pos;
                if (this.getPosChar() != 92) ** GOTO lbl155
                ++this.pos;
                block18 : switch (this.getPosChar()) {
                    case 97: {
                        this.tokenValue = 7L;
                        ** GOTO lbl157
                    }
                    case 98: {
                        this.tokenValue = 8L;
                        ** GOTO lbl157
                    }
                    case 102: {
                        this.tokenValue = 12L;
                        ** GOTO lbl157
                    }
                    case 110: {
                        this.tokenValue = 10L;
                        ** GOTO lbl157
                    }
                    case 114: {
                        this.tokenValue = 13L;
                        ** GOTO lbl157
                    }
                    case 116: {
                        this.tokenValue = 9L;
                        ** GOTO lbl157
                    }
                    case 118: {
                        this.tokenValue = 11L;
                        ** GOTO lbl157
                    }
                    case 39: {
                        this.tokenValue = 39L;
                        ** GOTO lbl157
                    }
                    case 34: {
                        this.tokenValue = 34L;
                        ** GOTO lbl157
                    }
                    case 63: {
                        this.tokenValue = 63L;
                        ** GOTO lbl157
                    }
                    case 92: {
                        this.tokenValue = 92L;
                        ** GOTO lbl157
                    }
                    case 120: {
                        this.tokenValue = 0L;
                        if (this.getHexNumber(this.getPosChar(1)) < 0) {
                            this.str = null;
                            this.token = 0;
                            return 0;
                        }
                        while ((var1_1 = this.getHexNumber(this.getPosChar(1))) >= 0) {
                            this.tokenValue = this.tokenValue * 16L + (long)var1_1;
                            ++this.pos;
                        }
                        ** GOTO lbl157
                    }
                    default: {
                        this.tokenValue = 0L;
                        if (this.getOctalNumber(this.getPosChar(1)) < 0) {
                            this.str = null;
                            this.token = 0;
                            return 0;
                        }
                        while ((var1_2 = this.getOctalNumber(this.getPosChar(1))) >= 0) {
                            this.tokenValue = this.tokenValue * 8L + (long)var1_2;
                            ++this.pos;
                            break block18;
                        }
                        ** GOTO lbl157
                    }
                }
                {
                    continue;
                    break;
                }
lbl155:
                // 1 sources

                if (this.getPosChar() == 39) break;
                this.tokenValue = this.getPosChar();
lbl157:
                // 14 sources

                ++this.pos;
                if (this.getPosChar() != 39) break;
                ++this.pos;
                this.token = 2;
                return 2;
            }
            case -1: {
                return 1;
            }
            default: {
                if (this.isDigit(this.getPosChar())) {
                    this.tokenValue = 0L;
                    do {
                        this.tokenValue = this.tokenValue * 10L + (long)(this.getPosChar() - 48);
                        ++this.pos;
                    } while (this.isDigit(this.getPosChar()));
                    this.token = 2;
                    return 2;
                }
                if (!this.isJavaIdentifierStart(this.getPosChar())) break;
                this.eatIdentifier();
                var1_3 = (String)this.defines.get(this.str.substring(this.tokenStart, this.pos));
                if (var1_3 == null || var1_3.length() < 1) {
                    var1_3 = "0 ";
                }
                this.str = this.str.substring(0, this.tokenStart) + var1_3 + this.str.substring(this.pos);
                this.pos = this.tokenStart;
                return this.getToken();
            }
        }
        this.str = null;
        this.token = 0;
        return 0;
    }

    boolean cmpToken() {
        if (this.getToken() > 0) {
            this.token = -1;
            return true;
        }
        this.str = null;
        return false;
    }

    boolean cmpToken(int n) {
        if (this.getToken() == n) {
            this.token = -1;
            return true;
        }
        this.str = null;
        return false;
    }

    public long calcOR() {
        long l = this.calcAND() != 0L ? 1L : 0L;
        while (this.getToken() == 3) {
            if (!this.cmpToken()) {
                return 0L;
            }
            l |= this.calcAND() != 0L ? 1L : 0L;
        }
        return l;
    }

    public long calcAND() {
        long l = this.calcBOR() != 0L ? 1L : 0L;
        while (this.getToken() == 4) {
            if (!this.cmpToken()) {
                return 0L;
            }
            l |= this.calcBOR() != 0L ? 1L : 0L;
        }
        return l;
    }

    public long calcBOR() {
        long l = this.calcBXOR();
        while (this.getToken() == 21) {
            if (!this.cmpToken()) {
                return 0L;
            }
            l |= this.calcBXOR();
        }
        return l;
    }

    public long calcBXOR() {
        long l = this.calcBAND();
        while (this.getToken() == 23) {
            if (!this.cmpToken()) {
                return 0L;
            }
            l ^= this.calcBAND();
        }
        return l;
    }

    public long calcBAND() {
        long l = this.calcEquality();
        while (this.getToken() == 22) {
            if (!this.cmpToken()) {
                return 0L;
            }
            l &= this.calcEquality();
        }
        return l;
    }

    public long calcEquality() {
        long l = this.calcRelational();
        boolean bl = true;
        block4: while (true) {
            switch (this.getToken()) {
                case 8: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcRelational();
                    bl = bl && l == l2;
                    l = l2;
                    continue block4;
                }
                case 9: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcRelational();
                    bl = bl && l != l2;
                    l = l2;
                    continue block4;
                }
            }
            break;
        }
        return bl ? l : 0L;
    }

    public long calcRelational() {
        long l = this.calcShift();
        boolean bl = true;
        block6: while (true) {
            switch (this.getToken()) {
                case 10: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcShift();
                    bl = bl && l > l2;
                    l = l2;
                    continue block6;
                }
                case 11: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcShift();
                    bl = bl && l >= l2;
                    l = l2;
                    continue block6;
                }
                case 12: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcShift();
                    bl = bl && l < l2;
                    l = l2;
                    continue block6;
                }
                case 13: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcShift();
                    bl = bl && l <= l2;
                    l = l2;
                    continue block6;
                }
            }
            break;
        }
        return bl ? l : 0L;
    }

    public long calcShift() {
        long l = this.calcAdditive();
        block4: while (true) {
            switch (this.getToken()) {
                case 19: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    l <<= (int)this.calcAdditive();
                    continue block4;
                }
                case 20: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    l >>= (int)this.calcRelational();
                    continue block4;
                }
            }
            break;
        }
        return l;
    }

    public long calcAdditive() {
        long l = this.calcMultiplicative();
        block4: while (true) {
            switch (this.getToken()) {
                case 14: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    l += this.calcMultiplicative();
                    continue block4;
                }
                case 15: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    l -= this.calcMultiplicative();
                    continue block4;
                }
            }
            break;
        }
        return l;
    }

    public long calcMultiplicative() {
        long l = this.calcValue();
        block5: while (true) {
            switch (this.getToken()) {
                case 16: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    l *= this.calcValue();
                    continue block5;
                }
                case 17: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcValue();
                    if (l2 == 0L) {
                        this.str = null;
                        return 0L;
                    }
                    l /= l2;
                    continue block5;
                }
                case 18: {
                    if (!this.cmpToken()) {
                        return 0L;
                    }
                    long l2 = this.calcValue();
                    if (l2 == 0L) {
                        this.str = null;
                        return 0L;
                    }
                    l %= l2;
                    continue block5;
                }
            }
            break;
        }
        return l;
    }

    public long calcValue() {
        switch (this.getToken()) {
            case 14: {
                if (!this.cmpToken()) {
                    return 0L;
                }
                return this.calcValue();
            }
            case 15: {
                if (!this.cmpToken()) {
                    return 0L;
                }
                return -this.calcValue();
            }
            case 5: {
                if (!this.cmpToken()) {
                    return 0L;
                }
                return this.calcValue() != 0L ? 0L : 1L;
            }
            case 6: {
                if (!this.cmpToken()) {
                    return 0L;
                }
                long l = this.calcOR();
                if (!this.cmpToken(7)) {
                    return 0L;
                }
                return l;
            }
        }
        if (!this.cmpToken(2)) {
            return 0L;
        }
        return this.tokenValue;
    }

    public boolean calcExpression() throws PreprocessorException {
        this.pos = 0;
        this.token = -1;
        long l = this.calcOR();
        if (this.getToken() != 1 || this.str == null) {
            this.error("Parse error");
            return false;
        }
        return l != 0L;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform() throws PreprocessorException {
        this.input = this.getInput();
        this.state = 0;
        String string = "# 1 \"" + this.filename + '\"';
        if (this.included) {
            string = this.systemFile ? string + " 1 3" : string + " 1";
        }
        this.output.println(string);
        while (this.readLine()) {
            int n = this.state;
            this.performComment();
            this.pos = 0;
            this.eatWhiteSpaces();
            if (this.pos < this.str.length() && this.str.charAt(this.pos) == '#') {
                while (this.state == 2 && this.readLineNext()) {
                    this.state = n;
                    this.performComment();
                }
            }
            switch (this.findCommand()) {
                case 0: {
                    this.performLine();
                    break;
                }
                case 3: {
                    this.performDefine();
                    break;
                }
                case 4: {
                    this.performUndef();
                    break;
                }
                case 5: {
                    this.performInclude();
                    break;
                }
                case 6: {
                    this.performLineDef();
                    break;
                }
                case 7: {
                    this.performIfDef();
                    break;
                }
                case 8: {
                    this.performIfNDef();
                    break;
                }
                case 9: {
                    this.performElse();
                    break;
                }
                case 10: {
                    this.performEndIf();
                    break;
                }
                case 2: {
                    this.writeOutput(null);
                    break;
                }
                case 11: {
                    this.performIf();
                    break;
                }
                case 12: {
                    this.performElif();
                    break;
                }
                case 1: {
                    this.performUnknown();
                    break;
                }
                default: {
                    this.error("Internal error: bad command: " + this.str);
                    this.writeOutput(null);
                }
            }
        }
        Object var4_4 = null;
        if (this.input == null) return;
        try {
            this.input.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                this.error("Error while reading file: " + this.filename);
                Object var4_5 = null;
                if (this.input == null) return;
                try {
                    this.input.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (this.input == null) throw throwable;
            try {
                this.input.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void main(String[] stringArray, PrintStream printStream) throws PreprocessorException {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("-I")) {
                arrayList2.add(stringArray[n2].substring(2));
            } else if (stringArray[n2].startsWith("-D")) {
                n = stringArray[n2].indexOf(61);
                if (n >= 3) {
                    hashtable.put(stringArray[n2].substring(2, n), stringArray[n2].substring(n + 1) + " ");
                } else if (stringArray[n2].length() >= 3) {
                    hashtable.put(stringArray[n2].substring(2), " ");
                } else {
                    Preprocessor.staticError("Bad command argument for preprocessor: " + stringArray[n2]);
                }
            } else if (stringArray[n2].startsWith("-U")) {
                arrayList.add(stringArray[n2].substring(2));
            } else if (stringArray[n2].startsWith("-W")) {
                if (stringArray[n2].length() > 2) {
                    string = stringArray[n2].substring(2);
                }
            } else {
                arrayList3.add(stringArray[n2]);
            }
            ++n2;
        }
        n = 0;
        while (n < arrayList.size()) {
            hashtable.remove(arrayList.get(n));
            ++n;
        }
        String[] stringArray2 = new String[arrayList2.size()];
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            stringArray2[n3] = (String)arrayList2.get(n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < arrayList3.size()) {
            new Preprocessor(string, (String)arrayList3.get(n4), hashtable, stringArray2, printStream).perform();
            ++n4;
        }
    }

    public static void main(String[] stringArray) throws PreprocessorException {
        Preprocessor.main(stringArray, System.out);
    }

    private BufferedReader getInput() throws PreprocessorException {
        if (this.systemFile) {
            int n = 0;
            while (n < this.sysDirs.length) {
                this.file = new File(this.sysDirs[n], this.filename);
                if (!(this.file != null && this.file.exists() && this.file.isFile() && this.file.canRead())) {
                    this.file = null;
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            this.file = new File(this.pwd, this.filename);
            if (!(this.file == null || this.file.exists() && this.file.isFile() && this.file.canRead())) {
                this.file = null;
            }
        }
        if (this.file != null) {
            try {
                return new BufferedReader(new FileReader(this.file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Error opening file: " + this.filename);
            }
        } else {
            Object object;
            Object object2;
            FileSystem fileSystem = null;
            String string = null;
            Enumeration enumeration = TopManager.getDefault().getRepository().fileSystems();
            while (enumeration.hasMoreElements()) {
                fileSystem = (FileSystem)enumeration.nextElement();
                object2 = NbClassPath.toFile((FileObject)fileSystem.getRoot());
                string = object2 != null ? ((File)object2).getAbsolutePath() : fileSystem.getSystemName();
                if (!this.filename.startsWith(string) || ((String)(object = this.filename.substring(string.length()))).length() <= 1) continue;
                object = FileUtils.convert2Canonical((String)object);
                object = ((String)object).replace(File.separatorChar, '/');
                this.fobj = fileSystem.findResource((String)object);
                if (this.fobj != null) break;
            }
            if (this.fobj == null && this.pwd != null) {
                object2 = TopManager.getDefault().getRepository().fileSystems();
                while (object2.hasMoreElements()) {
                    fileSystem = (FileSystem)object2.nextElement();
                    object = NbClassPath.toFile((FileObject)fileSystem.getRoot());
                    string = object != null ? ((File)object).getAbsolutePath() : fileSystem.getSystemName();
                    if (!this.pwd.startsWith(string)) continue;
                    String string2 = this.pwd.substring(string.length());
                    string2 = string2.length() > 1 ? string2 + File.separatorChar + this.filename : this.filename;
                    string2 = FileUtils.convert2Canonical(string2);
                    string2 = string2.replace(File.separatorChar, '/');
                    this.fobj = fileSystem.findResource(string2);
                    if (this.fobj != null) break;
                }
            }
            if (this.fobj == null || this.fobj.isFolder() || !this.fobj.isValid()) {
                this.error("File not found or cannot be read: " + this.filename);
            }
            try {
                return new BufferedReader(new InputStreamReader(this.fobj.getInputStream()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Error opening file: " + this.filename);
            }
        }
        return null;
    }

    public static class PreprocessorException
    extends Exception {
        int line;

        public PreprocessorException(int n, String string) {
            super(string);
            this.line = n;
        }

        public int getLine() {
            return this.line;
        }
    }
}

