/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.ioranalyzer;

import java.util.ArrayList;
import org.netbeans.modules.corba.ioranalyzer.IORInputStream;
import org.netbeans.modules.corba.ioranalyzer.IOROutputStream;
import org.netbeans.modules.corba.ioranalyzer.IORProfile;
import org.netbeans.modules.corba.ioranalyzer.IORTaggedProfile;

public class IORData {
    IORInputStream in_;
    boolean littleEndian_;
    String repositoryId_;
    ArrayList profiles_ = new ArrayList();

    public IORData(String string) {
        this.in_ = new IORInputStream(string);
        this.parse();
    }

    public IORData() {
    }

    public boolean isLittleEndian() {
        return this.littleEndian_;
    }

    public void setLittleEndian(boolean bl) {
        this.littleEndian_ = bl;
    }

    public boolean isBigEndian() {
        return !this.littleEndian_;
    }

    public void setBigEndian(boolean bl) {
        this.littleEndian_ = !bl;
    }

    public String getRepositoryId() {
        return this.repositoryId_;
    }

    public void setRepositoryId(String string) {
        this.repositoryId_ = string;
    }

    public ArrayList getProfiles() {
        return this.profiles_;
    }

    public void addProfiles(ArrayList arrayList) {
        this.profiles_.addAll(arrayList);
    }

    public void write(IOROutputStream iOROutputStream) {
        iOROutputStream.setLittleEndian(this.littleEndian_);
        iOROutputStream.writeString(this.repositoryId_);
        iOROutputStream.writeUnsignedLong(this.profiles_.size());
        int n = 0;
        while (n < this.profiles_.size()) {
            Object e = this.profiles_.get(n);
            int n2 = 0;
            byte[] byArray = null;
            if (e instanceof IORProfile) {
                n2 = ((IORProfile)e).tag_;
                byArray = ((IORProfile)e).in_.buf;
            } else if (e instanceof IORTaggedProfile) {
                n2 = ((IORTaggedProfile)e).getTag();
                byArray = ((IORTaggedProfile)e).getData();
            }
            iOROutputStream.writeUnsignedLong(n2);
            iOROutputStream.writeOctetArray(byArray);
            ++n;
        }
    }

    public String toString() {
        String string = "LittleEndian " + this.littleEndian_ + "\nRepositoryId= " + this.repositoryId_ + "\n";
        int n = 0;
        while (n < this.profiles_.size()) {
            string = string + this.profiles_.get(n).toString();
            ++n;
        }
        return string;
    }

    private void parse() {
        this.littleEndian_ = this.in_.isLittleEndian();
        this.in_.skeep(4);
        this.repositoryId_ = this.in_.readString();
        int n = this.in_.readUnsignedLong();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.in_.readUnsignedLong();
            byte[] byArray = this.in_.readOctetArray();
            if (n3 == 0) {
                IORProfile iORProfile = new IORProfile(n3, byArray);
                this.profiles_.add(iORProfile);
            } else {
                this.profiles_.add(new IORTaggedProfile(n3, byArray));
            }
            ++n2;
        }
    }
}

