/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.ioranalyzer;

import org.omg.CORBA.BAD_PARAM;

public class IORInputStream {
    protected boolean little_endian;
    protected byte[] buf;
    protected int count;
    protected int pos;

    public IORInputStream(String string) {
        if (string == null) {
            throw new BAD_PARAM("Not valid IOR");
        }
        int n = string.length();
        if (n < 4) {
            throw new BAD_PARAM("Not valid IOR");
        }
        if (!string.startsWith("IOR:")) {
            throw new BAD_PARAM("Not valid IOR");
        }
        if (((n -= 4) & 1) != 0) {
            throw new BAD_PARAM("Not valid IOR");
        }
        this.buf = new byte[n /= 2];
        this.count = n;
        int n2 = 0;
        int n3 = 4;
        while (n2 < n) {
            this.buf[n2] = (byte)((byte)(this.hexDigit(string.charAt(n3)) << 4 & 0xFFFFFFF0) | (byte)(this.hexDigit(string.charAt(n3 + 1)) & 0xF));
            n3 += 2;
            ++n2;
        }
        this.little_endian = this.buf[0] != 0;
    }

    public IORInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 1;
        this.count = byArray.length;
        this.little_endian = byArray[0] != 0;
    }

    public boolean isLittleEndian() {
        return this.little_endian;
    }

    public boolean isBigEndian() {
        return !this.little_endian;
    }

    public String readString() {
        int n = this.readUnsignedLong() - 1;
        String string = new String(this.buf, this.pos, n);
        this.pos += n;
        if (this.read() != 0) {
            throw new BAD_PARAM("Bad IOR format");
        }
        return string;
    }

    public int readUnsignedLong() {
        int n = this.pos % 4;
        if (n != 0) {
            this.pos += 4 - n;
        }
        if (this.little_endian) {
            return this.buf[this.pos++] & 0xFF | this.buf[this.pos++] << 8 & 0xFF00 | this.buf[this.pos++] << 16 & 0xFF0000 | this.buf[this.pos++] << 24 & 0xFF000000;
        }
        return this.buf[this.pos++] << 24 & 0xFF000000 | this.buf[this.pos++] << 16 & 0xFF0000 | this.buf[this.pos++] << 8 & 0xFF00 | this.buf[this.pos++] & 0xFF;
    }

    public short readUnsignedShort() {
        int n = this.pos % 2;
        if (n != 0) {
            this.pos += 2 - n;
        }
        if (this.little_endian) {
            return (short)(this.buf[this.pos++] & 0xFF | this.buf[this.pos++] << 8 & 0xFFFFFF00);
        }
        return (short)(this.buf[this.pos++] << 8 & 0xFFFFFF00 | this.buf[this.pos++] & 0xFF);
    }

    public byte readOctet() {
        return this.buf[this.pos++];
    }

    public byte[] readOctetArray() {
        int n = this.readUnsignedLong();
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    private byte hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(10 + c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(10 + c - 65);
        }
        throw new BAD_PARAM("Invalid IOR format");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.buf.length) {
            stringBuffer.append((char)this.buf[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int read() {
        return this.buf[this.pos++];
    }

    public void skeep(int n) {
        this.pos += n;
    }

    public void seek(int n) {
        this.pos = n;
    }
}

