/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.ioranalyzer;

import org.netbeans.modules.corba.ioranalyzer.Stringifier;

public class IOROutputStream {
    protected byte[] buf_;
    protected int pos_;
    protected boolean little_endian_;

    public IOROutputStream() {
        this.buf_ = new byte[1024];
        this.pos_ = 0;
    }

    public IOROutputStream(int n) {
        this.buf_ = new byte[n];
        this.pos_ = 0;
    }

    public void setBigEndian(boolean bl) {
        this.little_endian_ = !bl;
    }

    public void setLittleEndian(boolean bl) {
        this.little_endian_ = bl;
    }

    public void writeUnsignedLong(int n) {
        int n2 = this.pos_ % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
            this.ensureCapacity(n2 + 4);
            this.pos_ += n2;
        } else {
            this.ensureCapacity(4);
        }
        if (this.little_endian_) {
            this.buf_[this.pos_++] = (byte)n;
            this.buf_[this.pos_++] = (byte)(n >> 8);
            this.buf_[this.pos_++] = (byte)(n >> 16);
            this.buf_[this.pos_++] = (byte)(n >> 24);
        } else {
            this.buf_[this.pos_++] = (byte)(n >> 24);
            this.buf_[this.pos_++] = (byte)(n >> 16);
            this.buf_[this.pos_++] = (byte)(n >> 8);
            this.buf_[this.pos_++] = (byte)n;
        }
    }

    public void writeUnsignedShort(short s) {
        int n = this.pos_ % 2;
        this.ensureCapacity(n + 2);
        this.pos_ += n;
        if (this.little_endian_) {
            this.buf_[this.pos_++] = (byte)s;
            this.buf_[this.pos_++] = (byte)(s >> 8);
        } else {
            this.buf_[this.pos_++] = (byte)(s >> 8);
            this.buf_[this.pos_++] = (byte)s;
        }
    }

    public void writeOctet(byte by) {
        this.ensureCapacity(1);
        this.buf_[this.pos_++] = by;
    }

    public void writeString(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        this.writeUnsignedLong(n + 1);
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf_, this.pos_, n);
        this.pos_ += n;
        this.writeOctet((byte)0);
    }

    public void writeOctetArray(byte[] byArray) {
        int n = byArray.length;
        this.writeUnsignedLong(n);
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf_, this.pos_, n);
        this.pos_ += n;
    }

    public byte[] getBytes() {
        this.trim();
        return (byte[])this.buf_.clone();
    }

    public void writeRaw(byte[] byArray) {
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf_, this.pos_, n);
        this.pos_ += n;
    }

    private void ensureCapacity(int n) {
        int n2 = n + this.pos_;
        if (n2 > this.buf_.length) {
            this.enlarge(512);
        }
    }

    private void resize(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf_, 0, byArray, 0, this.buf_.length);
        this.buf_ = byArray;
    }

    private void enlarge(int n) {
        byte[] byArray = new byte[this.buf_.length + n];
        System.arraycopy(this.buf_, 0, byArray, 0, this.buf_.length);
        this.buf_ = byArray;
    }

    private void trim() {
        byte[] byArray = new byte[this.pos_];
        System.arraycopy(this.buf_, 0, byArray, 0, this.pos_);
        this.buf_ = byArray;
    }

    public String toString() {
        String string = this.little_endian_ ? "01000000" : "00000000";
        this.trim();
        string = string + Stringifier.stringify(this.buf_);
        return string;
    }
}

