/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.ioranalyzer;

import org.netbeans.modules.corba.ioranalyzer.IORInputStream;
import org.netbeans.modules.corba.ioranalyzer.TaggedComponent;

public class IORProfile {
    IORInputStream in_;
    int tag_;
    short major_;
    short minor_;
    String hostname_;
    short port_;
    byte[] objectKey_;
    TaggedComponent[] components_;
    byte[] objectId_;
    byte[] adapterId_;
    String poaHierarchy_;
    String timeStamp_;
    boolean persistent_;

    public IORProfile(int n, byte[] byArray) {
        this.in_ = new IORInputStream(byArray);
        this.tag_ = n;
        this.parse();
    }

    public int getTag() {
        return this.tag_;
    }

    public short getMajor() {
        return this.major_;
    }

    public short getMinor() {
        return this.minor_;
    }

    public String getHostname() {
        return this.hostname_;
    }

    public short getPort() {
        return this.port_;
    }

    public byte[] getObjectKey() {
        return this.objectKey_;
    }

    public byte[] getObjectId() {
        return this.objectId_;
    }

    public byte[] getAdapterId() {
        return this.adapterId_;
    }

    public String getPOAHierarchy() {
        return this.poaHierarchy_;
    }

    public boolean isPersistent() {
        return this.persistent_;
    }

    public String getCreationTime() {
        return this.timeStamp_;
    }

    public int componentCount() {
        return this.components_.length;
    }

    public TaggedComponent[] getComponents() {
        return this.components_;
    }

    public String toString() {
        String string = "Tag= " + this.tag_ + "\nMajor= " + this.major_ + "\nMinor= " + this.minor_ + "\nHostname= " + this.hostname_ + "\nPort= " + this.port_ + "\n";
        String string2 = "";
        int n = 0;
        while (n < this.objectKey_.length) {
            string2 = string2 + new Character((char)this.objectKey_[n]).toString();
            ++n;
        }
        string = string + "Object Key= " + string2 + "\n";
        int n2 = 0;
        while (n2 < this.components_.length) {
            string = string + "Component Tag= " + this.components_[n2].tag + "\n";
            string2 = "";
            int n3 = 0;
            while (n3 < this.components_[n2].component_data.length) {
                string2 = string2 + new Character((char)this.components_[n2].component_data[n3]).toString();
                ++n3;
            }
            string = string + "Component Data= " + string2 + "\n";
            ++n2;
        }
        return string;
    }

    private void parse() {
        int n;
        int n2;
        this.major_ = this.in_.readOctet();
        this.minor_ = this.in_.readOctet();
        this.hostname_ = this.in_.readString();
        this.port_ = this.in_.readUnsignedShort();
        this.objectKey_ = this.in_.readOctetArray();
        if (this.major_ >= 1 && this.minor_ >= 1) {
            n2 = this.in_.readUnsignedLong();
            this.components_ = new TaggedComponent[n2];
            n = 0;
            while (n < n2) {
                this.components_[n] = new TaggedComponent();
                this.components_[n].tag = this.in_.readUnsignedLong();
                this.components_[n].component_data = this.in_.readOctetArray();
                ++n;
            }
        } else {
            this.components_ = new TaggedComponent[0];
        }
        if (this.objectKey_.length > 4 && this.objectKey_[0] == -85 && this.objectKey_[1] == -84 && this.objectKey_[2] == -85) {
            n2 = 3;
            if (this.objectKey_[n2] == 48) {
                this.persistent_ = true;
                ++n2;
            } else if (this.objectKey_[n2] == 49) {
                this.persistent_ = false;
                n = ++n2;
                while (n2 < this.objectKey_.length && this.objectKey_[n2] != 0) {
                    ++n2;
                }
                if (n2 >= this.objectKey_.length) {
                    return;
                }
                this.timeStamp_ = new String(this.objectKey_, n, n2, n2 - n);
                ++n2;
            } else {
                return;
            }
            this.poaHierarchy_ = "";
            while (n2 < this.objectKey_.length) {
                n = n2;
                while (n2 < this.objectKey_.length && this.objectKey_[n2] != 0) {
                    ++n2;
                }
                if (n2 >= this.objectKey_.length) {
                    return;
                }
                String string = new String(this.objectKey_, 0, n, n2 - n);
                this.poaHierarchy_ = this.poaHierarchy_ + "/" + string;
                if (++n2 >= this.objectKey_.length) {
                    return;
                }
                if (this.objectKey_[n2] != 0) continue;
                this.adapterId_ = new byte[n2 + 1];
                System.arraycopy(this.objectKey_, 0, this.adapterId_, 0, n2 + 1);
                n = ++n2;
                while (n2 < this.objectKey_.length) {
                    ++n2;
                }
                this.objectId_ = new byte[n2 - n];
                System.arraycopy(this.objectKey_, n, this.objectId_, 0, n2 - n);
                ++n2;
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof IORProfile)) {
            return false;
        }
        IORProfile iORProfile = (IORProfile)object;
        if (this.tag_ != iORProfile.tag_) {
            return false;
        }
        if (this.major_ != iORProfile.major_) {
            return false;
        }
        if (this.minor_ != iORProfile.minor_) {
            return false;
        }
        if (!this.hostname_.equals(iORProfile.hostname_)) {
            return false;
        }
        if (this.port_ != iORProfile.port_) {
            return false;
        }
        if (this.objectKey_.length != iORProfile.objectKey_.length) {
            return false;
        }
        int n = 0;
        while (n < this.objectKey_.length) {
            if (this.objectKey_[n] != iORProfile.objectKey_[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

