/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.ioranalyzer;

import java.util.ArrayList;
import org.netbeans.modules.corba.ioranalyzer.IOPProfileKey;
import org.netbeans.modules.corba.ioranalyzer.IORData;
import org.netbeans.modules.corba.ioranalyzer.IORDataObject;
import org.netbeans.modules.corba.ioranalyzer.IORProfile;
import org.netbeans.modules.corba.ioranalyzer.IORTaggedProfile;
import org.netbeans.modules.corba.ioranalyzer.ProfileKey;
import org.netbeans.modules.corba.ioranalyzer.ProfileNode;
import org.netbeans.modules.corba.ioranalyzer.TaggedNode;
import org.netbeans.modules.corba.ioranalyzer.TaggedProfileKey;
import org.omg.CORBA.BAD_PARAM;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ProfileChildren
extends Children.Keys {
    IORDataObject dataObject;
    IORData iorData;

    public ProfileChildren(IORDataObject iORDataObject) {
        this.dataObject = iORDataObject;
        this.iorData = null;
    }

    public void addNotify() {
        try {
            this.lazyInit();
            this.createKeys();
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.setKeys(new Object[0]);
            this.handleBadIOR();
        }
    }

    public void createKeys() {
        ArrayList arrayList = this.iorData.getProfiles();
        Object[] objectArray = new ProfileKey[arrayList.size()];
        int n = 0;
        while (n < objectArray.length) {
            Object e = arrayList.get(n);
            if (e instanceof IORProfile) {
                objectArray[n] = new IOPProfileKey(n, (IORProfile)e);
            } else if (e instanceof IORTaggedProfile) {
                objectArray[n] = new TaggedProfileKey(n, (IORTaggedProfile)e);
            }
            ++n;
        }
        this.setKeys(objectArray);
    }

    public Node[] createNodes(Object object) {
        if (object instanceof IOPProfileKey) {
            return new Node[]{new ProfileNode(((IOPProfileKey)object).index, ((IOPProfileKey)object).value)};
        }
        if (object instanceof TaggedProfileKey) {
            return new Node[]{new TaggedNode(((TaggedProfileKey)object).index, ((TaggedProfileKey)object).value)};
        }
        return new Node[0];
    }

    public void update() {
        this.iorData = null;
        this.addNotify();
    }

    public Integer getProfileCount() {
        try {
            this.lazyInit();
            return new Integer(this.iorData.getProfiles().size());
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.handleBadIOR();
            return null;
        }
    }

    public String getRepositoryId() {
        try {
            this.lazyInit();
            return this.iorData.getRepositoryId();
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.handleBadIOR();
            return null;
        }
    }

    public Boolean isLittleEndian() {
        try {
            this.lazyInit();
            return new Boolean(this.iorData.isLittleEndian());
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.handleBadIOR();
            return null;
        }
    }

    private void lazyInit() {
        if (this.iorData == null) {
            this.iorData = new IORData(this.dataObject.getContent());
        }
    }

    private void handleBadIOR() {
    }
}

