/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.poasupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.netbeans.modules.corba.poasupport.DefaultServantElement;
import org.netbeans.modules.corba.poasupport.POAActivatorElement;
import org.netbeans.modules.corba.poasupport.POASupport;
import org.netbeans.modules.corba.poasupport.RootPOAElement;
import org.netbeans.modules.corba.poasupport.ServantElement;
import org.netbeans.modules.corba.poasupport.ServantManagerElement;
import org.netbeans.modules.corba.poasupport.tools.POAChecker;
import org.netbeans.modules.corba.settings.POASettings;
import org.openide.cookies.OpenCookie;
import org.openide.src.ClassElement;

public class POAElement {
    public static String PROP_POA_NAME = "POAName";
    public static String PROP_VAR_NAME = "VarName";
    public static String PROP_MANAGER = "Manager";
    public static String PROP_POLICIES = "Policies";
    private String poaName = null;
    private String varName = null;
    private String manager = null;
    private Properties policies = new Properties();
    private Vector childPOAs = new Vector();
    private Vector servants = new Vector();
    private POAActivatorElement poaActivator = null;
    private DefaultServantElement defaultServant = null;
    private ServantManagerElement servantManager = null;
    private POAElement parentPOA;
    protected RootPOAElement rootPOA;
    protected boolean writeable;
    private transient ArrayList propertyChangeListenerList;

    public POAElement(POAElement pOAElement, RootPOAElement rootPOAElement, boolean bl) {
        this.parentPOA = pOAElement;
        this.rootPOA = rootPOAElement;
        this.writeable = bl;
        this.poaName = this.getDefaultPOAName();
        this.varName = this.getDefaultVarName();
    }

    public POAElement(boolean bl) {
        this.parentPOA = null;
        this.rootPOA = null;
        this.writeable = bl;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public boolean canUseAsNewVarName(String string) {
        return this.rootPOA.canUseAsNewVarNameFor(string, this);
    }

    public String getDefaultVarName() {
        int n = 1;
        String string = this.getParentPOA().getRootPOA().getORBTag();
        POASettings pOASettings = string != null ? POASupport.getCORBASettings().getSettingByTag(string).getPOASettings() : POASupport.getPOASettings();
        while (!this.canUseAsNewVarName(pOASettings.getDefaultPOAVarName() + String.valueOf(n))) {
            ++n;
        }
        return pOASettings.getDefaultPOAVarName() + String.valueOf(n);
    }

    public boolean canUseAsPOAName(String string) {
        return this.getParentPOA().canUseIDForChildPOA(string, this);
    }

    public String getDefaultPOAName() {
        if (this.isRootPOA()) {
            return POASupport.getString("LBL_RootPOA_node");
        }
        int n = 1;
        String string = this.getParentPOA().getRootPOA().getORBTag();
        POASettings pOASettings = string != null ? POASupport.getCORBASettings().getSettingByTag(string).getPOASettings() : POASupport.getPOASettings();
        while (!this.canUseAsPOAName(pOASettings.getDefaultPOAName() + String.valueOf(n))) {
            ++n;
        }
        return pOASettings.getDefaultPOAName() + String.valueOf(n);
    }

    public ClassElement getDeclaringClass() {
        return this.rootPOA.maker.getClassElement();
    }

    public OpenCookie getOpenCookie() {
        return this.rootPOA.maker.getOpenCookie();
    }

    public void setLinePosition() {
        this.rootPOA.maker.setLinePosition(this);
    }

    public String getPOAName() {
        return this.poaName;
    }

    public void setPOAName(String string) {
        if (!string.equals(this.poaName)) {
            String string2 = this.poaName;
            this.poaName = string;
            this.firePropertyChange(new PropertyChangeEvent(this, PROP_POA_NAME, string2, this.poaName));
        }
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String string) {
        if (!string.equals(this.varName)) {
            String string2 = this.varName;
            this.varName = string;
            this.firePropertyChange(new PropertyChangeEvent(this, PROP_VAR_NAME, string2, this.varName));
        }
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String string) {
        if (string != null && !string.equals(this.manager) || string == null && this.manager != null) {
            String string2 = this.manager;
            this.manager = string;
            this.firePropertyChange(new PropertyChangeEvent(this, PROP_MANAGER, string2, this.manager));
        }
    }

    public Properties getPolicies() {
        return (Properties)((Hashtable)this.policies).clone();
    }

    public void setPolicies(Properties properties) {
        if (!((Hashtable)properties).equals(this.policies)) {
            Properties properties2 = this.policies;
            this.policies = properties;
            if (this.getServants().size() > 0 && POAChecker.checkDisabledServantActivation(this, this.policies).equals("all-servants")) {
                this.removeAllServants();
            }
            if (this.getServantManager() != null && !POAChecker.isServantManagerEnabled(this, this.policies)) {
                this.removeServantManager();
            }
            if (this.getDefaultServant() != null && !POAChecker.isDefaultServantEnabled(this, this.policies)) {
                this.removeDefaultServant();
            }
            this.firePropertyChange(new PropertyChangeEvent(this, PROP_POLICIES, properties2, this.policies));
        }
    }

    public Vector getChildPOAs() {
        return (Vector)this.childPOAs.clone();
    }

    public void addChildPOA(POAElement pOAElement) {
        this.childPOAs.addElement(pOAElement);
        this.rootPOA.addPOAToList(pOAElement);
    }

    public void removeChildPOA(POAElement pOAElement) {
        int n = this.childPOAs.indexOf(pOAElement);
        if (n != -1) {
            this.childPOAs.remove(n);
            this.rootPOA.removePOAFromList(pOAElement);
        }
    }

    public Vector getServants() {
        return (Vector)this.servants.clone();
    }

    public void addServant(ServantElement servantElement) {
        this.servants.addElement(servantElement);
        this.rootPOA.addServantToList(servantElement);
    }

    public void removeServant(ServantElement servantElement) {
        int n = this.servants.indexOf(servantElement);
        if (n != -1) {
            this.servants.remove(n);
            this.rootPOA.removeServantFromList(servantElement);
        }
    }

    public void removeAllServants() {
        ListIterator listIterator = ((AbstractList)this.servants).listIterator();
        while (listIterator.hasNext()) {
            this.rootPOA.removeServantFromList((ServantElement)listIterator.next());
        }
        this.servants.removeAllElements();
    }

    public DefaultServantElement getDefaultServant() {
        return this.defaultServant;
    }

    public void setDefaultServant(DefaultServantElement defaultServantElement) {
        this.defaultServant = defaultServantElement;
        this.rootPOA.addDefaultServantToList(this.defaultServant);
    }

    public void removeDefaultServant() {
        this.rootPOA.removeDefaultServantFromList(this.defaultServant);
        this.defaultServant = null;
    }

    public ServantManagerElement getServantManager() {
        return this.servantManager;
    }

    public void setServantManager(ServantManagerElement servantManagerElement) {
        this.servantManager = servantManagerElement;
        this.rootPOA.addServantManagerToList(this.servantManager);
    }

    public void removeServantManager() {
        this.rootPOA.removeServantManagerFromList(this.servantManager);
        this.servantManager = null;
    }

    public POAActivatorElement getPOAActivator() {
        return this.poaActivator;
    }

    public void setPOAActivator(POAActivatorElement pOAActivatorElement) {
        this.poaActivator = pOAActivatorElement;
        this.rootPOA.addPOAActivatorToList(this.poaActivator);
    }

    public void removePOAActivator() {
        this.rootPOA.removePOAActivatorFromList(this.poaActivator);
        this.poaActivator = null;
    }

    public POAElement getParentPOA() {
        return this.parentPOA;
    }

    public RootPOAElement getRootPOA() {
        return this.rootPOA;
    }

    public boolean isRootPOA() {
        return false;
    }

    public Vector getAvailablePOAManagers() {
        return this.rootPOA.getAvailablePOAManagers(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListenerList == null) {
            this.propertyChangeListenerList = new ArrayList();
        }
        this.propertyChangeListenerList.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListenerList != null) {
            ((AbstractCollection)this.propertyChangeListenerList).remove(propertyChangeListener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        ArrayList arrayList;
        POAElement pOAElement = this;
        synchronized (pOAElement) {
            if (this.propertyChangeListenerList == null) {
                return;
            }
            arrayList = (ArrayList)this.propertyChangeListenerList.clone();
        }
        int n = 0;
        while (n < arrayList.size()) {
            ((PropertyChangeListener)arrayList.get(n)).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    protected boolean canUseIDForServant(String string, ServantElement servantElement) {
        if (string == null) {
            return true;
        }
        int n = 0;
        while (n < this.servants.size()) {
            ServantElement servantElement2 = (ServantElement)this.servants.get(n);
            if (string.equals(servantElement2.getObjID()) && !servantElement2.equals(servantElement)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean canUseIDForChildPOA(String string, POAElement pOAElement) {
        if (string == null) {
            return true;
        }
        int n = 0;
        while (n < this.childPOAs.size()) {
            POAElement pOAElement2 = (POAElement)this.childPOAs.get(n);
            if (string.equals(pOAElement2.getPOAName()) && !pOAElement2.equals(pOAElement)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean canUseAsNewVarNameFor(String string, Object object) {
        return this.rootPOA.canUseAsNewVarNameFor(string, object);
    }

    protected boolean canUseAsVarNameFor(String string, Object object) {
        return this.rootPOA.canUseAsVarNameFor(string, object);
    }
}

