/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.poasupport.nodes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.corba.poasupport.POAElement;
import org.netbeans.modules.corba.poasupport.POASupport;
import org.netbeans.modules.corba.poasupport.tools.POAChecker;
import org.netbeans.modules.corba.settings.POAPolicyDescriptor;
import org.netbeans.modules.corba.settings.POAPolicyValueDescriptor;
import org.netbeans.modules.corba.settings.POASettings;

public class POACustomizer
extends JPanel
implements DocumentListener {
    private POAElement element;
    private POASettings settings;
    private JPanel poaPanel;
    private JLabel poaNameLabel;
    private JTextField poaNameTextField;
    private JLabel varNameLabel;
    private JTextField varNameTextField;
    private JLabel managerLabel;
    private JComboBox managerComboBox;
    private JPanel propertiesPanel;
    private Vector policyLabels = new Vector();
    private Vector policyComboBoxes = new Vector();
    private ActionListener propertyComboBoxesListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            POACustomizer.this.propertyComboBoxActionPerformed(actionEvent);
        }
    };

    public POACustomizer(POAElement pOAElement) {
        this.element = pOAElement;
        String string = this.element.getRootPOA().getORBTag();
        this.settings = string != null ? POASupport.getCORBASettings().getSettingByTag(string).getPOASettings() : POASupport.getPOASettings();
        this.initComponents();
        this.poaNameLabel.setDisplayedMnemonic(POASupport.getString("MNE_POACustomizer_POAName").charAt(0));
        this.varNameLabel.setDisplayedMnemonic(POASupport.getString("MNE_POACustomizer_VarName").charAt(0));
        this.managerLabel.setDisplayedMnemonic(POASupport.getString("MNE_POACustomizer_Mgr").charAt(0));
        this.managerComboBox.addItem(POACustomizer.defaultManager());
        this.initDynamicComponents();
        this.initContent();
        this.managerComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                POACustomizer.this.managerComboBoxActionPerformed(actionEvent);
            }
        });
    }

    public void initContent() {
        this.setPOAName("");
        this.setVarName("");
        String string = this.element.getManager();
        if (string != null) {
            this.managerComboBox.setSelectedItem(string);
        } else {
            this.managerComboBox.setSelectedItem(POACustomizer.defaultManager());
        }
        Properties properties = this.element.getPolicies();
        if (properties != null) {
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                this.setPolicy(string2, (String)((Hashtable)properties).get(string2));
            }
        }
    }

    private void initComponents() {
        this.poaPanel = new JPanel();
        this.poaNameLabel = new JLabel();
        this.poaNameTextField = new JTextField();
        this.varNameLabel = new JLabel();
        this.varNameTextField = new JTextField();
        this.managerLabel = new JLabel();
        this.managerComboBox = new JComboBox(this.element.getAvailablePOAManagers());
        this.propertiesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.poaPanel.setLayout(new GridBagLayout());
        this.poaPanel.setAlignmentY(0.0f);
        this.poaPanel.setAlignmentX(0.0f);
        this.poaNameLabel.setText(POASupport.getString("LBL_POACustomizer_POAName"));
        this.poaNameLabel.setForeground(Color.black);
        this.poaNameLabel.setLabelFor(this.poaNameTextField);
        this.poaNameLabel.setAlignmentY(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 9, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.poaPanel.add((Component)this.poaNameLabel, gridBagConstraints);
        this.poaNameTextField.setAlignmentY(0.0f);
        this.poaNameTextField.setAlignmentX(0.0f);
        this.poaNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                POACustomizer.this.poaNameTextFieldFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                POACustomizer.this.poaNameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 6, 0, 9);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.poaPanel.add((Component)this.poaNameTextField, gridBagConstraints);
        this.varNameLabel.setText(POASupport.getString("LBL_POACustomizer_VarName"));
        this.varNameLabel.setForeground(Color.black);
        this.varNameLabel.setLabelFor(this.varNameTextField);
        this.varNameLabel.setAlignmentY(0.0f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 9, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.poaPanel.add((Component)this.varNameLabel, gridBagConstraints);
        this.varNameTextField.setAlignmentY(0.0f);
        this.varNameTextField.setAlignmentX(0.0f);
        this.varNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                POACustomizer.this.varNameTextFieldFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                POACustomizer.this.varNameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 0, 9);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.poaPanel.add((Component)this.varNameTextField, gridBagConstraints);
        this.managerLabel.setText(POASupport.getString("LBL_POACustomizer_Mgr"));
        this.managerLabel.setForeground(Color.black);
        this.managerLabel.setLabelFor(this.managerComboBox);
        this.managerLabel.setAlignmentY(0.0f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 9, 10, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.poaPanel.add((Component)this.managerLabel, gridBagConstraints);
        this.managerComboBox.setAlignmentY(0.0f);
        this.managerComboBox.setAlignmentX(0.0f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 9, 9);
        gridBagConstraints.anchor = 17;
        this.poaPanel.add((Component)this.managerComboBox, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 4);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.poaPanel, gridBagConstraints2);
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.propertiesPanel.setAlignmentY(0.0f);
        this.propertiesPanel.setAlignmentX(0.0f);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(4, 5, 4, 4);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.propertiesPanel, gridBagConstraints2);
    }

    private void poaNameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        if (POAChecker.checkPOAName(this.poaNameTextField.getText(), this.element, true)) {
            this.element.setPOAName(this.poaNameTextField.getText());
        } else {
            this.poaNameTextField.setText(this.element.getPOAName());
            this.poaNameTextField.requestFocus();
        }
    }

    private void poaNameTextFieldFocusGained(FocusEvent focusEvent) {
        this.poaNameTextField.selectAll();
    }

    private void varNameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        if (POAChecker.checkPOAVarName(this.varNameTextField.getText(), this.element, true)) {
            this.element.setVarName(this.varNameTextField.getText());
        } else {
            this.varNameTextField.setText(this.element.getVarName());
            this.varNameTextField.requestFocus();
        }
    }

    private void varNameTextFieldFocusGained(FocusEvent focusEvent) {
        this.varNameTextField.selectAll();
    }

    private void managerComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.managerComboBox.getSelectedItem();
        if (string.equals(POACustomizer.defaultManager())) {
            this.element.setManager(null);
        } else {
            this.element.setManager(string);
        }
    }

    private void initDynamicComponents() {
        this.poaPanel.setBorder(new TitledBorder(new EtchedBorder(Color.white, new Color(149, 142, 130)), POASupport.getString("LBL_POACustomizer_Details"), 0, 0, new Font("Dialog", 0, 11), Color.black));
        this.propertiesPanel.setBorder(new TitledBorder(new EtchedBorder(Color.white, new Color(149, 142, 130)), POASupport.getString("LBL_POACustomizer_Policies"), 0, 2, new Font("Dialog", 0, 11), Color.black));
        if (this.settings == null) {
            return;
        }
        ListIterator listIterator = this.settings.getPolicies().listIterator();
        boolean bl = true;
        while (listIterator.hasNext()) {
            POAPolicyDescriptor pOAPolicyDescriptor = (POAPolicyDescriptor)listIterator.next();
            JLabel jLabel = new JLabel(pOAPolicyDescriptor.getName() + POASupport.getString("LBL_Colon"));
            ListIterator listIterator2 = pOAPolicyDescriptor.getValues().listIterator();
            Vector<String> vector = new Vector<String>();
            while (listIterator2.hasNext()) {
                vector.add(((POAPolicyValueDescriptor)listIterator2.next()).getName());
            }
            JComboBox jComboBox = new JComboBox(vector);
            if (vector.size() == 0) {
                jComboBox.setEditable(true);
            }
            jLabel.setLabelFor(jComboBox);
            String string = pOAPolicyDescriptor.getMnemonicCharacter();
            if (string != null) {
                jLabel.setDisplayedMnemonic(string.charAt(0));
            }
            jLabel.setForeground(Color.black);
            jComboBox.addActionListener(this.propertyComboBoxesListener);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = bl ? new Insets(3, 9, 0, 0) : (!listIterator.hasNext() ? new Insets(6, 9, 10, 0) : new Insets(6, 9, 0, 0));
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weighty = 1.0;
            this.propertiesPanel.add((Component)jLabel, gridBagConstraints);
            this.policyLabels.add(jLabel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = bl ? new Insets(3, 6, 0, 9) : (!listIterator.hasNext() ? new Insets(5, 6, 9, 9) : new Insets(5, 6, 0, 9));
            gridBagConstraints.anchor = 16;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.propertiesPanel.add(jComboBox, gridBagConstraints);
            this.policyComboBoxes.add(jComboBox);
            bl = false;
        }
    }

    private void propertyComboBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.policyComboBoxes.indexOf(actionEvent.getSource());
        if (n == -1) {
            return;
        }
        String string = ((JLabel)this.policyLabels.get(n)).getText();
        string = string.substring(0, string.length() - 1);
        String string2 = (String)((JComboBox)this.policyComboBoxes.get(n)).getSelectedItem();
        Properties properties = this.element.getPolicies();
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            List list = this.settings.getPolicyByName(string).getValues();
            string3 = list.size() > 0 ? ((POAPolicyValueDescriptor)list.get(0)).getName() : "";
        }
        if (string2.equals(string3)) {
            return;
        }
        if (POAChecker.checkPOAPoliciesChange(this.element, properties, string, string2, true)) {
            this.element.setPolicies(properties);
            int n2 = 0;
            while (n2 < this.policyComboBoxes.size()) {
                String string4 = ((JLabel)this.policyLabels.get(n2)).getText();
                string4 = string4.substring(0, string4.length() - 1);
                ((JComboBox)this.policyComboBoxes.get(n2)).removeActionListener(this.propertyComboBoxesListener);
                String string5 = properties.getProperty(string4);
                if (string5 == null) {
                    if (((JComboBox)this.policyComboBoxes.get(n2)).getItemCount() > 0) {
                        ((JComboBox)this.policyComboBoxes.get(n2)).setSelectedIndex(0);
                    }
                } else {
                    ((JComboBox)this.policyComboBoxes.get(n2)).setSelectedItem(string5);
                }
                ((JComboBox)this.policyComboBoxes.get(n2)).addActionListener(this.propertyComboBoxesListener);
                ++n2;
            }
        } else {
            ((JComboBox)this.policyComboBoxes.get(n)).setSelectedItem(string3);
        }
    }

    private void setPolicy(String string, String string2) {
        int n = 0;
        while (n < this.policyLabels.size()) {
            if ((string + POASupport.getString("LBL_Colon")).equals(((JLabel)this.policyLabels.get(n)).getText())) break;
            ++n;
        }
        if (n < this.policyLabels.size()) {
            ((JComboBox)this.policyComboBoxes.get(n)).setSelectedItem(string2);
        }
    }

    private void setPOAName(String string) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = this.element.getPOAName();
        }
        this.poaNameTextField.getDocument().removeDocumentListener(this);
        this.poaNameTextField.setText(string2);
        this.poaNameTextField.getDocument().addDocumentListener(this);
        if (string == null || string.length() == 0) {
            this.poaNameTextField.selectAll();
        }
    }

    private void setVarName(String string) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = this.element.getVarName();
        }
        this.varNameTextField.getDocument().removeDocumentListener(this);
        this.varNameTextField.setText(string2);
        this.varNameTextField.getDocument().addDocumentListener(this);
        if (string == null || string.length() == 0) {
            this.varNameTextField.selectAll();
        }
    }

    private static String defaultManager() {
        return POASupport.getString("FMT_DefaultPOAManagerName");
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.poaNameTextField.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POACustomizer.this.poaNameTextField.getText().equals("")) {
                        POACustomizer.this.setPOAName("");
                    }
                }
            });
            return;
        }
        if (documentEvent.getDocument() == this.varNameTextField.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POACustomizer.this.varNameTextField.getText().equals("")) {
                        POACustomizer.this.setVarName("");
                    }
                }
            });
            return;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }
}

