/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.utils;

import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class FullBeanContextSupport
extends Vector
implements BeanContext,
Serializable {
    public static final String BEAN_CONTEXT = "beanContext";
    public static final String DESIGN_MODE = "designMode";
    protected boolean avoidGui = false;
    protected boolean isDesignTime = false;
    protected int noChildDesignTime = 0;
    protected BeanContext parent = null;
    protected transient ArrayList contentMembershipListeners = new ArrayList();
    protected transient HashMap propertyChangeListeners = new HashMap();
    protected transient HashMap vetoableListeners;
    protected transient PropertyChangeDispatcher pchDispatcher;
    protected transient VetoableChangeListener vchDispatcher;

    public FullBeanContextSupport() {
        this.propertyChangeListeners.put(DESIGN_MODE, new ArrayList());
        this.vetoableListeners = new HashMap();
        this.pchDispatcher = new PropertyChangeDispatcher();
        this.vchDispatcher = new VetoableChangeDispatcher();
    }

    public Object instantiateChild(String string) throws IOException, ClassNotFoundException {
        return Beans.instantiate(this.getClass().getClassLoader(), string);
    }

    public synchronized void addBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        this.contentMembershipListeners.add(beanContextMembershipListener);
    }

    public synchronized void removeBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        ((AbstractCollection)this.contentMembershipListeners).remove(beanContextMembershipListener);
    }

    public URL getResource(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResource(string);
    }

    public InputStream getResourceAsStream(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResourceAsStream(string);
    }

    public void setBeanContext(BeanContext beanContext) throws PropertyVetoException {
        BeanContext beanContext2 = this.parent;
        this.fireVetoableChange(BEAN_CONTEXT, this.parent, beanContext);
        this.parent = beanContext;
        this.firePropertyChange(BEAN_CONTEXT, beanContext2, this.parent);
    }

    public BeanContext getBeanContext() {
        return this.parent;
    }

    public synchronized void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        ArrayList<VetoableChangeListener> arrayList = (ArrayList<VetoableChangeListener>)this.vetoableListeners.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<VetoableChangeListener>();
            this.vetoableListeners.put(string, arrayList);
            Iterator iterator = ((AbstractList)this).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                BeanContextChild beanContextChild = this.getBeanContextChild(e);
                if (beanContextChild == null) continue;
                beanContextChild.addVetoableChangeListener(string, this.vchDispatcher);
            }
        }
        arrayList.add(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        ArrayList arrayList = (ArrayList)this.vetoableListeners.get(string);
        if (arrayList == null) {
            return;
        }
        ((AbstractCollection)arrayList).remove(vetoableChangeListener);
        if (arrayList.size() == 0) {
            this.vetoableListeners.put(string, null);
            Iterator iterator = ((AbstractList)this).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                BeanContextChild beanContextChild = this.getBeanContextChild(e);
                if (beanContextChild == null) continue;
                beanContextChild.removeVetoableChangeListener(string, this.vchDispatcher);
            }
        }
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        ArrayList<PropertyChangeListener> arrayList = (ArrayList<PropertyChangeListener>)this.propertyChangeListeners.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<PropertyChangeListener>();
            this.propertyChangeListeners.put(string, arrayList);
            Iterator iterator = ((AbstractList)this).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                BeanContextChild beanContextChild = this.getBeanContextChild(e);
                if (e == null) continue;
                beanContextChild.addPropertyChangeListener(string, this.pchDispatcher);
            }
        }
        arrayList.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        ArrayList arrayList = (ArrayList)this.propertyChangeListeners.get(string);
        if (arrayList == null) {
            return;
        }
        ((AbstractCollection)arrayList).remove(propertyChangeListener);
        if (arrayList.size() == 0 && !DESIGN_MODE.equals(string)) {
            this.propertyChangeListeners.remove(string);
            Iterator iterator = ((AbstractList)this).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                BeanContextChild beanContextChild = this.getBeanContextChild(e);
                if (beanContextChild == null) continue;
                beanContextChild.removePropertyChangeListener(string, this.pchDispatcher);
            }
        }
    }

    public void okToUseGui() {
        this.avoidGui = false;
    }

    public boolean needsGui() {
        return !this.avoidGui;
    }

    public boolean avoidingGui() {
        return this.avoidGui;
    }

    public void dontUseGui() {
        this.avoidGui = true;
    }

    public boolean isDesignTime() {
        return this.isDesignTime || this.noChildDesignTime > 0;
    }

    public void setDesignTime(boolean bl) {
        boolean bl2 = this.isDesignTime;
        this.isDesignTime = bl;
        this.firePropertyChange(DESIGN_MODE, new Boolean(bl2), new Boolean(this.isDesignTime));
    }

    public synchronized boolean add(Object object) {
        boolean bl = super.add(object);
        if (bl) {
            BeanContextChild beanContextChild = this.getBeanContextChild(object);
            if (beanContextChild != null) {
                try {
                    beanContextChild.setBeanContext(this);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (beanContextChild instanceof BeanContext && ((BeanContext)beanContextChild).isDesignTime()) {
                    ++this.noChildDesignTime;
                }
                Iterator iterator = this.propertyChangeListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    beanContextChild.addPropertyChangeListener((String)iterator.next(), this.pchDispatcher);
                }
                iterator = this.vetoableListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    beanContextChild.addVetoableChangeListener((String)iterator.next(), this.vchDispatcher);
                }
            }
            this.fireChildrenAdded(new Object[]{object});
        }
        return bl;
    }

    public synchronized boolean addAll(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) continue;
            arrayList.add(e);
            super.add(e);
            BeanContextChild beanContextChild = this.getBeanContextChild(e);
            if (beanContextChild == null) continue;
            try {
                beanContextChild.setBeanContext(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (beanContextChild instanceof BeanContext && ((BeanContext)beanContextChild).isDesignTime()) {
                ++this.noChildDesignTime;
            }
            Iterator iterator2 = this.propertyChangeListeners.keySet().iterator();
            while (iterator.hasNext()) {
                beanContextChild.addPropertyChangeListener((String)iterator2.next(), this.pchDispatcher);
            }
            Iterator iterator3 = this.vetoableListeners.keySet().iterator();
            while (iterator.hasNext()) {
                beanContextChild.addVetoableChangeListener((String)iterator3.next(), this.vchDispatcher);
            }
        }
        this.fireChildrenAdded(arrayList);
        return arrayList.size() != 0;
    }

    public synchronized void clear() {
        ArrayList arrayList = new ArrayList();
        while (this.size() > 0) {
            Object e = this.remove(0);
            arrayList.add(e);
            BeanContextChild beanContextChild = this.getBeanContextChild(e);
            if (beanContextChild == null) continue;
            try {
                beanContextChild.setBeanContext(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            Iterator iterator = this.propertyChangeListeners.keySet().iterator();
            while (iterator.hasNext()) {
                beanContextChild.removePropertyChangeListener((String)iterator.next(), this.pchDispatcher);
            }
            Iterator iterator2 = this.vetoableListeners.keySet().iterator();
            while (iterator2.hasNext()) {
                beanContextChild.removeVetoableChangeListener((String)iterator2.next(), this.vchDispatcher);
            }
        }
        this.noChildDesignTime = 0;
        this.fireChildrenRemoved(arrayList);
    }

    public synchronized boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (bl) {
            BeanContextChild beanContextChild = this.getBeanContextChild(object);
            if (beanContextChild != null) {
                try {
                    beanContextChild.setBeanContext(null);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (beanContextChild instanceof BeanContext && ((BeanContext)beanContextChild).isDesignTime()) {
                    --this.noChildDesignTime;
                }
                Iterator iterator = this.propertyChangeListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    beanContextChild.removePropertyChangeListener((String)iterator.next(), this.pchDispatcher);
                }
                iterator = this.vetoableListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    beanContextChild.removeVetoableChangeListener((String)iterator.next(), this.vchDispatcher);
                }
            }
            this.fireChildrenRemoved(new Object[]{object});
        }
        return bl;
    }

    public synchronized boolean removeAll(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            arrayList.add(e);
            super.remove(e);
            BeanContextChild beanContextChild = this.getBeanContextChild(e);
            if (beanContextChild == null) continue;
            try {
                beanContextChild.setBeanContext(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (beanContextChild instanceof BeanContext && ((BeanContext)beanContextChild).isDesignTime()) {
                --this.noChildDesignTime;
            }
            Iterator iterator2 = this.propertyChangeListeners.keySet().iterator();
            while (iterator.hasNext()) {
                beanContextChild.addPropertyChangeListener((String)iterator2.next(), this.pchDispatcher);
            }
            Iterator iterator3 = this.vetoableListeners.keySet().iterator();
            while (iterator.hasNext()) {
                beanContextChild.addVetoableChangeListener((String)iterator3.next(), this.vchDispatcher);
            }
        }
        this.fireChildrenRemoved(arrayList);
        return arrayList.size() != 0;
    }

    public synchronized boolean retainAll(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            super.remove(e);
            BeanContextChild beanContextChild = this.getBeanContextChild(e);
            if (beanContextChild != null) {
                try {
                    beanContextChild.setBeanContext(null);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (beanContextChild instanceof BeanContext && ((BeanContext)beanContextChild).isDesignTime()) {
                    --this.noChildDesignTime;
                }
                Iterator iterator2 = this.propertyChangeListeners.keySet().iterator();
                while (iterator2.hasNext()) {
                    beanContextChild.removePropertyChangeListener((String)iterator2.next(), this.pchDispatcher);
                }
                Iterator iterator3 = this.vetoableListeners.keySet().iterator();
                while (iterator3.hasNext()) {
                    beanContextChild.removeVetoableChangeListener((String)iterator3.next(), this.vchDispatcher);
                }
            }
            arrayList.add(e);
        }
        this.fireChildrenRemoved(arrayList);
        return arrayList.size() != 0;
    }

    protected void fireChildrenAdded(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        BeanContextMembershipEvent beanContextMembershipEvent = new BeanContextMembershipEvent((BeanContext)this, objectArray);
        this.fireChildrenAdded(beanContextMembershipEvent);
    }

    protected void fireChildrenAdded(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        BeanContextMembershipEvent beanContextMembershipEvent = new BeanContextMembershipEvent((BeanContext)this, collection);
        this.fireChildrenAdded(beanContextMembershipEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fireChildrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
        Iterator iterator;
        FullBeanContextSupport fullBeanContextSupport = this;
        synchronized (fullBeanContextSupport) {
            iterator = ((AbstractList)((ArrayList)this.contentMembershipListeners.clone())).iterator();
        }
        while (iterator.hasNext()) {
            ((BeanContextMembershipListener)iterator.next()).childrenAdded(beanContextMembershipEvent);
        }
    }

    protected void fireChildrenRemoved(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        BeanContextMembershipEvent beanContextMembershipEvent = new BeanContextMembershipEvent((BeanContext)this, objectArray);
        this.fireChildrenRemoved(beanContextMembershipEvent);
    }

    protected void fireChildrenRemoved(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        BeanContextMembershipEvent beanContextMembershipEvent = new BeanContextMembershipEvent((BeanContext)this, collection);
        this.fireChildrenRemoved(beanContextMembershipEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fireChildrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
        Iterator iterator;
        FullBeanContextSupport fullBeanContextSupport = this;
        synchronized (fullBeanContextSupport) {
            iterator = ((AbstractList)((ArrayList)this.contentMembershipListeners.clone())).iterator();
        }
        while (iterator.hasNext()) {
            ((BeanContextMembershipListener)iterator.next()).childrenRemoved(beanContextMembershipEvent);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        ArrayList arrayList;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        FullBeanContextSupport fullBeanContextSupport = this;
        synchronized (fullBeanContextSupport) {
            arrayList = (ArrayList)this.propertyChangeListeners.get(string);
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            arrayList = (ArrayList)arrayList.clone();
        }
        this.firePropertyChange(propertyChangeEvent, arrayList);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent, ArrayList arrayList) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        ArrayList arrayList;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        FullBeanContextSupport fullBeanContextSupport = this;
        synchronized (fullBeanContextSupport) {
            arrayList = (ArrayList)this.vetoableListeners.get(string);
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            arrayList = (ArrayList)arrayList.clone();
        }
        this.fireVetoableChange(propertyChangeEvent, arrayList);
    }

    protected void fireVetoableChange(PropertyChangeEvent propertyChangeEvent, ArrayList arrayList) throws PropertyVetoException {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            ((VetoableChangeListener)iterator.next()).vetoableChange(propertyChangeEvent);
        }
    }

    protected BeanContextChild getBeanContextChild(Object object) {
        if (object instanceof BeanContextChild) {
            return (BeanContextChild)object;
        }
        if (object instanceof BeanContextProxy) {
            ((BeanContextProxy)object).getBeanContextProxy();
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.contentMembershipListeners = new ArrayList();
        this.propertyChangeListeners = new HashMap();
        this.vetoableListeners = new HashMap();
        this.pchDispatcher = new PropertyChangeDispatcher();
        this.vchDispatcher = new VetoableChangeDispatcher();
    }

    private class VetoableChangeDispatcher
    implements VetoableChangeListener {
        private VetoableChangeDispatcher() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (!FullBeanContextSupport.this.contains(propertyChangeEvent.getSource())) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            FullBeanContextSupport fullBeanContextSupport = FullBeanContextSupport.this;
            synchronized (fullBeanContextSupport) {
                ArrayList arrayList = (ArrayList)FullBeanContextSupport.this.vetoableListeners.get(string);
                if (arrayList != null && arrayList.size() > 0) {
                    FullBeanContextSupport.this.fireVetoableChange(propertyChangeEvent, arrayList);
                }
            }
        }
    }

    private class PropertyChangeDispatcher
    implements PropertyChangeListener {
        private PropertyChangeDispatcher() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Serializable serializable;
            if (!FullBeanContextSupport.this.contains(propertyChangeEvent.getSource())) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (FullBeanContextSupport.DESIGN_MODE.equals(string) && (serializable = (Boolean)propertyChangeEvent.getNewValue()) != null) {
                FullBeanContextSupport.this.noChildDesignTime = ((Boolean)serializable).booleanValue() ? ++FullBeanContextSupport.this.noChildDesignTime : --FullBeanContextSupport.this.noChildDesignTime;
            }
            serializable = FullBeanContextSupport.this;
            synchronized (serializable) {
                ArrayList arrayList = (ArrayList)FullBeanContextSupport.this.propertyChangeListeners.get(string);
                if (arrayList != null && arrayList.size() > 0) {
                    FullBeanContextSupport.this.firePropertyChange(propertyChangeEvent, arrayList);
                }
            }
        }
    }
}

