/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.wizard.nodes.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.corba.wizard.nodes.gui.ExPanel;
import org.netbeans.modules.corba.wizard.nodes.utils.IdlUtilities;

public class EnumPanel
extends ExPanel
implements DocumentListener {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField name;
    private JTextField values;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/nodes/gui/Bundle");

    public EnumPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    public String getName() {
        return this.name.getText().trim();
    }

    public void setName(String string) {
        this.name.setText(string);
    }

    public String getValues() {
        return this.values.getText();
    }

    public void setValues(String string) {
        this.values.setText(string);
    }

    private void postInitComponents() {
        this.name.getDocument().addDocumentListener(this);
        this.values.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.name = new JTextField();
        this.values = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(250, 56));
        this.jLabel1.setText(bundle.getString("TXT_ModuleName"));
        this.jLabel1.setLabelFor(this.name);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("TXT_EnumValues"));
        this.jLabel2.setLabelFor(this.values);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 8, 8, 4);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.name.setPreferredSize(new Dimension(100, 16));
        this.name.setToolTipText(bundle.getString("TIP_EnumName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 4, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.name, gridBagConstraints);
        this.values.setPreferredSize(new Dimension(100, 16));
        this.values.setToolTipText(bundle.getString("TIP_EnumValues"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 8, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.values, gridBagConstraints);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkState();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkState();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkState();
    }

    private void checkState() {
        if (!IdlUtilities.isValidIDLIdentifier(this.name.getText()) || this.values.getText().length() == 0) {
            this.disableOk();
        } else {
            String string = this.values.getText().trim();
            if (string.charAt(string.length() - 1) == ',') {
                this.disableOk();
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (IdlUtilities.isValidIDLIdentifier(string2)) continue;
                    this.disableOk();
                    return;
                }
                this.enableOk();
            }
        }
    }
}

