/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.wizard.nodes.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.corba.wizard.nodes.gui.ExPanel;
import org.netbeans.modules.corba.wizard.nodes.utils.IdlUtilities;

public class ValuePanel
extends ExPanel
implements DocumentListener,
ChangeListener {
    private JLabel jLabel1;
    private JTextField name;
    private JLabel jLabel2;
    private JTextField type;
    private JLabel jLabel3;
    private JTextField length;
    private JRadioButton pri;
    private JRadioButton pub;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/nodes/gui/Bundle");

    public ValuePanel() {
        this.initComponents();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.pub);
        buttonGroup.add(this.pri);
        this.name.getDocument().addDocumentListener(this);
        this.type.getDocument().addDocumentListener(this);
        this.length.getDocument().addDocumentListener(this);
        this.pub.addChangeListener(this);
        this.pri.addChangeListener(this);
        this.pri.setSelected(true);
    }

    public boolean isPublic() {
        return this.pub.isSelected();
    }

    public boolean isPrivate() {
        return this.pri.isSelected();
    }

    public void setPublic(boolean bl) {
        this.pub.setSelected(bl);
        this.pri.setSelected(!bl);
    }

    public void setPrivate(boolean bl) {
        this.pri.setSelected(bl);
        this.pub.setSelected(!bl);
    }

    public String getName() {
        return this.name.getText().trim();
    }

    public String getType() {
        return this.type.getText().trim();
    }

    public void setName(String string) {
        this.name.setText(string);
    }

    public void setType(String string) {
        this.type.setText(string);
    }

    public String getLength() {
        return this.length.getText();
    }

    public void setLength(String string) {
        this.length.setText(string);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.name = new JTextField();
        this.jLabel2 = new JLabel();
        this.type = new JTextField();
        this.jLabel3 = new JLabel();
        this.length = new JTextField();
        this.pri = new JRadioButton();
        this.pub = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("TXT_ValueName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.name.setToolTipText(bundle.getString("TIP_ValueName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 4, 8);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.name, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("TXT_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.type.setToolTipText(bundle.getString("TIP_ValueType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 8);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.type, gridBagConstraints);
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/nodes/gui/Bundle").getString("TXT_Length"));
        this.jLabel3.setLabelFor(this.length);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.length.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/nodes/gui/Bundle").getString("TIP_ValueLength"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 8);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.length, gridBagConstraints);
        this.pri.setText(bundle.getString("TXT_ValuePrivate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pri, gridBagConstraints);
        this.pub.setText(bundle.getString("TXT_ValuePublic"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 8, 8);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pub, gridBagConstraints);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkState();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkState();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkState();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.checkState();
    }

    private void checkState() {
        if (IdlUtilities.isValidIDLIdentifier(this.name.getText()) && this.type.getText().length() > 0 && IdlUtilities.validLength(this.length.getText())) {
            this.enableOk();
        } else {
            this.disableOk();
        }
    }
}

