/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.wizard.nodes.utils;

import java.util.StringTokenizer;

public class IdlUtilities {
    private static String[] primitiveTypes;

    private IdlUtilities() {
    }

    public static final boolean isValidIDLIdentifier(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        String string2 = string.toUpperCase();
        if (!(string2.charAt(0) >= 'A' && string2.charAt(0) <= 'Z' || string2.charAt(0) >= '\u00c0' && string2.charAt(0) <= '\u00dc' && string2.charAt(0) != '\u00d0' && string2.charAt(0) != '\u00d7' || string.charAt(0) == '\u00fe' || string.charAt(0) == '\u00ff' || string.charAt(0) == '_')) {
            return false;
        }
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (!(c >= 'A' && c <= 'Z' || c >= '\u00c0' && c <= '\u00dc' && c != '\u00d0' && c != '\u00d7' || Character.isDigit(c) || c == '_' || string.charAt(n) == '\u00fe' || string.charAt(n) == '\u00ff')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean validLength(String string) {
        if ((string = string.trim()).length() == 0) {
            return true;
        }
        if (string.charAt(string.length() - 1) == ',') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (IdlUtilities.isValidIDLIdentifier(string2)) continue;
                return false;
            }
        }
        return true;
    }

    public static String[] getIDLPrimitiveTypes() {
        if (primitiveTypes == null) {
            primitiveTypes = new String[]{"any", "boolean", "char", "CORBA::TypeCode", "CORBA::Principle", "double", "fixed<,>", "float", "long", "long double", "long long", "Object", "octet", "short", "string", "unsigned long", "unsigned long long", "unsigned short", "ValueBase", "void", "wchar", "wstring"};
        }
        return primitiveTypes;
    }
}

