/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.wizard.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.corba.settings.ORBBindingDescriptor;
import org.netbeans.modules.corba.settings.ORBSettings;
import org.netbeans.modules.corba.settings.WizardRequirement;
import org.netbeans.modules.corba.settings.WizardSettings;
import org.netbeans.modules.corba.wizard.CorbaWizardData;
import org.netbeans.modules.corba.wizard.panels.AbstractCORBAWizardPanel;
import org.netbeans.modules.corba.wizard.panels.BindingDetail;
import org.netbeans.modules.corba.wizard.panels.FilePanel;
import org.netbeans.modules.corba.wizard.panels.NSPanel;
import org.netbeans.modules.corba.wizard.panels.StringPanel;
import org.openide.util.NbBundle;

public class BindingDetailsPanel
extends AbstractCORBAWizardPanel
implements ChangeListener {
    private static final String STRING = "string";
    private static final String NAMING = "ns_code";
    private static final String FILE = "file_name";
    private CorbaWizardData wizardData;
    private ORBSettings orbSettings;
    private HashMap bindingDetails;
    private boolean maximizeReminder;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/panels/Bundle");
    static /* synthetic */ Class class$org$netbeans$modules$corba$wizard$panels$PackagePanel;

    public BindingDetailsPanel() {
        this.initComponents();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(4));
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$corba$wizard$panels$PackagePanel == null ? (class$org$netbeans$modules$corba$wizard$panels$PackagePanel = BindingDetailsPanel.class$("org.netbeans.modules.corba.wizard.panels.PackagePanel")) : class$org$netbeans$modules$corba$wizard$panels$PackagePanel)).getString("TXT_BindingMethodDetails"));
    }

    public void readCorbaSettings(CorbaWizardData corbaWizardData) {
        WizardRequirement wizardRequirement;
        ListIterator listIterator;
        WizardSettings wizardSettings;
        ORBBindingDescriptor oRBBindingDescriptor;
        ListIterator listIterator2;
        this.wizardData = corbaWizardData;
        this.orbSettings = corbaWizardData.getSettings().getActiveSetting();
        this.bindingDetails = (HashMap)corbaWizardData.getBindingDetails();
        if (this.bindingDetails == null) {
            this.bindingDetails = new HashMap();
        }
        this.maximizeReminder = true;
        HashSet<String> hashSet = new HashSet<String>();
        int n = corbaWizardData.getGenerate();
        if ((n & 4) == 4) {
            listIterator2 = this.orbSettings.getServerBindings().listIterator();
            oRBBindingDescriptor = null;
            while (listIterator2.hasNext()) {
                oRBBindingDescriptor = (ORBBindingDescriptor)listIterator2.next();
                if (!oRBBindingDescriptor.getName().equals(corbaWizardData.getBindMethod()) || (wizardSettings = oRBBindingDescriptor.getWizardSettings()) == null || !wizardSettings.isSupported()) continue;
                listIterator = wizardSettings.getRequirements().listIterator();
                while (listIterator.hasNext()) {
                    wizardRequirement = (WizardRequirement)listIterator.next();
                    if (hashSet.contains(wizardRequirement.getValue())) continue;
                    hashSet.add(wizardRequirement.getValue());
                    this.displayItem(wizardRequirement);
                }
            }
        }
        if ((n & 8) == 8 || (n & 0x10) == 16) {
            listIterator2 = this.orbSettings.getClientBindings().listIterator();
            oRBBindingDescriptor = null;
            while (listIterator2.hasNext()) {
                oRBBindingDescriptor = (ORBBindingDescriptor)listIterator2.next();
                if (!oRBBindingDescriptor.getName().equals(corbaWizardData.getClientBindMethod()) || (wizardSettings = oRBBindingDescriptor.getWizardSettings()) == null || !wizardSettings.isSupported()) continue;
                listIterator = wizardSettings.getRequirements().listIterator();
                while (listIterator.hasNext()) {
                    wizardRequirement = (WizardRequirement)listIterator.next();
                    if (hashSet.contains(wizardRequirement.getValue())) continue;
                    hashSet.add(wizardRequirement.getValue());
                    this.displayItem(wizardRequirement);
                }
            }
        }
        if (hashSet.size() == 0) {
            this.displayMessage();
        }
        this.fillReminder();
    }

    public void storeCorbaSettings(CorbaWizardData corbaWizardData) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof BindingDetail) {
                BindingDetail bindingDetail = (BindingDetail)componentArray[n];
                bindingDetail.removeChangeListener(this);
                this.bindingDetails.put(bindingDetail.getValue(), bindingDetail.getData());
            }
            ++n;
        }
        this.removeAll();
        corbaWizardData.setBindingDetails(this.bindingDetails);
    }

    public boolean isValid() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof BindingDetail && !((BindingDetail)componentArray[n]).isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 340));
    }

    private void displayItem(WizardRequirement wizardRequirement) {
        String string = wizardRequirement.getType();
        BindingDetail bindingDetail = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (string.equals(STRING)) {
            bindingDetail = new StringPanel();
        } else if (string.equals(FILE)) {
            bindingDetail = new FilePanel();
        } else if (string.equals(NAMING)) {
            bindingDetail = new NSPanel();
            gridBagConstraints.weighty = 1.0;
            this.maximizeReminder = false;
        }
        bindingDetail.setTitle(this.orbSettings.getLocalizedString(wizardRequirement.getTitle()));
        bindingDetail.setValue(wizardRequirement.getValue());
        bindingDetail.setData(this.bindingDetails.get(wizardRequirement.getValue()));
        bindingDetail.addChangeListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)bindingDetail, gridBagConstraints);
    }

    private void displayMessage() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(bundle.getString("TXT_NoBindingDetails"));
        jTextArea.setPreferredSize(new Dimension(400, 50));
        jTextArea.setMinimumSize(new Dimension(400, 50));
        jTextArea.setBackground(this.getBackground());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)jTextArea, gridBagConstraints);
    }

    private void fillReminder() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        if (this.maximizeReminder) {
            gridBagConstraints.weighty = 1.0;
        }
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

