/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.wizard.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.corba.wizard.IDLWizardData;
import org.netbeans.modules.corba.wizard.nodes.AbstractMutableIDLNode;
import org.netbeans.modules.corba.wizard.nodes.IdlFileNode;
import org.netbeans.modules.corba.wizard.nodes.actions.DestroyAction;
import org.netbeans.modules.corba.wizard.nodes.actions.EditAction;
import org.netbeans.modules.corba.wizard.nodes.utils.Create;
import org.netbeans.modules.corba.wizard.panels.AbstractIDLWizardPanel;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class CreateIDLPanel
extends AbstractIDLWizardPanel
implements PropertyChangeListener,
VetoableChangeListener {
    private static final boolean DEBUG = false;
    private BeanTreeView bv;
    private IdlFileNode root;
    private SystemAction removeAction;
    private SystemAction editAction;
    private IDLWizardData data;
    private ExplorerPanel tree;
    private JComboBox types;
    private JButton create;
    private JButton edit;
    private JButton up;
    private JButton down;
    private JButton remove;
    private JPanel jPanel2;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/panels/Bundle");

    public CreateIDLPanel(IDLWizardData iDLWizardData) {
        this.data = iDLWizardData;
        this.initComponents();
        this.postInitComponents();
        this.setName(bundle.getString("TXT_CreateIDL"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
    }

    public void postInitComponents() {
        this.bv = new BeanTreeView();
        this.bv.setPopupAllowed(false);
        this.bv.setDefaultActionAllowed(false);
        this.tree.add((Component)this.bv);
        this.root = new IdlFileNode();
        this.tree.getExplorerManager().setRootContext((Node)this.root);
        this.tree.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.tree.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        try {
            this.tree.getExplorerManager().setSelectedNodes(new Node[]{this.root});
            this.createCommandPanel(new Node[]{this.root});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void readIDLSettings(TemplateWizard templateWizard) {
    }

    public void storeIDLSettings(TemplateWizard templateWizard) {
        this.data.setIdlSource(this.root.generate());
    }

    public boolean isValid() {
        return true;
    }

    private void initComponents() {
        this.tree = new ExplorerPanel();
        this.types = new JComboBox();
        this.create = new JButton();
        this.edit = new JButton();
        this.up = new JButton();
        this.down = new JButton();
        this.remove = new JButton();
        this.jPanel2 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 300));
        this.setMinimumSize(new Dimension(100, 100));
        this.tree.setBorder(new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tree, gridBagConstraints);
        this.types.setPreferredSize(new Dimension(120, 23));
        this.types.setMinimumSize(new Dimension(120, 23));
        this.types.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIDLPanel.this.typesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 6, 12);
        this.add((Component)this.types, gridBagConstraints);
        this.create.setText(bundle.getString("TXT_CreateButton"));
        this.create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIDLPanel.this.createActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.create, gridBagConstraints);
        this.edit.setText(bundle.getString("TXT_EditButton"));
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIDLPanel.this.editActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.add((Component)this.edit, gridBagConstraints);
        this.up.setText(bundle.getString("TXT_UpButton"));
        this.up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIDLPanel.this.upActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.add((Component)this.up, gridBagConstraints);
        this.down.setText(bundle.getString("TXT_DownButton"));
        this.down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIDLPanel.this.downActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.add((Component)this.down, gridBagConstraints);
        this.remove.setText(bundle.getString("TXT_RemoveButton"));
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIDLPanel.this.removeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.add((Component)this.remove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(6, 0, 12, 12);
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void typesActionPerformed(ActionEvent actionEvent) {
    }

    private void downActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.tree.getExplorerManager().getSelectedNodes();
        ((AbstractMutableIDLNode)nodeArray[0]).moveDown();
        try {
            this.tree.getExplorerManager().setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void upActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.tree.getExplorerManager().getSelectedNodes();
        ((AbstractMutableIDLNode)nodeArray[0]).moveUp();
        try {
            this.tree.getExplorerManager().setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void editActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.tree.getExplorerManager().getSelectedNodes();
        this.editAction.actionPerformed(new ActionEvent(nodeArray, 0, ""));
    }

    private void removeActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.tree.getExplorerManager().getSelectedNodes();
        this.removeAction.actionPerformed(new ActionEvent(nodeArray, 0, ""));
    }

    private void createActionPerformed(ActionEvent actionEvent) {
        Object object = this.types.getSelectedItem();
        if (object == null || !(object instanceof NodeAction)) {
            return;
        }
        NodeAction nodeAction = (NodeAction)object;
        Node[] nodeArray = this.tree.getExplorerManager().getSelectedNodes();
        nodeAction.actionPerformed(new ActionEvent(nodeArray, 0, ""));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray;
        Object object = propertyChangeEvent.getNewValue();
        if (object != null && object instanceof Node[] && (nodeArray = (Node[])object).length == 1) {
            this.tree.setActivatedNodes(nodeArray);
            this.createCommandPanel(nodeArray);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        Object object = propertyChangeEvent.getNewValue();
        if (object != null && object instanceof Node[] && (nodeArray = (Node[])object).length != 1) {
            throw new PropertyVetoException("", propertyChangeEvent);
        }
    }

    private void enableUp() {
        this.up.setEnabled(true);
    }

    private void disableUp() {
        this.up.setEnabled(false);
    }

    private void enableDown() {
        this.down.setEnabled(true);
    }

    private void disableDown() {
        this.down.setEnabled(false);
    }

    private void createCommandPanel(Node[] nodeArray) {
        this.types.removeAllItems();
        SystemAction[] systemActionArray = nodeArray[0].getActions();
        this.remove.setEnabled(false);
        this.edit.setEnabled(false);
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        int n = 0;
        while (n < systemActionArray.length) {
            if (systemActionArray[n] != null) {
                if (systemActionArray[n] instanceof Create) {
                    if (((Create)systemActionArray[n]).isEnabled(nodeArray)) {
                        this.types.addItem(systemActionArray[n]);
                    }
                } else if (systemActionArray[n] instanceof DestroyAction) {
                    this.removeAction = systemActionArray[n];
                    this.remove.setEnabled(true);
                } else if (systemActionArray[n] instanceof EditAction) {
                    this.editAction = systemActionArray[n];
                    this.edit.setEnabled(true);
                }
            }
            ++n;
        }
        if (this.types.getItemCount() == 0) {
            this.create.setEnabled(false);
        } else {
            this.create.setEnabled(true);
        }
        if (nodeArray[0] instanceof AbstractMutableIDLNode) {
            this.up.setEnabled(((AbstractMutableIDLNode)nodeArray[0]).canMoveUp());
            this.down.setEnabled(((AbstractMutableIDLNode)nodeArray[0]).canMoveDown());
        }
    }
}

