/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.wizard.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.corba.settings.CORBASupportSettings;
import org.netbeans.modules.corba.settings.ORBBindingDescriptor;
import org.netbeans.modules.corba.settings.WizardSettings;
import org.netbeans.modules.corba.wizard.CorbaWizardData;
import org.netbeans.modules.corba.wizard.panels.AbstractCORBAWizardPanel;
import org.netbeans.modules.corba.wizard.panels.LocalizedRenderer;
import org.openide.util.NbBundle;

public class ORBPanel
extends AbstractCORBAWizardPanel {
    private boolean initialized = false;
    private CORBASupportSettings css = null;
    private CorbaWizardData data;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox orbs;
    private JComboBox bindings;
    private JPanel jPanel3;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/panels/Bundle");
    static /* synthetic */ Class class$org$netbeans$modules$corba$wizard$panels$PackagePanel;

    public ORBPanel() {
        this.initComponents();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$corba$wizard$panels$PackagePanel == null ? (class$org$netbeans$modules$corba$wizard$panels$PackagePanel = ORBPanel.class$("org.netbeans.modules.corba.wizard.panels.PackagePanel")) : class$org$netbeans$modules$corba$wizard$panels$PackagePanel)).getString("TXT_ImplementationsBindings"));
    }

    public void readCorbaSettings(CorbaWizardData corbaWizardData) {
        int n;
        Object object;
        if (!this.initialized) {
            Object object2;
            this.data = corbaWizardData;
            this.css = corbaWizardData.getSettings();
            object = this.css.getNames();
            n = 0;
            while (n < ((Vector)object).size()) {
                this.orbs.addItem(((Vector)object).elementAt(n));
                ++n;
            }
            List list = this.css.getActiveSetting().getServerBindings();
            this.bindings.setRenderer(new LocalizedRenderer(this.css.getActiveSetting()));
            if (list != null) {
                object2 = list.listIterator();
                while (object2.hasNext()) {
                    ORBBindingDescriptor oRBBindingDescriptor = (ORBBindingDescriptor)object2.next();
                    WizardSettings wizardSettings = oRBBindingDescriptor.getWizardSettings();
                    if (wizardSettings == null || !wizardSettings.isSupported()) continue;
                    this.bindings.addItem(oRBBindingDescriptor.getName());
                }
            }
            if ((object2 = this.css.getActiveSetting().getName()) != null) {
                this.orbs.setSelectedItem(object2);
                corbaWizardData.setDefaultOrbValue((String)object2);
            }
            object2 = this.css.getActiveSetting().getClientBinding().getValue();
            corbaWizardData.setDefaultClientBindingValue((String)object2);
            object2 = this.css.getActiveSetting().getServerBinding().getValue();
            corbaWizardData.setDefaultServerBindingValue((String)object2);
            this.orbs.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ORBPanel.this.orbChanged(actionEvent);
                }
            });
            this.bindings.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ORBPanel.this.bindingChanged(actionEvent);
                }
            });
            this.bindings.setSelectedItem(corbaWizardData.getDefaultServerBindingValue());
            this.initialized = true;
        }
        if ((object = corbaWizardData.getCORBAImpl()) != null) {
            this.orbs.setSelectedItem(object);
        }
        if ((object = corbaWizardData.getBindMethod()) != null) {
            this.bindings.setSelectedItem(object);
        }
        this.bindings.setEnabled(((n = corbaWizardData.getGenerate()) & 4) == 4 || (n & 8) == 8 || (n & 0x10) == 16);
    }

    public void storeCorbaSettings(CorbaWizardData corbaWizardData) {
        corbaWizardData.setCORBAImpl((String)this.orbs.getSelectedItem());
        corbaWizardData.setBindMethod((String)this.bindings.getSelectedItem());
    }

    public boolean isValid() {
        return true;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.orbs = new JComboBox();
        this.bindings = new JComboBox();
        this.jPanel3 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 340));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("TXT_OrbImplementations"));
        this.jLabel1.setLabelFor(this.orbs);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 6);
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("TXT_BindingMethod"));
        this.jLabel2.setLabelFor(this.bindings);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 12, 6);
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 6, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.orbs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 12, 12);
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.bindings, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints2);
    }

    private void bindingChanged(ActionEvent actionEvent) {
        String string = (String)this.bindings.getSelectedItem();
        if (string == null) {
            return;
        }
        this.css.getActiveSetting().setServerBindingFromString(string);
        String string2 = CorbaWizardData.getClientBindMethod(string);
        this.css.getActiveSetting().setClientBindingFromString(string2);
    }

    private void orbChanged(ActionEvent actionEvent) {
        if (this.data != null && this.data.getDefaultClientBindingValue() != null) {
            this.css.getActiveSetting().setClientBindingFromString(this.data.getDefaultClientBindingValue());
        }
        if (this.data != null && this.data.getDefaultServerBindingValue() != null) {
            this.css.getActiveSetting().setServerBindingFromString(this.data.getDefaultServerBindingValue());
        }
        this.css.setOrb((String)this.orbs.getSelectedItem());
        if (this.data != null) {
            this.data.setDefaultClientBindingValue(this.css.getActiveSetting().getClientBinding().getValue());
            this.data.setDefaultServerBindingValue(this.css.getActiveSetting().getServerBinding().getValue());
        }
        List list = this.css.getActiveSetting().getServerBindings();
        this.bindings.removeAllItems();
        this.bindings.setRenderer(new LocalizedRenderer(this.css.getActiveSetting()));
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ORBBindingDescriptor oRBBindingDescriptor = (ORBBindingDescriptor)listIterator.next();
                WizardSettings wizardSettings = oRBBindingDescriptor.getWizardSettings();
                if (wizardSettings == null || !wizardSettings.isSupported()) continue;
                this.bindings.addItem(oRBBindingDescriptor.getName());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

