/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.wizard.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.corba.IDLDataObject;
import org.netbeans.modules.corba.wizard.CorbaWizardData;
import org.netbeans.modules.corba.wizard.panels.AbstractCORBAWizardPanel;
import org.openide.TopManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PackagePanel
extends AbstractCORBAWizardPanel
implements PropertyChangeListener,
VetoableChangeListener,
DataFilter,
DocumentListener {
    private static final boolean DEBUG = false;
    private Node root;
    private boolean validIdlName = false;
    private BeanTreeView tv;
    private ExplorerPanel tree;
    private JPanel jPanel1;
    private JLabel jLabel3;
    private JTextField idlName;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/corba/wizard/panels/Bundle");
    static /* synthetic */ Class class$org$netbeans$modules$corba$wizard$panels$PackagePanel;

    public PackagePanel() {
        this.initComponents();
        this.tv = new BeanTreeView();
        this.tv.setPopupAllowed(false);
        this.tv.setDefaultActionAllowed(false);
        this.tree.setMinimumSize(new Dimension(400, 250));
        this.tree.setPreferredSize(new Dimension(400, 250));
        this.tree.setBorder(new EtchedBorder());
        this.tree.add((Component)this.tv, "Center");
        this.root = TopManager.getDefault().getPlaces().nodes().repository((DataFilter)this);
        this.tree.getExplorerManager().setRootContext(this.root);
        this.tree.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.tree.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        this.idlName.getDocument().addDocumentListener(this);
        this.putClientProperty("WizardPanel_autoWizardStyle", new Boolean(true));
        this.putClientProperty("WizardPanel_contentDisplayed", new Boolean(true));
        this.putClientProperty("WizardPanel_contentNumbered", new Boolean(true));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
        this.putClientProperty("WizardPanel_contentData", new String[]{bundle.getString("TXT_Source"), bundle.getString("TXT_AppComponents"), bundle.getString("TXT_ORBSettings"), bundle.getString("TXT_RootInterface"), bundle.getString("TXT_BindingDetails"), bundle.getString("TXT_Finish")});
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$corba$wizard$panels$PackagePanel == null ? (class$org$netbeans$modules$corba$wizard$panels$PackagePanel = PackagePanel.class$("org.netbeans.modules.corba.wizard.panels.PackagePanel")) : class$org$netbeans$modules$corba$wizard$panels$PackagePanel)).getString("TXT_Package"));
        this.fireChange(this);
    }

    public void readCorbaSettings(CorbaWizardData corbaWizardData) {
        IDLDataObject iDLDataObject = corbaWizardData.getIdlSource();
        if (iDLDataObject == null) {
            return;
        }
        String string = iDLDataObject.getName();
        iDLDataObject = iDLDataObject.getFolder();
        while (iDLDataObject != null) {
            string = iDLDataObject.getName() + "." + string;
            iDLDataObject = iDLDataObject.getFolder();
        }
        if (string.charAt(0) == '.') {
            string = string.substring(1);
        }
        this.idlName.setText(string);
    }

    public void storeCorbaSettings(CorbaWizardData corbaWizardData) {
        if (this.validIdlName) {
            String string = this.idlName.getText().replace('.', '/');
            string = string + ".idl";
            TopManager topManager = TopManager.getDefault();
            Repository repository = topManager.getRepository();
            FileObject fileObject = repository.findResource(string);
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject instanceof IDLDataObject) {
                    corbaWizardData.setIdlSource((IDLDataObject)dataObject);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                corbaWizardData.setIdlSource(null);
            }
        }
    }

    public boolean isValid() {
        return this.idlName.getText().length() > 0 && this.validIdlName;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray;
        Object object = propertyChangeEvent.getNewValue();
        if (object != null && object instanceof Node[] && (nodeArray = (Node[])object).length == 1) {
            Node node = nodeArray[0];
            String string = "";
            while (true) {
                Node node2;
                if ((node2 = node.getParentNode()) == null || node2 == this.root) {
                    if (!string.endsWith(".")) break;
                    string = string.substring(0, string.length() - 1);
                    break;
                }
                string = node.getDisplayName() + "." + string;
                node = node2;
            }
            this.idlName.setText(string);
            this.checkFileNameValidity(false);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        Object object = propertyChangeEvent.getNewValue();
        if (object != null && object instanceof Node[] && (nodeArray = (Node[])object).length != 1) {
            throw new PropertyVetoException("", propertyChangeEvent);
        }
    }

    private void initComponents() {
        this.tree = new ExplorerPanel();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.idlName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 340));
        this.setMinimumSize(new Dimension(480, 320));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tree, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("TXT_Name"));
        this.jLabel3.setLabelFor(this.idlName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 6, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.idlName.setToolTipText(bundle.getString("TIP_NameOfIdlFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 6, 12);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.idlName, gridBagConstraints);
    }

    public boolean acceptDataObject(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        return dataObject.isValid() && fileObject.isData() && fileObject.getExt().equals("idl") || fileObject.isFolder();
    }

    private void checkFileNameValidity(boolean bl) {
        try {
            block4: {
                try {
                    String string = this.idlName.getText().replace('.', '/');
                    string = string + ".idl";
                    TopManager topManager = TopManager.getDefault();
                    Repository repository = topManager.getRepository();
                    final FileObject fileObject = repository.findResource(string);
                    boolean bl2 = this.validIdlName = fileObject != null;
                    if (!bl || fileObject == null) break block4;
                    RequestProcessor.postRequest((Runnable)new Runnable(){

                        public void run() {
                            PackagePanel.this.selectPath(fileObject);
                        }
                    });
                }
                catch (Exception exception) {
                    Object var7_8 = null;
                    this.fireChange(this);
                }
            }
            Object var7_7 = null;
            this.fireChange(this);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fireChange(this);
            throw throwable;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkFileNameValidity(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkFileNameValidity(true);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkFileNameValidity(true);
    }

    private void selectPath(FileObject fileObject) {
        this.tree.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(fileObject.getPackageName('.'), ".");
            Node node = this.root.getChildren().findChild(fileObject.getFileSystem().getSystemName());
            while (stringTokenizer.hasMoreTokens()) {
                node = node.getChildren().findChild(stringTokenizer.nextToken());
            }
            this.tree.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tree.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

