/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.ProgressDialog;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

class Downloader {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$Downloader == null ? (class$org$netbeans$modules$autoupdate$Downloader = Downloader.class$("org.netbeans.modules.autoupdate.Downloader")) : class$org$netbeans$modules$autoupdate$Downloader));
    ProgressDialog progressDialog;
    private volatile boolean downloadCanceled;
    private int downloadSize;
    private long totalDownloaded;
    private long modulesCount;
    private boolean urlDownload;
    private static final String NBM_EXTENSION = "nbm";
    private Wizard.Validator validator;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$Downloader;

    public Downloader(ProgressDialog progressDialog, Wizard.Validator validator, boolean bl) {
        this.validator = validator;
        this.progressDialog = progressDialog;
        this.urlDownload = bl;
    }

    void doDownload() {
        this.downloadCanceled = false;
        Runnable runnable = new Runnable(){

            public void run() {
                Downloader.this.progressDialog.setLabelText(1, bundle.getString("CTL_PreparingDownload_Label"));
                Downloader.this.downloadSize = Downloader.this.getTotalDownloadSize();
                if (Downloader.this.downloadCanceled) {
                    return;
                }
                Downloader.this.downloadAll();
                if (Downloader.this.downloadCanceled) {
                    return;
                }
                Downloader.this.validator.setValid(true);
            }
        };
        Wizard.getRequestProcessor().post(runnable);
    }

    int getTotalDownloadSize() {
        long l = 0L;
        this.modulesCount = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected() || moduleUpdate.isDownloadOK()) continue;
            l += moduleUpdate.getDownloadSize();
            ++this.modulesCount;
        }
        return (int)(l / 1024L);
    }

    private void downloadAll() {
        Object object;
        if (this.downloadCanceled) {
            return;
        }
        this.progressDialog.setGaugeBounds(2, 0, this.downloadSize);
        this.progressDialog.setGaugeValue(2, 0);
        this.progressDialog.setLabelText(2, "");
        this.progressDialog.setGaugeValue(1, 0);
        int n = 0;
        this.totalDownloaded = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            if (this.downloadCanceled) {
                return;
            }
            object = (ModuleUpdate)iterator.next();
            if (!((ModuleUpdate)object).isSelected() || ((ModuleUpdate)object).isDownloadOK()) continue;
            this.progressDialog.setGaugeValue(1, 0);
            this.progressDialog.setLabelText(1, ((ModuleUpdate)object).getName() + " [" + (n + 1) + "/" + this.modulesCount + "]");
            this.download(l, (ModuleUpdate)object);
            ++n;
        }
        this.progressDialog.setGaugeValue(2, this.downloadSize);
        object = MessageFormat.format(bundle.getString("FMT_DownloadedTotal"), new Integer(this.downloadSize), new Integer(this.downloadSize));
        this.progressDialog.setLabelText(2, (String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void download(long l, ModuleUpdate moduleUpdate) {
        int n = 0;
        int n2 = 0;
        while (true) {
            Object object;
            Object object2;
            File file = null;
            try {
                URLConnection uRLConnection = null;
                if (this.urlDownload) {
                    uRLConnection = moduleUpdate.getDistribution().openConnection();
                    n2 = uRLConnection.getContentLength();
                    moduleUpdate.setRemoteDistributionFilename(uRLConnection);
                } else {
                    n2 = (int)moduleUpdate.getDistributionFile().length();
                }
                if (this.downloadCanceled) {
                    return;
                }
                n = 0;
                this.progressDialog.setGaugeBounds(1, 0, n2 / 1024);
                moduleUpdate.setDownloadStarted(true);
                file = Downloader.getNBM(moduleUpdate);
                object2 = this.urlDownload ? new BufferedInputStream(uRLConnection.getInputStream()) : new BufferedInputStream(new FileInputStream(moduleUpdate.getDistributionFile()));
                object = new BufferedOutputStream(new FileOutputStream(file));
                boolean bl = false;
                long l2 = System.currentTimeMillis();
                try {
                    while (true) {
                        int n3;
                        if ((n3 = ((BufferedInputStream)object2).read()) == -1) break;
                        ((BufferedOutputStream)object).write(n3);
                        ++n;
                        ++this.totalDownloaded;
                        long l3 = System.currentTimeMillis();
                        if (this.downloadCanceled) {
                            Object var18_15 = null;
                            ((BufferedInputStream)object2).close();
                            ((FilterOutputStream)object).close();
                            if (this.downloadCanceled) {
                                Downloader.getNBM(moduleUpdate).delete();
                            }
                            return;
                        }
                        if (n % 4096 != 0) continue;
                        l3 = l2;
                        String string = MessageFormat.format(bundle.getString("FMT_DownloadedTotal"), new Integer((int)(this.totalDownloaded / 1024L)), new Integer(this.downloadSize));
                        this.progressDialog.setGaugeValue(2, (int)(this.totalDownloaded / 1024L) > this.downloadSize ? this.downloadSize : (int)(this.totalDownloaded / 1024L));
                        this.progressDialog.setLabelText(2, string);
                        this.progressDialog.setGaugeValue(1, n / 1024);
                    }
                    Object var18_16 = null;
                    ((BufferedInputStream)object2).close();
                    ((FilterOutputStream)object).close();
                    if (!this.downloadCanceled) break;
                    Downloader.getNBM(moduleUpdate).delete();
                }
                catch (Throwable throwable) {
                    Object var18_17 = null;
                    ((BufferedInputStream)object2).close();
                    ((FilterOutputStream)object).close();
                    if (this.downloadCanceled) {
                        Downloader.getNBM(moduleUpdate).delete();
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                object2 = MessageFormat.format(bundle.getString("FMT_DownloadFailed"), moduleUpdate.getName());
                object = new NotifyDescriptor.Confirmation(object2, bundle.getString("CTL_DownloadFailed"), 1);
                TopManager.getDefault().notify((NotifyDescriptor)object);
                if (object.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    this.totalDownloaded -= (long)n;
                    continue;
                }
                if (object.getValue().equals(NotifyDescriptor.CANCEL_OPTION)) {
                    this.downloadCanceled = true;
                    this.validator.setValid(true);
                    return;
                }
                this.totalDownloaded -= (long)n;
                this.downloadSize -= (int)(moduleUpdate.getDownloadSize() / 1024L);
                if (file != null) {
                    file.delete();
                }
                return;
            }
            break;
        }
        this.progressDialog.setGaugeValue(1, n2 / 1024 + 10);
        moduleUpdate.setDownloadOK(true);
    }

    void cancelDownload() {
        this.downloadCanceled = true;
    }

    static File getNBM(ModuleUpdate moduleUpdate) {
        File file = new File(Autoupdater.Support.getDownloadDirectory(), moduleUpdate.getDistributionFilename());
        return file;
    }

    static File getMovedNBM(ModuleUpdate moduleUpdate) {
        File file = null;
        file = moduleUpdate.isToInstallDir() ? new File(Autoupdater.Support.getInstallDownloadDirectory(), moduleUpdate.getDistributionFilename()) : new File(Autoupdater.Support.getDownloadDirectory(), moduleUpdate.getDistributionFilename());
        return file;
    }

    static boolean tryMove(ModuleUpdate moduleUpdate) {
        File file = new File(Autoupdater.Support.getInstallDownloadDirectory(), moduleUpdate.getDistributionFilename());
        boolean bl = Downloader.getNBM(moduleUpdate).renameTo(file);
        if (bl) {
            return true;
        }
        bl = Downloader.tryCopy(Downloader.getNBM(moduleUpdate), file);
        if (bl) {
            Downloader.getNBM(moduleUpdate).delete();
        }
        return bl;
    }

    private static boolean tryCopy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 4096);
                while ((n = bufferedInputStream.read()) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                bufferedInputStream.close();
                filterOutputStream.close();
                throw throwable;
            }
            bufferedInputStream.close();
            filterOutputStream.close();
            {
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static void deleteModuleNBM(ModuleUpdate moduleUpdate) {
        Downloader.getNBM(moduleUpdate).delete();
    }

    static void deleteDownload() {
        boolean bl = true;
        PreparedModules preparedModules = null;
        if (Autoupdater.Support.getInstall_Later(true).exists()) {
            bl = false;
            preparedModules = PreparedModules.getPrepared();
        }
        File[] fileArray = Downloader.getNBMFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (bl || !preparedModules.hasNBM(fileArray[n].getName())) {
                fileArray[n].delete();
            }
            ++n;
        }
    }

    static boolean bannedWriteToInstall() {
        return !Autoupdater.Support.getInstallDownloadDirectory().canWrite();
    }

    private static File[] getNBMFiles() {
        File[] fileArray = Autoupdater.Support.getDownloadDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(Downloader.NBM_EXTENSION);
            }
        });
        return fileArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

