/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.CodeGeneratorClass;
import org.netbeans.modules.schema2beans.CodeGeneratorFactory;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphLink;
import org.netbeans.modules.schema2beans.GraphNode;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.TreeParser;
import org.netbeans.modules.schema2beans.metadd.MetaDD;
import org.netbeans.modules.schema2beans.metadd.MetaElement;
import org.netbeans.modules.schema2beans.metadd.MetaProperty;

public class BeanBuilder {
    private GenBeans.Config config;
    private CodeGeneratorFactory codeGenFactory;
    TreeParser parser;

    BeanBuilder(TreeParser treeParser, GenBeans.Config config, CodeGeneratorFactory codeGeneratorFactory) {
        this.parser = treeParser;
        this.config = config;
        this.codeGenFactory = codeGeneratorFactory;
    }

    private void buildProperties(GraphLink graphLink, CodeGeneratorClass codeGeneratorClass, int n, int n2, MetaElement metaElement, MetaDD metaDD, Map map) {
        while (graphLink != null) {
            if (graphLink.element != null) {
                BaseBean baseBean;
                BeanElement beanElement = (BeanElement)graphLink.element.getObject();
                boolean bl = false;
                if (beanElement == null) break;
                if (graphLink.parent != null) {
                    bl = graphLink.parent.isSequenceOr();
                }
                String string = beanElement.getName();
                String string2 = Common.constName(beanElement.getDTDName());
                if (map.containsKey(string)) {
                    int n3 = 2;
                    String string3 = string;
                    while (map.containsKey(string = string3 + n3)) {
                        ++n3;
                    }
                    beanElement.setName(string);
                    string2 = string2 + n3;
                    MetaElement metaElement2 = this.getMetaElement(metaDD, beanElement.getDTDName());
                    baseBean = (MetaElement)metaElement2.clone();
                    metaDD.addMetaElement((MetaElement)baseBean);
                    this.config.messageOut.println(Common.getMessage("RenamedProperty_msg", string3, string));
                }
                map.put(string, beanElement);
                codeGeneratorClass.addProperty(string, beanElement.getDTDName(), beanElement.getClassType(), n, graphLink.getElementInstance(), n2, beanElement.type, bl, beanElement.node.getAttributes(), string2);
                if (metaElement != null) {
                    MetaProperty[] metaPropertyArray = metaElement.getMetaProperty();
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < metaPropertyArray.length) {
                        if (string.equals(metaPropertyArray[n4].getBeanName())) {
                            bl2 = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl2) {
                        baseBean = new MetaProperty();
                        ((MetaProperty)baseBean).setBeanName(string);
                        metaElement.addMetaProperty((MetaProperty)baseBean);
                    }
                }
            }
            this.buildProperties(graphLink.child, codeGeneratorClass, n + 1, graphLink.getGroupInstance(), metaElement, metaDD, map);
            graphLink = graphLink.sibling;
        }
    }

    void process() throws IOException {
        Object object;
        Object object2;
        Object object3;
        File file;
        BeanElement beanElement;
        GraphNode graphNode = this.parser.getRoot();
        GraphNode[] graphNodeArray = this.parser.getNodes();
        MetaDD metaDD = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        if (graphNode == null) {
            throw new IllegalStateException(Common.getMessage("DTDObjectGraphIsNull_msg"));
        }
        int n = 0;
        while (n < graphNodeArray.length) {
            if (!graphNodeArray[n].getName().equals("#PCDATA") && !graphNodeArray[n].getName().equals("EMPTY")) {
                beanElement = new BeanElement(graphNodeArray[n]);
                beanElement.initialize(graphNodeArray[n] == graphNode);
                graphNodeArray[n].setObject(beanElement);
            }
            ++n;
        }
        String string = this.config.rootDir;
        String string2 = this.config.packagePath;
        if (string == null) {
            string = ".";
        }
        BeanElement beanElement2 = (BeanElement)graphNode.getObject();
        if (string2 == null || string2.equals("")) {
            string2 = beanElement2.getName().toLowerCase();
        }
        String string3 = string.equals("") ? string2 : (!string.equals("/") ? string + "/" + string2 : "/" + string2);
        if (this.config.mddFile != null || this.config.mddIn != null) {
            file = null;
            if (this.config.mddFile != null) {
                file = new File(this.config.mddFile);
            }
            if (this.config.mddIn == null && !file.exists()) {
                if (!this.config.auto) {
                    this.config.messageOut.print("The mdd file " + this.config.mddFile + " doesn't exist. Should we create it (y/n) ?");
                    object3 = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        object2 = ((BufferedReader)object3).readLine();
                    }
                    catch (IOException iOException) {
                        this.config.messageOut.println("Got unexpected exception: " + iOException.getMessage());
                        object2 = "n";
                    }
                    if (!((String)object2).equals("y")) {
                        this.config.messageOut.println("Generation aborted.");
                        return;
                    }
                }
                try {
                    fileOutputStream = new FileOutputStream(this.config.mddFile);
                    metaDD = MetaDD.createGraph();
                    bl = true;
                }
                catch (IOException iOException) {
                    throw new IOException(Common.getMessage("CantCreateFile_msg", this.config.mddFile, iOException.getMessage()));
                }
            }
            try {
                if (this.config.mddIn == null) {
                    this.config.mddIn = new FileInputStream(this.config.mddFile);
                    this.config.messageOut.println("Using the mdd information from " + this.config.mddFile);
                }
                metaDD = MetaDD.createGraph(this.config.mddIn);
            }
            catch (IOException iOException) {
                throw new IOException(Common.getMessage("CantCreateMetaDDFile_msg", iOException.getMessage()));
            }
        }
        metaDD = MetaDD.createGraph();
        if (!bl && this.config.outputStreamProvider == null) {
            file = new File(string3);
            if (file.exists() && !file.isDirectory()) {
                throw new Schema2BeansRuntimeException(Common.getMessage("CantCreateDirIsFile_msg", file));
            }
            if (!file.exists() && file.mkdirs()) {
                this.config.messageOut.println("created directory " + file);
            }
        }
        int n2 = 0;
        while (n2 < graphNodeArray.length) {
            object3 = null;
            object = graphNodeArray[n2].getJavaType();
            beanElement = (BeanElement)graphNodeArray[n2].getObject();
            if (beanElement != null) {
                object3 = this.getMetaElement(metaDD, beanElement.getDTDName());
                if (object3 == null) {
                    object3 = new MetaElement();
                    ((MetaElement)object3).setBeanName(beanElement.getName());
                    ((MetaElement)object3).setDtdName(beanElement.getDTDName());
                    metaDD.addMetaElement((MetaElement)object3);
                }
                if (object3 != null) {
                    if (((MetaElement)object3).getBeanName() != null && !((MetaElement)object3).getBeanName().equals("")) {
                        beanElement.setClassType(((MetaElement)object3).getBeanName());
                        beanElement.setName(((MetaElement)object3).getBeanName());
                    }
                    if (((MetaElement)object3).getWrapperClass() != null) {
                        object = ((MetaElement)object3).getWrapperClass();
                    } else if (object != null) {
                        ((MetaElement)object3).setWrapperClass((String)object);
                    } else if (beanElement != beanElement2 && Common.isScalar(beanElement.type)) {
                        ((MetaElement)object3).setWrapperClass(Common.wrapperClass(beanElement.type));
                        object = ((MetaElement)object3).getWrapperClass();
                    } else if (beanElement != beanElement2 && !Common.isBean(beanElement.type)) {
                        ((MetaElement)object3).setWrapperClass(beanElement.typeToString());
                        object = ((MetaElement)object3).getWrapperClass();
                    }
                }
                if (object != null) {
                    int n3 = Common.wrapperToType((String)object);
                    if (n3 != 0) {
                        beanElement.type = n3;
                    }
                    beanElement.setClassType((String)object);
                }
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < graphNodeArray.length) {
            object2 = null;
            beanElement = (BeanElement)graphNodeArray[n4].getObject();
            if (beanElement != null) {
                object2 = this.getMetaElement(metaDD, beanElement.getDTDName());
            }
            if (beanElement != null && (beanElement.isBean() || beanElement == beanElement2)) {
                String string4;
                Object object4;
                object = this.codeGenFactory.newCodeGeneratorClass(beanElement);
                object.setPackageName(string2);
                object.setIndent(this.config.indent);
                if (beanElement.isBean()) {
                    object4 = new HashMap();
                    object.setInvalidPropertyNames((Map)object4);
                    this.buildProperties(beanElement.getGraphNode().link, (CodeGeneratorClass)object, 0, 0, (MetaElement)object2, metaDD, (Map)object4);
                    string4 = beanElement.getClassType();
                } else {
                    string4 = beanElement.getName();
                }
                if (!bl) {
                    try {
                        String string5;
                        if (this.config.outputStreamProvider == null) {
                            string5 = string3 + "/" + string4 + ".java";
                            this.config.messageOut.println("Generating class " + string5);
                            object4 = new FileOutputStream(string5);
                        } else {
                            object4 = this.config.outputStreamProvider.getStream(string3, string4, "java");
                        }
                        object.generate((OutputStream)object4, metaDD, this.config);
                        ((OutputStream)object4).close();
                        object4 = null;
                        if (this.config.generateDelegator) {
                            string5 = string4 + "Delegator";
                            if (this.config.outputStreamProvider == null) {
                                String string6 = string3 + "/" + string5 + ".java";
                                this.config.messageOut.println("Generating class " + string6);
                                object4 = new FileOutputStream(string6);
                            } else {
                                object4 = this.config.outputStreamProvider.getStream(string3, string5, "java");
                            }
                            object.generateDelegator((OutputStream)object4, metaDD, this.config, string5);
                            ((OutputStream)object4).close();
                            object4 = null;
                        }
                    }
                    catch (IOException iOException) {
                        this.config.messageOut.println("Failed to generate bean class: " + string4);
                        TraceLogger.error(iOException);
                        throw iOException;
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.config.messageOut.println("Failed to generate bean class " + string4);
                        TraceLogger.error(illegalStateException);
                        throw illegalStateException;
                    }
                }
            }
            ++n4;
        }
        try {
            if (bl) {
                metaDD.write(fileOutputStream);
                this.config.messageOut.println("Writing metaDD XML file");
            }
        }
        catch (IOException iOException) {
            this.config.messageOut.println("Failed to write the mdd file: " + iOException.getMessage());
            throw iOException;
        }
    }

    private MetaElement getMetaElement(MetaDD metaDD, String string) {
        if (metaDD == null) {
            return null;
        }
        int n = metaDD.sizeMetaElement();
        int n2 = 0;
        while (n2 < n) {
            MetaElement metaElement = metaDD.getMetaElement(n2);
            if (metaElement != null && metaElement.getDtdName().equals(string)) {
                return metaElement;
            }
            ++n2;
        }
        return null;
    }

    class BeanElement {
        GraphNode node;
        String beanName;
        int type;
        String classType;
        boolean isRoot;

        BeanElement(GraphNode graphNode) {
            this.node = graphNode;
        }

        void initialize(boolean bl) {
            this.beanName = Common.convertName(this.node.getName());
            this.type = 512;
            GraphNode[] graphNodeArray = this.node.getNodes();
            if (graphNodeArray.length == 1) {
                if (graphNodeArray[0].getName().equals("#PCDATA")) {
                    this.type = 256;
                } else if (graphNodeArray[0].getName().equals("EMPTY")) {
                    this.type = 768;
                }
            }
            this.isRoot = bl;
        }

        public GraphNode getGraphNode() {
            return this.node;
        }

        public void setName(String string) {
            this.beanName = string;
        }

        public String getName() {
            return this.beanName;
        }

        public String getDTDName() {
            return this.node.getName();
        }

        public void setDTDName(String string) {
            this.node.setName(string);
        }

        public boolean isBean() {
            return Common.isBean(this.type);
        }

        public boolean isBoolean() {
            return Common.isBoolean(this.type);
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public String typeToString() {
            switch (this.type) {
                case 256: {
                    return "String";
                }
                case 768: {
                    return "Boolean";
                }
            }
            return this.beanName;
        }

        public String getClassType() {
            if (this.classType == null) {
                return this.typeToString();
            }
            return this.classType;
        }

        public void setClassType(String string) {
            this.classType = string;
        }

        public String toString() {
            return this.beanName + (this.type == 256 ? " \t(String)" : "\t(Bean)");
        }
    }
}

