/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DocDefHandler;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GeneralParser;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.SchemaParser;
import org.netbeans.modules.schema2beans.TraceLogger;

public class DocDefParser
extends GeneralParser
implements SchemaParser {
    private static final int WORD_NO_CONTEXT = 0;
    private static final int WORD_CHECK = 1;
    private static final int WORD_COMMENT = 2;
    private static final int WORD_ELEMENT1 = 3;
    private static final int WORD_ELEMENT = 4;
    private static final int WORD_ATTLIST1 = 5;
    private static final int WORD_ATTLIST = 6;
    private static final int WORD_PI = 7;
    static String errHeader = "DTD parsing failed: ";
    private char[] buffer = new char[BUFFER_SIZE];
    private int bufSize;
    private int bufScan;
    protected static int BUFFER_SIZE = 4096;
    private DocDefHandler handler;
    private GenBeans.Config config = null;

    public DocDefParser() {
    }

    public DocDefParser(GenBeans.Config config, DocDefHandler docDefHandler) {
        this.config = config;
        this.filename = config.filename;
        this.schemaIn = config.fileIn;
        this.handler = docDefHandler;
    }

    public void setFilename(String string) {
        this.filename = new String(string);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setHandler(DocDefHandler docDefHandler) {
        this.handler = docDefHandler;
    }

    public DocDefHandler getHandler() {
        return this.handler;
    }

    protected boolean checkBuffer() throws IOException {
        if (this.bufScan >= this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            if (this.bufSize == -1) {
                return false;
            }
            this.bufScan = 0;
        }
        return true;
    }

    protected char getNext() throws IOException {
        if (this.checkBuffer()) {
            return this.buffer[this.bufScan++];
        }
        return '\u0000';
    }

    protected char peekNext() throws IOException {
        if (this.checkBuffer()) {
            return this.buffer[this.bufScan];
        }
        return '\u0000';
    }

    private int getInstanceValue(char c) {
        switch (c) {
            case '*': {
                return 48;
            }
            case '+': {
                return 64;
            }
            case '?': {
                return 16;
            }
        }
        return 32;
    }

    private int processWord(StringBuffer stringBuffer, int n) {
        String string = stringBuffer.toString();
        int n2 = string.length();
        if (n2 > 0) {
            switch (n) {
                case 1: {
                    if (string.startsWith("--")) {
                        string = n2 > 2 ? stringBuffer.substring(2) : "";
                        this.handler.startElement(string, 1);
                        n = 2;
                        break;
                    }
                    if (string.equals("ELEMENT")) {
                        n = 3;
                        break;
                    }
                    if (string.equals("ATTLIST")) {
                        n = 5;
                        break;
                    }
                    System.err.println("Error: found an unknown '<!' sequence (" + string + ")");
                    throw new IllegalStateException("Error: found an unknown '<!' sequence (" + string + ")");
                }
                case 2: {
                    this.handler.element(string, 0);
                    break;
                }
                case 3: {
                    this.handler.startElement(string, 2);
                    n = 4;
                    break;
                }
                case 5: {
                    this.handler.startElement(string, 3);
                    n = 6;
                    break;
                }
                case 4: 
                case 6: {
                    int n3 = this.getInstanceValue(string.charAt(n2 - 1));
                    if (n3 != 32) {
                        string = stringBuffer.substring(0, n2 - 1);
                    }
                    try {
                        this.handler.element(string, n3);
                    }
                    catch (MissingEndOfEltException missingEndOfEltException) {
                        if (n != 6) break;
                        this.handler.startElement(missingEndOfEltException.propName, 3);
                        this.handler.element(string, n3);
                    }
                    break;
                }
            }
            stringBuffer.delete(0, n2);
        }
        return n;
    }

    void parse() throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        while ((c = this.getNext()) != '\u0000') {
            block0 : switch (c) {
                case '<': {
                    char c2 = this.getNext();
                    if (c2 == '!') {
                        if (n != 0 && n != 2) {
                            System.err.println("Error: found a '<!' sequence within another '<!' sequence");
                            throw new IllegalStateException("Warning: found a '<!' sequence within another '<!' sequence");
                        }
                        n = 1;
                        break;
                    }
                    if (c2 == '?') {
                        n = 7;
                        break;
                    }
                    stringBuffer.append(c);
                    stringBuffer.append(c2);
                    break;
                }
                case '>': {
                    switch (n) {
                        case 0: {
                            System.err.println("Error: Found '>' without '<!'");
                            throw new IllegalStateException("Error: Found '>' without '<!'");
                        }
                        case 7: {
                            String string = stringBuffer.toString();
                            int n2 = string.length();
                            if (string.endsWith("?")) {
                                stringBuffer.delete(0, n2);
                                n = 0;
                                break block0;
                            }
                            stringBuffer.append(c);
                            break block0;
                        }
                        case 2: {
                            String string = stringBuffer.toString();
                            int n2 = string.length();
                            if (string.endsWith("--")) {
                                this.handler.endElement();
                                stringBuffer.delete(0, n2);
                                n = 0;
                                break block0;
                            }
                            stringBuffer.append(c);
                            break block0;
                        }
                    }
                    n = this.processWord(stringBuffer, n);
                    this.handler.endElement();
                    n = 0;
                    break;
                }
                case '(': {
                    if (n == 4 || n == 6) {
                        n = this.processWord(stringBuffer, n);
                        this.handler.startGroupElements();
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case ')': {
                    n = this.processWord(stringBuffer, n);
                    if (n == 4 || n == 6) {
                        int n3 = this.getInstanceValue(this.peekNext());
                        if (n3 != 32) {
                            this.getNext();
                        }
                        this.handler.endGroupElements(n3);
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '|': {
                    n = this.processWord(stringBuffer, n);
                    if (n == 4 || n == 6) {
                        this.handler.character(c);
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    n = this.processWord(stringBuffer, n);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (n != 0) {
            System.out.println("Warning: unexpected EOF");
        }
    }

    public void process() throws IOException, Schema2BeansException {
        if (this.filename == null && this.schemaIn == null) {
            throw new IllegalArgumentException(Common.getMessage("FilenameNotSpecified_msg", errHeader));
        }
        if (this.handler == null) {
            throw new IllegalArgumentException(Common.getMessage("HandlerNotSpecified_msg", errHeader));
        }
        if (this.config.getTraceParse()) {
            this.config.messageOut.println("Parsing file " + this.filename + " with handler " + this.handler.getClass());
        }
        try {
            this.startupReader();
            this.handler.startDocument(this.config.docroot);
            this.parse();
            this.shutdownReader();
            this.handler.endDocument();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.config.messageOut.println("Error: file " + this.filename + " not found");
            throw fileNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            TraceLogger.error(runtimeException);
            throw runtimeException;
        }
    }

    static class MissingEndOfEltException
    extends RuntimeException {
        String propName;

        public MissingEndOfEltException(String string) {
            this.propName = string;
        }
    }
}

