/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DocDefHandler;
import org.netbeans.modules.schema2beans.DocDefParser;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphLink;
import org.netbeans.modules.schema2beans.GraphNode;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.TreeParser;

public class TreeBuilder
implements DocDefHandler,
TreeParser {
    GraphNode rootNode;
    String docRoot;
    GenBeans.Config config;
    GraphLink curLink;
    int curElementType;
    AttrProp curAttr = null;
    HashMap nameHash = new HashMap();
    private static final int CREATE = 1;
    private static final int GET = 2;
    private static final int REFERENCE = 3;
    private static final String INDENT = "  ";

    TreeBuilder(GenBeans.Config config) {
        this.config = config;
    }

    public void startDocument(String string) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 1, string);
            this.config.messageOut.println("Building the schema object graph.");
        }
        this.docRoot = string;
    }

    public void endDocument() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 2);
            this.config.messageOut.println("schema Object graph built.");
        }
        try {
            this.findRootNode();
        }
        catch (Schema2BeansException schema2BeansException) {
            throw new Schema2BeansRuntimeException(schema2BeansException);
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println(this.dump());
        }
    }

    private GraphNode getGraphNode(String string, String string2, int n) throws Schema2BeansException {
        GraphNode graphNode = (GraphNode)this.nameHash.get(string);
        if (graphNode != null) {
            if (graphNode.created && n == 1) {
                throw new Schema2BeansException(Common.getMessage("DuplicateElement_msg", string));
            }
        } else {
            graphNode = new GraphNode(string2, string);
            graphNode.link = new GraphLink();
            this.nameHash.put(string, graphNode);
        }
        if (n == 1) {
            graphNode.created = true;
        } else if (n == 3) {
            ++graphNode.refCount;
        }
        return graphNode;
    }

    public void startElement(String string, String string2, int n) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 3, string + " - " + string2 + " - " + TreeBuilder.typeToString(n));
        }
        this.curElementType = n;
        try {
            if (n == 2) {
                GraphNode graphNode = this.getGraphNode(string, string2, 1);
                this.curLink = graphNode.link;
            } else if (n == 3) {
                GraphNode graphNode = this.getGraphNode(string, string2, 2);
                this.curAttr = new AttrProp(string2);
                graphNode.addAttribute(this.curAttr);
            }
        }
        catch (Schema2BeansException schema2BeansException) {
            throw new Schema2BeansRuntimeException(schema2BeansException);
        }
    }

    public void startElement(String string, int n) {
        this.startElement(string, string, n);
    }

    public void endElement() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 4);
        }
        if (this.curElementType == 3) {
            this.curAttr.validate();
        }
        this.curElementType = 0;
    }

    public void character(char c) {
        if (this.curElementType == 2) {
            if (c == '|') {
                this.curLink.parent.setSequence(2);
            }
        } else if (this.curElementType == 3 && c == '|') {
            this.curAttr.checkEnum();
        }
    }

    public void element(String string, String string2, int n) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 5, string + TreeBuilder.instanceToString(n, false));
        }
        if (this.curElementType == 2) {
            GraphNode graphNode;
            try {
                graphNode = this.getGraphNode(string, string2, 3);
            }
            catch (Schema2BeansException schema2BeansException) {
                throw new Schema2BeansRuntimeException(schema2BeansException);
            }
            if (this.curLink.element != null || this.curLink.child != null) {
                GraphLink graphLink;
                this.curLink.sibling = graphLink = new GraphLink();
                graphLink.parent = this.curLink.parent;
                this.curLink = graphLink;
            }
            this.curLink.element = graphNode;
            this.curLink.setElementInstance(n);
        } else if (this.curElementType == 3) {
            if (this.curAttr.isComplete()) {
                throw new DocDefParser.MissingEndOfEltException(this.curAttr.getPropertyName());
            }
            this.curAttr.addValue(string2);
        }
    }

    public void element(String string, int n) {
        this.element(string, string, n);
    }

    public void javaType(String string, String string2, String string3) {
        if (this.curElementType == 2) {
            GraphNode graphNode;
            try {
                graphNode = this.getGraphNode(string, string2, 3);
            }
            catch (Schema2BeansException schema2BeansException) {
                throw new Schema2BeansRuntimeException(schema2BeansException);
            }
            graphNode.setJavaType(string3);
        } else {
            this.curAttr.setJavaType(string3);
        }
    }

    public void startGroupElements() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 5, 6);
        }
        if (this.curElementType == 2) {
            GraphLink graphLink = new GraphLink();
            graphLink.parent = this.curLink;
            this.curLink.child = graphLink;
            this.curLink = graphLink;
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(true);
        }
    }

    public void endGroupElements(int n) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 5, 7, TreeBuilder.instanceToString(n, false));
        }
        if (this.curElementType == 2) {
            this.curLink = this.curLink.parent;
            this.curLink.setGroupInstance(n);
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(false);
        }
    }

    private void findRootNode() throws Schema2BeansException {
        GraphNode graphNode;
        Iterator iterator = this.nameHash.values().iterator();
        int n = 0;
        ArrayList<GraphNode> arrayList = new ArrayList<GraphNode>();
        while (iterator.hasNext()) {
            graphNode = (GraphNode)iterator.next();
            if (graphNode.refCount != 0) continue;
            ++n;
            arrayList.add(graphNode);
        }
        if (n == 1) {
            this.rootNode = (GraphNode)arrayList.get(0);
            if (this.docRoot != null && !this.docRoot.equals(this.rootNode.name)) {
                String string = "Mismatch between doc root name specified (" + this.docRoot + ") and the root name found in the DTD graph (" + this.rootNode.name + ")";
                throw new IllegalStateException(string);
            }
        } else if (n == 0) {
            this.rootNode = null;
            if (this.docRoot != null) {
                iterator = this.nameHash.values().iterator();
                while (iterator.hasNext()) {
                    graphNode = (GraphNode)iterator.next();
                    if (!this.docRoot.equals(graphNode.name)) continue;
                    this.rootNode = graphNode;
                    break;
                }
            }
            if (this.rootNode == null) {
                throw new IllegalStateException(Common.getMessage("NoRootElementCandidate"));
            }
        } else {
            Object object;
            this.config.messageOut.println("The following elements could be the root of the document:");
            int n2 = 0;
            while (n2 < arrayList.size()) {
                object = (GraphNode)arrayList.get(n2);
                this.config.messageOut.print(n2 + 1 + ". " + object);
                if (this.docRoot != null && this.docRoot.equals(((GraphNode)object).name)) {
                    this.rootNode = object;
                    this.config.messageOut.println(" <= parameter value");
                } else {
                    this.config.messageOut.println("");
                }
                ++n2;
            }
            if (this.rootNode == null) {
                object = "Could not find the root of the document. Use the -d option to specify the doc root";
                if (this.config.auto) {
                    throw new IllegalStateException((String)object);
                }
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    this.config.messageOut.print("Enter the element that should be used as the root: ");
                    String string = bufferedReader.readLine();
                    int n3 = Integer.parseInt(string) - 1;
                    if (n3 < 0 || n3 >= arrayList.size()) {
                        throw new IllegalStateException((String)object);
                    }
                    this.rootNode = (GraphNode)arrayList.get(n3);
                }
                catch (Exception exception) {
                    TraceLogger.error(exception);
                    throw new Schema2BeansNestedException((String)object, exception);
                }
            }
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println("Using " + this.rootNode.name + " as the root of the document.");
        }
    }

    static String instanceToString(int n, boolean bl) {
        switch (n) {
            case 16: {
                return "?";
            }
            case 48: {
                if (bl) {
                    return "[0,n]";
                }
                return "*";
            }
            case 64: {
                if (bl) {
                    return "[1,n]";
                }
                return "+";
            }
        }
        return "";
    }

    static String typeToString(int n) {
        switch (n) {
            case 1: {
                return "comment";
            }
            case 2: {
                return "element";
            }
            case 3: {
                return "attlist";
            }
        }
        return "unknown value: " + n;
    }

    public GraphNode[] getNodes() {
        GraphNode[] graphNodeArray = new GraphNode[this.nameHash.size()];
        return this.nameHash.values().toArray(graphNodeArray);
    }

    public GraphNode getNode(String string) {
        return (GraphNode)this.nameHash.get(string);
    }

    public GraphNode getRoot() {
        return this.rootNode;
    }

    public String dumpHash() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.nameHash.values().iterator();
        stringBuffer.append("List of elements:\n");
        while (iterator.hasNext()) {
            GraphNode graphNode = (GraphNode)iterator.next();
            stringBuffer.append(INDENT + graphNode.name + " ");
            stringBuffer.append(graphNode.link.parent == null ? "" : "P ");
            stringBuffer.append(graphNode.link.sibling == null ? "" : "S ");
            stringBuffer.append(graphNode.link.child == null ? "" : "C ");
            stringBuffer.append(" [" + graphNode.refCount + "]\n");
        }
        return stringBuffer.toString();
    }

    static void dumpAttributes(GraphNode graphNode, StringBuffer stringBuffer, String string) {
        AttrProp[] attrPropArray = graphNode.getAttributes();
        int n = 0;
        while (n < attrPropArray.length) {
            stringBuffer.append(string + INDENT + "[attr: " + attrPropArray[n] + "]\n");
            ++n;
        }
    }

    static void dumpTree(GraphLink graphLink, StringBuffer stringBuffer, String string, boolean bl) {
        while (graphLink != null) {
            if (graphLink.element != null) {
                stringBuffer.append(string + graphLink.element.name + TreeBuilder.instanceToString(graphLink.getElementInstance(), false) + "\n");
                TreeBuilder.dumpAttributes(graphLink.element, stringBuffer, string);
                if (bl && !graphLink.element.marked) {
                    graphLink.element.marked = true;
                    TreeBuilder.dumpTree(graphLink.element.link, stringBuffer, string + INDENT + TreeBuilder.instanceToString(graphLink.getGroupInstance(), false) + (graphLink.isSequenceOr() ? "| " : " "), bl);
                    graphLink.element.marked = false;
                }
            }
            if (graphLink.isSequenceOr() || graphLink.getGroupInstance() != 32) {
                stringBuffer.append(string + TreeBuilder.instanceToString(graphLink.getGroupInstance(), false) + (graphLink.isSequenceOr() ? "|\n" : "\n"));
            }
            TreeBuilder.dumpTree(graphLink.child, stringBuffer, string + INDENT, bl);
            graphLink = graphLink.sibling;
        }
    }

    void dumpElt(GraphLink graphLink, StringBuffer stringBuffer, String string) {
        while (graphLink != null) {
            stringBuffer.append(string + "GraphLink= " + graphLink + "\n\t" + string + "E= " + graphLink.element + "\n\t" + string + "C= " + graphLink.child + "\n\t" + string + "P=" + graphLink.parent + "\n\t" + string + "S=" + graphLink.sibling + "\n\t" + string + "pE = " + TreeBuilder.instanceToString(graphLink.getElementInstance(), false) + "\n\t" + string + "pG = " + TreeBuilder.instanceToString(graphLink.getGroupInstance(), false) + "\n\t" + string + "seq = " + (graphLink.isSequenceOr() ? "or\n" : "and\n"));
            this.dumpElt(graphLink.child, stringBuffer, string + "\t");
            graphLink = graphLink.sibling;
        }
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tree:\n");
        stringBuffer.append(this.rootNode.name);
        stringBuffer.append("\n");
        TreeBuilder.dumpAttributes(this.rootNode, stringBuffer, INDENT);
        TreeBuilder.dumpTree(this.rootNode.link, stringBuffer, INDENT, true);
        return stringBuffer.toString();
    }

    public String dumpElement(GraphNode graphNode) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Element:\n");
        stringBuffer.append(graphNode.name);
        stringBuffer.append("\n");
        this.dumpElt(graphNode.link, stringBuffer, "\t");
        return stringBuffer.toString();
    }
}

