/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands.diff;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.diff.DiffCommand;
import org.netbeans.lib.cvsclient.command.diff.DiffInformation;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.cvsclient.IndependantClient;
import org.netbeans.modules.cvsclient.commands.diff.BinaryFilesWarning;
import org.netbeans.modules.cvsclient.commands.diff.DiffDisplayer;
import org.netbeans.modules.javacvs.commands.CvsDiff;
import org.netbeans.modules.javacvs.events.CommandDisplayerAdapter;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class DiffCommandDisplayer
extends CommandDisplayerAdapter {
    private static final String BINARY = "-kb";
    private CvsDiff command;
    private DiffCommand diffCommand;
    private boolean isDir = false;
    private File[] files;
    private HashMap standaloneFiles;
    private LinkedList resultList;
    private LinkedList updInfoList;
    private Command currentCommand;
    private boolean includeUpdateCommand = false;
    private boolean binaryFilesWarningShown;
    private boolean noDiffFilesWarningShown;
    private HashMap binaryFiles;
    private Set noDiffFiles;

    public DiffCommandDisplayer(CvsDiff cvsDiff) {
        this.command = cvsDiff;
    }

    public DiffCommandDisplayer(CvsDiff cvsDiff, boolean bl) {
        this.command = cvsDiff;
        this.setIncludeUpdateCommand(bl);
    }

    public void showAfterEachExecute() {
        if (this.currentCommand instanceof UpdateCommand) {
            return;
        }
        if (this.currentCommand instanceof StatusCommand) {
            return;
        }
        if (!this.isDir && this.files.length != this.standaloneFiles.size()) {
            int n = 0;
            while (n < this.files.length) {
                if (this.standaloneFiles.get(this.files[n]) == null) {
                    this.noDiffFiles.add(this.files[n]);
                }
                ++n;
            }
        }
    }

    public void showBeforeEachExecute(Command command) {
        this.currentCommand = command;
        if (command instanceof UpdateCommand) {
            return;
        }
        if (command instanceof StatusCommand) {
            return;
        }
        this.resultList = new LinkedList();
        this.diffCommand = (DiffCommand)command;
        this.files = this.command.getFiles();
        if (this.files[0].isDirectory()) {
            this.isDir = true;
        } else {
            this.isDir = false;
            this.standaloneFiles = new HashMap();
        }
    }

    public void showExecutionFailed(Exception exception) {
    }

    public void showFileInfoGenerated(FileInfoContainer fileInfoContainer) {
        if (fileInfoContainer == null) {
            return;
        }
        if (fileInfoContainer instanceof PipedFileInformation) {
            this.updInfoList.add(fileInfoContainer);
            return;
        }
        if (fileInfoContainer instanceof StatusInformation) {
            StatusInformation statusInformation = (StatusInformation)fileInfoContainer;
            String string = statusInformation.getStickyOptions();
            if (string != null && BINARY.equals(string)) {
                this.binaryFiles.put(statusInformation.getFile(), statusInformation.getFile());
            }
            return;
        }
        if (this.isDir) {
            this.resultList.add(fileInfoContainer);
        } else {
            DiffInformation diffInformation;
            File file = fileInfoContainer.getFile();
            if (this.binaryFiles.get(file) == null && (diffInformation = (DiffInformation)fileInfoContainer).getFirstChange() != null) {
                DiffDisplayer diffDisplayer = new DiffDisplayer(this.diffCommand);
                diffDisplayer.setFileSystemCommand(this.command);
                PipedFileInformation pipedFileInformation = this.getUpdInfo(diffInformation);
                diffDisplayer.setData(diffInformation, this.diffCommand, pipedFileInformation);
                diffDisplayer.displayOutputData();
                this.standaloneFiles.put(diffInformation.getFile(), diffInformation.getFile());
            }
        }
    }

    public void showFinishedCommand() {
        Iterator iterator = this.binaryFiles.keySet().iterator();
        while (iterator.hasNext()) {
            this.noDiffFiles.remove(iterator.next());
        }
        int n = this.binaryFiles.size();
        int n2 = this.noDiffFiles.size();
        if (n == 0 && n2 == 0) {
            return;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 1 && n2 == 0) {
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer;

                public void run() {
                    TopManager topManager = TopManager.getDefault();
                    String string = null;
                    File file = (File)DiffCommandDisplayer.this.binaryFiles.keySet().iterator().next();
                    string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer = 1.class$("org.netbeans.modules.cvsclient.commands.diff.DiffCommandDisplayer")) : class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer)).getString("MSG_BinaryFile"), file.getAbsolutePath());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                    topManager.notify((NotifyDescriptor)message);
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            return;
        }
        if (n == 0 && n2 == 1) {
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer;

                public void run() {
                    TopManager topManager = TopManager.getDefault();
                    String string = null;
                    File file = (File)DiffCommandDisplayer.this.noDiffFiles.iterator().next();
                    string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer = 2.class$("org.netbeans.modules.cvsclient.commands.diff.DiffCommandDisplayer")) : class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer)).getString("MSG_NoDiffFile"), file.getAbsolutePath());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                    topManager.notify((NotifyDescriptor)message);
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopManager topManager = TopManager.getDefault();
                BinaryFilesWarning binaryFilesWarning = null;
                binaryFilesWarning = new BinaryFilesWarning(DiffCommandDisplayer.this.binaryFiles.keySet(), DiffCommandDisplayer.this.noDiffFiles);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)binaryFilesWarning, 1);
                topManager.notify((NotifyDescriptor)message);
            }
        });
    }

    public void showStartCommand() {
        this.updInfoList = new LinkedList();
        this.resultList = new LinkedList();
        if (this.binaryFiles == null) {
            this.binaryFiles = new HashMap();
        } else {
            this.binaryFiles.clear();
        }
        this.binaryFilesWarningShown = false;
        this.noDiffFilesWarningShown = false;
        this.noDiffFiles = new HashSet();
        IndependantClient independantClient = (IndependantClient)this.command.getClientProvider();
        if (independantClient.getDisplayType() != 0 || this.isIncludeUpdateCommand()) {
            this.command.addCheckoutCommands();
        }
    }

    private PipedFileInformation getUpdInfo(DiffInformation diffInformation) {
        Iterator iterator = this.updInfoList.iterator();
        PipedFileInformation pipedFileInformation = null;
        while (iterator.hasNext()) {
            PipedFileInformation pipedFileInformation2 = (PipedFileInformation)iterator.next();
            if (!pipedFileInformation2.getFile().equals(diffInformation.getFile())) continue;
            pipedFileInformation = pipedFileInformation2;
            break;
        }
        return pipedFileInformation;
    }

    public void setIncludeUpdateCommand(boolean bl) {
        this.includeUpdateCommand = bl;
    }

    public boolean isIncludeUpdateCommand() {
        return this.includeUpdateCommand;
    }
}

