/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Vector;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.modules.javacvs.JavaCvsFileSystem;
import org.netbeans.modules.javacvs.caching.CommandLocker;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.caching.CvsCacheFile;
import org.netbeans.modules.javacvs.caching.JavaCvsCache;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.FileSystemCommandImpl;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.javacvs.events.CommandDisplayerListener;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakListener;

public class CvsFsCache
implements CachedFileSystem {
    private static CommandLocker refreshLocker = new CommandLocker();
    private static String OLD_CACHEFILE = "CVS/netbeans.cache";
    private static String NEW_CACHEFILE = "CVS/javacvs.cache";
    protected AbstractFileSystem cvsfs;
    private PropertyChangeListener list;
    protected boolean offLine;
    protected boolean hideShadowFiles;
    protected int autoRefresh;
    protected File fsRootFile;

    public CvsFsCache(AbstractFileSystem abstractFileSystem, File file) {
        this.cvsfs = abstractFileSystem;
        this.list = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CvsFsCache.this.propertiesChanged(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
        abstractFileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.list, (Object)abstractFileSystem));
    }

    public void setOffLine(boolean bl) {
        this.offLine = bl;
    }

    public void setAutoRefresh(int n) {
        this.autoRefresh = n;
    }

    public void setHideShadowFiles(boolean bl) {
        this.hideShadowFiles = bl;
    }

    public void setFsRootFile(File file) {
        this.fsRootFile = file;
    }

    public static JavaCvsCache getCacheObject() {
        FileSystemCache fileSystemCache = CacheHandler.getInstance().getCache("javacvs");
        JavaCvsCache javaCvsCache = fileSystemCache == null ? new JavaCvsCache() : (JavaCvsCache)fileSystemCache;
        return javaCvsCache;
    }

    protected JavaCvsStatusManager getStatusManager() {
        return JavaCvsStatusManager.getInstance();
    }

    private void propertiesChanged(String string, Object object, Object object2) {
        Comparable<Boolean> comparable;
        if (string == null) {
            return;
        }
        if (string.equals("offLine")) {
            comparable = (Boolean)object2;
            this.offLine = (Boolean)comparable;
        }
        if (string.equals("autoRefresh")) {
            comparable = (Integer)object2;
            this.autoRefresh = (Integer)comparable;
        }
        if (string.equals("hideShadowFiles")) {
            comparable = (Boolean)object2;
            this.hideShadowFiles = (Boolean)comparable;
        }
        if (string.equals("root")) {
            File file;
            comparable = (FileObject)object2;
            this.fsRootFile = file = FileSystemCommand.toFile(comparable);
        }
    }

    protected int adjustStrategy(int n) {
        if (n > 3 && this.offLine) {
            return 3;
        }
        return n;
    }

    protected boolean permitAction(int n) {
        return n <= 3 || !this.offLine;
    }

    protected void checkDirectoryAutorefresh(File file, boolean bl) {
        File file2 = new File(file.getPath(), "CVS");
        File file3 = new File(file.getPath(), OLD_CACHEFILE);
        File file4 = new File(file.getPath(), NEW_CACHEFILE);
        if (file2.exists() && !file3.exists() && !file4.exists()) {
            try {
                file4.createNewFile();
                this.doRefresh(new File[]{file}, false, bl);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getFileStatusOnly(Vector vector) {
        Object object;
        String string;
        int n = 3;
        int n2 = vector.size();
        CacheFile cacheFile = null;
        if (n2 < 1) {
            return "Unknown";
        }
        if (this.autoRefresh == 1) {
            string = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getPath(), string);
            if (((File)object).getParent() != null) {
                object = ((File)object).getParentFile();
                this.checkDirectoryAutorefresh((File)object, false);
            }
        }
        if (n2 == 1) {
            string = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getPath(), string);
            if (object != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile((File)object, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            String string2 = cacheFile != null ? cacheFile.getStatus() : "";
            return string2;
        }
        object = "NotInSynch";
        string = (String)vector.elementAt(0);
        File file = new File(this.fsRootFile.getPath(), string);
        if (file != null) {
            cacheFile = CacheHandler.getInstance().getCacheFile(file, this.adjustStrategy(n), (CachedFileSystem)this);
        }
        String string3 = cacheFile != null ? cacheFile.getStatus() : "";
        int n3 = 1;
        while (n3 < n2) {
            String string4;
            String string5 = (String)vector.elementAt(n3);
            File file2 = new File(this.fsRootFile.getPath(), string5);
            if (file2 != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile(file2, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            if (!(string4 = cacheFile != null ? cacheFile.getStatus() : "").equals(string3)) {
                return object;
            }
            ++n3;
        }
        return string3;
    }

    public String getFileStatusOnly(String string) {
        int n = 3;
        CacheFile cacheFile = null;
        File file = new File(this.fsRootFile.getPath(), string);
        if (this.autoRefresh == 1 && file.getParent() != null) {
            this.checkDirectoryAutorefresh(file.getParentFile(), true);
        }
        cacheFile = CacheHandler.getInstance().getCacheFile(file, this.adjustStrategy(n), (CachedFileSystem)this);
        String string2 = cacheFile.getStatus();
        return string2;
    }

    public String getStatus(String string, Vector vector) {
        Object object;
        String string2;
        int n = 3;
        String string3 = "";
        int n2 = vector.size();
        CacheFile cacheFile = null;
        if (n2 < 1) {
            return this.getStatusManager().getStatus("Unknown");
        }
        if (this.autoRefresh == 1) {
            string2 = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getPath(), string2);
            if (((File)object).getParent() != null) {
                object = ((File)object).getParentFile();
                this.checkDirectoryAutorefresh((File)object, false);
            }
        }
        if (n2 == 1) {
            string2 = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getPath(), string2);
            if (object != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile((File)object, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            String string4 = cacheFile != null ? this.getStatusManager().getStatus(cacheFile.getStatus()) : "";
            return string4;
        }
        object = this.getStatusManager().getStatus("NotInSynch");
        string2 = (String)vector.elementAt(0);
        File file = new File(this.fsRootFile.getPath(), string2);
        if (file != null) {
            cacheFile = CacheHandler.getInstance().getCacheFile(file, this.adjustStrategy(n), (CachedFileSystem)this);
        }
        String string5 = cacheFile != null ? this.getStatusManager().getStatus(cacheFile.getStatus()) : "";
        int n3 = 1;
        while (n3 < n2) {
            String string6;
            String string7 = (String)vector.elementAt(n3);
            File file2 = new File(this.fsRootFile.getPath(), string7);
            if (file2 != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile(file2, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            if (!(string6 = cacheFile != null ? this.getStatusManager().getStatus(cacheFile.getStatus()) : "").equals(string5)) {
                return object;
            }
            ++n3;
        }
        return string5;
    }

    public String[] getDirContent(File file) {
        CvsCacheDir cvsCacheDir = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file, 0, (CachedFileSystem)this);
        if (cvsCacheDir != null) {
            return cvsCacheDir.getDirContentNames(this.hideShadowFiles);
        }
        return null;
    }

    public void addToCache(File file) {
        File file2 = file.getParentFile();
        CvsCacheDir cvsCacheDir = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file2, 0, (CachedFileSystem)this);
        if (cvsCacheDir == null) {
            return;
        }
    }

    public void removeFromCache(File file, boolean bl) {
        File file2 = file.getParentFile();
        CvsCacheDir cvsCacheDir = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file2, 0, (CachedFileSystem)this);
        if (cvsCacheDir == null) {
            CvsCacheDir cvsCacheDir2 = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file, 0, (CachedFileSystem)this);
            CacheHandler.getInstance().getCache((CachedFileSystem)this).unregisterDir((CacheDir)cvsCacheDir2);
            return;
        }
        if (bl) {
            cvsCacheDir.removeChildDir(file.getName(), true);
        } else {
            cvsCacheDir.removeFile(file.getName(), true);
        }
    }

    public void removeFromCache(CacheFile cacheFile) {
        CacheDir cacheDir = cacheFile.getParent();
        if (cacheFile instanceof CacheDir) {
            if (cacheDir == null) {
                CacheDir cacheDir2 = (CacheDir)cacheFile;
                CacheHandler.getInstance().getCache((CachedFileSystem)this).unregisterDir(cacheDir2);
                return;
            }
            cacheDir.removeChildDir(cacheFile.getName(), true);
        } else if (cacheDir != null) {
            cacheDir.removeFile(cacheFile.getName(), true);
        }
    }

    public void renameTo(File file, File file2) {
        File file3 = file.getParentFile();
        CacheDir cacheDir = (CacheDir)CacheHandler.getInstance().getCacheFile(file3, 0, (CachedFileSystem)this);
        if (cacheDir == null) {
            return;
        }
        if (!file2.isDirectory()) {
            cacheDir.removeFile(file.getName(), true);
            CvsCacheFile cvsCacheFile = new CvsCacheFile(this.getCacheId(), file2.getName());
            cacheDir.addFile((CacheFile)cvsCacheFile, true);
            return;
        }
        CacheDir cacheDir2 = cacheDir.getSubDir(file.getName());
        cacheDir.removeChildDir(cacheDir2.getName(), false);
        cacheDir2.rename(new File(cacheDir.getFilePath() + File.separator + file2.getName()));
        cacheDir.addChildDir(cacheDir2, false);
        cacheDir2.renameChildDirs(cacheDir2, false);
        cacheDir.setModifiedContent(true);
        cacheDir.writeToDisk();
    }

    public String getLocker(Vector vector) {
        return "";
    }

    public void saveToDisk() {
        if (!CacheHandler.getInstance().getCache((CachedFileSystem)this).isWrittenToDisk()) {
            CacheHandler.getInstance().getCache((CachedFileSystem)this).writeAllToDisk();
        }
    }

    public void saveToDiskFromNode(String string) {
        File file = new File(this.fsRootFile.getPath(), string);
        CacheDir cacheDir = (CacheDir)CacheHandler.getInstance().getCacheFile(file, -1, (CachedFileSystem)this);
        if (cacheDir != null) {
            cacheDir.writeToDiskRecursively();
        }
    }

    public void fileModified(File file, boolean bl) {
        CacheFile cacheFile = CacheHandler.getInstance().getCacheFile(file, -1, (CachedFileSystem)this);
        if (cacheFile != null) {
            String string = cacheFile.getStatus();
            if (string.equals("Local") || string.equals("Unknown") || string.equals("LRemoved") || string.equals("NMerge")) {
                return;
            }
            if (string.equals("NPatch")) {
                cacheFile.setStatus("NMerge");
            } else {
                cacheFile.setStatus("LMod");
            }
            cacheFile.getParent().writeToDisk();
            if (bl) {
                CvsFsCache.getCacheObject().fireCacheHandlerEvent(2, cacheFile);
            }
        }
    }

    public void addRefreshDisplayers(CvsStatus cvsStatus) {
    }

    public void doRefresh(File[] fileArray, boolean bl) {
        JavaCvsFileSystem javaCvsFileSystem = (JavaCvsFileSystem)this.cvsfs;
        if (javaCvsFileSystem == null) {
            return;
        }
        FileSystemCommandImpl fileSystemCommandImpl = (FileSystemCommandImpl)((Object)javaCvsFileSystem.createRefresh());
        CvsStatus cvsStatus = (CvsStatus)fileSystemCommandImpl.getOuterClassInstance();
        cvsStatus.setRecursive(bl);
        cvsStatus.setRefreshing(false);
        if (fileArray != null && fileArray.length > 0 && fileArray[0].isDirectory()) {
            cvsStatus.setRefreshing(true);
        }
        cvsStatus.setFiles(fileArray);
        this.addRefreshDisplayers(cvsStatus);
        refreshLocker.addToQueueAndRun(cvsStatus);
    }

    public void doRefresh(File[] fileArray, boolean bl, boolean bl2) {
        JavaCvsFileSystem javaCvsFileSystem = (JavaCvsFileSystem)this.cvsfs;
        if (javaCvsFileSystem == null) {
            return;
        }
        FileSystemCommandImpl fileSystemCommandImpl = (FileSystemCommandImpl)((Object)javaCvsFileSystem.createRefresh());
        CvsStatus cvsStatus = (CvsStatus)fileSystemCommandImpl.getOuterClassInstance();
        cvsStatus.setRecursive(bl);
        cvsStatus.setRefreshing(false);
        if (fileArray != null && fileArray.length > 0 && fileArray[0].isDirectory()) {
            cvsStatus.setRefreshing(true);
        }
        cvsStatus.setFiles(fileArray);
        final Object object = new Object();
        if (bl2) {
            cvsStatus.addDisplayerListener(new CommandDisplayerListener(){

                public void showBeforeEachExecute(Command command) {
                }

                public void showAfterEachExecute() {
                }

                public void showExecutionFailed(Exception exception) {
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                }

                public void showFileInfoGenerated(FileInfoContainer fileInfoContainer) {
                }

                public void showFinishedCommand() {
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                }

                public void showStartCommand() {
                }

                public void messageGenerated(MessageEvent messageEvent) {
                }
            });
        }
        this.addRefreshDisplayers(cvsStatus);
        refreshLocker.addToQueueAndRun(cvsStatus);
        if (bl2) {
            Object object2 = object;
            synchronized (object2) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public String getCacheId() {
        return "javacvs";
    }

    public Reference createReference(FileObject fileObject) {
        File file = new File(this.fsRootFile.getPath(), fileObject.getPackageNameExt(File.separatorChar, '.'));
        return CacheHandler.getInstance().createReference((Object)fileObject, file, this.getCacheId());
    }

    public void removeNotify() {
        CvsFsCache.getCacheObject().unregisterFileSystem((FileSystem)this.cvsfs);
        this.list = null;
        this.cvsfs = null;
    }
}

