/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.LinkedList;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.rmi.RMIHelper;
import org.netbeans.modules.rmi.RMIStubCleanCompiler;
import org.netbeans.modules.rmi.RMIStubCompiler;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerType;
import org.openide.cookies.SourceCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RMIStubCompilerType
extends ExternalCompilerType {
    static final long serialVersionUID = 3511317103361547621L;
    public static final String PROP_StubCompiler = "stubCompiler";
    public static final String PROP_KEEP_GENERATED = "keepGenerated";
    public static final String PROP_IIOP = "iiop";
    public static final String PROP_VERSION = "version";
    public static final String PROP_TARGET_FILESYSTEM = "targetFileSystem";
    public static final String PROP_TARGET_POLICY = "targetPolicy";
    public static final String DEFAULT_COMPILER_PROCESS = "{jdk.home}{/}bin{/}rmic";
    public static final String DEFAULT_COMPILER_ARGUMENTS = "-classpath \"{java.home}{/}..{/}lib{/}rt.jar\"{:}{filesystems} {iiop} {version} {keepgenerated} {outputdir} {files}";
    private NbProcessDescriptor stubCompiler;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private static final String INVALID_TARGET_NAME = "InvalidTarget";
    private boolean keepGenerated = false;
    private boolean iiop = false;
    private int version = 3;
    private static final int CURRENT_VERSION = 1;
    private int serializedVersion = 1;
    private transient Reference targetFileSystem;
    private String targetFSName;
    private int targetPolicy;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIStubCompilerType;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    public RMIStubCompilerType() {
        this.setExternalCompiler(new NbProcessDescriptor(DEFAULT_COMPILER_PROCESS, DEFAULT_COMPILER_ARGUMENTS, NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIStubCompilerType.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)).getString("MSG_CompilerHint")));
    }

    public void prepareJob(CompilerJob compilerJob, Class clazz, DataObject dataObject) {
        if (clazz.equals(ExternalCompiler.CLEAN)) {
            compilerJob.add((Compiler)new RMIStubCleanCompiler(dataObject, this.getTargetPolicy() == 1 ? this.getTargetFileSystem() : null));
        } else {
            this.prepareJob(compilerJob, clazz, dataObject, null);
        }
    }

    void prepareJob(CompilerJob compilerJob, Class clazz, DataObject dataObject, JavaCompilerType javaCompilerType) {
        if (clazz.equals(ExternalCompiler.CLEAN)) {
            return;
        }
        RMIStubCompiler[] rMIStubCompilerArray = this.getRMIStubCompilers(clazz, dataObject, javaCompilerType);
        if (rMIStubCompilerArray != null && rMIStubCompilerArray.length > 0) {
            int n = 0;
            while (n < rMIStubCompilerArray.length) {
                compilerJob.add((Compiler)rMIStubCompilerArray[n]);
                ++n;
            }
        }
    }

    RMIStubCompiler[] getRMIStubCompilers(Class clazz, DataObject dataObject, JavaCompilerType javaCompilerType) {
        FileObject fileObject = dataObject.getPrimaryFile();
        String[] stringArray = RMIStubCompilerType.getRemoteClasses(dataObject, false);
        if (stringArray == null) {
            return null;
        }
        RMIStubCompiler[] rMIStubCompilerArray = new RMIStubCompiler[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            rMIStubCompilerArray[n] = this.createCompiler(fileObject, stringArray[n], clazz, javaCompilerType);
            ++n;
        }
        return rMIStubCompilerArray;
    }

    private RMIStubCompiler createCompiler(FileObject fileObject, String string, Class clazz, JavaCompilerType javaCompilerType) {
        return new RMIStubCompiler(fileObject, string, clazz, this.getExternalCompiler(), this.getErrorExpression(), this, javaCompilerType);
    }

    protected static String[] getRemoteClasses(DataObject dataObject, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        SourceCookie sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = RMIStubCompilerType.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        SourceElement sourceElement = sourceCookie.getSource();
        Identifier identifier = sourceElement.getPackage();
        String string = null;
        int n = 0;
        if (identifier != null) {
            string = identifier.getFullName();
            n = string.length();
        }
        ClassElement[] classElementArray = sourceElement.getAllClasses();
        int n2 = 0;
        while (n2 < classElementArray.length) {
            if (classElementArray[n2].isClass() && RMIHelper.implementsClass(classElementArray[n2], "java.rmi.Remote")) {
                String string2 = classElementArray[n2].getName().getFullName();
                if (identifier != null) {
                    string2 = string2.substring(n + 1);
                    string2 = string2.replace('.', '$');
                    if (bl) {
                        string2 = string + '.' + string2;
                    }
                } else {
                    string2 = string2.replace('.', '$');
                }
                linkedList.add(string2);
            }
            ++n2;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public NbProcessDescriptor getExternalCompiler() {
        NbProcessDescriptor nbProcessDescriptor = super.getExternalCompiler();
        if (nbProcessDescriptor == null) {
            return new NbProcessDescriptor(DEFAULT_COMPILER_PROCESS, DEFAULT_COMPILER_ARGUMENTS, NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIStubCompilerType.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)).getString("MSG_CompilerHint"));
        }
        return nbProcessDescriptor;
    }

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        ExternalCompiler.ErrorExpression errorExpression = super.getErrorExpression();
        if (errorExpression != null) {
            return errorExpression;
        }
        return ExternalCompiler.JAVAC;
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIStubCompilerType.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)).getString("CTL_RMIStubCompilerType");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIStubCompilerType.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType);
    }

    public boolean isKeepGenerated() {
        return this.keepGenerated;
    }

    public void setKeepGenerated(boolean bl) {
        boolean bl2 = this.keepGenerated;
        this.keepGenerated = bl;
        this.firePropertyChange(PROP_KEEP_GENERATED, new Boolean(bl2), new Boolean(bl));
    }

    public boolean isIiop() {
        return this.iiop;
    }

    public void setIiop(boolean bl) {
        boolean bl2 = this.iiop;
        this.iiop = bl;
        this.firePropertyChange(PROP_IIOP, new Boolean(bl2), new Boolean(bl));
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
        this.firePropertyChange(PROP_VERSION, null, null);
    }

    public void setTargetFileSystem(FileSystem fileSystem) {
        FileSystem fileSystem2 = this.getTargetFileSystem();
        if (fileSystem == fileSystem2 || fileSystem != null && fileSystem2 != null && fileSystem.equals(fileSystem2)) {
            return;
        }
        this.targetFileSystem = fileSystem == null ? null : new WeakReference<FileSystem>(fileSystem);
        this.firePropertyChange(PROP_TARGET_FILESYSTEM, fileSystem2, fileSystem);
    }

    public void assureValidTargetFS() throws IOException {
        Object object;
        FileSystem fileSystem = this.getTargetFileSystem();
        if (fileSystem == null) {
            return;
        }
        String string = null;
        if (fileSystem == JavaCompilerType.TARGET_INVALID) {
            string = "MSG_FS_Invalid";
        } else {
            object = TopManager.getDefault().getRepository().fileSystems();
            boolean bl = false;
            while (object.hasMoreElements()) {
                FileSystem fileSystem2 = (FileSystem)object.nextElement();
                if (fileSystem2 != fileSystem) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string = "MSG_FS_NotMounted";
            }
        }
        if (string == null) {
            if (fileSystem.isReadOnly()) {
                string = "MSG_FS_ReadOnly";
            } else {
                return;
            }
        }
        object = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIStubCompilerType.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)).getString(string), fileSystem.getDisplayName());
        throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException((String)object), 256, null, (String)object, null, null);
    }

    public FileSystem getTargetFileSystem() {
        if (this.targetFileSystem == null) {
            return null;
        }
        FileSystem fileSystem = (FileSystem)this.targetFileSystem.get();
        if (fileSystem == null) {
            fileSystem = JavaCompilerType.TARGET_INVALID;
            this.targetFileSystem = new WeakReference<FileSystem>(fileSystem);
        }
        return fileSystem;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        if (this.targetFSName == null) {
            return;
        }
        FileSystem fileSystem = JavaCompilerType.TARGET_INVALID;
        if (!INVALID_TARGET_NAME.equals(this.targetFSName)) {
            object = TopManager.getDefault().getRepository().fileSystems();
            while (object.hasMoreElements()) {
                FileSystem fileSystem2 = (FileSystem)object.nextElement();
                if (!fileSystem2.getSystemName().equals(this.targetFSName)) continue;
                fileSystem = fileSystem2;
                break;
            }
        }
        if (this.serializedVersion < 1) {
            this.serializedVersion = 1;
            object = this.getExternalCompiler().getArguments();
            this.setExternalCompiler(new NbProcessDescriptor(DEFAULT_COMPILER_PROCESS, DEFAULT_COMPILER_ARGUMENTS, NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIStubCompilerType.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)).getString("MSG_CompilerHint")));
            if (((String)object).indexOf("-iiop") != -1) {
                this.setIiop(true);
            }
        }
        this.targetFileSystem = new WeakReference<FileSystem>(fileSystem);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        FileSystem fileSystem = this.getTargetFileSystem();
        this.targetFSName = fileSystem == null ? null : (fileSystem == JavaCompilerType.TARGET_INVALID ? INVALID_TARGET_NAME : fileSystem.getSystemName());
        objectOutputStream.defaultWriteObject();
    }

    public int getTargetPolicy() {
        return this.targetPolicy;
    }

    public void setTargetPolicy(int n) {
        this.targetPolicy = n;
        this.firePropertyChange(PROP_TARGET_POLICY, null, null);
    }

    public static RMIStubCompilerType createIIOPType() {
        RMIStubCompilerType rMIStubCompilerType = new RMIStubCompilerType();
        rMIStubCompilerType.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIStubCompilerType.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)).getString("CTL_RMIStubCompilerType_IIOP"));
        rMIStubCompilerType.setVersion(0);
        rMIStubCompilerType.setIiop(true);
        return rMIStubCompilerType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

