/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.settings;

import java.io.IOException;
import java.io.ObjectInput;
import org.netbeans.modules.rmi.RMIStubCompilerType;
import org.netbeans.modules.rmi.RemoteDetectionSupport;
import org.netbeans.modules.rmi.settings.RMIActivationSettings;
import org.netbeans.modules.rmi.settings.RMIRegistrySettings;
import org.openide.ServiceType;
import org.openide.compiler.CompilerType;
import org.openide.options.ContextSystemOption;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class RMISettings
extends ContextSystemOption {
    static final long serialVersionUID = -8522143676848697297L;
    public static final String PROP_DETECT_REMOTE = "detectRemote";
    public static final String PROP_CONFIRM_CONVERT = "confirmConvert";
    public static final String PROP_STUB_COMPILER = "stubCompiler";
    static /* synthetic */ Class class$org$netbeans$modules$rmi$settings$RMISettings;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$settings$RMIRegistrySettings;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$settings$RMIActivationSettings;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIStubCompilerType;

    public RMISettings() {
        this.updateRemoteDetectionSupport();
        this.addOption(RMIActivationSettings.getDefault());
        this.addOption(RMISettings.getRMIRegistrySettings());
    }

    public String displayName() {
        return RMISettings.getString("CTL_RMI_SETTINGS");
    }

    static String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$settings$RMISettings == null ? (class$org$netbeans$modules$rmi$settings$RMISettings = RMISettings.class$("org.netbeans.modules.rmi.settings.RMISettings")) : class$org$netbeans$modules$rmi$settings$RMISettings)).getString(string);
    }

    public static RMIRegistrySettings getRMIRegistrySettings() {
        return (RMIRegistrySettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$rmi$settings$RMIRegistrySettings == null ? (class$org$netbeans$modules$rmi$settings$RMIRegistrySettings = RMISettings.class$("org.netbeans.modules.rmi.settings.RMIRegistrySettings")) : class$org$netbeans$modules$rmi$settings$RMIRegistrySettings), (boolean)true);
    }

    public static RMIActivationSettings getRMIActivationSettings() {
        return (RMIActivationSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$rmi$settings$RMIActivationSettings == null ? (class$org$netbeans$modules$rmi$settings$RMIActivationSettings = RMISettings.class$("org.netbeans.modules.rmi.settings.RMIActivationSettings")) : class$org$netbeans$modules$rmi$settings$RMIActivationSettings), (boolean)true);
    }

    public boolean isDetectRemote() {
        Boolean bl = (Boolean)this.getProperty(PROP_DETECT_REMOTE);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setDetectRemote(boolean bl) {
        this.putProperty(PROP_DETECT_REMOTE, new Boolean(bl), true);
    }

    public boolean isConfirmConvert() {
        Boolean bl = (Boolean)this.getProperty(PROP_CONFIRM_CONVERT);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setConfirmConvert(boolean bl) {
        this.putProperty(PROP_CONFIRM_CONVERT, new Boolean(bl), true);
    }

    public CompilerType getStubCompiler() {
        ServiceType.Handle handle = (ServiceType.Handle)this.getProperty(PROP_STUB_COMPILER);
        Object object = null;
        if (handle != null) {
            object = (CompilerType)handle.getServiceType();
        }
        if (object == null && (object = (CompilerType)Lookup.getDefault().lookup(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMISettings.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)) == null) {
            object = new RMIStubCompilerType();
            this.putProperty(PROP_STUB_COMPILER, new ServiceType.Handle((ServiceType)object), true);
        }
        return object;
    }

    public void setStubCompiler(CompilerType compilerType) {
        this.putProperty(PROP_STUB_COMPILER, new ServiceType.Handle((ServiceType)compilerType), true);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.updateRemoteDetectionSupport();
        this.addOption(RMISettings.getRMIActivationSettings());
        this.addOption(RMISettings.getRMIRegistrySettings());
    }

    private void updateRemoteDetectionSupport() {
        RemoteDetectionSupport remoteDetectionSupport = RemoteDetectionSupport.getInstance();
        remoteDetectionSupport.registerSettingsListener(this);
        remoteDetectionSupport.updateParsingListener(this);
    }

    public static RMISettings getInstance() {
        return (RMISettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$rmi$settings$RMISettings == null ? (class$org$netbeans$modules$rmi$settings$RMISettings = RMISettings.class$("org.netbeans.modules.rmi.settings.RMISettings")) : class$org$netbeans$modules$rmi$settings$RMISettings), (boolean)true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

