/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.wizard;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.rmi.wizard.RMIWizard2;
import org.netbeans.modules.rmi.wizard.RMIWizard3;
import org.netbeans.modules.rmi.wizard.RMIWizard4;
import org.netbeans.modules.rmi.wizard.RMIWizardSupport;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;

public class RMIWizardIterator
implements TemplateWizard.Iterator {
    static final int RMIWIZARD2 = 1;
    static final int RMIWIZARD3 = 2;
    static final int RMIWIZARD4 = 3;
    private static final String EA_DESCRIPTION = "templateWizardURL";
    private static final String EA_ITERATOR = "templateWizardIterator";
    static final String PROP_NEW_INTERFACE = "newInterface";
    static final String PROP_INTERFACE_TEMPLATE = "interfaceTemplate";
    static final String PROP_INTERFACE_NAME = "interfaceName";
    static final String PROP_IMPLEMENTATION_NAME = "implementationName";
    static final String PROP_METHOD_ELEMENTS = "methodElements";
    private transient WizardDescriptor.Panel[] panels;
    private transient String[] panelNames;
    private transient int current = 0;
    private transient TemplateWizard wizard;
    private static RMIWizardIterator instance;
    private static final long serialVersionUID = 4254416763446398308L;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$wizard$RMIWizardIterator;

    public void initialize(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
        this.panels = new WizardDescriptor.Panel[]{templateWizard.targetChooser(), new RMIWizard2(), new RMIWizard3(), new RMIWizard4()};
        this.panelNames = new String[this.panels.length];
        this.panelNames[0] = templateWizard.targetChooser().getComponent().getName();
        this.panelNames[1] = this.getString("RMIWizard2.Form.subtitle");
        this.panelNames[2] = this.getString("RMIWizard3.Form.subtitle");
        this.panelNames[3] = this.getString("RMIWizard4.Form.subtitle");
        if (this.panels.length > 0 && this.panels[0] instanceof JComponent) {
            ((JComponent)this.panels[0]).putClientProperty("WizardPanel_contentData", this.panelNames);
        }
        templateWizard.putProperty(PROP_INTERFACE_NAME, null);
        templateWizard.putProperty(PROP_IMPLEMENTATION_NAME, null);
        templateWizard.putProperty(PROP_NEW_INTERFACE, (Object)new Boolean(true));
        templateWizard.putProperty(PROP_INTERFACE_TEMPLATE, null);
        templateWizard.putProperty(PROP_METHOD_ELEMENTS, null);
        this.current = 0;
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
        this.panelNames = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        try {
            DataObject dataObject;
            String string;
            String string2 = (String)this.wizard.getProperty(PROP_INTERFACE_NAME);
            if (string2 == null) {
                string2 = this.wizard.getTargetName();
                if (string2 == null) {
                    string2 = "NewRemote";
                }
                this.wizard.putProperty(PROP_INTERFACE_NAME, (Object)string2);
            }
            if ((string = (String)this.wizard.getProperty(PROP_IMPLEMENTATION_NAME)) == null) {
                String string3 = NbBundle.getBundle((String)"org/netbeans/modules/rmi/wizard/Local").getString("FMT_DefaultImplementationName");
                string = MessageFormat.format(string3, string2);
                this.wizard.putProperty(PROP_IMPLEMENTATION_NAME, (Object)string);
            }
            int n = (Integer)((JComponent)this.current().getComponent()).getClientProperty("WizardPanel_contentSelectedIndex");
            Boolean bl = (Boolean)this.wizard.getProperty(PROP_NEW_INTERFACE);
            if (bl != null && bl.booleanValue() && (dataObject = this.instantiateInterface(n)) != null) {
                RMIWizardSupport.openDataObject(dataObject);
                hashSet.add(dataObject);
            }
            if ((dataObject = this.instantiateImplementation()) != null) {
                RMIWizardSupport.openDataObject(dataObject);
                hashSet.add(dataObject);
            }
        }
        catch (SourceException sourceException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)sourceException);
        }
        return hashSet;
    }

    public String name() {
        return this.panelNames[this.current];
    }

    public boolean hasNext() {
        return this.current + 1 < this.panels.length;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.current];
    }

    public void nextPanel() {
        RMIWizard2 rMIWizard2;
        this.current = this.current == 1 ? ((rMIWizard2 = (RMIWizard2)this.panels[1]).isNewSelected() ? ++this.current : 3) : ++this.current;
    }

    public void previousPanel() {
        RMIWizard2 rMIWizard2;
        this.current = this.current == 3 ? ((rMIWizard2 = (RMIWizard2)this.panels[1]).isNewSelected() ? --this.current : 1) : --this.current;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public static synchronized RMIWizardIterator singleton() {
        if (instance == null) {
            instance = new RMIWizardIterator();
        }
        return instance;
    }

    public static boolean isFileExist(String string, String string2, DataFolder dataFolder) {
        if (dataFolder != null) {
            FileObject fileObject = dataFolder.getPrimaryFile();
            if (string2 != null) {
                return fileObject.getFileObject(string, string2) != null;
            }
            return fileObject.getFileObject(string) != null;
        }
        return false;
    }

    public static boolean isFileExist(String string, String string2) {
        try {
            if (RMIWizardIterator.singleton().wizard != null) {
                return RMIWizardIterator.isFileExist(string, string2, RMIWizardIterator.singleton().wizard.getTargetFolder());
            }
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
        }
        return false;
    }

    static MethodElement[] getTemplateMethods(TemplateWizard templateWizard) {
        Identifier identifier;
        SourceElement sourceElement;
        ClassElement classElement;
        SourceCookie sourceCookie;
        DataObject dataObject = (DataObject)templateWizard.getProperty(PROP_INTERFACE_TEMPLATE);
        MethodElement[] methodElementArray = null;
        if (dataObject != null && (sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = RMIWizardIterator.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null && (classElement = (sourceElement = sourceCookie.getSource()).getClass(identifier = Identifier.create((String)dataObject.getPrimaryFile().getName()))) != null) {
            methodElementArray = RMIWizardSupport.cloneMethods(classElement.getMethods());
        }
        if (methodElementArray != null) {
            return methodElementArray;
        }
        return new MethodElement[0];
    }

    MethodElement[] getTemplateMethods() {
        return RMIWizardIterator.getTemplateMethods(this.wizard);
    }

    protected DataObject instantiateInterface(int n) throws IOException, SourceException {
        MethodElement[] methodElementArray;
        MethodElement[] methodElementArray2;
        ClassElement classElement;
        SourceElement sourceElement;
        ClassElement classElement2;
        DataObject dataObject;
        DataObject dataObject2 = (DataObject)this.wizard.getProperty(PROP_INTERFACE_TEMPLATE);
        String string = (String)this.wizard.getProperty(PROP_INTERFACE_NAME);
        if (dataObject2 != null) {
            dataObject = dataObject2.createFromTemplate(this.wizard.getTargetFolder(), string);
        } else {
            classElement2 = new ClassElement();
            classElement2.setName(RMIWizardSupport.createIdentifier(this.wizard.getTargetFolder(), string));
            classElement2.setClassOrInterface(false);
            classElement2.setModifiers(1);
            sourceElement = this.wizard.getTargetFolder().getPrimaryFile();
            classElement = sourceElement.createData(string, "java");
            dataObject = DataObject.find((FileObject)classElement);
            methodElementArray2 = (MethodElement[])dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = RMIWizardIterator.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
            if (methodElementArray2 != null) {
                methodElementArray = methodElementArray2.getSource();
                String string2 = sourceElement.getPackageName('.').trim();
                if (string2.length() > 0) {
                    methodElementArray.setPackage(Identifier.create((String)string2));
                }
                methodElementArray.addClass(classElement2);
            }
        }
        classElement2 = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = RMIWizardIterator.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        if (classElement2 != null && (classElement = (sourceElement = classElement2.getSource()).getClass(RMIWizardSupport.createIdentifier(dataObject))) != null) {
            RMIWizardSupport.addInterface(classElement, Identifier.create((String)"java.rmi.Remote"));
            methodElementArray2 = (MethodElement[])this.wizard.getProperty(PROP_METHOD_ELEMENTS);
            if (methodElementArray2 != null && n > 1) {
                methodElementArray = RMIWizardSupport.createInterfaceMethods(methodElementArray2);
                classElement.setMethods(methodElementArray);
            }
        }
        RMIWizardSupport.saveDataObject(dataObject);
        return dataObject;
    }

    protected DataObject instantiateImplementation() throws IOException, SourceException {
        DataObject dataObject = null;
        String string = (String)this.wizard.getProperty(PROP_IMPLEMENTATION_NAME);
        if (string != null) {
            Identifier identifier;
            SourceElement sourceElement;
            ClassElement classElement;
            SourceCookie sourceCookie;
            DataObject dataObject2 = this.wizard.getTemplate();
            if (dataObject2 != null) {
                dataObject = dataObject2.createFromTemplate(this.wizard.getTargetFolder(), string);
            }
            if ((sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = RMIWizardIterator.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null && (classElement = (sourceElement = sourceCookie.getSource()).getClass(identifier = RMIWizardSupport.createIdentifier(dataObject))) != null) {
                String string2 = (String)this.wizard.getProperty(PROP_INTERFACE_NAME);
                RMIWizardSupport.addInterface(classElement, Identifier.create((String)string2));
                Boolean bl = (Boolean)this.wizard.getProperty(PROP_NEW_INTERFACE);
                if (bl != null && !bl.booleanValue()) {
                    MethodElement[] methodElementArray = RMIWizardSupport.createImplementationMethods(RMIWizardSupport.getInterfaceMethods((String)this.wizard.getProperty(PROP_INTERFACE_NAME)));
                    classElement.addMethods(methodElementArray);
                } else {
                    MethodElement[] methodElementArray = (MethodElement[])this.wizard.getProperty(PROP_METHOD_ELEMENTS);
                    if (methodElementArray != null) {
                        MethodElement[] methodElementArray2 = RMIWizardSupport.createImplementationMethods(methodElementArray);
                        classElement.addMethods(methodElementArray2);
                    }
                }
            }
            RMIWizardSupport.saveDataObject(dataObject);
        }
        return dataObject;
    }

    private String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$wizard$RMIWizardIterator == null ? (class$org$netbeans$modules$rmi$wizard$RMIWizardIterator = RMIWizardIterator.class$("org.netbeans.modules.rmi.wizard.RMIWizardIterator")) : class$org$netbeans$modules$rmi$wizard$RMIWizardIterator)).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

