/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.wizard;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import org.openide.TopManager;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDocSupport;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;

public class RMIWizardSupport {
    private static final String EMPTY_STRING = "";
    private static final String TEMPLATES_RMI = "RMI";
    static final String DEFAULT_INTERFACE = "NewRemote";
    static final String REMOTE = "java.rmi.Remote";
    static final String DEFAULT_METHOD = "newMethod";
    static /* synthetic */ Class class$org$netbeans$modules$rmi$wizard$RMIWizardSupport;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    private static String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$wizard$RMIWizardSupport == null ? (class$org$netbeans$modules$rmi$wizard$RMIWizardSupport = RMIWizardSupport.class$("org.netbeans.modules.rmi.wizard.RMIWizardSupport")) : class$org$netbeans$modules$rmi$wizard$RMIWizardSupport), (String)string);
    }

    static ClassElement addInterface(ClassElement classElement, Identifier identifier) {
        try {
            Identifier[] identifierArray = classElement.getInterfaces();
            int n = 0;
            while (n < identifierArray.length) {
                if (identifierArray[n].equals((Object)identifier)) {
                    return classElement;
                }
                ++n;
            }
            classElement.addInterface(identifier);
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
        return classElement;
    }

    static Identifier createIdentifier(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        return Identifier.create((String)fileObject.getPackageName('.'), (String)fileObject.getName());
    }

    static Identifier createIdentifier(DataFolder dataFolder, String string) {
        if (dataFolder == null) {
            return Identifier.create((String)string);
        }
        String string2 = dataFolder.getPrimaryFile().getPackageName('.').trim();
        String string3 = string2.length() > 0 ? string2 + '.' + string : string;
        return Identifier.create((String)string3, (String)string);
    }

    static MethodElement[] cloneMethods(MethodElement[] methodElementArray) {
        MethodElement[] methodElementArray2 = new MethodElement[methodElementArray.length];
        int n = 0;
        while (n < methodElementArray2.length) {
            methodElementArray2[n] = (MethodElement)methodElementArray[n].clone();
            ++n;
        }
        return methodElementArray2;
    }

    static MethodElement[] getInterfaceMethods(String string) {
        ClassElement classElement;
        LinkedList<MethodElement> linkedList = new LinkedList<MethodElement>();
        if (string != null && (classElement = ClassElement.forName((String)string)) != null && !classElement.isClassOrInterface()) {
            MethodElement[] methodElementArray = classElement.getMethods();
            int n = 0;
            while (n < methodElementArray.length) {
                MethodElement methodElement = (MethodElement)methodElementArray[n].clone();
                try {
                    methodElement.setModifiers(1);
                    MethodParameter[] methodParameterArray = methodElement.getParameters();
                    int n2 = 0;
                    while (n2 < methodParameterArray.length) {
                        if (methodParameterArray[n2].getName() == null || methodParameterArray[n2].getName().trim().length() == 0) {
                            methodParameterArray[n2].setName("p" + n2);
                        }
                        ++n2;
                    }
                    methodElement.setParameters(methodParameterArray);
                }
                catch (SourceException sourceException) {
                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)sourceException);
                }
                linkedList.add(methodElement);
                ++n;
            }
        }
        return linkedList.toArray(new MethodElement[linkedList.size()]);
    }

    static MethodElement[] createInterfaceMethods(MethodElement[] methodElementArray) {
        MethodElement[] methodElementArray2 = new MethodElement[methodElementArray.length];
        int n = 0;
        while (n < methodElementArray2.length) {
            methodElementArray2[n] = (MethodElement)methodElementArray[n].clone();
            try {
                methodElementArray2[n].setModifiers(1);
                methodElementArray2[n].setBody(null);
            }
            catch (SourceException sourceException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)sourceException);
                return new MethodElement[0];
            }
            ++n;
        }
        return methodElementArray2;
    }

    static MethodElement[] createImplementationMethods(MethodElement[] methodElementArray) {
        MethodElement[] methodElementArray2 = new MethodElement[methodElementArray.length];
        int n = 0;
        while (n < methodElementArray2.length) {
            methodElementArray2[n] = (MethodElement)methodElementArray[n].clone();
            int n2 = methodElementArray2[n].getModifiers();
            int n3 = 6;
            try {
                methodElementArray2[n].setModifiers((n2 | 1 | n3) ^ n3);
                if ((n2 & 0x500) == 0) {
                    methodElementArray2[n].setBody("\n");
                } else {
                    methodElementArray2[n].setBody(null);
                }
            }
            catch (SourceException sourceException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)sourceException);
                return new MethodElement[0];
            }
            ++n;
        }
        return methodElementArray2;
    }

    static void commentMethods(MethodElement[] methodElementArray) {
        int n = 0;
        while (n < methodElementArray.length) {
            MethodParameter[] methodParameterArray = methodElementArray[n].getParameters();
            JavaDocTag.Param[] paramArray = new JavaDocTag.Param[methodParameterArray.length];
            int n2 = 0;
            while (n2 < paramArray.length) {
                paramArray[n2] = JavaDocSupport.createParamTag((String)methodParameterArray[n2].getName(), (String)EMPTY_STRING);
                ++n2;
            }
            Identifier[] identifierArray = methodElementArray[n].getExceptions();
            JavaDocTag.Throws[] throwsArray = new JavaDocTag.Throws[identifierArray.length];
            int n3 = 0;
            while (n3 < throwsArray.length) {
                throwsArray[n3] = JavaDocSupport.createThrowsTag((String)identifierArray[n3].getFullName(), (String)EMPTY_STRING);
                ++n3;
            }
            try {
                methodElementArray[n].getJavaDoc().changeTags((JavaDocTag[])paramArray, 1);
                methodElementArray[n].getJavaDoc().changeTags((JavaDocTag[])throwsArray, 1);
            }
            catch (SourceException sourceException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)sourceException);
            }
            ++n;
        }
    }

    static void openDataObject(DataObject dataObject) {
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = RMIWizardSupport.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
        if (openCookie != null) {
            openCookie.open();
        }
    }

    static void saveDataObject(DataObject dataObject) throws IOException {
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = RMIWizardSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        if (saveCookie != null) {
            saveCookie.save();
        }
    }

    static DataObject[] getDataObjects(DataFolder dataFolder, DataFilter dataFilter) {
        if (dataFolder == null) {
            return null;
        }
        LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
        Enumeration enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!dataFilter.acceptDataObject(dataObject)) continue;
            linkedList.add(dataObject);
        }
        return linkedList.toArray(new DataObject[linkedList.size()]);
    }

    static DataFolder getFolder(DataFolder dataFolder, String string) {
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n] instanceof DataFolder && dataObjectArray[n].getName().equals(string)) {
                return (DataFolder)dataObjectArray[n];
            }
            ++n;
        }
        return null;
    }

    static DataObject[] getInterfaceTemplates() {
        DataFolder dataFolder = RMIWizardSupport.getFolder(TopManager.getDefault().getPlaces().folders().templates(), TEMPLATES_RMI);
        Object var1_1 = null;
        if (dataFolder != null) {
            return RMIWizardSupport.getDataObjects(dataFolder, new TemplateFilter());
        }
        return new DataObject[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TemplateFilter
    implements DataFilter {
        static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

        TemplateFilter() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            SourceElement sourceElement;
            ClassElement classElement;
            SourceCookie sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = TemplateFilter.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
            if (sourceCookie != null && (classElement = (sourceElement = sourceCookie.getSource()).getClass(Identifier.create((String)dataObject.getName()))) != null && classElement.isInterface()) {
                Identifier[] identifierArray = classElement.getInterfaces();
                int n = 0;
                while (n < identifierArray.length) {
                    if (RMIWizardSupport.REMOTE.equals(identifierArray[n].getFullName())) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

