/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.lib;

import java.io.IOException;
import org.netbeans.modules.xml.tools.lib.GuiUtil;
import org.netbeans.modules.xml.tools.lib.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public final class FileUtilities {
    public static DataObject createDataObject(FileObject folder, String name, String ext, boolean overwrite) throws IOException {
        DataObject dataObject = null;
        FileObject fileObject = FileUtilities.createFileObject(folder, name, ext, overwrite, false, true);
        if (fileObject != null) {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        return dataObject;
    }

    public static FileObject createFileObject(FileObject folder, String nameExt, boolean overwrite) throws IOException {
        while (nameExt.startsWith("../")) {
            nameExt = nameExt.substring(3);
            if (folder.isRoot()) continue;
            folder = folder.getParent();
        }
        FileObject fo = null;
        if (overwrite || GuiUtil.confirmAction(Util.THIS.getString("PROP_replaceMsg", nameExt))) {
            fo = FileUtil.createData((FileObject)folder, (String)nameExt);
        }
        return fo;
    }

    private static FileObject createFileObject(final FileObject folder, final String name, final String ext, final boolean overwrite, boolean askForOverwrite, final boolean makeCopy) throws IOException {
        FileObject file;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("[FileUtilities.createFileObject]");
            Util.THIS.debug("    folder = " + folder);
            Util.THIS.debug("    name   = " + name);
            Util.THIS.debug("    ext    = " + ext);
        }
        if ((file = folder.getFileObject(name, ext)) == null) {
            file = folder.createData(name, ext);
        } else if (file.isVirtual() || overwrite) {
            FileSystem fs = folder.getFileSystem();
            final FileObject tempFile = file;
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    if (makeCopy && overwrite && !tempFile.isVirtual()) {
                        int i = 1;
                        while (true) {
                            if (!tempFile.existsExt(ext + i)) {
                                tempFile.copy(folder, name, ext + i);
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!makeCopy && tempFile.isVirtual()) {
                        tempFile.delete();
                        folder.createData(name, ext);
                    }
                }
            });
            file = folder.getFileObject(name, ext);
        } else if (askForOverwrite) {
            if (!GuiUtil.confirmAction(Util.THIS.getString("PROP_replaceMsg", name + "." + ext))) {
                file = null;
            }
        } else {
            file = null;
        }
        return file;
    }
}

