/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.lib;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.tools.lib.Util;
import org.netbeans.tax.TreeException;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public final class GuiUtil {
    public static void performDefaultAction(FileObject fo) {
        if (fo == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("FileObject can not be null.", new IllegalArgumentException());
            }
            return;
        }
        try {
            DataObject obj = DataObject.find((FileObject)fo);
            Node node = obj.getNodeDelegate();
            SystemAction action = node.getDefaultAction();
            if (action != null) {
                TopManager.getDefault().getActionManager().invokeAction((Action)action, new ActionEvent(node, 1001, ""));
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    public static boolean confirmAction(String message) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, 0);
        Object option = TopManager.getDefault().notify((NotifyDescriptor)nd);
        return option == NotifyDescriptor.YES_OPTION;
    }

    public static void setStatusText(String text) {
        TopManager.getDefault().setStatusText(text);
    }

    public static void notifyException(Throwable exc) {
        GuiUtil.notifyException(null, exc);
    }

    public static void notifyException(String desc, Throwable ex) {
        ErrorManager err = TopManager.getDefault().getErrorManager();
        if (desc != null) {
            err.annotate(ex, desc);
        }
        err.notify(4096, ex);
    }

    public static void notifyTreeException(TreeException exc) {
        GuiUtil.notifyWarning(exc.getMessage());
    }

    public static void notifyWarning(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
                TopManager.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }

    public static void notifyError(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
        });
    }
}

