/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.VcsDirContainer;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RetrievingDialog
extends JDialog
implements Runnable,
DirReaderListener {
    private Debug E;
    private Debug D;
    private JLabel retrievingLabel;
    private JScrollPane listScrollPane;
    private JButton stopButton;
    private JList list;
    private DefaultListModel listData;
    private VcsFileSystem fileSystem;
    private String rootPath;
    private Vector queue;
    private boolean shouldStop;
    private boolean success;
    static final long serialVersionUID = -6441709213287922213L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$RetrievingDialog;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsFSCache;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandsPool;

    public RetrievingDialog(VcsFileSystem vcsFileSystem, String string, Frame frame, boolean bl) {
        super(frame, bl);
        this.D = this.E = new Debug("RetrievingDialog", true);
        this.fileSystem = null;
        this.rootPath = null;
        this.queue = new Vector(50);
        this.shouldStop = false;
        this.success = true;
        this.rootPath = string;
        this.fileSystem = vcsFileSystem;
        this.success = true;
        this.initComponents();
        this.initAccessibility();
        this.pack();
        HelpCtx.setHelpIDString((JComponent)this.getRootPane(), (String)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog).getName());
    }

    private void initComponents() {
        ((Component)this).setBackground(new Color(192, 192, 192));
        this.setTitle(this.g("CTL_Retrieving"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RetrievingDialog.this.closeDialog();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.retrievingLabel = new JLabel();
        this.retrievingLabel.setText(this.g("CTL_Retrieving_directories"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.05;
        this.getContentPane().add((Component)this.retrievingLabel, gridBagConstraints);
        this.listScrollPane = new JScrollPane();
        this.listScrollPane.setPreferredSize(new Dimension(400, 70));
        this.listScrollPane.setVerticalScrollBarPolicy(22);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.listData = new DefaultListModel();
        this.list.setModel(this.listData);
        this.listScrollPane.add(this.list);
        this.listScrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        this.getContentPane().add((Component)this.listScrollPane, gridBagConstraints);
        this.stopButton = new JButton();
        this.stopButton.setText(this.g("CTL_StopButtonLabel"));
        this.stopButton.setMnemonic(this.g("CTL_StopButtonLabel.mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.stopButton, gridBagConstraints);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrievingDialog.this.stopButtonPressed(actionEvent);
            }
        });
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSD_Retrieving"));
        this.retrievingLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"CTL_Retrieving_directories").charAt(0));
        this.retrievingLabel.setLabelFor(this.list);
        this.list.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSN_DirList"));
        this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSD_DirList"));
        this.stopButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSD_StopButton"));
    }

    private void stopButtonPressed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.shouldStop = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void readDirFinished(String string, Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = RefreshCommandSupport.getFileName((String[])iterator.next());
            if (!string2.endsWith("/")) continue;
            String string3 = string + "/" + string2;
            if (bl) {
                this.queue.addElement(string3.substring(0, string3.length() - 1));
                continue;
            }
            this.queue.removeAllElements();
            this.success = false;
        }
        this.success = this.success && bl;
        ((VcsCache)CacheHandler.getInstance().getCache(this.fileSystem.getCacheIdStr())).readDirFinished(string, collection, bl, null);
    }

    public void readDirFinishedRecursive(String string, VcsDirContainer vcsDirContainer, boolean bl) {
    }

    private void printMessage(String string) {
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RetrievingDialog.this.listData.addElement(string2);
                int n = Math.max(0, RetrievingDialog.this.listData.size() - 1);
                RetrievingDialog.this.list.setSelectedIndex(n);
                RetrievingDialog.this.list.ensureIndexIsVisible(n);
                RetrievingDialog.this.list.validate();
            }
        });
    }

    public void run() {
        String string = null;
        this.queue.addElement(this.rootPath);
        this.show();
        boolean bl = false;
        while (!this.queue.isEmpty()) {
            VcsCommandExecutor vcsCommandExecutor;
            String string2 = (String)this.queue.remove(0);
            this.D.deb("Retrieving recursively for path = " + string2);
            this.fileSystem.debug(this.g("MSG_Recursively_retrieving_directory", string2));
            String string3 = this.g("MSG_Root_folder");
            string = string2.equals("") ? string3 : string2;
            this.printMessage(string);
            if (this.fileSystem.isOffLine() && NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? RetrievingDialog.class$("org.netbeans.modules.vcscore.caching.VcsFSCache") : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"DLG_RefreshCommandDisabled"), 0)))) {
                this.fileSystem.setOffLine(false);
            }
            if ((vcsCommandExecutor = this.fileSystem.getVcsFactory().getVcsDirReader(this, string2)) == null) {
                this.fileSystem.debug(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$commands$CommandsPool == null ? RetrievingDialog.class$("org.netbeans.modules.vcscore.commands.CommandsPool") : class$org$netbeans$modules$vcscore$commands$CommandsPool), (String)"MSG_Command_canceled"));
                this.queue.removeAllElements();
                bl = true;
                continue;
            }
            this.fileSystem.getCommandsPool().startExecutor(vcsCommandExecutor, this.fileSystem);
            try {
                this.fileSystem.getCommandsPool().waitToFinish(vcsCommandExecutor);
                this.shouldStop = this.shouldStop || vcsCommandExecutor.getExitStatus() == 2;
            }
            catch (InterruptedException interruptedException) {
                this.fileSystem.getCommandsPool().kill(vcsCommandExecutor);
                this.shouldStop = true;
            }
            if (!this.shouldStop) continue;
            string = this.g("MSG_Recursive_retrieving_interrupted_by_the_user");
            this.printMessage(string);
            this.fileSystem.debug(string);
            return;
        }
        this.stopButton.setText(this.g("CTL_CloseButtonLabel"));
        this.stopButton.setMnemonic(this.g("CTL_CloseButtonLabel.mnemonic").charAt(0));
        this.getRootPane().setDefaultButton(this.stopButton);
        string = bl ? this.g("MSG_Recursive_retrieving_canceled") : (this.success ? this.g("MSG_Subtree_successfully_retrieved") : this.g("MSG_Recursive_retrieving_failed"));
        this.printMessage(string);
        this.fileSystem.debug(string);
    }

    String g(String string) {
        return NbBundle.getBundle((String)"org.netbeans.modules.vcscore.Bundle").getString(string);
    }

    String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.g(string), object, object2, object3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

