/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.Actions;
import org.openide.explorer.view.MenuView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class VcsMountFromTemplateAction
extends NodeAction {
    static final long serialVersionUID = 1537855553229904521L;
    private static final String ATTR_MNEMONIC = "VcsMountAction.mnemonic";
    private static Reference where = new WeakReference<Object>(null);
    private static TemplateWizard defaultWizard;
    private static Reference standardWizardRef;
    private static DataFolder targetFolder;
    private static DataFolder vcsFolder;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction;

    private static DataFolder getVCSFolder() {
        if (vcsFolder == null) {
            vcsFolder = DataFolder.findFolder((FileObject)TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Templates/Mount/VCS"));
        }
        return vcsFolder;
    }

    private static DataFolder getTargetFolder() {
        if (targetFolder == null) {
            targetFolder = DataFolder.findFolder((FileObject)TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Mount"));
        }
        return targetFolder;
    }

    static TemplateWizard getWizard(Node node) {
        TemplateWizard templateWizard;
        DataFolder dataFolder;
        if (node == null) {
            dataFolder = VcsMountFromTemplateAction.getVCSFolder();
            node = dataFolder.getNodeDelegate();
        }
        Cookie cookie = node == null ? null : (dataFolder = (Cookie)node.getCookie(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie = VcsMountFromTemplateAction.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction$Cookie")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie));
        if (dataFolder != null && (templateWizard = dataFolder.getTemplateWizard()) != null) {
            return templateWizard;
        }
        if (defaultWizard == null) {
            defaultWizard = VcsMountFromTemplateAction.getStandardWizard();
        }
        return defaultWizard;
    }

    static TemplateWizard getStandardWizard() {
        TemplateWizard templateWizard;
        TemplateWizard templateWizard2 = templateWizard = standardWizardRef == null ? null : (TemplateWizard)standardWizardRef.get();
        if (templateWizard == null) {
            templateWizard = new TW();
            standardWizardRef = new SoftReference<TemplateWizard>(templateWizard);
        }
        templateWizard.setTemplatesFolder(VcsMountFromTemplateAction.getVCSFolder());
        templateWizard.setTargetFolder(VcsMountFromTemplateAction.getTargetFolder());
        return templateWizard;
    }

    protected void performAction(Node[] nodeArray) {
        try {
            Node node = nodeArray.length == 1 ? nodeArray[0] : null;
            TemplateWizard templateWizard = VcsMountFromTemplateAction.getWizard(node);
            templateWizard.setTargetName(null);
            templateWizard.instantiate();
        }
        catch (IOException iOException) {
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            Throwable throwable = errorManager.annotate((Throwable)iOException, "Creating from template did not succeed.");
            errorManager.notify(1, throwable);
            String string = iOException.getMessage();
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction = VcsMountFromTemplateAction.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction)).getString("CTL_MountActionName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction = VcsMountFromTemplateAction.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction);
    }

    protected String iconResource() {
        return "org/netbeans/modules/vcscore/actions/mountNewVCS.gif";
    }

    public JMenuItem getMenuPresenter() {
        MountMenu mountMenu = new MountMenu(null, new TemplateActionListener(), false, false);
        Actions.connect((JMenuItem)((Object)mountMenu), (SystemAction)this, (boolean)false);
        return mountMenu;
    }

    public Component getToolbarPresenter() {
        return new Actions.ToolbarButton((SystemAction)this){

            public void setEnabled(boolean bl) {
                super.setEnabled(true);
            }
        };
    }

    public JMenuItem getPopupPresenter() {
        MountMenu mountMenu = new MountMenu(null, new TemplateActionListener(), false, true);
        Actions.connect((JMenuItem)((Object)mountMenu), (SystemAction)this, (boolean)true);
        return mountMenu;
    }

    public static Node getTemplateRoot() {
        RootChildren rootChildren = new RootChildren();
        return new AbstractNode((Children)rootChildren);
    }

    private static void setTWIterator(TemplateWizard templateWizard, DataObject dataObject) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class TW
    extends TemplateWizard
    implements FileSystem.AtomicAction {
        private Set retValue;

        private TW() {
        }

        protected synchronized Set handleInstantiate() throws IOException {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            return this.retValue;
        }

        public void run() throws IOException {
            this.retValue = super.handleInstantiate();
            Iterator iterator = this.retValue.iterator();
            while (iterator.hasNext()) {
                DataObject dataObject = (DataObject)iterator.next();
                DataFolder dataFolder = dataObject.getFolder();
                ArrayList<DataObject> arrayList = new ArrayList<DataObject>(Arrays.asList(dataFolder.getChildren()));
                arrayList.remove(dataObject);
                arrayList.add(dataObject);
                dataFolder.setOrder(arrayList.toArray(new DataObject[0]));
            }
        }
    }

    private static class TemplateChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        public TemplateChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            DataFolder dataFolder = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateChildren.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (dataFolder == null || dataFolder.isTemplate()) {
                return new FilterNode(node, Children.LEAF);
            }
            return new FilterNode(node, (Children)new TemplateChildren(node));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class RootChildren
    extends Children.Keys
    implements NodeListener {
        private TemplateWizard wizard;
        private WeakReference current;
        private NodeListener listener = WeakListener.node((NodeListener)this, null);
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public RootChildren() {
            TopComponent.Registry registry = TopManager.getDefault().getWindowManager().getRegistry();
            registry.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((Object)this), (Object)registry));
            this.updateWizard(VcsMountFromTemplateAction.getWizard(null));
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = RootChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                if (dataObject.isTemplate()) {
                    return new Node[]{new FilterNode(node, Children.LEAF)};
                }
                if (dataObject instanceof DataFolder) {
                    return new Node[]{new FilterNode(node, (Children)new TemplateChildren(node))};
                }
            }
            return null;
        }

        private void updateNode(Node node) {
            if (this.current != null && this.current.get() == node) {
                return;
            }
            if (this.current != null && this.current.get() != null) {
                ((Node)this.current.get()).removeNodeListener(this.listener);
            }
            node.addNodeListener(this.listener);
            this.current = new WeakReference<Node>(node);
        }

        private void updateWizard(TemplateWizard templateWizard) {
            Node node;
            if (this.wizard == templateWizard) {
                return;
            }
            if (this.wizard != null) {
                node = this.wizard.getTemplatesFolder().getNodeDelegate();
                node.removeNodeListener(this.listener);
            }
            node = templateWizard.getTemplatesFolder().getNodeDelegate();
            node.addNodeListener(this.listener);
            this.wizard = templateWizard;
            this.updateKeys();
        }

        private void updateKeys() {
            DataFolder dataFolder = this.wizard.getTemplatesFolder();
            if (dataFolder.isValid()) {
                this.setKeys(dataFolder.getNodeDelegate().getChildren().getNodes(true));
            } else {
                this.setKeys(new Object[0]);
            }
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.updateKeys();
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray;
            String string = propertyChangeEvent.getPropertyName();
            if (this.current != null && propertyChangeEvent.getSource() == this.current.get()) {
                if ("cookie".equals(string)) {
                    this.updateWizard(VcsMountFromTemplateAction.getWizard((Node)this.current.get()));
                }
            } else if ("activatedNodes".equals(string) && (nodeArray = TopManager.getDefault().getWindowManager().getRegistry().getActivatedNodes()).length == 1) {
                this.updateNode(nodeArray[0]);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class TemplateActionListener
    implements NodeAcceptor,
    DataFilter {
        static final long serialVersionUID = 4733270452576543255L;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        private TemplateActionListener() {
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            Node node = nodeArray[0];
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateActionListener.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject == null || !dataObject.isTemplate()) {
                return false;
            }
            TemplateWizard templateWizard = VcsMountFromTemplateAction.getWizard(null);
            try {
                templateWizard.setTargetName(null);
                templateWizard.instantiate(dataObject, targetFolder);
            }
            catch (IOException iOException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                Throwable throwable = errorManager.annotate((Throwable)iOException, "Creating from template did not succeed.");
                errorManager.notify(1, throwable);
                String string = iOException.getMessage();
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            }
            return true;
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return dataObject.isTemplate() || dataObject instanceof DataFolder;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class MountMenu
    extends MenuView.Menu {
        private boolean popupMenu;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public MountMenu(Node node, NodeAcceptor nodeAcceptor, boolean bl, boolean bl2) {
            super(node, nodeAcceptor, bl);
            this.popupMenu = bl2;
        }

        protected JMenuItem createMenuItem(Node node) {
            JMenuItem jMenuItem = super.createMenuItem(node);
            if (!this.popupMenu) {
                FileObject fileObject;
                String string;
                String string2 = null;
                DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = MountMenu.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                if (dataObject != null && (string = (String)(fileObject = dataObject.getPrimaryFile()).getAttribute(VcsMountFromTemplateAction.ATTR_MNEMONIC)) != null) {
                    try {
                        string = Utilities.translate((String)string);
                        ResourceBundle resourceBundle = NbBundle.getBundle((String)string, (Locale)Locale.getDefault(), (ClassLoader)TopManager.getDefault().systemClassLoader());
                        string2 = resourceBundle.getString(fileObject.getPackageNameExt('/', '.') + "_m");
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                if (string2 != null && string2.length() > 0) {
                    jMenuItem.setMnemonic(string2.charAt(0));
                }
            }
            return jMenuItem;
        }

        public JPopupMenu getPopupMenu() {
            if (this.node == null) {
                this.node = VcsMountFromTemplateAction.getTemplateRoot();
            }
            return super.getPopupMenu();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static interface Cookie
    extends Node.Cookie {
        public TemplateWizard getTemplateWizard();
    }
}

