/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.vcscore.cache.CacheDir;

public class CacheFile {
    private PersistentData data;
    protected String parentCache;
    private CacheDir parent;

    public CacheFile(String string, PersistentData persistentData) {
        this.setCacheName(string);
        this.data = persistentData;
    }

    public CacheFile(String string, String string2, PersistentData persistentData) {
        this(string, persistentData);
        persistentData.setName(string2);
    }

    public final PersistentData getPersistentData() {
        return this.data;
    }

    protected void setParent(CacheDir cacheDir) {
        this.parent = cacheDir;
    }

    public CacheDir getParent() {
        return this.parent;
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String string) {
        this.data.setName(string);
    }

    public String getStatus() {
        return this.data.getStatus();
    }

    public void setStatus(String string) {
        this.data.setStatus(string);
    }

    public String getRevision() {
        return this.data.getRevision();
    }

    public void setRevision(String string) {
        this.data.setRevision(string);
    }

    public String getSticky() {
        return this.data.getSticky();
    }

    public void setSticky(String string) {
        this.data.setSticky(string);
    }

    public String getDate() {
        return this.data.getDate();
    }

    public void setDate(String string) {
        this.data.setDate(string);
    }

    public String getTime() {
        return this.data.getTime();
    }

    public void setTime(String string) {
        this.data.setTime(string);
    }

    public String getLocker() {
        return this.data.getLocker();
    }

    public void setLocker(String string) {
        this.data.setLocker(string);
    }

    public String getAttr() {
        return this.data.getAttr();
    }

    public void setAttr(String string) {
        this.data.setAttr(string);
    }

    public int getSize() {
        return this.data.getSize();
    }

    public void setSize(int n) {
        this.data.setSize(n);
    }

    public String getCacheName() {
        return this.parentCache;
    }

    public void setCacheName(String string) {
        this.parentCache = string;
    }

    public String getAbsolutePath() {
        if (this.parent != null) {
            return this.parent.getAbsolutePath() + File.separator + this.data.getName();
        }
        return null;
    }

    protected static abstract class PersistentData {
        private boolean directory;
        private String name = "";
        private String status = "";
        private String locker = "";
        private String revision = "";
        private String sticky = "";
        private String attr = "";
        private String date = "";
        private String time = "";
        private int size = 0;
        private boolean modified = false;

        public PersistentData(boolean bl) {
            this.directory = bl;
        }

        public final void writeToDisk() throws IOException {
            if (this.isModified()) {
                this.doWriteToDisk();
                this.setModified(false);
            }
        }

        protected abstract void doWriteToDisk() throws IOException;

        public final boolean isDirectory() {
            return this.directory;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String string) {
            if (!this.name.equals(string)) {
                this.setModified(true);
                this.name = string;
            }
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String string) {
            if (this.status == null && string != null || this.status != null && !this.status.equals(string)) {
                this.setModified(true);
                this.status = string;
            }
        }

        public final String getLocker() {
            return this.locker;
        }

        public final void setLocker(String string) {
            if (this.locker == null && string != null || this.locker != null && !this.locker.equals(string)) {
                this.setModified(true);
                this.locker = string;
            }
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String string) {
            if (this.revision == null && string != null || this.revision != null && !this.revision.equals(string)) {
                this.setModified(true);
                this.revision = string;
            }
        }

        public final String getSticky() {
            return this.sticky;
        }

        public final void setSticky(String string) {
            if (this.sticky == null && string != null || this.sticky != null && !this.sticky.equals(string)) {
                this.setModified(true);
                this.sticky = string;
            }
        }

        public final String getAttr() {
            return this.attr;
        }

        public final void setAttr(String string) {
            if (this.attr == null && string != null || this.attr != null && !this.attr.equals(string)) {
                this.setModified(true);
                this.attr = string;
            }
        }

        public final String getDate() {
            return this.date;
        }

        public final void setDate(String string) {
            if (this.date == null && string != null || this.date != null && !this.date.equals(string)) {
                this.setModified(true);
                this.date = string;
            }
        }

        public final String getTime() {
            return this.time;
        }

        public final void setTime(String string) {
            if (this.time == null && string != null || this.time != null && !this.time.equals(string)) {
                this.setModified(true);
                this.time = string;
            }
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            if (this.size != n) {
                this.setModified(true);
                this.size = n;
            }
        }

        public final boolean isModified() {
            return this.modified;
        }

        public final void setModified(boolean bl) {
            this.modified = bl;
        }

        public String toString() {
            return (this.directory ? "DIR[" : "FILE[") + this.name + ", " + (this.modified ? "MODIFIED, " : "NON-MODIFIED, ") + this.status + ", " + this.locker + ", " + this.revision + ", " + this.sticky + ", " + this.attr + ", " + this.date + ", " + this.time + ", " + this.size + "]";
        }
    }
}

