/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.io.File;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.ExecuteCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsListCommand;
import org.netbeans.modules.vcscore.cmdline.exec.BadRegexException;
import org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class CommandLineVcsDirReader
implements VcsCommandExecutor {
    private Debug E;
    private Debug D;
    private VcsFileSystem fileSystem;
    private UserCommand list;
    private Hashtable vars;
    private String path;
    private String exec;
    private ArrayList commandOutputListener;
    private ArrayList commandErrorOutputListener;
    private ArrayList commandDataOutputListener;
    private ArrayList commandDataErrorOutputListener;
    private boolean shouldFail;
    private int exitStatus;
    private Vector rawData;
    private DirReaderListener listener;

    public CommandLineVcsDirReader(DirReaderListener dirReaderListener, VcsFileSystem vcsFileSystem, UserCommand userCommand, Hashtable hashtable) {
        this.D = this.E = new Debug("CommandLineVcsDirReader", true);
        this.fileSystem = null;
        this.list = null;
        this.vars = null;
        this.commandOutputListener = new ArrayList();
        this.commandErrorOutputListener = new ArrayList();
        this.commandDataOutputListener = new ArrayList();
        this.commandDataErrorOutputListener = new ArrayList();
        this.shouldFail = false;
        this.rawData = new Vector(40);
        this.listener = null;
        this.listener = dirReaderListener;
        this.fileSystem = vcsFileSystem;
        this.list = userCommand;
        this.vars = hashtable;
        this.path = (String)hashtable.get("DIR");
        this.D.deb("DIR=" + (String)hashtable.get("DIR"));
        this.path = this.path.replace(File.separatorChar, '/');
        this.path = vcsFileSystem.getFile(this.path).getAbsolutePath().replace(File.separatorChar, '/');
        this.D.deb("DIR=" + (String)hashtable.get("DIR"));
        this.exec = (String)userCommand.getProperty("exec");
    }

    public synchronized void addOutputListener(CommandOutputListener commandOutputListener) {
        if (this.commandOutputListener != null) {
            this.commandOutputListener.add(commandOutputListener);
        }
    }

    public synchronized void addErrorOutputListener(CommandOutputListener commandOutputListener) {
        if (this.commandErrorOutputListener != null) {
            this.commandErrorOutputListener.add(commandOutputListener);
        }
    }

    public synchronized void addDataOutputListener(CommandDataOutputListener commandDataOutputListener) {
        if (this.commandDataOutputListener != null) {
            this.commandDataOutputListener.add(commandDataOutputListener);
        }
    }

    public synchronized void addDataErrorOutputListener(CommandDataOutputListener commandDataOutputListener) {
        if (this.commandDataErrorOutputListener != null) {
            this.commandDataErrorOutputListener.add(commandDataOutputListener);
        }
    }

    public VcsCommand getCommand() {
        return this.list;
    }

    public String preprocessCommand(VcsCommand vcsCommand, Hashtable hashtable, String string) {
        return (String)this.list.getProperty("exec");
    }

    public Hashtable getVariables() {
        return this.vars;
    }

    public String getExec() {
        return this.exec;
    }

    public VcsCommandVisualizer getVisualizer() {
        return null;
    }

    public Collection getFiles() {
        String string = (String)this.vars.get("DIR");
        String string2 = (String)this.vars.get("FILE");
        String string3 = (string.length() > 0 ? string.replace(File.separatorChar, '/') + "/" : "") + (string2 == null ? "" : string2);
        return Collections.singleton(string3);
    }

    public Vector getRawData() {
        return this.rawData;
    }

    private void printOutput(String string) {
        if (this.commandOutputListener != null) {
            Iterator iterator = ((AbstractList)this.commandOutputListener).iterator();
            while (iterator.hasNext()) {
                ((CommandOutputListener)iterator.next()).outputLine(string);
            }
        }
    }

    private void printErrorOutput(String string) {
        if (this.commandErrorOutputListener != null) {
            Iterator iterator = ((AbstractList)this.commandErrorOutputListener).iterator();
            while (iterator.hasNext()) {
                ((CommandOutputListener)iterator.next()).outputLine(string);
            }
        }
    }

    private void printDataOutput(String[] stringArray) {
        if (this.commandDataOutputListener != null) {
            Iterator iterator = ((AbstractList)this.commandDataOutputListener).iterator();
            while (iterator.hasNext()) {
                ((CommandDataOutputListener)iterator.next()).outputData(stringArray);
            }
        }
    }

    private void printDataErrorOutput(String[] stringArray) {
        if (this.commandDataErrorOutputListener != null) {
            Iterator iterator = ((AbstractList)this.commandDataErrorOutputListener).iterator();
            while (iterator.hasNext()) {
                ((CommandDataOutputListener)iterator.next()).outputData(stringArray);
            }
        }
    }

    private void runCommand(String string) {
        ExternalCommand externalCommand = new ExternalCommand(string);
        externalCommand.setInput((String)this.list.getProperty("input"));
        String string2 = (String)this.list.getProperty("data.regex");
        if (string2 == null) {
            string2 = "^(.*$)";
        }
        try {
            externalCommand.addStdoutRegexListener(new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    stringArray = CommandLineVcsDirReader.translateElements(stringArray, CommandLineVcsDirReader.this.list);
                    CommandLineVcsDirReader.this.rawData.addElement(stringArray);
                    CommandLineVcsDirReader.this.printDataOutput(stringArray);
                }
            }, string2);
        }
        catch (BadRegexException badRegexException) {
            this.E.err(badRegexException, "bad regex");
        }
        String string3 = (String)this.list.getProperty("error.regex");
        if (string3 == null) {
            string3 = "^(.*$)";
        }
        try {
            externalCommand.addStderrRegexListener(new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    CommandLineVcsDirReader.this.printDataErrorOutput(stringArray);
                    CommandLineVcsDirReader.this.shouldFail = true;
                }
            }, string3);
        }
        catch (BadRegexException badRegexException) {
            this.E.err(badRegexException, "bad regex");
        }
        this.D.deb("ec=" + externalCommand);
        Iterator iterator = ((AbstractList)this.commandOutputListener).iterator();
        while (iterator.hasNext()) {
            externalCommand.addStdoutListener((CommandOutputListener)iterator.next());
        }
        Iterator iterator2 = ((AbstractList)this.commandErrorOutputListener).iterator();
        while (iterator2.hasNext()) {
            externalCommand.addStderrListener((CommandOutputListener)iterator2.next());
        }
        this.exitStatus = externalCommand.exec();
        if (this.shouldFail) {
            this.exitStatus = 1;
        }
        switch (this.exitStatus) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.shouldFail = true;
            }
        }
    }

    private void runClass(String string, StringTokenizer stringTokenizer) {
        Object object;
        String string2;
        Object object2;
        this.E.deb("runClass: " + string);
        this.E.deb("Creating new CvsListCommand");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, TopManager.getDefault().currentClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printErrorOutput("CLASS LIST: " + this.g("ERR_ClassNotFound", string));
            this.shouldFail = true;
            return;
        }
        this.E.deb(clazz + " loaded");
        VcsListCommand vcsListCommand = null;
        try {
            vcsListCommand = (VcsListCommand)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.printErrorOutput("CLASS LIST: " + this.g("ERR_CanNotInstantiate", clazz));
            this.shouldFail = true;
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.printErrorOutput("CLASS LIST: " + this.g("ERR_IllegalAccessOnClass", clazz));
            this.shouldFail = true;
            return;
        }
        this.E.deb("VcsListCommand created.");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        Hashtable hashtable = new Hashtable();
        if (!this.shouldFail) {
            ExecuteCommand.setAdditionalParams(vcsListCommand, this.fileSystem);
            object2 = (String)this.list.getProperty("data.regex");
            if (object2 == null) {
                object2 = "^(.*$)";
            }
            this.vars.put("DATAREGEX", object2);
            string2 = (String)this.list.getProperty("error.regex");
            if (string2 == null) {
                string2 = "^(.*$)";
            }
            this.vars.put("ERRORREGEX", string2);
            object = (String)this.list.getProperty("input");
            if (object != null) {
                this.vars.put("INPUT", object);
            }
            TopManager.getDefault().setStatusText(this.g("MSG_Command_name_running", this.list.getName()));
            this.shouldFail = !vcsListCommand.list(this.vars, stringArray, hashtable, new CommandOutputListener(){

                public void outputLine(String string) {
                    CommandLineVcsDirReader.this.printOutput(string);
                }
            }, new CommandOutputListener(){

                public void outputLine(String string) {
                    CommandLineVcsDirReader.this.printErrorOutput(string);
                }
            }, new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    CommandLineVcsDirReader.this.printDataOutput(stringArray);
                }
            }, (String)this.list.getProperty("data.regex"), new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    CommandLineVcsDirReader.this.printDataErrorOutput(stringArray);
                }
            }, (String)this.list.getProperty("error.regex"));
            this.E.deb("shouldFail = " + this.shouldFail + " after list with " + hashtable.size() + " elements");
        }
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            string2 = (String)object2.nextElement();
            object = (String[])hashtable.get(string2);
            this.E.deb("Processing: " + string2 + "|" + object);
            object = CommandLineVcsDirReader.translateElements(object, this.list);
            this.rawData.addElement(object);
        }
        this.exitStatus = this.shouldFail ? 1 : 0;
    }

    public void run() {
        this.exec = Variables.expand(this.vars, this.exec, false).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(this.exec);
        String string = stringTokenizer.nextToken();
        this.E.deb("first = " + string);
        if (string != null && string.toLowerCase().endsWith(".class")) {
            this.runClass(string.substring(0, string.length() - ".class".length()), stringTokenizer);
        } else {
            this.runCommand(this.exec);
        }
        if (this.shouldFail) {
            // empty if block
        }
        String string2 = (String)this.vars.get("DIR");
        string2 = string2.replace(File.separatorChar, '/');
        this.listener.readDirFinished(string2, this.rawData, !this.shouldFail);
        this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
        this.commandOutputListener = null;
        this.commandErrorOutputListener = null;
        this.commandDataOutputListener = null;
        this.commandDataErrorOutputListener = null;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public void addFileReaderListener(FileReaderListener fileReaderListener) {
    }

    public static String[] translateElements(String[] stringArray, UserCommand userCommand) {
        int n = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.removedFileName.index");
        if (n >= 0 && stringArray.length > n && stringArray[n] != null) {
            return new String[]{stringArray[n]};
        }
        int n2 = 9;
        int[] nArray = new int[n2];
        nArray[0] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.fileName.index");
        nArray[1] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.status.index");
        nArray[2] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.locker.index");
        nArray[3] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.revision.index");
        nArray[4] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.sticky.index");
        nArray[5] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.attr.index");
        nArray[7] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.date.index");
        nArray[8] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.time.index");
        nArray[6] = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.size.index");
        String[] stringArray2 = new String[n2];
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n2) {
            if (nArray[n4] >= 0 && nArray[n4] < n3) {
                stringArray2[n4] = stringArray[nArray[n4]];
            }
            ++n4;
        }
        return stringArray2;
    }

    String g(String string) {
        return NbBundle.getBundle((String)"org.netbeans.modules.vcscore.cmdline.Bundle").getString(string);
    }

    String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.g(string), object, object2, object3);
    }
}

