/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.io.File;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.RetrievingDialog;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsDirContainer;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReader;
import org.netbeans.modules.vcscore.cmdline.ExecuteCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsListRecursiveCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class CommandLineVcsDirReaderRecursive
implements VcsCommandExecutor {
    private Debug E;
    private Debug D;
    private VcsFileSystem fileSystem;
    private UserCommand listSub;
    private Hashtable vars;
    private String path;
    private String exec;
    private ArrayList commandOutputListener;
    private ArrayList commandErrorOutputListener;
    private ArrayList commandDataOutputListener;
    private ArrayList commandDataErrorOutputListener;
    private boolean shouldFail;
    private int exitStatus;
    private VcsDirContainer rawData;
    private DirReaderListener listener;

    public CommandLineVcsDirReaderRecursive(DirReaderListener dirReaderListener, VcsFileSystem vcsFileSystem, UserCommand userCommand, Hashtable hashtable) {
        this.D = this.E = new Debug("CommandLineVcsDirReaderRecursive", true);
        this.fileSystem = null;
        this.listSub = null;
        this.vars = null;
        this.path = null;
        this.commandOutputListener = new ArrayList();
        this.commandErrorOutputListener = new ArrayList();
        this.commandDataOutputListener = new ArrayList();
        this.commandDataErrorOutputListener = new ArrayList();
        this.shouldFail = false;
        this.rawData = null;
        this.listener = null;
        this.listener = dirReaderListener;
        this.fileSystem = vcsFileSystem;
        this.listSub = userCommand;
        this.vars = hashtable;
        this.path = (String)hashtable.get("DIR");
        this.D.deb("DIR=" + (String)hashtable.get("DIR"));
        this.path = this.path.replace(File.separatorChar, '/');
        this.D.deb("DIR=" + (String)hashtable.get("DIR"));
        this.exec = (String)userCommand.getProperty("exec");
    }

    public synchronized void addOutputListener(CommandOutputListener commandOutputListener) {
        if (this.commandOutputListener != null) {
            this.commandOutputListener.add(commandOutputListener);
        }
    }

    public synchronized void addErrorOutputListener(CommandOutputListener commandOutputListener) {
        if (this.commandErrorOutputListener != null) {
            this.commandErrorOutputListener.add(commandOutputListener);
        }
    }

    public synchronized void addDataOutputListener(CommandDataOutputListener commandDataOutputListener) {
        if (this.commandDataOutputListener != null) {
            this.commandDataOutputListener.add(commandDataOutputListener);
        }
    }

    public synchronized void addDataErrorOutputListener(CommandDataOutputListener commandDataOutputListener) {
        if (this.commandDataErrorOutputListener != null) {
            this.commandDataErrorOutputListener.add(commandDataOutputListener);
        }
    }

    public VcsCommand getCommand() {
        return this.listSub;
    }

    public String preprocessCommand(VcsCommand vcsCommand, Hashtable hashtable, String string) {
        return (String)this.listSub.getProperty("exec");
    }

    public String getExec() {
        return this.exec;
    }

    public VcsCommandVisualizer getVisualizer() {
        return null;
    }

    public Collection getFiles() {
        String string = (String)this.vars.get("DIR");
        String string2 = (String)this.vars.get("FILE");
        String string3 = (string.length() > 0 ? string.replace(File.separatorChar, '/') + "/" : "") + (string2 == null ? "" : string2);
        return Collections.singleton(string3);
    }

    public Hashtable getVariables() {
        return this.vars;
    }

    private void printOutput(String string) {
        Iterator iterator = ((AbstractList)this.commandOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandOutputListener)iterator.next()).outputLine(string);
        }
    }

    private void printErrorOutput(String string) {
        Iterator iterator = ((AbstractList)this.commandErrorOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandOutputListener)iterator.next()).outputLine(string);
        }
    }

    private void printDataOutput(String[] stringArray) {
        Iterator iterator = ((AbstractList)this.commandDataOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandDataOutputListener)iterator.next()).outputData(stringArray);
        }
    }

    private void printDataErrorOutput(String[] stringArray) {
        Iterator iterator = ((AbstractList)this.commandDataErrorOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandDataOutputListener)iterator.next()).outputData(stringArray);
        }
    }

    private void runCommand(String string) {
        this.printErrorOutput("LIST_SUB: " + this.g("MSG_List_command_failed") + "\n");
        this.exitStatus = 1;
        this.shouldFail = true;
    }

    private void runClass(String string, StringTokenizer stringTokenizer) {
        this.E.deb("runClass: " + string);
        this.E.deb("Creating new CvsListCommand");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, TopManager.getDefault().currentClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printErrorOutput("LIST_SUB: " + this.g("ERR_ClassNotFound", string));
            this.shouldFail = true;
            return;
        }
        this.E.deb(clazz + " loaded");
        VcsListRecursiveCommand vcsListRecursiveCommand = null;
        try {
            vcsListRecursiveCommand = (VcsListRecursiveCommand)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.printErrorOutput("LIST_SUB: " + this.g("ERR_CanNotInstantiate", clazz));
            this.shouldFail = true;
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.printErrorOutput(this.g("LIST_SUB: ERR_IllegalAccessOnClass", clazz));
            this.shouldFail = true;
            return;
        }
        this.E.deb("VcsListCommand created.");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        VcsDirContainer vcsDirContainer = new VcsDirContainer(this.path);
        if (!this.shouldFail) {
            ExecuteCommand.setAdditionalParams(vcsListRecursiveCommand, this.fileSystem);
            String string2 = (String)this.listSub.getProperty("data.regex");
            if (string2 == null) {
                string2 = "^(.*$)";
            }
            this.vars.put("DATAREGEX", string2);
            String string3 = (String)this.listSub.getProperty("error.regex");
            if (string3 == null) {
                string3 = "^(.*$)";
            }
            this.vars.put("ERRORREGEX", string3);
            String string4 = (String)this.listSub.getProperty("input");
            if (string4 != null) {
                this.vars.put("INPUT", string4);
            }
            this.shouldFail = !vcsListRecursiveCommand.listRecursively(this.vars, stringArray, vcsDirContainer, new CommandOutputListener(){

                public void outputLine(String string) {
                    CommandLineVcsDirReaderRecursive.this.printOutput(string);
                }
            }, new CommandOutputListener(){

                public void outputLine(String string) {
                    CommandLineVcsDirReaderRecursive.this.printErrorOutput(string);
                }
            }, new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    CommandLineVcsDirReaderRecursive.this.printDataOutput(stringArray);
                }
            }, (String)this.listSub.getProperty("data.regex"), new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    CommandLineVcsDirReaderRecursive.this.printDataErrorOutput(stringArray);
                }
            }, (String)this.listSub.getProperty("error.regex"));
        }
        this.rawData = vcsDirContainer;
        this.translateElementsRecursively(this.rawData);
        this.exitStatus = this.shouldFail ? 1 : 0;
    }

    private void translateElementsRecursively(VcsDirContainer vcsDirContainer) {
        Object object;
        Hashtable hashtable = (Hashtable)vcsDirContainer.getElement();
        if (hashtable != null) {
            object = new Hashtable();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                stringArray = CommandLineVcsDirReader.translateElements(stringArray, this.listSub);
                ((Hashtable)object).put(string, stringArray);
            }
            vcsDirContainer.setElement(object);
        }
        object = vcsDirContainer.getSubdirContainers();
        int n = 0;
        while (n < ((VcsDirContainer[])object).length) {
            this.translateElementsRecursively(object[n]);
            ++n;
        }
    }

    public void run() {
        if (this.exec == null) {
            String string = ((String)this.vars.get("DIR")).replace(((String)this.vars.get("PS")).charAt(0), '/');
            RetrievingDialog retrievingDialog = new RetrievingDialog(this.fileSystem, string, new JFrame(), false);
            VcsUtilities.centerWindow(retrievingDialog);
            retrievingDialog.run();
            this.exitStatus = 0;
            return;
        }
        this.exec = Variables.expand(this.vars, this.exec, false).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(this.exec);
        String string = stringTokenizer.nextToken();
        this.E.deb("first = " + string);
        if (string != null && string.toLowerCase().endsWith(".class")) {
            this.runClass(string.substring(0, string.length() - ".class".length()), stringTokenizer);
        } else {
            this.runCommand(this.exec);
        }
        if (this.shouldFail) {
            // empty if block
        }
        String string2 = (String)this.vars.get("DIR");
        String string3 = string2.replace(File.separatorChar, '/');
        this.listener.readDirFinishedRecursive(string3, this.rawData, !this.shouldFail);
        this.fileSystem.removeNumDoAutoRefresh(string2);
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public void addFileReaderListener(FileReaderListener fileReaderListener) {
    }

    String g(String string) {
        return NbBundle.getBundle((String)"org.netbeans.modules.vcscore.cmdline.Bundle").getString(string);
    }

    String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.g(string), object, object2, object3);
    }
}

