/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.vcscore.ui.views.FileInfoNode;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class SingleNodeView
extends JPanel
implements Externalizable {
    static final long serialVersionUID = 0L;
    private transient ExplorerManager manager;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupAdapter popupListener;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = false;
    private ActionListener defaultProcessor;
    private transient Node filterNode;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient boolean listenerActive;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public SingleNodeView() {
        this.initialize();
    }

    private void initialize() {
        this.managerListener = new Listener();
        this.popupListener = new PopupAdapter();
        this.addMouseListener(this.managerListener);
        this.addMouseListener((MouseListener)((Object)this.popupListener));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addFocusListener(new FocusAdapter());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Boolean(this.popupAllowed));
        objectOutput.writeObject(new Boolean(this.traversalAllowed));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)objectInput.readObject();
        this.traversalAllowed = (Boolean)objectInput.readObject();
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean bl) {
        this.popupAllowed = bl;
    }

    public boolean isTraversalAllowed() {
        return this.traversalAllowed;
    }

    public void setTraversalAllowed(boolean bl) {
        this.traversalAllowed = bl;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener actionListener) {
        this.defaultProcessor = actionListener;
    }

    public boolean isDragSource() {
        return false;
    }

    public boolean isDropTarget() {
        return false;
    }

    public int getAllowedDragActions() {
        return 0x40000003;
    }

    public void setAllowedDragActions(int n) {
    }

    public int getAllowedDropActions() {
        return 0x40000003;
    }

    public void setAllowedDropActions(int n) {
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        explorerManager.setSelectedNodes(nodeArray);
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        return true;
    }

    public void setContextNode(Node node) {
        FileVcsInfo fileVcsInfo;
        if (this.filterNode != null) {
            fileVcsInfo = (FileVcsInfo)this.filterNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = SingleNodeView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            fileVcsInfo.removePropertyChangeListener(this.managerListener);
        }
        if (node != null) {
            this.filterNode = (FileInfoNode)node;
            fileVcsInfo = (FileVcsInfo)this.filterNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = SingleNodeView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            fileVcsInfo.addPropertyChangeListener(this.managerListener);
        } else {
            this.filterNode = null;
        }
    }

    public Node getContextNode() {
        return this.filterNode;
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find((Component)this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListener.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            Node[] nodeArray = this.manager.getSelectedNodes();
            if (nodeArray != null && nodeArray.length == 1 && nodeArray[0] instanceof FileInfoNode) {
                this.setContextNode(nodeArray[0]);
            } else {
                this.setContextNode(null);
            }
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
        }
    }

    public void removeNotify() {
        FileVcsInfo fileVcsInfo;
        super.removeNotify();
        this.listenerActive = false;
        if (this.filterNode != null && (fileVcsInfo = (FileVcsInfo)this.filterNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = SingleNodeView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) != null) {
            fileVcsInfo.removePropertyChangeListener(this.managerListener);
        }
    }

    public void requestFocus() {
        this.requestFocus();
    }

    final void performNode(Node node, int n) {
        if (this.defaultProcessor != null) {
            this.defaultProcessor.actionPerformed(new ActionEvent(node, 0, null, n));
            return;
        }
        SystemAction systemAction = node.getDefaultAction();
        if (systemAction != null && (n & 2) == 0) {
            SingleNodeView.invokeAction(systemAction, new ActionEvent(node, 1001, ""));
        } else if (this.traversalAllowed && !node.isLeaf()) {
            this.manager.setExploredContext(node, this.manager.getSelectedNodes());
        }
    }

    static void invokeAction(SystemAction systemAction, ActionEvent actionEvent) {
        ErrorManager errorManager;
        Exception exception = null;
        try {
            errorManager = Class.forName("org.openide.actions.ActionManager");
            Object object = Lookup.getDefault().lookup(errorManager);
            if (object != null) {
                Method method = errorManager.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = SingleNodeView.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = SingleNodeView.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                method.invoke(object, systemAction, actionEvent);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (LinkageError linkageError) {
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        if (exception != null) {
            errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = SingleNodeView.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (errorManager != null) {
                errorManager.notify(1, (Throwable)exception);
            } else {
                exception.printStackTrace();
            }
        }
        systemAction.actionPerformed(actionEvent);
    }

    static boolean shouldPopupBeDisplayed(Component component) {
        try {
            Class<?> clazz = Class.forName("org.openide.windows.TopComponent$Registry");
            Object object = Lookup.getDefault().lookup(clazz);
            if (object == null) {
                return true;
            }
            Method method = clazz.getMethod("getActivated", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            boolean bl = SwingUtilities.isDescendingFrom(component, (Component)object2);
            if (bl) {
                return true;
            }
            Window window = SwingUtilities.getWindowAncestor(component);
            return window instanceof Dialog;
        }
        catch (Exception exception) {
            ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = SingleNodeView.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (errorManager != null) {
                errorManager.notify(1, (Throwable)exception);
            } else {
                exception.printStackTrace();
            }
            return true;
        }
    }

    private void updateSelection() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1 && nodeArray[0] instanceof FileInfoNode) {
            this.setContextNode(nodeArray[0]);
        } else {
            this.setContextNode(null);
        }
    }

    void createPopup(int n, int n2) {
        if (this.manager == null || this.getContextNode() == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        JPopupMenu jPopupMenu = NodeOp.findContextMenu((Node[])new Node[]{this.getContextNode()});
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0 && SingleNodeView.shouldPopupBeDisplayed(this)) {
            Point point = this.getVisibleRect().getLocation();
            point.x = n - point.x;
            point.y = n2 - point.y;
            SwingUtilities.convertPointToScreen(point, this);
            Dimension dimension = jPopupMenu.getPreferredSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x + dimension.width > dimension2.width) {
                point.x = dimension2.width - dimension.width;
            }
            if (point.y + dimension.height > dimension2.height) {
                point.y = dimension2.height - dimension.height;
            }
            SwingUtilities.convertPointFromScreen(point, this);
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class EnterAction
    extends AbstractAction {
        static final long serialVersionUID = -239805141416294016L;

        public EnterAction() {
            super("Enter");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node node = SingleNodeView.this.getContextNode();
            if (node != null) {
                SingleNodeView.this.performNode(node, actionEvent.getModifiers());
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class Listener
    extends MouseAdapter
    implements PropertyChangeListener,
    VetoableChangeListener {
        private Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Node node;
            if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && (node = SingleNodeView.this.getContextNode()) != null) {
                SingleNodeView.this.performNode(node, mouseEvent.getModifiers());
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            SingleNodeView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && !SingleNodeView.this.selectionAccept(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SingleNodeView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                SingleNodeView.this.updateSelection();
                return;
            }
            if (propertyChangeEvent.getSource() != null && propertyChangeEvent.getSource() instanceof FileVcsInfo) {
                SingleNodeView.this.setContextNode(SingleNodeView.this.getContextNode());
            }
        }
    }

    final class FocusAdapter
    implements FocusListener {
        CallbackSystemAction csa;
        PopupPerformer performer;
        static /* synthetic */ Class class$org$openide$ErrorManager;

        FocusAdapter() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.csa == null) {
                try {
                    Class<?> clazz = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(clazz);
                    this.performer = new PopupPerformer();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError();
                    ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = FocusAdapter.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                    if (errorManager != null) {
                        errorManager.annotate((Throwable)noClassDefFoundError, (Throwable)classNotFoundException);
                    }
                    throw noClassDefFoundError;
                }
            }
            this.csa.setActionPerformer((ActionPerformer)this.performer);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupPerformer) {
                this.csa.setActionPerformer(null);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    final class PopupPerformer
    implements ActionPerformer {
        PopupPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Point point = SingleNodeView.this.getLocation();
                    if (point == null) {
                        return;
                    }
                    SingleNodeView.this.createPopup(point.x, point.y);
                }
            });
        }
    }

    private final class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        private PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            SingleNodeView.this.createPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

