/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.netbeans.modules.vcscore.util.VariableInputComponent;
import org.netbeans.modules.vcscore.util.VariableInputFormatException;
import org.netbeans.modules.vcscore.util.VariableInputValidator;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.util.NbBundle;

public class VariableInputDescriptor {
    public static final int INPUT_LABEL = 0;
    public static final int INPUT_ACCESSIBILITY = 10;
    public static final int INPUT_PROMPT_FIELD = 1;
    public static final int INPUT_PROMPT_AREA = 2;
    public static final int INPUT_ASK = 3;
    public static final int INPUT_SELECT_RADIO = 4;
    public static final int INPUT_RADIO_BTN = 5;
    public static final int INPUT_SELECT_COMBO = 6;
    public static final int INPUT_COMBO_ITEM = 7;
    public static final int INPUT_GLOBAL = 8;
    public static final int INPUT_SELECT_COMBO_EDITABLE = 9;
    public static final String INPUT_STR_LABEL = "LABEL";
    public static final String INPUT_STR_PROMPT_FIELD = "PROMPT_FOR";
    public static final String INPUT_STR_PROMPT_AREA = "PROMPT_FOR_FILE";
    public static final String INPUT_STR_ASK = "ASK_FOR";
    public static final String INPUT_STR_SELECT_RADIO = "SELECT_RADIO";
    public static final String INPUT_STR_SELECT_COMBO = "SELECT_COMBO";
    public static final String INPUT_STR_SELECT_COMBO_EDITABLE = "SELECT_COMBO_EDITABLE";
    public static final String INPUT_STR_GLOBAL_PARAMS = "GLOBAL_PARAMS";
    public static final String INPUT_STR_GLOBAL_ALL_VARS = "ALL_VARIABLES";
    public static final String INPUT_IS_EXPERT = "_EXPERT";
    public static final String INPUT_STR_ENABLE = "ENABLE";
    public static final String INPUT_STR_DISABLE = "DISABLE";
    public static final String INPUT_STR_ACCESSIBILITY = "ACCESSIBILITY";
    public static final String INPUT_STR_A11Y_NAME = "NAME_";
    public static final String INPUT_STR_A11Y_DESCRIPTION = "DESCRIPTION_";
    public static final String INPUT_STR_MNEMONIC = "MNEMONIC_";
    public static final String INPUT_STR_A11Y_DELIMETER = ";;";
    public static final String SELECTOR = "SELECTOR_";
    public static final String SELECTOR_FILE = "SELECTOR_FILE";
    public static final String SELECTOR_DIR = "SELECTOR_DIR";
    public static final String SELECTOR_DATE_CVS = "SELECTOR_DATE_CVS";
    public static final String SELECTOR_CMD = "SELECTOR_CMD_";
    public static final String IF_VAR_NON_EMPTY_BEGIN = "IF_VAR_NON_EMPTY\"";
    public static final String IF_VAR_NON_EMPTY_END = "\"_";
    public static final String IF_VAR_EMPTY_BEGIN = "IF_VAR_EMPTY\"";
    public static final String IF_VAR_EMPTY_END = "\"_";
    public static final char INPUT_STR_ARG_OPEN = '(';
    public static final char INPUT_STR_ARG_CLOSE = ')';
    public static final char INPUT_SELECT_STR_ARG_OPEN = '[';
    public static final char INPUT_SELECT_STR_ARG_CLOSE = ']';
    private static HashMap inputMap = null;
    private static final Object inputMapLock = new Object();
    private String label;
    private String a11yName = null;
    private String a11yDescription = null;
    private ArrayList components = new ArrayList();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$VariableInputDescriptor;

    private VariableInputDescriptor() {
        if (inputMap == null) {
            Object object = inputMapLock;
            synchronized (object) {
                if (inputMap == null) {
                    inputMap = new HashMap();
                    inputMap.put(INPUT_STR_LABEL, new Integer(0));
                    inputMap.put(INPUT_STR_ACCESSIBILITY, new Integer(10));
                    inputMap.put(INPUT_STR_PROMPT_FIELD, new Integer(1));
                    inputMap.put(INPUT_STR_PROMPT_AREA, new Integer(2));
                    inputMap.put(INPUT_STR_ASK, new Integer(3));
                    inputMap.put(INPUT_STR_SELECT_RADIO, new Integer(4));
                    inputMap.put(INPUT_STR_SELECT_COMBO, new Integer(6));
                    inputMap.put(INPUT_STR_SELECT_COMBO_EDITABLE, new Integer(9));
                    inputMap.put(INPUT_STR_GLOBAL_PARAMS, new Integer(8));
                }
            }
        }
    }

    public static VariableInputDescriptor create(String string, VariableInputComponent[] variableInputComponentArray) {
        VariableInputDescriptor variableInputDescriptor = new VariableInputDescriptor();
        variableInputDescriptor.label = string;
        variableInputDescriptor.components.addAll(Arrays.asList(variableInputComponentArray));
        return variableInputDescriptor;
    }

    public static VariableInputDescriptor parseItems(String string) throws VariableInputFormatException {
        int n;
        VariableInputDescriptor variableInputDescriptor = new VariableInputDescriptor();
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(40, n2)) >= 0 && (n3 = VcsUtilities.getPairIndex(string, n + 1, '(', ')')) >= 0) {
            VariableInputComponent variableInputComponent;
            String string2 = string.substring(n2, n).trim();
            boolean bl = string2.endsWith(INPUT_IS_EXPERT);
            if (bl) {
                string2 = string2.substring(0, string2.length() - INPUT_IS_EXPERT.length());
            }
            String[] stringArray = new String[2];
            string2 = VariableInputDescriptor.getVarConditions(string2, stringArray);
            int n4 = VariableInputDescriptor.getInputId(string2);
            String string3 = string.substring(n + 1, n3);
            String[] stringArray2 = VcsUtilities.getQuotedStrings(string3);
            if (n4 == 0 && stringArray2.length > 0) {
                variableInputDescriptor.label = VcsUtilities.getBundleString(stringArray2[0]);
            } else if (n4 == 10 && stringArray2.length > 0) {
                variableInputComponent = new VariableInputComponent(0, "", "");
                VariableInputDescriptor.setA11y(VcsUtilities.getBundleString(string3), variableInputComponent);
                variableInputDescriptor.a11yName = variableInputComponent.getA11yName();
                variableInputDescriptor.a11yDescription = variableInputComponent.getA11yDescription();
            } else {
                variableInputComponent = VariableInputDescriptor.parseComponent(n4, stringArray2, string3);
                variableInputComponent.setExpert(bl);
                variableInputComponent.setVarConditions(stringArray);
                variableInputDescriptor.components.add(variableInputComponent);
            }
            n2 = n3 + 1;
            while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            if (n2 < string.length()) continue;
        }
        if (n2 < string.length()) {
            if (n3 >= 0) {
                throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_UnrecognizedItem", new Integer(n2)));
            }
            throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_MissingClosingPar", new Integer(n)));
        }
        return variableInputDescriptor;
    }

    public String getLabel() {
        return this.label;
    }

    public String getA11yName() {
        return this.a11yName;
    }

    public String getA11yDescription() {
        return this.a11yDescription;
    }

    public VariableInputComponent[] components() {
        return this.components.toArray(new VariableInputComponent[0]);
    }

    public VariableInputValidator validate() {
        VariableInputValidator variableInputValidator = null;
        VariableInputComponent[] variableInputComponentArray = this.components();
        int n = 0;
        while (n < variableInputComponentArray.length) {
            variableInputValidator = variableInputComponentArray[n].validate();
            if (!variableInputValidator.isValid()) break;
            ++n;
        }
        if (variableInputValidator == null) {
            variableInputValidator = new VariableInputValidator(null, null);
        }
        return variableInputValidator;
    }

    public void addValuesToHistory() {
        VariableInputComponent[] variableInputComponentArray = this.components();
        int n = 0;
        while (n < variableInputComponentArray.length) {
            variableInputComponentArray[n].addValuesToHistory();
            ++n;
        }
    }

    public void setValuesAsDefault() {
        VariableInputComponent[] variableInputComponentArray = this.components();
        int n = 0;
        while (n < variableInputComponentArray.length) {
            variableInputComponentArray[n].setValuesAsDefault();
            ++n;
        }
    }

    public void setDefaultValues() {
        VariableInputComponent[] variableInputComponentArray = this.components();
        int n = 0;
        while (n < variableInputComponentArray.length) {
            variableInputComponentArray[n].setDefaultValues();
            ++n;
        }
    }

    private static String getVarConditions(String string, String[] stringArray) {
        int n;
        if (string.startsWith(IF_VAR_EMPTY_BEGIN) && (n = string.indexOf("\"_", IF_VAR_EMPTY_BEGIN.length())) > 0) {
            stringArray[0] = string.substring(IF_VAR_EMPTY_BEGIN.length(), n);
            string = string.substring(n + "\"_".length());
        }
        if (string.startsWith(IF_VAR_NON_EMPTY_BEGIN) && (n = string.indexOf("\"_", IF_VAR_NON_EMPTY_BEGIN.length())) > 0) {
            stringArray[1] = string.substring(IF_VAR_NON_EMPTY_BEGIN.length(), n);
            string = string.substring(n + "\"_".length());
        }
        return string;
    }

    private static int getInputId(String string) throws VariableInputFormatException {
        Integer n = (Integer)inputMap.get(string);
        if (n == null) {
            throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_UnrecognizedComponent", string));
        }
        return n;
    }

    private static VariableInputComponent parseComponent(int n, String[] stringArray, String string) throws VariableInputFormatException {
        int n2;
        VariableInputComponent[] variableInputComponentArray;
        int n3;
        int n4;
        VariableInputComponent variableInputComponent;
        int n5 = stringArray.length;
        if (n5 < 2) {
            throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_InsufficientArgs"));
        }
        if (n5 > 3 && stringArray[3].startsWith(INPUT_STR_ACCESSIBILITY)) {
            variableInputComponent = new VariableInputComponent(n, stringArray[0], VcsUtilities.getBundleString(stringArray[1]));
            n4 = stringArray[3].indexOf(40, 0);
            if (n4 > 0) {
                int n6 = stringArray[3].lastIndexOf(41);
                if (n6 < 0) {
                    n6 = stringArray[3].length();
                }
                VariableInputDescriptor.setA11y(stringArray[3].substring(n4 + 1, n6), variableInputComponent);
            }
            n3 = 4;
        } else {
            variableInputComponent = new VariableInputComponent(n, stringArray[0], VcsUtilities.getBundleString(stringArray[1]));
            n3 = 3;
        }
        if (n5 >= 3) {
            variableInputComponent.setValue(VcsUtilities.getBundleString(stringArray[2]));
        }
        if (n5 > n3 && stringArray[n3].indexOf("VALIDATOR_") == 0) {
            String string2 = stringArray[n3];
            variableInputComponent.setValidator(string2);
            ++n3;
        }
        if (n5 > n3 && stringArray[n3].indexOf(SELECTOR) >= 0) {
            String string3 = stringArray[n3];
            String[] stringArray2 = new String[2];
            if ((string3 = VariableInputDescriptor.getVarConditions(string3, stringArray2)).indexOf(SELECTOR) == 0) {
                variableInputComponent.setSelector(string3);
                variableInputComponent.setSelectorVarConditions(stringArray2);
                ++n3;
            }
        }
        if (2 == n && n5 >= n3 + 2) {
            try {
                n4 = Integer.parseInt(stringArray[n3]);
                int n7 = Integer.parseInt(stringArray[n3 + 1]);
                variableInputComponent.setDimension(new Dimension(n4, n7));
            }
            catch (NumberFormatException numberFormatException) {
                throw new VariableInputFormatException(numberFormatException.getMessage());
            }
            n3 += 2;
        }
        if (4 == n || 6 == n || 9 == n) {
            String[] stringArray3 = VariableInputDescriptor.getSelectArgs(stringArray[0], string, stringArray[0].length() + stringArray[1].length());
            int n8 = 4 == n ? 5 : 7;
            int n9 = 0;
            while (n9 < stringArray3.length) {
                variableInputComponentArray = VariableInputDescriptor.parseComponent(n8, VcsUtilities.getQuotedStrings(stringArray3[n9]), stringArray3[n9]);
                variableInputComponent.addSubComponent((VariableInputComponent)variableInputComponentArray);
                ++n9;
            }
        }
        if (3 == n && n5 > n3 && stringArray[n3].indexOf(INPUT_STR_ENABLE) < 0) {
            variableInputComponent.setValueSelected(stringArray[n3]);
            ++n3;
        }
        if (3 == n && n5 > n3 && stringArray[n3].indexOf(INPUT_STR_ENABLE) < 0) {
            variableInputComponent.setValueUnselected(stringArray[n3]);
            ++n3;
        }
        if (3 == n) {
            String string4 = variableInputComponent.getValueSelected();
            if (string4 != null) {
                if (Boolean.TRUE.toString().equalsIgnoreCase(variableInputComponent.getValue())) {
                    variableInputComponent.setValue(variableInputComponent.getValueSelected());
                } else {
                    variableInputComponent.setValue(variableInputComponent.getValueUnselected());
                }
            } else if (!Boolean.TRUE.toString().equalsIgnoreCase(variableInputComponent.getValue())) {
                variableInputComponent.setValue("");
            }
        }
        if (n5 > n3 && stringArray[n3].indexOf(INPUT_STR_ENABLE) == 0) {
            n3 = VariableInputDescriptor.addEnable(stringArray, n3, variableInputComponent);
        }
        if (n5 > n3 && stringArray[n3].indexOf(INPUT_STR_DISABLE) == 0) {
            n3 = VariableInputDescriptor.addDisable(stringArray, n3, variableInputComponent);
        }
        if (5 == n && n5 > n3 && (n2 = string.indexOf(stringArray[n3])) > 0) {
            String string5 = string.substring(n2);
            VariableInputDescriptor variableInputDescriptor = VariableInputDescriptor.parseItems(string5);
            variableInputComponentArray = variableInputDescriptor.components();
            int n10 = 0;
            while (n10 < variableInputComponentArray.length) {
                variableInputComponent.addSubComponent(variableInputComponentArray[n10]);
                ++n10;
            }
        }
        return variableInputComponent;
    }

    private static int addEnable(String[] stringArray, int n, VariableInputComponent variableInputComponent) {
        String string = stringArray[n].substring(INPUT_STR_ENABLE.length() + 1).trim();
        String string2 = new Character(')').toString();
        while (true) {
            if (string.endsWith(string2)) {
                string = string.substring(0, string.length() - 1);
                variableInputComponent.addEnable(string.trim());
                break;
            }
            variableInputComponent.addEnable(string.trim());
            if (++n >= stringArray.length) break;
            string = stringArray[n].trim();
        }
        return n + 1;
    }

    private static int addDisable(String[] stringArray, int n, VariableInputComponent variableInputComponent) {
        String string = stringArray[n].substring(INPUT_STR_DISABLE.length() + 1).trim();
        String string2 = new Character(')').toString();
        while (true) {
            if (string.endsWith(string2)) {
                string = string.substring(0, string.length() - 1);
                variableInputComponent.addDisable(string.trim());
                break;
            }
            variableInputComponent.addDisable(string.trim());
            if (++n >= stringArray.length) break;
            string = stringArray[n].trim();
        }
        return n + 1;
    }

    private static String[] getSelectArgs(String string, String string2, int n) {
        String string3 = string2;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n3;
            if (n2 < string3.length() && string3.charAt(n2) != '[') {
                ++n2;
                continue;
            }
            if (n2 >= string3.length() || (n3 = VcsUtilities.getPairIndex(string3, n2 + 1, '[', ']')) < 0) break;
            String string4 = string3.substring(n2 + 1, n3);
            arrayList.add(string + ", " + string4);
            n2 = n3 + 1;
            if (n2 >= string3.length()) break;
        }
        return arrayList.toArray(new String[0]);
    }

    private static void setA11y(String string, VariableInputComponent variableInputComponent) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, INPUT_STR_A11Y_DELIMETER);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith(INPUT_STR_A11Y_NAME)) {
                variableInputComponent.setA11yName(string2.substring(INPUT_STR_A11Y_NAME.length()));
                continue;
            }
            if (string2.startsWith(INPUT_STR_A11Y_DESCRIPTION)) {
                variableInputComponent.setA11yDescription(string2.substring(INPUT_STR_A11Y_DESCRIPTION.length()));
                continue;
            }
            if (!string2.startsWith(INPUT_STR_MNEMONIC)) continue;
            variableInputComponent.setLabelMnemonic(string2.substring(INPUT_STR_MNEMONIC.length()));
        }
    }

    private static String g(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDescriptor == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDescriptor = VariableInputDescriptor.class$("org.netbeans.modules.vcscore.util.VariableInputDescriptor")) : class$org$netbeans$modules$vcscore$util$VariableInputDescriptor)).getString(string);
    }

    private static String g(String string, Object object) {
        return MessageFormat.format(VariableInputDescriptor.g(string), object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

