/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class WeakList
extends AbstractList {
    private ArrayList items = new ArrayList();

    public WeakList() {
    }

    public WeakList(Collection collection) {
        this.addAll(0, collection);
    }

    public void add(int n, Object object) {
        this.items.add(n, new WeakReference<Object>(object));
    }

    public Iterator iterator() {
        return new WeakListIterator();
    }

    public int size() {
        this.removeReleased();
        return this.items.size();
    }

    public Object get(int n) {
        return ((WeakReference)this.items.get(n)).get();
    }

    private void removeReleased() {
        Iterator iterator = ((AbstractList)this.items).iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            ((AbstractCollection)this.items).remove(weakReference);
        }
    }

    private class WeakListIterator
    implements Iterator {
        private int n;
        private int i;

        public WeakListIterator() {
            this.n = WeakList.this.size();
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public Object next() {
            return WeakList.this.get(this.i++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

