/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.search.VcsSearchTypeFileSystem;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusListener;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataLoader;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataObject;
import org.netbeans.modules.vcscore.versioning.impl.VersioningFolderDataLoader;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.EmptyEnumeration;

public abstract class VersioningFileSystem
extends AbstractFileSystem
implements VcsSearchTypeFileSystem {
    private static final SystemAction[] NO_ACTIONS = new SystemAction[0];
    public static final String VERSIONING_PROPERTIES_SAVE_METHOD = "saveVersioningFileSystemProperties";
    private AbstractFileSystem fileSystem;
    private transient EventListenerList listenerList = new EventListenerList();
    private static final long serialVersionUID = 1437726745709092169L;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener;

    public VersioningFileSystem() {
    }

    public VersioningFileSystem(AbstractFileSystem abstractFileSystem) {
        this.fileSystem = abstractFileSystem;
    }

    public abstract Versions getVersions();

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Image getFSIcon(int n) {
        FileSystem fileSystem = this.getFileSystem();
        if (fileSystem != null) {
            try {
                BeanInfo beanInfo = Utilities.getBeanInfo(fileSystem.getClass());
                if (beanInfo != null) {
                    return beanInfo.getIcon(n);
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getFSCustomizer() {
        block8: {
            FileSystem fileSystem = this.getFileSystem();
            if (fileSystem != null) {
                try {
                    BeanInfo beanInfo = Utilities.getBeanInfo(fileSystem.getClass());
                    if (beanInfo == null) break block8;
                    Class<?> clazz = beanInfo.getBeanDescriptor().getCustomizerClass();
                    if (clazz == null) {
                        return null;
                    }
                    try {
                        Object obj = clazz.newInstance();
                        if (obj instanceof Customizer) {
                            Customizer customizer = (Customizer)obj;
                            customizer.setObject(fileSystem);
                        }
                        return obj;
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected final void propagatePropertyChange(String[] stringArray) {
        Method method = null;
        try {
            method = this.fileSystem.getClass().getMethod(VERSIONING_PROPERTIES_SAVE_METHOD, class$java$lang$String == null ? (class$java$lang$String = VersioningFileSystem.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = VersioningFileSystem.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        final Method method2 = method;
        if (method2 == null) {
            return;
        }
        final WeakReference<AbstractFileSystem> weakReference = new WeakReference<AbstractFileSystem>(this.fileSystem);
        final String[] stringArray2 = stringArray;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object t = weakReference.get();
                if (t == null) {
                    VersioningFileSystem.this.removePropertyChangeListener(this);
                    return;
                }
                int n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals(string)) {
                        try {
                            method2.invoke(t, string, propertyChangeEvent.getNewValue());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        return;
                    }
                    ++n;
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    protected Reference createReference(FileObject fileObject) {
        try {
            if (fileObject.isFolder()) {
                DataLoaderPool.setPreferredLoader((FileObject)fileObject, (DataLoader)((VersioningFolderDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningFolderDataLoader")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader), (boolean)true)));
            } else {
                DataLoaderPool.setPreferredLoader((FileObject)fileObject, (DataLoader)((VersioningDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataLoader")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader), (boolean)true)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Reference reference = super.createReference(fileObject);
        return reference;
    }

    public String getDisplayName() {
        return this.fileSystem.getDisplayName();
    }

    public SystemAction[] getActions(Set set) {
        SystemAction[] systemActionArray = this.fileSystem.getActions(set);
        SystemAction systemAction = SystemAction.get((Class)(class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction == null ? (class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction = VersioningFileSystem.class$("org.netbeans.modules.vcscore.actions.VersioningExplorerAction")) : class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction));
        int n = 0;
        while (n < systemActionArray.length) {
            if (systemAction.equals((Object)systemActionArray[n])) break;
            ++n;
        }
        if (n < systemActionArray.length) {
            SystemAction[] systemActionArray2 = new SystemAction[systemActionArray.length - 1];
            if (n > 0) {
                System.arraycopy(systemActionArray, 0, systemActionArray2, 0, n);
            }
            if (n < systemActionArray2.length) {
                System.arraycopy(systemActionArray, n + 1, systemActionArray2, n, systemActionArray2.length - n);
            }
            systemActionArray = systemActionArray2;
        }
        return systemActionArray;
    }

    public FileStatusProvider getFileStatusProvider() {
        return null;
    }

    public String[] getPossibleFileStatuses() {
        FileStatusProvider fileStatusProvider = this.getFileStatusProvider();
        if (fileStatusProvider != null) {
            return fileStatusProvider.getPossibleFileStatusesTable().values().toArray(new String[0]);
        }
        return new String[0];
    }

    public String getStatus(DataObject dataObject) {
        if (dataObject instanceof VersioningDataObject) {
            VersioningDataObject versioningDataObject = (VersioningDataObject)dataObject;
            return versioningDataObject.getStatus();
        }
        return "";
    }

    public void statusChanged(final String string, final boolean bl) {
        VcsFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fileObject;
                FileObject fileObject2 = VersioningFileSystem.this.findResource(string);
                if (fileObject2 == null) {
                    return;
                }
                Enumeration enumeration = VersioningFileSystem.super.existingFileObjects(fileObject2);
                HashSet hashSet = new HashSet();
                if (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
                while (enumeration.hasMoreElements()) {
                    fileObject = (FileObject)enumeration.nextElement();
                    if (!fileObject2.equals(fileObject.getParent()) && !bl) break;
                    hashSet.add(fileObject);
                }
                fileObject = Collections.synchronizedSet(hashSet);
                VersioningFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VersioningFileSystem.this, (Set)fileObject, true, true));
            }
        });
    }

    public void statusChanged(final String string) {
        VcsFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fileObject = VersioningFileSystem.this.findExistingResource(string);
                if (fileObject == null) {
                    return;
                }
                VersioningFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VersioningFileSystem.this, fileObject, true, true));
            }
        });
    }

    public SystemAction[] getRevisionActions(FileObject fileObject, Set set) {
        return NO_ACTIONS;
    }

    public FileObject findExistingResource(String string) {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        FileObject fileObject = null;
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string.equals(fileObject2.getPackageNameExt('/', '.'))) continue;
            fileObject = fileObject2;
            break;
        }
        return fileObject;
    }

    protected void refreshExistingFolders() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Enumeration enumeration = VersioningFileSystem.super.existingFileObjects(VersioningFileSystem.this.getRoot());
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject = (FileObject)enumeration.nextElement();
                    if (!fileObject.isFolder()) continue;
                    fileObject.refresh(true);
                }
            }
        });
    }

    public final void addVcsFileStatusListener(VcsFileStatusListener vcsFileStatusListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener, vcsFileStatusListener);
        }
    }

    public final void removeVcsFileStatusListener(VcsFileStatusListener vcsFileStatusListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener, vcsFileStatusListener);
        }
    }

    protected final void fireVcsFileStatusChanged(VcsFileStatusEvent vcsFileStatusEvent) {
        VcsFileStatusListener[] vcsFileStatusListenerArray;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            vcsFileStatusListenerArray = (VcsFileStatusListener[])this.listenerList.getListeners(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener);
        }
        int n = 0;
        while (n < vcsFileStatusListenerArray.length) {
            vcsFileStatusListenerArray[n].vcsStatusChanged(vcsFileStatusEvent);
            ++n;
        }
    }

    public abstract String[] getStates(DataObject var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DefVersioningList
    implements AbstractFileSystem.List {
        private static final long serialVersionUID = 567851736120604546L;

        public String[] children(String string) {
            FileObject fileObject = VersioningFileSystem.this.fileSystem.findResource(string);
            FileObject[] fileObjectArray = fileObject.getChildren();
            if (fileObjectArray != null) {
                String[] stringArray = new String[fileObjectArray.length];
                int n = 0;
                while (n < fileObjectArray.length) {
                    stringArray[n] = fileObjectArray[n].getNameExt();
                    ++n;
                }
                return stringArray;
            }
            return new String[0];
        }
    }

    public class VersioningFSChange
    implements AbstractFileSystem.Change {
        private static final long serialVersionUID = -4757075426649682071L;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem;

        public void delete(String string) throws IOException {
            FileObject fileObject = VersioningFileSystem.this.fileSystem.findResource(string);
            if (fileObject == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FileCanNotDelete", (Object)string));
            }
            fileObject.delete(fileObject.lock());
        }

        public void createFolder(String string) throws IOException {
            String string2 = VcsUtilities.getDirNamePart(string);
            String string3 = VcsUtilities.getFileNamePart(string);
            FileObject fileObject = VersioningFileSystem.this.fileSystem.findResource(string2);
            if (fileObject == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FolderCanNotCreate", (Object)string));
            }
            fileObject.createFolder(string3);
        }

        public void createData(String string) throws IOException {
            String string2 = VcsUtilities.getDirNamePart(string);
            String string3 = VcsUtilities.getFileNamePart(string);
            FileObject fileObject = VersioningFileSystem.this.fileSystem.findResource(string2);
            if (fileObject == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FileCanNotCreate", (Object)string));
            }
            fileObject.createData(string3);
        }

        public void rename(String string, String string2) throws IOException {
            String string3;
            int n = string2.lastIndexOf(46);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            String string4 = VcsUtilities.getDirNamePart(string);
            String string5 = VcsUtilities.getFileNamePart(string);
            String string6 = VcsUtilities.getFileNamePart(string2);
            n = string6.lastIndexOf(46);
            if (n >= 0) {
                string3 = string6.substring(n + 1);
                string6 = string6.substring(0, n);
            } else {
                string3 = null;
            }
            FileObject fileObject = VersioningFileSystem.this.fileSystem.findResource(string);
            if (fileObject == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FileCanNotRename", (Object)string));
            }
            fileObject.rename(fileObject.lock(), string6, string3);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class VersioningAttrs
    implements AbstractFileSystem.Attr {
        private HashMap files = new HashMap();
        private static final long serialVersionUID = 7177122547454760079L;

        public void deleteAttributes(String string) {
            this.files.remove(string);
        }

        public Enumeration attributes(String string) {
            HashMap hashMap = (HashMap)this.files.get(string);
            if (hashMap == null) {
                return new EmptyEnumeration();
            }
            return Collections.enumeration(hashMap.keySet());
        }

        public void renameAttributes(String string, String string2) {
            HashMap hashMap = (HashMap)this.files.get(string);
            if (hashMap != null) {
                this.files.remove(string);
                this.files.put(string2, hashMap);
            }
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
            HashMap<String, Object> hashMap = (HashMap<String, Object>)this.files.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            hashMap.put(string2, object);
            this.files.put(string, hashMap);
        }

        public Object readAttribute(String string, String string2) {
            HashMap hashMap = (HashMap)this.files.get(string);
            Object var4_4 = null;
            var4_4 = hashMap == null ? null : hashMap.get(string2);
            return var4_4;
        }
    }

    public static interface Versions
    extends Serializable {
        public RevisionList getRevisions(String var1, boolean var2);

        public InputStream inputStream(String var1, String var2) throws FileNotFoundException;
    }
}

