/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventSet;
import org.netbeans.modules.form.FormEventHandlers;
import org.netbeans.modules.form.RADComponent;

public class ComponentEventHandlers {
    private RADComponent metacomponent;
    private EventSet[] eventSetHandlers;
    private boolean initialized;

    ComponentEventHandlers(RADComponent rADComponent) {
        this.metacomponent = rADComponent;
        this.initialized = false;
    }

    private void initialize() {
        this.initialized = true;
        BeanInfo beanInfo = this.metacomponent.getBeanInfo();
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        this.eventSetHandlers = new EventSet[eventSetDescriptorArray.length];
        int n = 0;
        while (n < eventSetDescriptorArray.length) {
            this.eventSetHandlers[n] = new EventSet(this.metacomponent, eventSetDescriptorArray[n]);
            ++n;
        }
        Arrays.sort(this.eventSetHandlers, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((EventSet)object).getName();
                String string2 = ((EventSet)object2).getName();
                return string.compareTo(string2);
            }
        });
    }

    public EventSet[] getEventSets() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.eventSetHandlers;
    }

    public Event getDefaultEvent() {
        BeanInfo beanInfo;
        int n;
        if (!this.initialized) {
            this.initialize();
        }
        if ((n = (beanInfo = this.metacomponent.getBeanInfo()).getDefaultEventIndex()) == -1) {
            int n2 = 0;
            while (n2 < this.eventSetHandlers.length) {
                if ("action".equals(this.eventSetHandlers[n2].getName())) {
                    Event[] eventArray = this.eventSetHandlers[n2].getEvents();
                    int n3 = 0;
                    while (n3 < eventArray.length) {
                        if ("actionPerformed".equals(eventArray[n3].getName())) {
                            return eventArray[n3];
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.eventSetHandlers.length) {
                Event[] eventArray = this.eventSetHandlers[n5].getEvents();
                int n6 = 0;
                while (n6 < eventArray.length) {
                    if (n4 == n) {
                        return eventArray[n6];
                    }
                    ++n4;
                    ++n6;
                }
                ++n5;
            }
        }
        return null;
    }

    public int getEventCount() {
        if (!this.initialized) {
            this.initialize();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.eventSetHandlers.length) {
            n += this.eventSetHandlers[n2].getEventCount();
            ++n2;
        }
        return n;
    }

    public int getHandlersCount() {
        if (!this.initialized) {
            this.initialize();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.eventSetHandlers.length) {
            Event[] eventArray = this.eventSetHandlers[n2].getEvents();
            int n3 = 0;
            while (n3 < eventArray.length) {
                n += eventArray[n3].getHandlers().size();
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    void initEvents(Collection collection) {
        if (!this.initialized) {
            this.initialize();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Event.EventInfo eventInfo = (Event.EventInfo)iterator.next();
            Event event = eventInfo.findEvent(this);
            if (event == null) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(eventInfo.eventHandlers, ",");
            FormEventHandlers formEventHandlers = this.metacomponent.getFormModel().getFormEventHandlers();
            while (stringTokenizer.hasMoreTokens()) {
                formEventHandlers.addEventHandler(event, stringTokenizer.nextToken());
            }
        }
    }

    List getEventsInfo() {
        if (!this.initialized) {
            this.initialize();
        }
        ArrayList<Event.EventInfo> arrayList = new ArrayList<Event.EventInfo>();
        int n = 0;
        while (n < this.eventSetHandlers.length) {
            Event[] eventArray = this.eventSetHandlers[n].getEvents();
            int n2 = 0;
            while (n2 < eventArray.length) {
                if (eventArray[n2].getHandlers().size() > 0) {
                    arrayList.add(new Event.EventInfo(eventArray[n2]));
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }
}

