/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.cookies.InstanceCookie;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

class CopySupport {
    private static final String flavorMimeType = "application/x-form-metacomponent;class=java.lang.Object";
    private static DataFlavor copyFlavor;
    private static DataFlavor cutFlavor;

    CopySupport() {
    }

    static DataFlavor getComponentCopyFlavor() {
        if (copyFlavor == null) {
            copyFlavor = new DataFlavor(flavorMimeType, "COMPONENT_COPY_FLAVOR");
        }
        return copyFlavor;
    }

    static DataFlavor getComponentCutFlavor() {
        if (cutFlavor == null) {
            cutFlavor = new DataFlavor(flavorMimeType, "COMPONENT_CUT_FLAVOR");
        }
        return cutFlavor;
    }

    public static boolean canPasteCut(RADComponent rADComponent, FormModel formModel, RADComponent rADComponent2) {
        if (rADComponent.getFormModel() != formModel) {
            return true;
        }
        if (rADComponent2 == null) {
            return formModel.getModelContainer().getIndexOf(rADComponent) < 0;
        }
        return rADComponent != rADComponent2 && rADComponent.getParentComponent() != rADComponent2 && !rADComponent.isParentComponent(rADComponent2);
    }

    static class InstancePaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private FormModel targetForm;
        private RADComponent targetComponent;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        public InstancePaste(Transferable transferable, FormModel formModel, RADComponent rADComponent) {
            this.transferable = transferable;
            this.targetForm = formModel;
            this.targetComponent = rADComponent;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException mutexException) {
                Exception exception = mutexException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                exception.printStackTrace();
                return this.transferable;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            InstanceCookie instanceCookie = (InstanceCookie)NodeTransfer.cookie((Transferable)this.transferable, (int)1, (Class)(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstancePaste.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie));
            if (instanceCookie != null) {
                this.targetForm.getComponentCreator().createComponent(instanceCookie, this.targetComponent, null);
            }
            return this.transferable;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class RADPaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private FormModel targetForm;
        private RADComponent targetComponent;

        public RADPaste(Transferable transferable, FormModel formModel, RADComponent rADComponent) {
            this.transferable = transferable;
            this.targetForm = formModel;
            this.targetComponent = rADComponent;
        }

        public String getName() {
            return FormUtils.getBundleString(this.isComponentCut() ? "CTL_CutPaste" : "CTL_CopyPaste");
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException mutexException) {
                Exception exception = mutexException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                exception.printStackTrace();
                return ExTransferable.EMPTY;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Transferable doPaste() throws IOException {
            boolean bl = this.isComponentCut();
            RADComponent rADComponent = this.getSourceComponent(bl);
            if (rADComponent == null) {
                return null;
            }
            if (!bl || rADComponent.getCodeExpression() == null) {
                this.targetForm.getComponentCreator().copyComponent(rADComponent, this.targetComponent);
                return null;
            }
            FormModel formModel = rADComponent.getFormModel();
            if (formModel != this.targetForm || this.targetComponent != null && !rADComponent.getClass().isAssignableFrom(this.targetComponent.getClass())) {
                if (this.targetForm.getComponentCreator().copyComponent(rADComponent, this.targetComponent) == null) return null;
                RADComponentNode rADComponentNode = rADComponent.getNodeReference();
                if (rADComponentNode == null) throw new IllegalStateException();
                rADComponentNode.destroy();
                return ExTransferable.EMPTY;
            }
            if (!CopySupport.canPasteCut(rADComponent, this.targetForm, this.targetComponent) || !MetaComponentCreator.canAddComponent(rADComponent.getBeanClass(), this.targetComponent)) {
                return null;
            }
            formModel.removeComponentFromContainer(rADComponent);
            if (rADComponent instanceof RADVisualComponent && this.targetComponent instanceof RADVisualContainer) {
                RADVisualContainer rADVisualContainer = (RADVisualContainer)this.targetComponent;
                LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
                RADVisualComponent[] rADVisualComponentArray = new RADVisualComponent[]{(RADVisualComponent)rADComponent};
                LayoutConstraints[] layoutConstraintsArray = new LayoutConstraints[]{layoutSupportManager.getStoredConstraints(rADVisualComponentArray[0])};
                try {
                    layoutSupportManager.acceptNewComponents(rADVisualComponentArray, layoutConstraintsArray, -1);
                }
                catch (RuntimeException runtimeException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) return this.transferable;
                    runtimeException.printStackTrace();
                    return this.transferable;
                }
                rADVisualContainer.add(rADComponent);
                layoutSupportManager.addComponents(rADVisualComponentArray, layoutConstraintsArray, -1);
                this.targetForm.fireComponentAdded(rADComponent, false);
                return ExTransferable.EMPTY;
            }
            ComponentContainer componentContainer = this.targetComponent instanceof ComponentContainer ? (ComponentContainer)((Object)this.targetComponent) : null;
            this.targetForm.addComponent(rADComponent, componentContainer);
            return ExTransferable.EMPTY;
        }

        boolean isComponentCut() {
            return this.transferable.isDataFlavorSupported(CopySupport.getComponentCutFlavor());
        }

        RADComponent getSourceComponent(boolean bl) throws IOException {
            RADComponent rADComponent = null;
            try {
                Object object = this.transferable.getTransferData(bl ? CopySupport.getComponentCutFlavor() : CopySupport.getComponentCopyFlavor());
                if (object instanceof RADComponent) {
                    rADComponent = (RADComponent)object;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return rADComponent;
        }
    }

    static class RADTransferable
    implements Transferable {
        private RADComponent radComponent;
        private DataFlavor[] flavors;

        RADTransferable(DataFlavor dataFlavor, RADComponent rADComponent) {
            this(new DataFlavor[]{dataFlavor}, rADComponent);
        }

        RADTransferable(DataFlavor[] dataFlavorArray, RADComponent rADComponent) {
            this.flavors = dataFlavorArray;
            this.radComponent = rADComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            int n = 0;
            while (n < this.flavors.length) {
                if (this.flavors[n] == dataFlavor) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if ("x-form-metacomponent".equals(dataFlavor.getSubType())) {
                return this.radComponent;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

