/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventHandler;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class FormEventHandlers {
    private HashMap nameToHandler = new HashMap();

    FormEventHandlers() {
    }

    EventHandler getEventHandler(String string) {
        return (EventHandler)this.nameToHandler.get(string);
    }

    EventHandler[] getAllHandlers() {
        Collection collection = this.nameToHandler.values();
        EventHandler[] eventHandlerArray = new EventHandler[collection.size()];
        collection.toArray(eventHandlerArray);
        return eventHandlerArray;
    }

    String findFreeHandlerName(Event event) {
        return this.findFreeHandlerName(FormEventHandlers.getDefaultHandlerName(event));
    }

    String findFreeHandlerName(String string) {
        String string2 = string;
        int n = 0;
        while (this.nameToHandler.get(string2) != null) {
            string2 = string + ++n;
        }
        return string2;
    }

    static String getDefaultHandlerName(Event event) {
        RADComponent rADComponent = event.getComponent();
        String string = rADComponent.getFormModel().getTopRADComponent() == rADComponent ? "form" : rADComponent.getName();
        return FormEventHandlers.getDefaultHandlerName(string, event);
    }

    static String getDefaultHandlerName(String string, Event event) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        String string2 = event.getListenerMethod().getName();
        stringBuffer.append(string2.substring(0, 1).toUpperCase());
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }

    public boolean addEventHandler(Event event, String string) {
        return this.addEventHandler(event, string, null);
    }

    boolean addEventHandler(Event event, String string, String string2) {
        boolean bl;
        FormModel formModel = event.getComponent().getFormModel();
        EventHandler eventHandler = (EventHandler)this.nameToHandler.get(string);
        if (eventHandler != null) {
            if (!eventHandler.checkCompatibility(event)) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_CannotAttach"), 2));
                return false;
            }
            if (!eventHandler.attachEvent(event)) {
                event = null;
            }
            bl = false;
        } else {
            eventHandler = new EventHandler(event, string);
            this.nameToHandler.put(string, eventHandler);
            bl = true;
        }
        formModel.fireEventHandlerAdded(event, eventHandler, string2, bl);
        return true;
    }

    void removeEventHandler(Event event) {
        List list = event.getHandlers();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            this.removeEventHandler(event, (EventHandler)list.get(n));
            ++n;
        }
    }

    void removeEventHandler(Event event, String string) {
        EventHandler eventHandler = (EventHandler)this.nameToHandler.get(string);
        this.removeEventHandler(event, eventHandler);
    }

    void removeEventHandler(Event event, EventHandler eventHandler) {
        int n;
        int n2 = n = eventHandler != null ? eventHandler.getAttachedEvents().size() : 0;
        if (n < 1) {
            return;
        }
        eventHandler.detachEvent(event);
        if (n == 1) {
            this.nameToHandler.remove(eventHandler.getName());
        }
        FormModel formModel = event.getComponent().getFormModel();
        formModel.fireEventHandlerRemoved(event, eventHandler, n == 1);
    }

    void renameEventHandler(String string, String string2) {
        EventHandler eventHandler = (EventHandler)this.nameToHandler.get(string);
        this.renameEventHandler(eventHandler, string2);
    }

    void renameEventHandler(EventHandler eventHandler, String string) {
        if (eventHandler == null) {
            return;
        }
        if (this.nameToHandler.get(string) != null) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_CannotRename"), 2));
            return;
        }
        String string2 = eventHandler.getName();
        this.nameToHandler.remove(string2);
        this.nameToHandler.put(string, eventHandler);
        eventHandler.setName(string);
        if (!eventHandler.isEmpty()) {
            Event event = (Event)eventHandler.getAttachedEvents().get(0);
            FormModel formModel = event.getComponent().getFormModel();
            formModel.fireEventHandlerRenamed(eventHandler, string2);
        }
    }
}

