/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.JSplitPane;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class JSplitPaneSupport
extends AbstractLayoutSupport {
    private static Method setLeftComponentMethod;
    private static Method setRightComponentMethod;
    private static Method setTopComponentMethod;
    private static Method setBottomComponentMethod;
    static /* synthetic */ Class class$javax$swing$JSplitPane;
    static /* synthetic */ Class class$java$awt$Component;

    public Class getSupportedClass() {
        return class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = JSplitPaneSupport.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane;
    }

    public LayoutConstraints getNewConstraints(Container container, Container container2, Component component, int n, Point point, Point point2) {
        if (!(container instanceof JSplitPane)) {
            return null;
        }
        JSplitPane jSplitPane = (JSplitPane)container;
        Dimension dimension = jSplitPane.getSize();
        int n2 = jSplitPane.getOrientation();
        Component component2 = jSplitPane.getLeftComponent();
        Component component3 = jSplitPane.getRightComponent();
        String string = this.findFreePosition();
        if (component2 == null || component3 == null) {
            string = n2 == 1 ? (point.x <= dimension.width / 2 ? "left" : "right") : (point.x <= dimension.height / 2 ? "top" : "bottom");
        }
        return new SplitConstraints(string);
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        if (!(container instanceof JSplitPane)) {
            return false;
        }
        String string = (String)layoutConstraints.getConstraintsObject();
        if (string == null) {
            return false;
        }
        JSplitPane jSplitPane = (JSplitPane)container;
        int n2 = jSplitPane.getOrientation();
        Dimension dimension = jSplitPane.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width, dimension.height);
        if (n2 == 1) {
            Component component2 = jSplitPane.getLeftComponent();
            Component component3 = jSplitPane.getRightComponent();
            if (string == "left") {
                rectangle.width = component3 == null ? dimension.width / 2 : component3.getBounds().x - rectangle.x;
            } else if (component2 == null) {
                rectangle.x = insets.left + dimension.width / 2;
                rectangle.width = dimension.width - rectangle.x;
            } else {
                rectangle.x = component2.getBounds().x + component2.getBounds().width;
                rectangle.width = dimension.width - rectangle.x;
            }
        } else {
            Component component4 = jSplitPane.getTopComponent();
            Component component5 = jSplitPane.getBottomComponent();
            if (string == "top") {
                rectangle.height = component5 == null ? (rectangle.height /= 2) : component5.getBounds().y - rectangle.y;
            } else if (component4 == null) {
                rectangle.y = insets.top + dimension.height / 2;
                rectangle.height = dimension.height - rectangle.y;
            } else {
                rectangle.y = component4.getBounds().y + component4.getBounds().height;
                rectangle.height = dimension.height - rectangle.y;
            }
        }
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return true;
    }

    public void addComponentsToContainer(Container container, Container container2, Component[] componentArray, int n) {
        if (!(container instanceof JSplitPane)) {
            return;
        }
        int n2 = 0;
        while (n2 < componentArray.length) {
            int n3 = this.convertPosition(this.getConstraints(n2 + n));
            if (n3 == 0) {
                ((JSplitPane)container).setLeftComponent(componentArray[n2]);
            } else if (n3 == 1) {
                ((JSplitPane)container).setRightComponent(componentArray[n2]);
            }
            ++n2;
        }
    }

    public boolean removeComponentFromContainer(Container container, Container container2, Component component) {
        return false;
    }

    protected CodeExpression readComponentCode(CodeStatement codeStatement, CodeGroup codeGroup) {
        String string;
        CodeExpression[] codeExpressionArray = codeStatement.getStatementParameters();
        if (codeExpressionArray.length != 1) {
            return null;
        }
        Object object = codeStatement.getMetaObject();
        if (JSplitPaneSupport.getSetLeftComponentMethod().equals(object)) {
            string = "left";
        } else if (JSplitPaneSupport.getSetRightComponentMethod().equals(object)) {
            string = "right";
        } else if (JSplitPaneSupport.getSetTopComponentMethod().equals(object)) {
            string = "top";
        } else if (JSplitPaneSupport.getSetBottomComponentMethod().equals(object)) {
            string = "bottom";
        } else {
            return null;
        }
        SplitConstraints splitConstraints = new SplitConstraints(string);
        this.getConstraintsList().add(splitConstraints);
        codeGroup.addStatement(codeStatement);
        return codeExpressionArray[0];
    }

    protected void createComponentCode(CodeGroup codeGroup, CodeExpression codeExpression, int n) {
        LayoutConstraints layoutConstraints = this.getConstraints(n);
        if (!(layoutConstraints instanceof SplitConstraints)) {
            return;
        }
        ((SplitConstraints)layoutConstraints).createComponentCode(codeGroup, this.getLayoutContext().getContainerCodeExpression(), codeExpression);
    }

    protected LayoutConstraints createDefaultConstraints() {
        return new SplitConstraints(this.findFreePosition());
    }

    private int convertPosition(LayoutConstraints layoutConstraints) {
        Object object = layoutConstraints.getConstraintsObject();
        if ("left".equals(object) || "top".equals(object)) {
            return 0;
        }
        if ("right".equals(object) || "bottom".equals(object)) {
            return 1;
        }
        return -1;
    }

    private String findFreePosition() {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        int n4 = this.getComponentCount();
        while (n3 < n4) {
            LayoutConstraints layoutConstraints = this.getConstraints(n3);
            if (layoutConstraints instanceof SplitConstraints) {
                int n5 = this.convertPosition(layoutConstraints);
                if (n5 == 0) {
                    ++n;
                } else if (n5 == 1) {
                    ++n2;
                }
            }
            ++n3;
        }
        if (n == 0 || n < n2) {
            return bl ? "left" : "top";
        }
        return bl ? "right" : "bottom";
    }

    private static Method getSetLeftComponentMethod() {
        if (setLeftComponentMethod == null) {
            setLeftComponentMethod = JSplitPaneSupport.getAddMethod("setLeftComponent");
        }
        return setLeftComponentMethod;
    }

    private static Method getSetRightComponentMethod() {
        if (setRightComponentMethod == null) {
            setRightComponentMethod = JSplitPaneSupport.getAddMethod("setRightComponent");
        }
        return setRightComponentMethod;
    }

    private static Method getSetTopComponentMethod() {
        if (setTopComponentMethod == null) {
            setTopComponentMethod = JSplitPaneSupport.getAddMethod("setTopComponent");
        }
        return setTopComponentMethod;
    }

    private static Method getSetBottomComponentMethod() {
        if (setBottomComponentMethod == null) {
            setBottomComponentMethod = JSplitPaneSupport.getAddMethod("setBottomComponent");
        }
        return setBottomComponentMethod;
    }

    private static Method getAddMethod(String string) {
        try {
            return (class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = JSplitPaneSupport.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane).getMethod(string, class$java$awt$Component == null ? (class$java$awt$Component = JSplitPaneSupport.class$("java.awt.Component")) : class$java$awt$Component);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ ResourceBundle access$101() {
        return AbstractLayoutSupport.getBundle();
    }

    static /* synthetic */ ResourceBundle access$201() {
        return AbstractLayoutSupport.getBundle();
    }

    static class SplitPositionEditor
    extends PropertyEditorSupport {
        private final String[] values = new String[]{"left", "right", "top", "bottom"};

        SplitPositionEditor() {
        }

        public String[] getTags() {
            return this.values;
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String string) {
            int n = 0;
            while (n < this.values.length) {
                if (string.equals(this.values[n])) {
                    this.setValue(string);
                    break;
                }
                ++n;
            }
        }
    }

    public static class SplitConstraints
    implements LayoutConstraints {
        private String position;
        private Node.Property[] properties;
        private CodeExpression containerExpression;
        private CodeExpression componentExpression;
        private CodeGroup componentCode;
        static /* synthetic */ Class class$java$lang$String;

        public SplitConstraints(String string) {
            this.position = string;
        }

        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.properties = new Node.Property[]{new FormProperty(this, "splitPosition", class$java$lang$String == null ? (class$java$lang$String = SplitConstraints.class$("java.lang.String")) : class$java$lang$String, JSplitPaneSupport.access$101().getString("PROP_splitPos"), JSplitPaneSupport.access$201().getString("HINT_splitPos")){
                    private final /* synthetic */ SplitConstraints this$0;
                    {
                        this.this$0 = splitConstraints;
                    }

                    public Object getTargetValue() {
                        return SplitConstraints.access$300(this.this$0);
                    }

                    public void setTargetValue(Object object) {
                        SplitConstraints.access$302(this.this$0, (String)object);
                    }

                    public PropertyEditor getExpliciteEditor() {
                        return new SplitPositionEditor();
                    }

                    protected void propertyValueChanged(Object object, Object object2) {
                        if (this.isChangeFiring()) {
                            SplitConstraints.access$400(this.this$0);
                        }
                        super.propertyValueChanged(object, object2);
                    }

                    public void setPropertyContext(FormPropertyContext formPropertyContext) {
                    }
                }};
            }
            return this.properties;
        }

        public Object getConstraintsObject() {
            return this.position;
        }

        public LayoutConstraints cloneConstraints() {
            return new SplitConstraints(this.position);
        }

        private void createComponentCode(CodeGroup codeGroup, CodeExpression codeExpression, CodeExpression codeExpression2) {
            this.componentCode = codeGroup;
            this.containerExpression = codeExpression;
            this.componentExpression = codeExpression2;
            this.updateCode();
        }

        private void updateCode() {
            Method method;
            if (this.componentCode == null) {
                return;
            }
            CodeStructure.removeStatements(this.componentCode.getStatementsIterator());
            this.componentCode.removeAll();
            if ("left".equals(this.position)) {
                method = JSplitPaneSupport.getSetLeftComponentMethod();
            } else if ("right".equals(this.position)) {
                method = JSplitPaneSupport.getSetRightComponentMethod();
            } else if ("top".equals(this.position)) {
                method = JSplitPaneSupport.getSetTopComponentMethod();
            } else if ("bottom".equals(this.position)) {
                method = JSplitPaneSupport.getSetBottomComponentMethod();
            } else {
                return;
            }
            this.componentCode.addStatement(CodeStructure.createStatement(this.containerExpression, method, new CodeExpression[]{this.componentExpression}));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ String access$300(SplitConstraints splitConstraints) {
            return splitConstraints.position;
        }

        static /* synthetic */ String access$302(SplitConstraints splitConstraints, String string) {
            splitConstraints.position = string;
            return splitConstraints.position;
        }

        static /* synthetic */ void access$400(SplitConstraints splitConstraints) {
            splitConstraints.updateCode();
        }
    }
}

