/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.form.palette.AlignedListUI;

public class AlignedList
extends JList {
    public static final int HORIZONTAL_ALIGN_STYLE = 0;
    public static final int VERTICAL_ALIGN_STYLE = 1;
    private int rolloverIndex = -1;
    private int alignStyle = 1;
    private int visibleColumnCount = 8;

    public AlignedList() {
    }

    public AlignedList(Object[] objectArray) {
        super(objectArray);
    }

    public void updateUI() {
        this.setUI(new AlignedListUI());
        this.invalidate();
    }

    public void setRolloverIndex(int n) {
        int n2 = this.rolloverIndex;
        this.rolloverIndex = n;
        this.firePropertyChange("rolloverIndex", n2, this.rolloverIndex);
    }

    public int getRolloverIndex() {
        return this.rolloverIndex;
    }

    public void setAlignStyle(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid alignStyle");
            }
        }
        int n2 = this.alignStyle;
        this.alignStyle = n;
        this.firePropertyChange("alignStyle", n2, this.alignStyle);
    }

    public int getAlignStyle() {
        return this.alignStyle;
    }

    public void setVisibleColumnCount(int n) {
        int n2 = this.visibleColumnCount;
        this.visibleColumnCount = Math.max(0, n);
        this.firePropertyChange("visibleColumnCount", n2, this.visibleColumnCount);
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Component component;
            Point point = mouseEvent.getPoint();
            int n = this.locationToIndex(point);
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (n != -1 && listCellRenderer != null && (component = listCellRenderer.getListCellRendererComponent(this, this.getModel().getElementAt(n), n, this.isSelectedIndex(n), this.hasFocus() && n == this.getLeadSelectionIndex())) instanceof JComponent) {
                Rectangle rectangle = this.getCellBounds(n, n);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                return ((JComponent)component).getToolTipText(mouseEvent2);
            }
        }
        return null;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.alignStyle == 0) {
            return true;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.alignStyle == 1) {
            return true;
        }
        return super.getScrollableTracksViewportHeight();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = this.getVisibleRowCount();
        int n4 = this.getVisibleColumnCount();
        int n5 = this.getFixedCellWidth();
        int n6 = this.getFixedCellHeight();
        if (n5 > 0 && n6 > 0) {
            int n7 = n4 * n5 + n;
            int n8 = n3 * n6 + n2;
            return new Dimension(n7, n8);
        }
        if (this.getModel().getSize() > 0) {
            Rectangle rectangle = this.getCellBounds(0, 0);
            int n9 = n4 * rectangle.width + n;
            int n10 = n3 * rectangle.height + n2;
            return new Dimension(n9, n10);
        }
        n5 = n5 > 0 ? n5 : 256;
        n6 = n6 > 0 ? n6 : 16;
        return new Dimension(n5 * n4, n6 * n3);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = this.getFirstVisibleIndex();
        Rectangle rectangle2 = this.getCellBounds(n3, n3);
        if (rectangle2 == null) {
            return 0;
        }
        int n4 = 0;
        n4 = n == 0 ? rectangle2.width : rectangle2.height;
        return n4;
    }
}

