/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItemNode;
import org.netbeans.modules.form.palette.PaletteNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class PaletteCategoryNode
extends DataFolder.FolderNode {
    private static String iconURL = "org/netbeans/modules/form/resources/paletteCategory.gif";
    private static String icon32URL = "org/netbeans/modules/form/resources/paletteCategory32.gif";
    private static final String PALETTE_FOLDER_NAME = "Palette";
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private static SystemAction[] staticActions;
    private DataFolder folder;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    public PaletteCategoryNode(DataFolder dataFolder) {
        super(dataFolder, (Children)new PaletteCategoryNodeChildren(dataFolder));
        this.folder = dataFolder;
        Object object = dataFolder.getPrimaryFile().getAttribute("categoryName");
        if (object != null && object instanceof String) {
            this.setName((String)object, false);
        } else {
            String string;
            String string2 = ((FeatureDescriptor)((Object)this)).getName();
            if (!string2.equals(string = this.getDisplayName())) {
                this.setName(string, false);
            }
        }
    }

    public void setName(String string) {
        this.setName(string, true);
    }

    public void setName(String string, boolean bl) {
        if (bl) {
            if (!PaletteCategoryNode.checkCategoryName(string, (Node)this)) {
                return;
            }
            try {
                DataObject dataObject = this.getDataObject();
                FileObject fileObject = dataObject.getPrimaryFile();
                String string2 = PaletteCategoryNode.convertToFolderName(string, fileObject.getName());
                fileObject.setAttribute("categoryName", null);
                dataObject.rename(string2);
                if (!string2.equals(string)) {
                    fileObject.setAttribute("categoryName", (Object)string);
                }
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, (Throwable)iOException);
                throw illegalArgumentException;
            }
        }
        super.setName(string, false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.options.component-palette");
    }

    public Node[] getValidItemNodes() {
        Node[] nodeArray = this.getChildren().getNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
        int n = 0;
        while (n < nodeArray.length) {
            Node node = nodeArray[n];
            if (node instanceof PaletteItemNode && ((PaletteItemNode)node).getItemClass() != null) {
                arrayList.add(node);
            }
            ++n;
        }
        if (arrayList.size() != nodeArray.length) {
            nodeArray = new Node[arrayList.size()];
            arrayList.toArray(nodeArray);
        }
        return nodeArray;
    }

    public Node.Cookie getCookie(Class clazz) {
        DataFolder dataFolder;
        if ((class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = PaletteCategoryNode.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index).isAssignableFrom(clazz) && (dataFolder = (DataFolder)super.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PaletteCategoryNode.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
            return new PaletteCategoryIndex(dataFolder, (PaletteCategoryNodeChildren)this.getChildren());
        }
        return super.getCookie(clazz);
    }

    public Image getIcon(int n) {
        if (n == 1 || n == 3) {
            return Utilities.loadImage((String)iconURL);
        }
        return Utilities.loadImage((String)icon32URL);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public NewType[] getNewTypes() {
        return new NewType[0];
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = PaletteCategoryNode.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = PaletteCategoryNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = PaletteCategoryNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = PaletteCategoryNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PaletteCategoryNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = PaletteCategoryNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = PaletteCategoryNode.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction))};
        }
        return staticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        boolean bl;
        Node[] nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)6);
        if (nodeArray == null) {
            bl = false;
            nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)1);
            if (nodeArray == null) {
                return;
            }
        } else {
            bl = true;
        }
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        int n = 0;
        while (n < nodeArray.length) {
            FileObject fileObject;
            Node node = nodeArray[n];
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? PaletteCategoryNode.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            InstanceCookie instanceCookie = (InstanceCookie)node.getCookie(class$org$openide$cookies$InstanceCookie == null ? PaletteCategoryNode.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            FileObject fileObject2 = fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
            if (this.getChildren().findChild(node.getName()) == null && dataObject != null && dataObject.isValid() && instanceCookie != null && (!bl || "instance".equals(fileObject.getExt()) || "shadow".equals(fileObject.getExt()))) {
                arrayList.add(dataObject);
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            list.add(new BeanPaste(arrayList, bl, false));
            if (!bl) {
                list.add(new BeanPaste(arrayList, bl, true));
            }
        }
    }

    static boolean checkCategoryName(String string, Node node) {
        boolean bl = false;
        if (string == null || "".equals(string)) {
            bl = true;
        } else {
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                if (c == '.' || c == ' ' && n + 1 == n2) {
                    bl = true;
                    break;
                }
                if (c != ' ') break;
                ++n;
            }
        }
        if (bl) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(CPManager.getBundle().getString("ERR_InvalidName"), string), 1));
            return false;
        }
        Node[] nodeArray = PaletteNode.getPaletteNode().getChildren().getNodes();
        int n = 0;
        while (n < nodeArray.length) {
            if (string.equals(nodeArray[n].getName()) && nodeArray[n] != node) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(CPManager.getBundle().getString("FMT_CategoryExists"), string), 1));
                return false;
            }
            ++n;
        }
        return true;
    }

    static String convertToFolderName(String string, String string2) {
        int n;
        if (string == null || "".equals(string)) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        char c = string.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            stringBuffer.append(c);
            n = 1;
        } else {
            stringBuffer.append('_');
            n = 0;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        String string3 = stringBuffer.toString();
        if ("_".equals(string3)) {
            string3 = "Category";
        }
        if (string3.equals(string2)) {
            return string3;
        }
        FileObject fileObject = PaletteNode.getPaletteFolder().getPrimaryFile();
        String string4 = null;
        boolean bl = false;
        n = 0;
        while (!bl) {
            String string5 = string4 = n > 0 ? string3 + "_" + n : string3;
            if (Utilities.isWindows()) {
                bl = true;
                Enumeration enumeration = fileObject.getChildren(false);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    String string6 = fileObject2.getName();
                    String string7 = fileObject2.getExt();
                    if (string7 != null && !"".equals(string7) || !string6.equalsIgnoreCase(string4)) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = fileObject.getFileObject(string4) == null;
            }
            ++n;
        }
        return string4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BeanPaste
    extends PasteType {
        private List dataObjs;
        private boolean cut;
        private boolean createLink;
        static /* synthetic */ Class class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        public BeanPaste(List list, boolean bl, boolean bl2) {
            this.dataObjs = list;
            this.cut = bl;
            this.createLink = bl2;
        }

        public String getName() {
            return this.createLink ? CPManager.getBundle().getString("CTL_PasteLink") : CPManager.getBundle().getString("CTL_PasteBean");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx((class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste == null ? (class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste = BeanPaste.class$("org.netbeans.modules.form.palette.PaletteCategoryNode$BeanPaste")) : class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste).getName());
        }

        public final Transferable paste() throws IOException {
            DataFolder dataFolder = PaletteCategoryNode.this.folder;
            Iterator iterator = this.dataObjs.iterator();
            while (iterator.hasNext()) {
                Object object;
                DataObject dataObject = (DataObject)iterator.next();
                FileObject fileObject = dataObject.getPrimaryFile();
                if (!this.createLink && ("instance".equals(fileObject.getExt()) || "shadow".equals(fileObject.getExt()))) {
                    object = fileObject.getAttribute("SystemFileSystem.icon");
                    Object object2 = fileObject.getAttribute("beaninfo");
                    if (this.cut) {
                        if (dataObject.isMoveAllowed()) {
                            dataObject.move(dataFolder);
                        } else {
                            dataObject = null;
                        }
                    } else {
                        dataObject = dataObject.copy(dataFolder);
                    }
                    if (dataObject == null) continue;
                    if (object != null) {
                        dataObject.getPrimaryFile().setAttribute("SystemFileSystem.icon", object);
                    }
                    if (object2 == null) continue;
                    dataObject.getPrimaryFile().setAttribute("beaninfo", object2);
                    continue;
                }
                if (this.cut) continue;
                if (!this.createLink && ("java".equals(fileObject.getExt()) || "class".equals(fileObject.getExt()))) {
                    object = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? BeanPaste.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                    if (object == null) continue;
                    BeanInstaller.createInstance(dataFolder.getPrimaryFile(), object.instanceName());
                    continue;
                }
                dataObject.createShadow(dataFolder);
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static final class PaletteCategoryIndex
    extends DataFolder.Index {
        PaletteCategoryNodeChildren children;

        PaletteCategoryIndex(DataFolder dataFolder, PaletteCategoryNodeChildren paletteCategoryNodeChildren) {
            super(dataFolder);
            this.children = paletteCategoryNodeChildren;
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }
    }

    private static class PaletteCategoryNodeChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        public PaletteCategoryNodeChildren(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            if (node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PaletteCategoryNodeChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject) != null && node.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PaletteCategoryNodeChildren.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) != null) {
                return new PaletteItemNode(node);
            }
            return node.cloneNode();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

